/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.spark.sv.discovery;

import com.google.common.annotations.VisibleForTesting;
import htsjdk.samtools.util.SequenceUtil;
import htsjdk.variant.variantcontext.Allele;
import java.util.Collections;
import java.util.Map;
import org.broadinstitute.hellbender.engine.BasicReference;
import org.broadinstitute.hellbender.tools.spark.sv.discovery.SvType;
import org.broadinstitute.hellbender.tools.spark.sv.discovery.alignment.StrandSwitch;
import org.broadinstitute.hellbender.tools.spark.sv.discovery.inference.NovelAdjacencyAndAltHaplotype;
import org.broadinstitute.hellbender.tools.spark.sv.discovery.inference.TypeInferredFromSimpleChimera;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import scala.Tuple2;

public abstract class BreakEndVariantType
extends SvType {
    private final boolean isTheUpstreamMate;

    protected BreakEndVariantType(String variantCHR, int variantPOS, String variantId, Allele refAllele, Allele altAllele, Map<String, Object> extraAttributes, boolean isTheUpstreamMate) {
        super(variantCHR, variantPOS, -1, variantId, refAllele, altAllele, -1, extraAttributes);
        this.isTheUpstreamMate = isTheUpstreamMate;
    }

    public final boolean isTheUpstreamMate() {
        return this.isTheUpstreamMate;
    }

    @Override
    public final boolean hasApplicableEnd() {
        return false;
    }

    @Override
    public final boolean hasApplicableLength() {
        return false;
    }

    public final String toString() {
        return "BND";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BreakEndVariantType that = (BreakEndVariantType)o;
        return this.isTheUpstreamMate == that.isTheUpstreamMate;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.isTheUpstreamMate ? 1 : 0);
        return result;
    }

    private static String getIDString(NovelAdjacencyAndAltHaplotype narl, boolean forUpstreamLoc) {
        String bndtype = narl.getStrandSwitch().equals((Object)StrandSwitch.NO_SWITCH) || !narl.getLeftJustifiedLeftRefLoc().getContig().equals(narl.getLeftJustifiedRightRefLoc().getContig()) ? "" : (narl.getStrandSwitch().equals((Object)StrandSwitch.FORWARD_TO_REVERSE) ? "INV55" : "INV33");
        String locationPartOfString = BreakEndVariantType.makeLocationString(narl.getLeftJustifiedLeftRefLoc().getContig(), narl.getLeftJustifiedLeftRefLoc().getStart(), narl.getLeftJustifiedRightRefLoc().getContig(), narl.getLeftJustifiedRightRefLoc().getEnd());
        return "BND_" + (bndtype.isEmpty() ? "" : bndtype + "_") + locationPartOfString + "_" + (forUpstreamLoc ? "1" : "2");
    }

    private static String getRefBaseString(NovelAdjacencyAndAltHaplotype narl, boolean forUpstreamLoc, BasicReference reference) {
        byte[] refBases = reference.getBases(forUpstreamLoc ? narl.getLeftJustifiedLeftRefLoc() : narl.getLeftJustifiedRightRefLoc());
        return new String(refBases);
    }

    public static final class InterChromosomeBreakend
    extends BreakEndVariantType {
        @VisibleForTesting
        public InterChromosomeBreakend(String variantCHR, int variantPOS, String variantId, Allele refAllele, Allele altAllele, Map<String, Object> extraAttributes, boolean isTheUpstreamMate) {
            super(variantCHR, variantPOS, variantId, refAllele, altAllele, extraAttributes, isTheUpstreamMate);
        }

        private InterChromosomeBreakend(NovelAdjacencyAndAltHaplotype narl, BasicReference reference, boolean isTheUpstreamMate) {
            super(isTheUpstreamMate ? narl.getLeftJustifiedLeftRefLoc().getContig() : narl.getLeftJustifiedRightRefLoc().getContig(), isTheUpstreamMate ? narl.getLeftJustifiedLeftRefLoc().getStart() : narl.getLeftJustifiedRightRefLoc().getEnd(), BreakEndVariantType.getIDString(narl, isTheUpstreamMate), Allele.create((String)BreakEndVariantType.getRefBaseString(narl, isTheUpstreamMate, reference), (boolean)true), InterChromosomeBreakend.constructAltAllele(narl, reference, isTheUpstreamMate), noExtraAttributes, isTheUpstreamMate);
        }

        public static Tuple2<BreakEndVariantType, BreakEndVariantType> getOrderedMates(NovelAdjacencyAndAltHaplotype narl, BasicReference reference) {
            return new Tuple2((Object)new InterChromosomeBreakend(narl, reference, true), (Object)new InterChromosomeBreakend(narl, reference, false));
        }

        private static Allele constructAltAllele(NovelAdjacencyAndAltHaplotype narl, BasicReference reference, boolean forUpstreamLoc) {
            String refBase = BreakEndVariantType.getRefBaseString(narl, forUpstreamLoc, reference);
            String insertedSequence = InterChromosomeBreakend.extractInsertedSequence(narl, forUpstreamLoc);
            SimpleInterval novelAdjRefLoc = forUpstreamLoc ? narl.getLeftJustifiedRightRefLoc() : narl.getLeftJustifiedLeftRefLoc();
            boolean upstreamLocIsFirstInPartner = narl.getTypeInferredFromSimpleChimera().equals((Object)TypeInferredFromSimpleChimera.INTER_CHR_NO_SS_WITH_LEFT_MATE_FIRST_IN_PARTNER);
            if (narl.getStrandSwitch().equals((Object)StrandSwitch.NO_SWITCH)) {
                if (forUpstreamLoc == upstreamLocIsFirstInPartner) {
                    return Allele.create((String)(refBase + insertedSequence + "[" + novelAdjRefLoc.getContig() + ":" + novelAdjRefLoc.getEnd() + "["));
                }
                return Allele.create((String)("]" + novelAdjRefLoc.getContig() + ":" + novelAdjRefLoc.getStart() + "]" + insertedSequence + refBase));
            }
            if (narl.getStrandSwitch().equals((Object)StrandSwitch.FORWARD_TO_REVERSE)) {
                return Allele.create((String)(refBase + insertedSequence + "]" + novelAdjRefLoc.getContig() + ":" + novelAdjRefLoc.getEnd() + "]"));
            }
            return Allele.create((String)("[" + novelAdjRefLoc.getContig() + ":" + novelAdjRefLoc.getEnd() + "[" + insertedSequence + refBase));
        }

        private static String extractInsertedSequence(NovelAdjacencyAndAltHaplotype narl, boolean forUpstreamLoc) {
            String ins = narl.getComplication().getInsertedSequenceForwardStrandRep();
            if (ins.isEmpty() || narl.getStrandSwitch() == StrandSwitch.NO_SWITCH) {
                return ins;
            }
            return forUpstreamLoc == narl.getStrandSwitch().equals((Object)StrandSwitch.FORWARD_TO_REVERSE) ? ins : SequenceUtil.reverseComplement((String)ins);
        }
    }

    public static final class IntraChromosomeRefOrderSwap
    extends BreakEndVariantType {
        @VisibleForTesting
        public IntraChromosomeRefOrderSwap(String variantCHR, int variantPOS, String variantId, Allele refAllele, Allele altAllele, Map<String, Object> extraAttributes, boolean isTheUpstreamMate) {
            super(variantCHR, variantPOS, variantId, refAllele, altAllele, extraAttributes, isTheUpstreamMate);
        }

        private IntraChromosomeRefOrderSwap(NovelAdjacencyAndAltHaplotype narl, BasicReference reference, boolean isTheUpstreamMate) {
            super(isTheUpstreamMate ? narl.getLeftJustifiedLeftRefLoc().getContig() : narl.getLeftJustifiedRightRefLoc().getContig(), isTheUpstreamMate ? narl.getLeftJustifiedLeftRefLoc().getStart() : narl.getLeftJustifiedRightRefLoc().getEnd(), BreakEndVariantType.getIDString(narl, isTheUpstreamMate), Allele.create((String)BreakEndVariantType.getRefBaseString(narl, isTheUpstreamMate, reference), (boolean)true), IntraChromosomeRefOrderSwap.constructAltAllele(BreakEndVariantType.getRefBaseString(narl, isTheUpstreamMate, reference), narl.getComplication().getInsertedSequenceForwardStrandRep(), isTheUpstreamMate ? narl.getLeftJustifiedRightRefLoc() : narl.getLeftJustifiedLeftRefLoc(), isTheUpstreamMate), noExtraAttributes, isTheUpstreamMate);
        }

        public static Tuple2<BreakEndVariantType, BreakEndVariantType> getOrderedMates(NovelAdjacencyAndAltHaplotype narl, BasicReference reference) {
            return new Tuple2((Object)new IntraChromosomeRefOrderSwap(narl, reference, true), (Object)new IntraChromosomeRefOrderSwap(narl, reference, false));
        }

        private static Allele constructAltAllele(String refBase, String insertedSequence, SimpleInterval novelAdjRefLoc, boolean forUpstreamLoc) {
            if (forUpstreamLoc) {
                return Allele.create((String)("]" + novelAdjRefLoc.getContig() + ":" + novelAdjRefLoc.getEnd() + "]" + insertedSequence + refBase));
            }
            return Allele.create((String)(refBase + insertedSequence + "[" + novelAdjRefLoc.getContig() + ":" + novelAdjRefLoc.getEnd() + "["));
        }
    }

    public static final class IntraChromosomalStrandSwitch33BreakEnd
    extends IntraChromosomalStrandSwitchBreakEnd {
        @VisibleForTesting
        public IntraChromosomalStrandSwitch33BreakEnd(String variantCHR, int variantPOS, String variantId, Allele refAllele, Allele altAllele, Map<String, Object> extraAttributes, boolean isTheUpstreamMate) {
            super(variantCHR, variantPOS, variantId, refAllele, altAllele, extraAttributes, isTheUpstreamMate);
        }

        private IntraChromosomalStrandSwitch33BreakEnd(NovelAdjacencyAndAltHaplotype narl, BasicReference reference, boolean isTheUpstreamMate) {
            super(isTheUpstreamMate ? narl.getLeftJustifiedLeftRefLoc().getContig() : narl.getLeftJustifiedRightRefLoc().getContig(), isTheUpstreamMate ? narl.getLeftJustifiedLeftRefLoc().getStart() : narl.getLeftJustifiedRightRefLoc().getEnd(), BreakEndVariantType.getIDString(narl, isTheUpstreamMate), Allele.create((String)BreakEndVariantType.getRefBaseString(narl, isTheUpstreamMate, reference), (boolean)true), IntraChromosomalStrandSwitch33BreakEnd.constructAltAllele(BreakEndVariantType.getRefBaseString(narl, isTheUpstreamMate, reference), IntraChromosomalStrandSwitch33BreakEnd.extractInsertedSequence(narl, isTheUpstreamMate), isTheUpstreamMate ? narl.getLeftJustifiedRightRefLoc() : narl.getLeftJustifiedLeftRefLoc()), INV33_FLAG, isTheUpstreamMate);
        }

        public static Tuple2<BreakEndVariantType, BreakEndVariantType> getOrderedMates(NovelAdjacencyAndAltHaplotype narl, BasicReference reference) {
            return new Tuple2((Object)new IntraChromosomalStrandSwitch33BreakEnd(narl, reference, true), (Object)new IntraChromosomalStrandSwitch33BreakEnd(narl, reference, false));
        }

        private static Allele constructAltAllele(String refBase, String insertedSequence, SimpleInterval novelAdjRefLoc) {
            return Allele.create((String)("[" + novelAdjRefLoc.getContig() + ":" + novelAdjRefLoc.getEnd() + "[" + insertedSequence + refBase));
        }
    }

    public static final class IntraChromosomalStrandSwitch55BreakEnd
    extends IntraChromosomalStrandSwitchBreakEnd {
        @VisibleForTesting
        public IntraChromosomalStrandSwitch55BreakEnd(String variantCHR, int variantPOS, String variantId, Allele refAllele, Allele altAllele, Map<String, Object> extraAttributes, boolean isTheUpstreamMate) {
            super(variantCHR, variantPOS, variantId, refAllele, altAllele, extraAttributes, isTheUpstreamMate);
        }

        private IntraChromosomalStrandSwitch55BreakEnd(NovelAdjacencyAndAltHaplotype narl, BasicReference reference, boolean isTheUpstreamMate) {
            super(isTheUpstreamMate ? narl.getLeftJustifiedLeftRefLoc().getContig() : narl.getLeftJustifiedRightRefLoc().getContig(), isTheUpstreamMate ? narl.getLeftJustifiedLeftRefLoc().getStart() : narl.getLeftJustifiedRightRefLoc().getEnd(), BreakEndVariantType.getIDString(narl, isTheUpstreamMate), Allele.create((String)BreakEndVariantType.getRefBaseString(narl, isTheUpstreamMate, reference), (boolean)true), IntraChromosomalStrandSwitch55BreakEnd.constructAltAllele(BreakEndVariantType.getRefBaseString(narl, isTheUpstreamMate, reference), IntraChromosomalStrandSwitch55BreakEnd.extractInsertedSequence(narl, isTheUpstreamMate), isTheUpstreamMate ? narl.getLeftJustifiedRightRefLoc() : narl.getLeftJustifiedLeftRefLoc()), INV55_FLAG, isTheUpstreamMate);
        }

        public static Tuple2<BreakEndVariantType, BreakEndVariantType> getOrderedMates(NovelAdjacencyAndAltHaplotype narl, BasicReference reference) {
            return new Tuple2((Object)new IntraChromosomalStrandSwitch55BreakEnd(narl, reference, true), (Object)new IntraChromosomalStrandSwitch55BreakEnd(narl, reference, false));
        }

        private static Allele constructAltAllele(String refBase, String insertedSequence, SimpleInterval novelAdjRefLoc) {
            return Allele.create((String)(refBase + insertedSequence + "]" + novelAdjRefLoc.getContig() + ":" + novelAdjRefLoc.getEnd() + "]"));
        }
    }

    private static abstract class IntraChromosomalStrandSwitchBreakEnd
    extends BreakEndVariantType {
        static final Map<String, Object> INV55_FLAG = Collections.singletonMap("INV55", true);
        static final Map<String, Object> INV33_FLAG = Collections.singletonMap("INV33", true);

        private IntraChromosomalStrandSwitchBreakEnd(String variantCHR, int variantPOS, String variantId, Allele refAllele, Allele altAllele, Map<String, Object> extraAttributes, boolean isTheUpstreamMate) {
            super(variantCHR, variantPOS, variantId, refAllele, altAllele, extraAttributes, isTheUpstreamMate);
        }

        @VisibleForTesting
        static String extractInsertedSequence(NovelAdjacencyAndAltHaplotype narl, boolean forUpstreamLoc) {
            String ins = narl.getComplication().getInsertedSequenceForwardStrandRep();
            return forUpstreamLoc ? ins : SequenceUtil.reverseComplement((String)ins);
        }
    }

    public static enum SupportedType {
        INTRA_CHR_STRAND_SWITCH_55,
        INTRA_CHR_STRAND_SWITCH_33,
        INTRA_CHR_REF_ORDER_SWAP,
        INTER_CHR_STRAND_SWITCH_55,
        INTER_CHR_STRAND_SWITCH_33,
        INTER_CHR_NO_SS_WITH_LEFT_MATE_FIRST_IN_PARTNER,
        INTER_CHR_NO_SS_WITH_LEFT_MATE_SECOND_IN_PARTNER;

    }
}

