/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.spark.sv.discovery;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.variant.variantcontext.VariantContext;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.broadcast.Broadcast;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.ArgumentCollection;
import org.broadinstitute.barclay.argparser.BetaFeature;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.cmdline.programgroups.StructuralVariantDiscoveryProgramGroup;
import org.broadinstitute.hellbender.engine.filters.ReadFilter;
import org.broadinstitute.hellbender.engine.filters.ReadFilterLibrary;
import org.broadinstitute.hellbender.engine.spark.GATKSparkTool;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.tools.spark.sv.StructuralVariationDiscoveryArgumentCollection;
import org.broadinstitute.hellbender.tools.spark.sv.StructuralVariationDiscoveryPipelineSpark;
import org.broadinstitute.hellbender.tools.spark.sv.discovery.SvDiscoveryInputMetaData;
import org.broadinstitute.hellbender.tools.spark.sv.discovery.alignment.AlignedContig;
import org.broadinstitute.hellbender.tools.spark.sv.discovery.alignment.AssemblyContigAlignmentsRDDProcessor;
import org.broadinstitute.hellbender.tools.spark.sv.discovery.inference.ContigChimericAlignmentIterativeInterpreter;
import org.broadinstitute.hellbender.tools.spark.sv.utils.SVIntervalTree;
import org.broadinstitute.hellbender.tools.spark.sv.utils.SVUtils;
import org.broadinstitute.hellbender.tools.spark.sv.utils.SVVCFWriter;

@DocumentedFeature
@BetaFeature
@CommandLineProgramProperties(oneLineSummary="(Internal) Examines aligned contigs from local assemblies and calls structural variants", summary="This tool is used in development and should not be of interest to most researchers.  It packages structural variant calling as a separate tool, independent of the generation of local assemblies. Most researchers will run StructuralVariationDiscoveryPipelineSpark, which both generates local assemblies of interesting genomic regions, and then calls structural variants from these assemblies. This tool takes a SAM/BAM/CRAM containing the alignments of assembled contigs from local assemblies and searches it for split alignments indicating the presence of structural variations. To do so the tool parses primary and supplementary alignments; secondary alignments are ignored. To be considered valid evidence of an SV, two alignments from the same contig must have mapping quality 60, and both alignments must have length greater than or equal to min-alignment-length. Imprecise variants with approximate locations are also called.\n The input file is typically the output file produced by FindBreakpointEvidenceSpark.", programGroup=StructuralVariantDiscoveryProgramGroup.class)
public final class DiscoverVariantsFromContigAlignmentsSAMSpark
extends GATKSparkTool {
    private static final long serialVersionUID = 1L;
    private final Logger localLogger = LogManager.getLogger(DiscoverVariantsFromContigAlignmentsSAMSpark.class);
    @ArgumentCollection
    private final StructuralVariationDiscoveryArgumentCollection.DiscoverVariantsFromContigAlignmentsArgumentCollection discoverStageArgs = new StructuralVariationDiscoveryArgumentCollection.DiscoverVariantsFromContigAlignmentsArgumentCollection();
    @Argument(doc="prefix for discovery (non-genotyped) VCF; sample name will be appended after the provided argument, followed by \"_inv_del_ins.vcf\"", shortName="O", fullName="output")
    private String prefixForOutput;

    @Override
    public boolean requiresReference() {
        return true;
    }

    @Override
    public boolean requiresReads() {
        return true;
    }

    @Override
    public List<ReadFilter> getDefaultReadFilters() {
        return Collections.singletonList(ReadFilterLibrary.MAPPED);
    }

    @Override
    protected void runTool(JavaSparkContext ctx) {
        this.validateParams();
        Broadcast<SVIntervalTree<VariantContext>> cnvCallsBroadcast = StructuralVariationDiscoveryPipelineSpark.broadcastCNVCalls(ctx, this.getHeaderForReads(), this.discoverStageArgs.cnvCallsFile);
        String vcfOutputPath = this.getVcfOutputPath();
        SvDiscoveryInputMetaData svDiscoveryInputMetaData = new SvDiscoveryInputMetaData(ctx, this.discoverStageArgs, null, vcfOutputPath, null, null, null, cnvCallsBroadcast, this.getHeaderForReads(), this.getReference(), this.getDefaultToolVCFHeaderLines(), this.localLogger);
        JavaRDD<AlignedContig> parsedContigAlignments = new AssemblyContigAlignmentsRDDProcessor.SAMFormattedContigAlignmentParser(this.getReads(), (SAMFileHeader)svDiscoveryInputMetaData.getSampleSpecificData().getHeaderBroadcast().getValue(), true).getAlignedContigs();
        List<VariantContext> annotatedVariants = ContigChimericAlignmentIterativeInterpreter.discoverVariantsFromChimeras(svDiscoveryInputMetaData, parsedContigAlignments);
        SAMSequenceDictionary refSeqDictionary = (SAMSequenceDictionary)svDiscoveryInputMetaData.getReferenceData().getReferenceSequenceDictionaryBroadcast().getValue();
        SVVCFWriter.writeVCF(annotatedVariants, vcfOutputPath, refSeqDictionary, this.getDefaultToolVCFHeaderLines(), this.localLogger);
    }

    private void validateParams() {
        this.discoverStageArgs.validate();
    }

    private String getVcfOutputPath() {
        if (Files.exists(Paths.get(this.prefixForOutput, new String[0]), new LinkOption[0])) {
            if (Files.isDirectory(Paths.get(this.prefixForOutput, new String[0]), new LinkOption[0])) {
                return this.prefixForOutput + (this.prefixForOutput.endsWith("/") ? "" : "/") + SVUtils.getSampleId(this.getHeaderForReads()) + "_inv_del_ins.vcf";
            }
            throw new UserException("Provided prefix for output is pointing to an existing file: " + this.prefixForOutput);
        }
        return this.prefixForOutput + (this.prefixForOutput.endsWith("/") ? "" : "_") + SVUtils.getSampleId(this.getHeaderForReads()) + "_inv_del_ins.vcf";
    }
}

