/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.spark.sv.discovery;

import htsjdk.variant.variantcontext.VariantContext;
import org.broadinstitute.hellbender.tools.spark.sv.discovery.StructuralVariantFilter;

public final class SVAlignmentLengthFilter
implements StructuralVariantFilter {
    static final long serialVersionUID = 1L;
    private static final String attributeKey = "MAX_ALIGN_LENGTH";
    private final int threshold;

    public SVAlignmentLengthFilter(int threshold) {
        this.threshold = threshold;
    }

    @Override
    public String getName() {
        return "SHORT_ALN";
    }

    @Override
    public boolean test(VariantContext variantContext) {
        if (!variantContext.hasAttribute("CTG_NAMES")) {
            return true;
        }
        int alnLength = variantContext.getAttributeAsInt(attributeKey, 0);
        return alnLength >= this.threshold;
    }
}

