/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.spark.sv.discovery;

import htsjdk.variant.variantcontext.VariantContext;
import java.util.List;
import org.broadinstitute.hellbender.tools.spark.sv.discovery.StructuralVariantFilter;
import org.broadinstitute.hellbender.tools.spark.sv.utils.SVUtils;

public final class SVMappingQualityFilter
implements StructuralVariantFilter {
    static final long serialVersionUID = 1L;
    private static final String attributeKey = "MAPPING_QUALITIES";
    private final int threshold;

    public SVMappingQualityFilter(int threshold) {
        this.threshold = threshold;
    }

    @Override
    public String getName() {
        return "LOW_MQ";
    }

    @Override
    public boolean test(VariantContext variantContext) {
        if (!variantContext.hasAttribute("CTG_NAMES")) {
            return true;
        }
        List<String> mapQuals = SVUtils.getAttributeAsStringList(variantContext, attributeKey);
        int maxMQ = 0;
        for (String mapQual : mapQuals) {
            Integer integer = Integer.valueOf(mapQual);
            maxMQ = maxMQ < integer ? integer : maxMQ;
        }
        return maxMQ >= this.threshold;
    }
}

