/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.spark.sv.discovery;

import com.google.common.annotations.VisibleForTesting;
import htsjdk.variant.variantcontext.Allele;
import java.util.Collections;
import java.util.Map;
import org.broadinstitute.hellbender.engine.BasicReference;
import org.broadinstitute.hellbender.engine.spark.datasources.ReferenceMultiSparkSource;
import org.broadinstitute.hellbender.tools.spark.sv.discovery.SvType;
import org.broadinstitute.hellbender.tools.spark.sv.discovery.alignment.StrandSwitch;
import org.broadinstitute.hellbender.tools.spark.sv.discovery.inference.BreakpointComplications;
import org.broadinstitute.hellbender.tools.spark.sv.discovery.inference.NovelAdjacencyAndAltHaplotype;
import org.broadinstitute.hellbender.tools.spark.sv.evidence.EvidenceTargetLink;
import org.broadinstitute.hellbender.tools.spark.sv.evidence.ReadMetadata;
import org.broadinstitute.hellbender.tools.spark.sv.utils.SVInterval;
import org.broadinstitute.hellbender.utils.SimpleInterval;

public abstract class SimpleSVType
extends SvType {
    public static String createBracketedSymbAlleleString(String vcfHeaderDefinedSymbAltAllele) {
        return "<" + vcfHeaderDefinedSymbAltAllele + ">";
    }

    protected SimpleSVType(String variantCHR, int variantPOS, int variantEND, String variantId, Allele refAllele, Allele altAllele, int svLen, Map<String, Object> extraAttributes) {
        super(variantCHR, variantPOS, variantEND, variantId, refAllele, altAllele, svLen, extraAttributes);
    }

    @Override
    public final boolean hasApplicableEnd() {
        return true;
    }

    @Override
    public final boolean hasApplicableLength() {
        return true;
    }

    public static final class DuplicationInverted
    extends SimpleSVType {
        public String toString() {
            return "DUP:INV";
        }

        public DuplicationInverted(NovelAdjacencyAndAltHaplotype novelAdjacencyAndAltHaplotype, BasicReference reference) {
            super(novelAdjacencyAndAltHaplotype.getLeftJustifiedLeftRefLoc().getContig(), novelAdjacencyAndAltHaplotype.getLeftJustifiedLeftRefLoc().getStart(), novelAdjacencyAndAltHaplotype.getLeftJustifiedLeftRefLoc().getStart(), DuplicationInverted.getIDString(novelAdjacencyAndAltHaplotype), Allele.create((byte[])DuplicationInverted.extractRefBases(novelAdjacencyAndAltHaplotype.getLeftJustifiedLeftRefLoc(), reference), (boolean)true), Allele.create((String)DuplicationInverted.createBracketedSymbAlleleString("DUP:INV")), DuplicationInverted.getSVLen(novelAdjacencyAndAltHaplotype), noExtraAttributes);
        }

        private static int getSVLen(NovelAdjacencyAndAltHaplotype novelAdjacencyAndAltHaplotype) {
            return ((BreakpointComplications.InvertedDuplicationBreakpointComplications)novelAdjacencyAndAltHaplotype.getComplication()).getDupSeqRepeatUnitRefSpan().size();
        }

        private static String getIDString(NovelAdjacencyAndAltHaplotype novelAdjacencyAndAltHaplotype) {
            return "INS-DUPLICATION-INVERTED-EXPANSION_" + DuplicationInverted.makeLocationString(novelAdjacencyAndAltHaplotype);
        }
    }

    public static final class ImpreciseDeletion
    extends SimpleSVType {
        public String toString() {
            return SupportedType.DEL.name();
        }

        public ImpreciseDeletion(EvidenceTargetLink evidenceTargetLink, int svLength, ReadMetadata metadata, ReferenceMultiSparkSource reference) {
            super(metadata.getContigName(evidenceTargetLink.getPairedStrandedIntervals().getLeft().getInterval().getContig()), evidenceTargetLink.getPairedStrandedIntervals().getLeft().getInterval().midpoint(), evidenceTargetLink.getPairedStrandedIntervals().getRight().getInterval().midpoint(), ImpreciseDeletion.getIDString(evidenceTargetLink, metadata), Allele.create((byte[])ImpreciseDeletion.getRefBases(evidenceTargetLink, metadata, reference), (boolean)true), Allele.create((String)ImpreciseDeletion.createBracketedSymbAlleleString("DEL")), svLength, Collections.singletonMap("IMPRECISE", true));
        }

        private static byte[] getRefBases(EvidenceTargetLink evidenceTargetLink, ReadMetadata metadata, ReferenceMultiSparkSource reference) {
            SVInterval leftInterval = evidenceTargetLink.getPairedStrandedIntervals().getLeft().getInterval();
            return ImpreciseDeletion.extractRefBases(new SimpleInterval(metadata.getContigName(leftInterval.getContig()), leftInterval.midpoint(), leftInterval.midpoint()), reference);
        }

        private static String getIDString(EvidenceTargetLink evidenceTargetLink, ReadMetadata metadata) {
            SVInterval leftInterval = evidenceTargetLink.getPairedStrandedIntervals().getLeft().getInterval();
            SVInterval rightInterval = evidenceTargetLink.getPairedStrandedIntervals().getRight().getInterval();
            return SupportedType.DEL.name() + "_" + "IMPRECISE" + "_" + metadata.getContigName(leftInterval.getContig()) + "_" + leftInterval.getStart() + "_" + leftInterval.getEnd() + "_" + rightInterval.getStart() + "_" + rightInterval.getEnd();
        }
    }

    public static final class DuplicationTandem
    extends SimpleSVType {
        public String toString() {
            return SupportedType.DUP.name();
        }

        @VisibleForTesting
        public DuplicationTandem(String variantCHR, int variantPOS, int variantEND, String variantId, Allele refAllele, Allele altAllele, int svLen, Map<String, Object> extraAttributes) {
            super(variantCHR, variantPOS, variantEND, variantId, refAllele, altAllele, svLen, extraAttributes);
        }

        public DuplicationTandem(NovelAdjacencyAndAltHaplotype novelAdjacencyAndAltHaplotype, BasicReference reference) {
            super(novelAdjacencyAndAltHaplotype.getLeftJustifiedLeftRefLoc().getContig(), novelAdjacencyAndAltHaplotype.getLeftJustifiedLeftRefLoc().getStart(), novelAdjacencyAndAltHaplotype.getLeftJustifiedLeftRefLoc().getStart(), DuplicationTandem.getIDString(novelAdjacencyAndAltHaplotype), Allele.create((byte[])DuplicationTandem.extractRefBases(novelAdjacencyAndAltHaplotype.getLeftJustifiedLeftRefLoc(), reference), (boolean)true), Allele.create((String)DuplicationTandem.createBracketedSymbAlleleString("DUP")), novelAdjacencyAndAltHaplotype.getLengthForDupTandemExpansion(), Collections.singletonMap("EXPANSION", true));
        }

        private static String getIDString(NovelAdjacencyAndAltHaplotype novelAdjacencyAndAltHaplotype) {
            SimpleInterval dupSeqRepeatUnitRefSpan = ((BreakpointComplications.SmallDuplicationBreakpointComplications)novelAdjacencyAndAltHaplotype.getComplication()).getDupSeqRepeatUnitRefSpan();
            return "INS-DUPLICATION-TANDEM-EXPANSION_" + DuplicationTandem.makeLocationString(dupSeqRepeatUnitRefSpan.getContig(), dupSeqRepeatUnitRefSpan.getStart(), dupSeqRepeatUnitRefSpan.getContig(), dupSeqRepeatUnitRefSpan.getEnd());
        }
    }

    public static final class Insertion
    extends SimpleSVType {
        public String toString() {
            return SupportedType.INS.name();
        }

        @VisibleForTesting
        public Insertion(String variantCHR, int variantPOS, int variantEND, String variantId, Allele refAllele, Allele altAllele, int svLen, Map<String, Object> extraAttributes) {
            super(variantCHR, variantPOS, variantEND, variantId, refAllele, altAllele, svLen, extraAttributes);
        }

        public Insertion(NovelAdjacencyAndAltHaplotype novelAdjacencyAndAltHaplotype, BasicReference reference) {
            super(novelAdjacencyAndAltHaplotype.getLeftJustifiedLeftRefLoc().getContig(), novelAdjacencyAndAltHaplotype.getLeftJustifiedLeftRefLoc().getStart(), Insertion.getEnd(novelAdjacencyAndAltHaplotype), Insertion.getIDString(novelAdjacencyAndAltHaplotype), Allele.create((byte[])Insertion.getRefBases(novelAdjacencyAndAltHaplotype, reference), (boolean)true), Allele.create((String)Insertion.createBracketedSymbAlleleString("INS")), Insertion.getLength(novelAdjacencyAndAltHaplotype), noExtraAttributes);
        }

        private static int getEnd(NovelAdjacencyAndAltHaplotype novelAdjacencyAndAltHaplotype) {
            return novelAdjacencyAndAltHaplotype.isCandidateForFatInsertion() ? novelAdjacencyAndAltHaplotype.getLeftJustifiedRightRefLoc().getEnd() : novelAdjacencyAndAltHaplotype.getLeftJustifiedLeftRefLoc().getStart();
        }

        private static byte[] getRefBases(NovelAdjacencyAndAltHaplotype novelAdjacencyAndAltHaplotype, BasicReference reference) {
            return Insertion.extractRefBases(novelAdjacencyAndAltHaplotype.isCandidateForFatInsertion() ? novelAdjacencyAndAltHaplotype.getIntervalForFatInsertion() : novelAdjacencyAndAltHaplotype.getLeftJustifiedLeftRefLoc(), reference);
        }

        private static int getLength(NovelAdjacencyAndAltHaplotype novelAdjacencyAndAltHaplotype) {
            return novelAdjacencyAndAltHaplotype.getComplication().hasDuplicationAnnotation() ? novelAdjacencyAndAltHaplotype.getLengthForDupTandemExpansion() : novelAdjacencyAndAltHaplotype.getComplication().getInsertedSequenceForwardStrandRep().length();
        }

        private static String getIDString(NovelAdjacencyAndAltHaplotype novelAdjacencyAndAltHaplotype) {
            if (novelAdjacencyAndAltHaplotype.isCandidateForFatInsertion()) {
                return SupportedType.INS.name() + "_" + Insertion.makeLocationString(novelAdjacencyAndAltHaplotype);
            }
            return SupportedType.INS.name() + "_" + Insertion.makeLocationString(novelAdjacencyAndAltHaplotype.getLeftJustifiedLeftRefLoc().getContig(), novelAdjacencyAndAltHaplotype.getLeftJustifiedLeftRefLoc().getStart(), novelAdjacencyAndAltHaplotype.getLeftJustifiedLeftRefLoc().getContig(), novelAdjacencyAndAltHaplotype.getLeftJustifiedLeftRefLoc().getStart());
        }
    }

    public static final class Deletion
    extends SimpleSVType {
        public String toString() {
            return SupportedType.DEL.name();
        }

        @VisibleForTesting
        public Deletion(String variantCHR, int variantPOS, int variantEND, String variantId, Allele refAllele, Allele altAllele, int svLen, Map<String, Object> extraAttributes) {
            super(variantCHR, variantPOS, variantEND, variantId, refAllele, altAllele, svLen, extraAttributes);
        }

        public Deletion(NovelAdjacencyAndAltHaplotype novelAdjacencyAndAltHaplotype, BasicReference reference) {
            super(novelAdjacencyAndAltHaplotype.getLeftJustifiedLeftRefLoc().getContig(), novelAdjacencyAndAltHaplotype.getLeftJustifiedLeftRefLoc().getStart(), novelAdjacencyAndAltHaplotype.getLeftJustifiedRightRefLoc().getEnd(), Deletion.getIDString(novelAdjacencyAndAltHaplotype), Allele.create((byte[])Deletion.extractRefBases(novelAdjacencyAndAltHaplotype.getLeftJustifiedLeftRefLoc(), reference), (boolean)true), Allele.create((String)Deletion.createBracketedSymbAlleleString("DEL")), -novelAdjacencyAndAltHaplotype.getDistanceBetweenNovelAdjacencies(), (Map<String, Object>)(novelAdjacencyAndAltHaplotype.hasDuplicationAnnotation() ? Collections.singletonMap("CONTRACTION", true) : noExtraAttributes));
        }

        private static String getIDString(NovelAdjacencyAndAltHaplotype novelAdjacencyAndAltHaplotype) {
            return (novelAdjacencyAndAltHaplotype.hasDuplicationAnnotation() ? "DEL-DUPLICATION-TANDEM-CONTRACTION" : SupportedType.DEL.name()) + "_" + Deletion.makeLocationString(novelAdjacencyAndAltHaplotype);
        }
    }

    public static final class Inversion
    extends SimpleSVType {
        public String toString() {
            return SupportedType.INV.name();
        }

        @VisibleForTesting
        public Inversion(String variantCHR, int variantPOS, int variantEND, String variantId, Allele refAllele, Allele altAllele, int svLen, Map<String, Object> extraAttributes) {
            super(variantCHR, variantPOS, variantEND, variantId, refAllele, altAllele, svLen, extraAttributes);
        }

        @VisibleForTesting
        public Inversion(NovelAdjacencyAndAltHaplotype novelAdjacencyAndAltHaplotype, int svLength, BasicReference reference) {
            super(novelAdjacencyAndAltHaplotype.getLeftJustifiedLeftRefLoc().getContig(), novelAdjacencyAndAltHaplotype.getLeftJustifiedLeftRefLoc().getStart(), novelAdjacencyAndAltHaplotype.getLeftJustifiedRightRefLoc().getEnd(), Inversion.getIDString(novelAdjacencyAndAltHaplotype), Allele.create((byte[])Inversion.extractRefBases(novelAdjacencyAndAltHaplotype.getLeftJustifiedLeftRefLoc(), reference), (boolean)true), Allele.create((String)Inversion.createBracketedSymbAlleleString("INV")), svLength, Collections.singletonMap(novelAdjacencyAndAltHaplotype.getStrandSwitch() == StrandSwitch.FORWARD_TO_REVERSE ? "INV55" : "INV33", true));
        }

        private static String getIDString(NovelAdjacencyAndAltHaplotype novelAdjacencyAndAltHaplotype) {
            StrandSwitch strandSwitch = novelAdjacencyAndAltHaplotype.getStrandSwitch();
            return (strandSwitch.equals((Object)StrandSwitch.FORWARD_TO_REVERSE) ? "INV55" : "INV33") + "_" + Inversion.makeLocationString(novelAdjacencyAndAltHaplotype);
        }
    }

    public static enum SupportedType {
        INV,
        DEL,
        INS,
        DUP,
        DUP_INV;

    }
}

