/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.spark.sv.discovery;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.vcf.VCFHeaderLine;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.Logger;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.broadcast.Broadcast;
import org.broadinstitute.hellbender.engine.spark.datasources.ReferenceMultiSparkSource;
import org.broadinstitute.hellbender.tools.spark.sv.StructuralVariationDiscoveryArgumentCollection;
import org.broadinstitute.hellbender.tools.spark.sv.evidence.EvidenceTargetLink;
import org.broadinstitute.hellbender.tools.spark.sv.evidence.ReadMetadata;
import org.broadinstitute.hellbender.tools.spark.sv.utils.PairedStrandedIntervalTree;
import org.broadinstitute.hellbender.tools.spark.sv.utils.SVInterval;
import org.broadinstitute.hellbender.tools.spark.sv.utils.SVIntervalTree;
import org.broadinstitute.hellbender.tools.spark.sv.utils.SVUtils;

public final class SvDiscoveryInputMetaData {
    private final ReferenceData referenceData;
    private final SampleSpecificData sampleSpecificData;
    private final StructuralVariationDiscoveryArgumentCollection.DiscoverVariantsFromContigAlignmentsArgumentCollection discoverStageArgs;
    private final Set<VCFHeaderLine> defaultToolVCFHeaderLines;
    private final Logger toolLogger;
    private String outputPath;

    public ReferenceData getReferenceData() {
        return this.referenceData;
    }

    public SampleSpecificData getSampleSpecificData() {
        return this.sampleSpecificData;
    }

    public StructuralVariationDiscoveryArgumentCollection.DiscoverVariantsFromContigAlignmentsArgumentCollection getDiscoverStageArgs() {
        return this.discoverStageArgs;
    }

    public Logger getToolLogger() {
        return this.toolLogger;
    }

    public String getOutputPath() {
        return this.outputPath;
    }

    public Set<VCFHeaderLine> getDefaultToolVCFHeaderLines() {
        return this.defaultToolVCFHeaderLines;
    }

    public SvDiscoveryInputMetaData(JavaSparkContext ctx, StructuralVariationDiscoveryArgumentCollection.DiscoverVariantsFromContigAlignmentsArgumentCollection discoverStageArgs, String nonCanonicalChromosomeNamesFile, String outputPath, ReadMetadata readMetadata, List<SVInterval> assembledIntervals, PairedStrandedIntervalTree<EvidenceTargetLink> evidenceTargetLinks, Broadcast<SVIntervalTree<VariantContext>> cnvCallsBroadcast, SAMFileHeader headerForReads, ReferenceMultiSparkSource reference, Set<VCFHeaderLine> defaultToolVCFHeaderLines, Logger toolLogger) {
        SAMSequenceDictionary sequenceDictionary = headerForReads.getSequenceDictionary();
        Broadcast canonicalChromosomesBroadcast = ctx.broadcast(SVUtils.getCanonicalChromosomes(nonCanonicalChromosomeNamesFile, sequenceDictionary));
        String sampleId = SVUtils.getSampleId(headerForReads);
        this.referenceData = new ReferenceData((Broadcast<Set<String>>)canonicalChromosomesBroadcast, (Broadcast<ReferenceMultiSparkSource>)ctx.broadcast((Object)reference), (Broadcast<SAMSequenceDictionary>)ctx.broadcast((Object)sequenceDictionary));
        this.sampleSpecificData = new SampleSpecificData(sampleId, cnvCallsBroadcast, assembledIntervals, evidenceTargetLinks, readMetadata, (Broadcast<SAMFileHeader>)ctx.broadcast((Object)headerForReads));
        this.discoverStageArgs = discoverStageArgs;
        this.outputPath = outputPath;
        this.defaultToolVCFHeaderLines = defaultToolVCFHeaderLines;
        this.toolLogger = toolLogger;
    }

    public void updateOutputPath(String newOutputPath) {
        this.outputPath = newOutputPath;
    }

    public static final class SampleSpecificData {
        private final String sampleId;
        private final ReadMetadata readMetadata;
        private final Broadcast<SAMFileHeader> headerBroadcast;
        private final Broadcast<SVIntervalTree<VariantContext>> cnvCallsBroadcast;
        private final PairedStrandedIntervalTree<EvidenceTargetLink> evidenceTargetLinks;
        private final List<SVInterval> assembledIntervals;

        public SampleSpecificData(String sampleId, Broadcast<SVIntervalTree<VariantContext>> cnvCallsBroadcast, List<SVInterval> assembledIntervals, PairedStrandedIntervalTree<EvidenceTargetLink> evidenceTargetLinks, ReadMetadata readMetadata, Broadcast<SAMFileHeader> headerBroadcast) {
            this.sampleId = sampleId;
            this.cnvCallsBroadcast = cnvCallsBroadcast;
            this.assembledIntervals = assembledIntervals;
            this.evidenceTargetLinks = evidenceTargetLinks;
            this.readMetadata = readMetadata;
            this.headerBroadcast = headerBroadcast;
        }

        public String getSampleId() {
            return this.sampleId;
        }

        public ReadMetadata getReadMetadata() {
            return this.readMetadata;
        }

        public Broadcast<SAMFileHeader> getHeaderBroadcast() {
            return this.headerBroadcast;
        }

        public Broadcast<SVIntervalTree<VariantContext>> getCnvCallsBroadcast() {
            return this.cnvCallsBroadcast;
        }

        public PairedStrandedIntervalTree<EvidenceTargetLink> getEvidenceTargetLinks() {
            return this.evidenceTargetLinks;
        }

        public List<SVInterval> getAssembledIntervals() {
            return this.assembledIntervals;
        }
    }

    public static final class ReferenceData {
        private final Broadcast<Set<String>> canonicalChromosomesBroadcast;
        private final Broadcast<ReferenceMultiSparkSource> referenceBroadcast;
        private final Broadcast<SAMSequenceDictionary> referenceSequenceDictionaryBroadcast;

        ReferenceData(Broadcast<Set<String>> canonicalChromosomesBroadcast, Broadcast<ReferenceMultiSparkSource> referenceBroadcast, Broadcast<SAMSequenceDictionary> referenceSequenceDictionaryBroadcast) {
            this.canonicalChromosomesBroadcast = canonicalChromosomesBroadcast;
            this.referenceBroadcast = referenceBroadcast;
            this.referenceSequenceDictionaryBroadcast = referenceSequenceDictionaryBroadcast;
        }

        public Broadcast<Set<String>> getCanonicalChromosomesBroadcast() {
            return this.canonicalChromosomesBroadcast;
        }

        public Broadcast<ReferenceMultiSparkSource> getReferenceBroadcast() {
            return this.referenceBroadcast;
        }

        public Broadcast<SAMSequenceDictionary> getReferenceSequenceDictionaryBroadcast() {
            return this.referenceSequenceDictionaryBroadcast;
        }
    }
}

