/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.spark.sv.discovery;

import htsjdk.samtools.SAMSequenceDictionary;
import java.util.List;
import org.apache.logging.log4j.Logger;
import org.broadinstitute.hellbender.tools.spark.sv.StructuralVariationDiscoveryArgumentCollection;
import org.broadinstitute.hellbender.tools.spark.sv.discovery.inference.BreakpointComplications;
import org.broadinstitute.hellbender.tools.spark.sv.discovery.inference.NovelAdjacencyAndAltHaplotype;
import org.broadinstitute.hellbender.tools.spark.sv.utils.SVInterval;
import org.broadinstitute.hellbender.tools.spark.sv.utils.SVIntervalTree;
import org.broadinstitute.hellbender.tools.spark.sv.utils.SVVCFReader;
import org.broadinstitute.hellbender.utils.SimpleInterval;

public final class SvDiscoveryUtils {
    public static void evaluateIntervalsAndNarls(List<SVInterval> assembledIntervals, List<NovelAdjacencyAndAltHaplotype> narls, SAMSequenceDictionary referenceSequenceDictionary, StructuralVariationDiscoveryArgumentCollection.DiscoverVariantsFromContigAlignmentsArgumentCollection parameters, Logger toolLogger) {
        if (parameters.truthVCF != null) {
            SVIntervalTree<String> trueBreakpoints = SVVCFReader.readBreakpointsFromTruthVCF(parameters.truthVCF, referenceSequenceDictionary, parameters.truthIntervalPadding);
            if (assembledIntervals != null) {
                SvDiscoveryUtils.evaluateIntervalsAgainstTruth(assembledIntervals, trueBreakpoints, toolLogger);
            }
            SVIntervalTree<String> narlyBreakpoints = SvDiscoveryUtils.readBreakpointsFromNarls(narls, referenceSequenceDictionary, parameters.truthIntervalPadding);
            SvDiscoveryUtils.evaluateNarlsAgainstTruth(narlyBreakpoints, trueBreakpoints, toolLogger);
        }
    }

    private static SVIntervalTree<String> readBreakpointsFromNarls(List<NovelAdjacencyAndAltHaplotype> narls, SAMSequenceDictionary dictionary, int breakpointPadding) {
        SVIntervalTree<String> breakpoints = new SVIntervalTree<String>();
        for (NovelAdjacencyAndAltHaplotype narl : narls) {
            int padding = breakpointPadding + SvDiscoveryUtils.getAmbiguity(narl.getComplication());
            SimpleInterval si1 = narl.getLeftJustifiedLeftRefLoc();
            breakpoints.put(new SVInterval(dictionary.getSequenceIndex(si1.getContig()), si1.getStart() - padding, si1.getStart() + padding), null);
            SimpleInterval si2 = narl.getLeftJustifiedRightRefLoc();
            breakpoints.put(new SVInterval(dictionary.getSequenceIndex(si2.getContig()), si2.getStart() - padding, si2.getStart() + padding), null);
        }
        return breakpoints;
    }

    private static void evaluateNarlsAgainstTruth(SVIntervalTree<String> narlyBreakpoints, SVIntervalTree<String> trueBreakpoints, Logger localLogger) {
        float falsePos = 1.0f - narlyBreakpoints.overlapFraction(trueBreakpoints);
        int nNarly = narlyBreakpoints.size();
        localLogger.info("Breakpoint false positive rate = " + falsePos + " (" + Math.round(falsePos * (float)nNarly) + "/" + nNarly + ")");
        float falseNeg = 1.0f - trueBreakpoints.overlapFraction(narlyBreakpoints);
        int nTrue = trueBreakpoints.size();
        localLogger.info("Breakpoint false negative rate = " + falseNeg + " (" + Math.round(falseNeg * (float)nTrue) + "/" + nTrue + ")");
    }

    private static void evaluateIntervalsAgainstTruth(List<SVInterval> assembledIntervals, SVIntervalTree<String> trueBreakpoints, Logger localLogger) {
        SVIntervalTree<Integer> intervals = new SVIntervalTree<Integer>();
        int nIntervals = assembledIntervals.size();
        for (int idx = 0; idx != nIntervals; ++idx) {
            intervals.put(assembledIntervals.get(idx), idx);
        }
        float falsePos = 1.0f - intervals.overlapFraction(trueBreakpoints);
        localLogger.info("Interval false positive rate = " + falsePos + " (" + Math.round(falsePos * (float)nIntervals) + "/" + nIntervals + ")");
        float falseNeg = 1.0f - trueBreakpoints.overlapFraction(intervals);
        int nTrue = trueBreakpoints.size();
        localLogger.info("Interval false negative rate = " + falseNeg + " (" + Math.round(falseNeg * (float)nTrue) + "/" + nTrue + ")");
    }

    private static int getAmbiguity(BreakpointComplications complications) {
        return complications.getHomologyForwardStrandRep().length();
    }
}

