/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.spark.sv.discovery;

import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.VariantContextBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.lang3.EnumUtils;
import org.broadinstitute.hellbender.engine.BasicReference;
import org.broadinstitute.hellbender.tools.spark.sv.discovery.SimpleSVType;
import org.broadinstitute.hellbender.tools.spark.sv.discovery.inference.NovelAdjacencyAndAltHaplotype;
import org.broadinstitute.hellbender.utils.SimpleInterval;

public abstract class SvType {
    public static final int NO_APPLICABLE_END = -1;
    public static final int NO_APPLICABLE_LEN = -1;
    protected final String variantChromosome;
    protected final int variantStart;
    protected final int variantStop;
    protected final String variantId;
    protected final Allele refAllele;
    protected final Allele altAllele;
    protected final int svLen;
    protected final Map<String, Object> typeSpecificAttributes;
    protected static final Map<String, Object> noExtraAttributes = Collections.emptyMap();

    public SvType(String variantChromosome, int variantStart, int variantStop, String variantId, Allele refAllele, Allele altAllele, int svLen, Map<String, Object> typeSpecificAttributes) {
        this.variantChromosome = variantChromosome;
        this.variantStart = variantStart;
        this.variantStop = variantStop;
        this.variantId = variantId;
        this.refAllele = refAllele;
        this.altAllele = altAllele;
        this.svLen = svLen;
        this.typeSpecificAttributes = typeSpecificAttributes;
    }

    public final VariantContextBuilder getBasicInformation() {
        if (!this.hasApplicableEnd()) {
            VariantContextBuilder builder = new VariantContextBuilder().chr(this.variantChromosome).start((long)this.variantStart).stop((long)this.variantStart).id(this.variantId).alleles(new ArrayList<Allele>(Arrays.asList(this.refAllele, this.altAllele))).attribute("SVTYPE", (Object)this.toString());
            this.typeSpecificAttributes.forEach((arg_0, arg_1) -> ((VariantContextBuilder)builder).attribute(arg_0, arg_1));
            return builder;
        }
        VariantContextBuilder builder = new VariantContextBuilder().chr(this.variantChromosome).start((long)this.variantStart).stop((long)this.variantStop).id(this.variantId).alleles(new ArrayList<Allele>(Arrays.asList(this.refAllele, this.altAllele))).attribute("END", (Object)this.variantStop).attribute("SVTYPE", (Object)this.toString()).attribute("SVLEN", (Object)this.svLen);
        this.typeSpecificAttributes.forEach((arg_0, arg_1) -> ((VariantContextBuilder)builder).attribute(arg_0, arg_1));
        return builder;
    }

    public String getVariantChromosome() {
        return this.variantChromosome;
    }

    public int getVariantStart() {
        return this.variantStart;
    }

    public int getVariantStop() {
        return this.variantStop;
    }

    public final String getInternalVariantId() {
        return this.variantId;
    }

    Allele getRefAllele() {
        return this.refAllele;
    }

    public final Allele getAltAllele() {
        return this.altAllele;
    }

    public final int getSVLength() {
        return this.svLen;
    }

    public final Map<String, Object> getTypeSpecificAttributes() {
        return this.typeSpecificAttributes;
    }

    public abstract boolean hasApplicableEnd();

    public abstract boolean hasApplicableLength();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SvType svType = (SvType)o;
        if (this.svLen != svType.svLen) {
            return false;
        }
        if (!this.variantId.equals(svType.variantId)) {
            return false;
        }
        if (!this.altAllele.equals((Object)svType.altAllele)) {
            return false;
        }
        if (this.typeSpecificAttributes.size() != svType.typeSpecificAttributes.size()) {
            return false;
        }
        for (Map.Entry<String, Object> act : this.typeSpecificAttributes.entrySet()) {
            if (svType.typeSpecificAttributes.containsKey(act.getKey())) {
                if (act.getValue().equals(svType.typeSpecificAttributes.get(act.getKey()))) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = this.variantId.hashCode();
        result = 31 * result + this.altAllele.hashCode();
        result = 31 * result + this.svLen;
        result = 31 * result + this.typeSpecificAttributes.hashCode();
        return result;
    }

    public static SortedSet<String> getKnownTypes() {
        TreeSet knownTypes = new TreeSet(EnumUtils.getEnumMap(SimpleSVType.SupportedType.class).keySet());
        knownTypes.add("CPX");
        knownTypes.add("BND");
        return Collections.unmodifiableSortedSet(knownTypes);
    }

    public static String makeLocationString(String chr1, int pos1, String chr2, int pos2) {
        return chr1 + "_" + pos1 + "_" + (chr2.equals(chr1) ? "" : chr2 + "_") + pos2;
    }

    public static String makeLocationString(NovelAdjacencyAndAltHaplotype novelAdjacencyAndAltHaplotype) {
        String leftContig = novelAdjacencyAndAltHaplotype.getLeftJustifiedLeftRefLoc().getContig();
        String rightContig = novelAdjacencyAndAltHaplotype.getLeftJustifiedRightRefLoc().getContig();
        int pos1 = novelAdjacencyAndAltHaplotype.getLeftJustifiedLeftRefLoc().getStart();
        int pos2 = novelAdjacencyAndAltHaplotype.getLeftJustifiedRightRefLoc().getEnd();
        return SvType.makeLocationString(leftContig, pos1, rightContig, pos2);
    }

    static byte[] extractRefBases(SimpleInterval interval, BasicReference reference) {
        return reference.getBases(interval);
    }
}

