/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.spark.sv.discovery.alignment;

import com.esotericsoftware.kryo.DefaultSerializer;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.List;
import org.broadinstitute.hellbender.tools.spark.sv.discovery.alignment.AlignedContig;

@DefaultSerializer(value=Serializer.class)
public final class AlignedAssembly {
    public final int assemblyId;
    public final List<AlignedContig> alignedContigs;

    public AlignedAssembly(int assemblyId, List<AlignedContig> alignedContigs) {
        this.assemblyId = assemblyId;
        this.alignedContigs = alignedContigs;
    }

    @VisibleForTesting
    private AlignedAssembly(Kryo kryo, Input input) {
        this.assemblyId = input.readInt();
        int nContigs = input.readInt();
        this.alignedContigs = new ArrayList<AlignedContig>(nContigs);
        for (int contigIdx = 0; contigIdx < nContigs; ++contigIdx) {
            this.alignedContigs.add(new AlignedContig(kryo, input));
        }
    }

    @VisibleForTesting
    private void serialize(Kryo kryo, Output output) {
        output.writeInt(this.assemblyId);
        output.writeInt(this.alignedContigs.size());
        this.alignedContigs.forEach(alignedContig -> alignedContig.serialize(kryo, output));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AlignedAssembly that = (AlignedAssembly)o;
        if (this.assemblyId != that.assemblyId) {
            return false;
        }
        return this.alignedContigs.equals(that.alignedContigs);
    }

    public int hashCode() {
        int result = this.assemblyId;
        result = 31 * result + this.alignedContigs.hashCode();
        return result;
    }

    public static final class Serializer
    extends com.esotericsoftware.kryo.Serializer<AlignedAssembly> {
        public void write(Kryo kryo, Output output, AlignedAssembly alignedAssembly) {
            alignedAssembly.serialize(kryo, output);
        }

        public AlignedAssembly read(Kryo kryo, Input input, Class<AlignedAssembly> clazz) {
            return new AlignedAssembly(kryo, input);
        }
    }
}

