/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.spark.sv.discovery.alignment;

import com.esotericsoftware.kryo.DefaultSerializer;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import htsjdk.samtools.CigarOperator;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.util.SequenceUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.tools.spark.sv.discovery.alignment.AlignmentInterval;
import org.broadinstitute.hellbender.tools.spark.sv.discovery.alignment.AssemblyContigWithFineTunedAlignments;
import org.broadinstitute.hellbender.tools.spark.sv.discovery.alignment.ContigAlignmentsModifier;
import org.broadinstitute.hellbender.tools.spark.sv.utils.SVUtils;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.read.CigarUtils;
import scala.Tuple2;

@DefaultSerializer(value=Serializer.class)
public final class AlignedContig {
    public static final int ALIGNMENT_LOW_READ_UNIQUENESS_THRESHOLD = 10;
    static final int ALIGNMENT_MQ_THRESHOLD = 20;
    static final int SECONDARY_CONFIGURATION_MQ_FILTER_THRESHOLD = 0;
    static final double COVERAGE_MQ_NORMALIZATION_CONST = 60.0;
    static final int ALIGNMENT_MQ_THRESHOLD_FOR_SPEED_BOOST = 10;
    private final String contigName;
    private final byte[] contigSequence;
    private final List<AlignmentInterval> alignmentIntervals;

    public AlignedContig(String contigName, byte[] contigSequence, List<AlignmentInterval> alignmentIntervals) {
        if (alignmentIntervals == null) {
            throw new IllegalArgumentException("AlignedContig being constructed with null alignments: " + contigName);
        }
        this.contigName = contigName;
        this.contigSequence = contigSequence;
        this.alignmentIntervals = alignmentIntervals.stream().sorted(AlignedContig.getAlignmentIntervalComparator()).collect(Collectors.toList());
    }

    AlignedContig(Kryo kryo, Input input) {
        this.contigName = input.readString();
        int nBases = input.readInt();
        this.contigSequence = new byte[nBases];
        for (int b = 0; b < nBases; ++b) {
            this.contigSequence[b] = input.readByte();
        }
        int nAlignments = input.readInt();
        this.alignmentIntervals = new ArrayList<AlignmentInterval>(nAlignments);
        for (int i = 0; i < nAlignments; ++i) {
            this.alignmentIntervals.add(new AlignmentInterval(kryo, input));
        }
    }

    @VisibleForTesting
    public static AlignedContig parseReadsAndOptionallySplitGappedAlignments(Iterable<SAMRecord> noSecondaryAlignments, int gapSplitSensitivity, boolean splitGapped) {
        List<AlignmentInterval> parsedAlignments;
        Utils.validateArg(noSecondaryAlignments.iterator().hasNext(), "input collection of GATK reads is empty");
        SAMRecord primaryAlignment = Utils.stream(noSecondaryAlignments).filter(sam -> !sam.getSupplementaryAlignmentFlag()).findFirst().orElseThrow(() -> new GATKException("no primary alignment for read " + ((SAMRecord)noSecondaryAlignments.iterator().next()).getReadName()));
        Utils.validate(!primaryAlignment.getCigar().containsOperator(CigarOperator.H), "assumption that primary alignment does not contain hard clipping is invalid for read: " + primaryAlignment.toString());
        byte[] contigSequence = (byte[])primaryAlignment.getReadBases().clone();
        if (primaryAlignment.getReadUnmappedFlag()) {
            parsedAlignments = Collections.emptyList();
        } else {
            if (primaryAlignment.getReadNegativeStrandFlag()) {
                SequenceUtil.reverseComplement((byte[])contigSequence);
            }
            Stream<AlignmentInterval> unSplitAIList = Utils.stream(noSecondaryAlignments).map(AlignmentInterval::new);
            if (splitGapped) {
                int unClippedContigLength = primaryAlignment.getReadLength();
                parsedAlignments = unSplitAIList.map(ar -> ContigAlignmentsModifier.splitGappedAlignment(ar, gapSplitSensitivity, unClippedContigLength)).flatMap(Utils::stream).collect(Collectors.toList());
            } else {
                parsedAlignments = unSplitAIList.collect(Collectors.toList());
            }
        }
        return new AlignedContig(primaryAlignment.getReadName(), contigSequence, parsedAlignments);
    }

    boolean hasOnly2Alignments() {
        return this.alignmentIntervals.size() == 2;
    }

    public AlignmentInterval getHeadAlignment() {
        return this.alignmentIntervals.get(0);
    }

    public AlignmentInterval getTailAlignment() {
        return this.alignmentIntervals.get(this.alignmentIntervals.size() - 1);
    }

    public String getContigName() {
        return this.contigName;
    }

    public byte[] getContigSequence() {
        return this.contigSequence;
    }

    public boolean isUnmapped() {
        return this.alignmentIntervals.isEmpty();
    }

    public List<AlignmentInterval> getAlignments() {
        return this.alignmentIntervals;
    }

    public boolean hasGoodMQ() {
        if (this.alignmentIntervals.size() < 2) {
            return !this.alignmentIntervals.isEmpty() && this.alignmentIntervals.get((int)0).mapQual > 20;
        }
        int notBadMappingsCount = 0;
        for (AlignmentInterval alignment : this.alignmentIntervals) {
            if (alignment.mapQual <= 20) continue;
            if (alignment.containsGapOfEqualOrLargerSize(50)) {
                return true;
            }
            ++notBadMappingsCount;
        }
        return notBadMappingsCount > 1;
    }

    @VisibleForTesting
    public List<AssemblyContigWithFineTunedAlignments> reconstructContigFromBestConfiguration(Set<String> canonicalChromosomes, double scoreDiffTolerance) {
        List<GoodAndBadMappings> bestConfigurations = this.pickAndFilterConfigurations(canonicalChromosomes, scoreDiffTolerance);
        if (bestConfigurations.size() > 1) {
            return bestConfigurations.stream().map(mappings -> AlignedContig.splitGaps(mappings, false)).map(mappings -> AlignedContig.removeNonUniqueMappings(mappings, 20, 10)).filter(mappings -> AlignedContig.alignmentShouldNotBeStitchedTogether(mappings.getGoodMappings())).map(mappings -> AlignedContig.createContigGivenClassifiedAlignments(this.contigName, this.contigSequence, mappings, true)).sorted(AlignedContig.getConfigurationComparator()).collect(Collectors.toList());
        }
        GoodAndBadMappings intermediate = AlignedContig.splitGaps(bestConfigurations.get(0), false);
        GoodAndBadMappings result = AlignedContig.removeNonUniqueMappings(intermediate, 20, 10);
        if (AlignedContig.alignmentShouldNotBeStitchedTogether(result.getGoodMappings())) {
            return Collections.singletonList(AlignedContig.createContigGivenClassifiedAlignments(this.contigName, this.contigSequence, result, false));
        }
        return Collections.emptyList();
    }

    private static boolean alignmentShouldNotBeStitchedTogether(List<AlignmentInterval> alignments) {
        return alignments.size() != 2 || !AlignedContig.simpleChimeraWithStichableAlignments(alignments.get(0), alignments.get(1));
    }

    private static AssemblyContigWithFineTunedAlignments createContigGivenClassifiedAlignments(String contigName, byte[] contigSeq, GoodAndBadMappings goodAndBadMappings, boolean setResultContigAsAmbiguous) {
        return new AssemblyContigWithFineTunedAlignments(new AlignedContig(contigName, contigSeq, goodAndBadMappings.getGoodMappings()), goodAndBadMappings.getBadMappings().stream().map(AlignmentInterval::toPackedString).collect(Collectors.toList()), setResultContigAsAmbiguous, goodAndBadMappings.getMayBeNullGoodMappingToNonCanonicalChromosome());
    }

    @VisibleForTesting
    static Comparator<AssemblyContigWithFineTunedAlignments> getConfigurationComparator() {
        Comparator<AssemblyContigWithFineTunedAlignments> numFirst = Comparator.comparingInt(tig -> tig.getAlignments().size());
        Comparator mismatchSecond = (x, y) -> Integer.compare(x.getAlignments().stream().mapToInt(ai -> ai.mismatches).sum(), y.getAlignments().stream().mapToInt(ai -> ai.mismatches).sum());
        return numFirst.thenComparing(mismatchSecond);
    }

    @VisibleForTesting
    static GoodAndBadMappings splitGaps(GoodAndBadMappings configuration, boolean keepSplitChildrenTogether) {
        return keepSplitChildrenTogether ? AlignedContig.splitGapsAndKeepChildrenTogether(configuration) : AlignedContig.splitGapsAndDropAlignmentContainedByOtherOnRead(configuration);
    }

    @VisibleForTesting
    static GoodAndBadMappings splitGapsAndKeepChildrenTogether(GoodAndBadMappings configuration) {
        List<AlignmentInterval> originalBadMappings = configuration.getBadMappings();
        List<AlignmentInterval> scan = configuration.getGoodMappings();
        List alignmentSplitChildren = scan.stream().map(alignment -> {
            Iterable<AlignmentInterval> split = alignment.containsGapOfEqualOrLargerSize(50) ? ContigAlignmentsModifier.splitGappedAlignment(alignment, 50, CigarUtils.countUnclippedReadBases(alignment.cigarAlong5to3DirectionOfContig)) : Collections.singletonList(alignment);
            return new Tuple2((Object)true, split);
        }).collect(Collectors.toList());
        int count = scan.size();
        for (int i = 0; i < count; ++i) {
            AlignmentInterval alignment2 = scan.get(i);
            Tuple2 split = (Tuple2)alignmentSplitChildren.get(i);
            if (!((Boolean)split._1).booleanValue() || Iterables.size((Iterable)((Iterable)split._2)) == 1) continue;
            for (int j = 0; j < count; ++j) {
                Iterable copy;
                AlignmentInterval other = scan.get(j);
                if (j == i || AlignmentInterval.overlapOnContig(alignment2, other) == 0 || !Utils.stream((Iterable)split._2).anyMatch(other::containsOnRead)) continue;
                if (AlignedContig.gappedAlignmentOffersBetterCoverage(alignment2, other)) {
                    copy = (Iterable)((Tuple2)alignmentSplitChildren.get((int)j))._2;
                    alignmentSplitChildren.set(j, new Tuple2((Object)false, (Object)copy));
                    continue;
                }
                copy = (Iterable)((Tuple2)alignmentSplitChildren.get((int)i))._2;
                alignmentSplitChildren.set(i, new Tuple2((Object)false, (Object)copy));
            }
        }
        ArrayList<AlignmentInterval> good = new ArrayList<AlignmentInterval>();
        ArrayList<AlignmentInterval> bad = new ArrayList<AlignmentInterval>(originalBadMappings);
        for (Tuple2 pair : alignmentSplitChildren) {
            if (((Boolean)pair._1).booleanValue()) {
                good.addAll(Lists.newArrayList((Iterable)((Iterable)pair._2)));
                continue;
            }
            bad.addAll(Lists.newArrayList((Iterable)((Iterable)pair._2)));
        }
        good.sort(AlignedContig.getAlignmentIntervalComparator());
        return new GoodAndBadMappings(good, bad, configuration.getMayBeNullGoodMappingToNonCanonicalChromosome());
    }

    @VisibleForTesting
    static GoodAndBadMappings splitGapsAndDropAlignmentContainedByOtherOnRead(GoodAndBadMappings configuration) {
        List<AlignmentInterval> originalGoodMappings = configuration.getGoodMappings();
        ArrayList<AlignmentInterval> gapSplit = new ArrayList<AlignmentInterval>(originalGoodMappings.size());
        originalGoodMappings.forEach(alignment -> {
            if (alignment.containsGapOfEqualOrLargerSize(50)) {
                ContigAlignmentsModifier.splitGappedAlignment(alignment, 50, CigarUtils.countUnclippedReadBases(alignment.cigarAlong5to3DirectionOfContig)).forEach(gapSplit::add);
            } else {
                gapSplit.add((AlignmentInterval)alignment);
            }
        });
        int count = gapSplit.size();
        ArrayList<AlignmentInterval> bad = new ArrayList<AlignmentInterval>(configuration.getBadMappings());
        for (int i = 0; i < count; ++i) {
            AlignmentInterval one = (AlignmentInterval)gapSplit.get(i);
            for (int j = i + 1; j < count; ++j) {
                AlignmentInterval two = (AlignmentInterval)gapSplit.get(j);
                if (one.containsOnRead(two)) {
                    bad.add(two);
                    continue;
                }
                if (!two.containsOnRead(one)) continue;
                bad.add(one);
            }
        }
        gapSplit.removeAll(bad);
        gapSplit.sort(AlignedContig.getAlignmentIntervalComparator());
        return new GoodAndBadMappings(gapSplit, bad, configuration.getMayBeNullGoodMappingToNonCanonicalChromosome());
    }

    @VisibleForTesting
    static boolean gappedAlignmentOffersBetterCoverage(AlignmentInterval gapped, AlignmentInterval overlappingNonGapped) {
        int diff = gapped.getSizeOnRead() - overlappingNonGapped.getSizeOnRead();
        if (diff == 0) {
            return gapped.alnScore > overlappingNonGapped.alnScore;
        }
        return diff > 0;
    }

    @VisibleForTesting
    static GoodAndBadMappings removeNonUniqueMappings(GoodAndBadMappings goodAndBadMappings, int mapQThresholdInclusive, int uniqReadLenInclusive) {
        List<AlignmentInterval> inputAlignments = goodAndBadMappings.getGoodMappings();
        if (inputAlignments.size() <= 2) {
            return goodAndBadMappings;
        }
        ArrayList<AlignmentInterval> selectedAlignments = new ArrayList<AlignmentInterval>(inputAlignments.size());
        ArrayList<AlignmentInterval> lowUniquenessMappings = new ArrayList<AlignmentInterval>(goodAndBadMappings.getBadMappings());
        AlignedContig.removeDueToLowMQ(inputAlignments, mapQThresholdInclusive, selectedAlignments, lowUniquenessMappings);
        AlignedContig.removeDueToShortReadSpan(selectedAlignments, uniqReadLenInclusive, lowUniquenessMappings);
        return new GoodAndBadMappings(selectedAlignments, lowUniquenessMappings, goodAndBadMappings.getMayBeNullGoodMappingToNonCanonicalChromosome());
    }

    private static void removeDueToLowMQ(List<AlignmentInterval> inputAlignments, int mapQThresholdInclusive, List<AlignmentInterval> selectedAlignments, List<AlignmentInterval> lowUniquenessMappings) {
        for (AlignmentInterval alignment : inputAlignments) {
            if (alignment.mapQual >= mapQThresholdInclusive) {
                selectedAlignments.add(alignment);
                continue;
            }
            lowUniquenessMappings.add(alignment);
        }
    }

    private static void removeDueToShortReadSpan(List<AlignmentInterval> selectedAlignments, int uniqReadLenInclusive, List<AlignmentInterval> lowUniquenessMappings) {
        Map<AlignmentInterval, Tuple2<Integer, Integer>> maxOverlapMap = AlignedContig.getMaxOverlapPairs(selectedAlignments);
        Iterator<AlignmentInterval> iterator = selectedAlignments.iterator();
        while (iterator.hasNext()) {
            int maxOverlapRear;
            AlignmentInterval alignment = iterator.next();
            Tuple2<Integer, Integer> maxOverlapFrontAndRear = maxOverlapMap.get(alignment);
            int maxOverlapFront = Math.max(0, (Integer)maxOverlapFrontAndRear._1);
            int uniqReadSpan = alignment.endInAssembledContig - alignment.startInAssembledContig + 1 - maxOverlapFront - (maxOverlapRear = Math.max(0, (Integer)maxOverlapFrontAndRear._2));
            if (uniqReadSpan >= uniqReadLenInclusive) continue;
            lowUniquenessMappings.add(alignment);
            iterator.remove();
        }
    }

    @VisibleForTesting
    static Map<AlignmentInterval, Tuple2<Integer, Integer>> getMaxOverlapPairs(List<AlignmentInterval> configuration) {
        ArrayList<TempMaxOverlapInfo> intermediateResult = new ArrayList<TempMaxOverlapInfo>(Collections.nCopies(configuration.size(), new TempMaxOverlapInfo()));
        for (int i = 0; i < configuration.size() - 1; ++i) {
            int overlap;
            AlignmentInterval cur = configuration.get(i);
            int maxOverlapRearBases = -1;
            int maxOverlapRearIndex = -1;
            int j = i + 1;
            while (j < configuration.size() && (overlap = AlignmentInterval.overlapOnContig(cur, configuration.get(j))) > maxOverlapRearBases) {
                maxOverlapRearBases = overlap;
                maxOverlapRearIndex = j++;
            }
            if (maxOverlapRearBases <= 0) continue;
            Tuple2 maxRear = new Tuple2((Object)maxOverlapRearIndex, (Object)maxOverlapRearBases);
            Tuple2<Integer, Integer> maxFrontToCopy = ((TempMaxOverlapInfo)intermediateResult.get((int)i)).maxFront;
            intermediateResult.set(i, new TempMaxOverlapInfo(maxFrontToCopy, (Tuple2<Integer, Integer>)maxRear));
            TempMaxOverlapInfo oldValue = (TempMaxOverlapInfo)intermediateResult.get(maxOverlapRearIndex);
            if ((Integer)oldValue.maxFront._2 >= maxOverlapRearBases) continue;
            intermediateResult.set(maxOverlapRearIndex, new TempMaxOverlapInfo((Tuple2<Integer, Integer>)new Tuple2((Object)i, (Object)maxOverlapRearBases), oldValue.maxRear));
        }
        HashMap<AlignmentInterval, Tuple2<Integer, Integer>> maxOverlapMap = new HashMap<AlignmentInterval, Tuple2<Integer, Integer>>(configuration.size());
        for (int i = 0; i < configuration.size(); ++i) {
            maxOverlapMap.put(configuration.get(i), (Tuple2<Integer, Integer>)new Tuple2(((TempMaxOverlapInfo)intermediateResult.get((int)i)).maxFront._2, ((TempMaxOverlapInfo)intermediateResult.get((int)i)).maxRear._2));
        }
        return maxOverlapMap;
    }

    public static boolean simpleChimeraWithStichableAlignments(AlignmentInterval intervalOne, AlignmentInterval intervalTwo) {
        boolean refOrderSwap;
        if (intervalOne.startInAssembledContig > intervalTwo.startInAssembledContig) {
            throw new IllegalArgumentException("Assumption that input intervals are sorted by their starts on read is violated.\tFirst: " + intervalOne.toPackedString() + "\tSecond: " + intervalTwo.toPackedString());
        }
        if (!intervalOne.referenceSpan.getContig().equals(intervalTwo.referenceSpan.getContig())) {
            return false;
        }
        if (intervalOne.forwardStrand != intervalTwo.forwardStrand) {
            return false;
        }
        if (intervalOne.containsOnRead(intervalTwo) || intervalTwo.containsOnRead(intervalOne)) {
            return false;
        }
        if (intervalOne.containsOnRef(intervalTwo) || intervalTwo.containsOnRef(intervalOne)) {
            return false;
        }
        boolean bl = refOrderSwap = intervalOne.forwardStrand != intervalOne.referenceSpan.getStart() < intervalTwo.referenceSpan.getStart();
        if (refOrderSwap) {
            return false;
        }
        int overlapOnContig = AlignmentInterval.overlapOnContig(intervalOne, intervalTwo);
        int overlapOnRefSpan = AlignmentInterval.overlapOnRefSpan(intervalOne, intervalTwo);
        if (overlapOnContig == 0 && overlapOnRefSpan == 0) {
            boolean canBeStitched = intervalTwo.referenceSpan.getStart() - intervalOne.referenceSpan.getEnd() == 1 && intervalTwo.startInAssembledContig - intervalOne.endInAssembledContig == 1;
            return canBeStitched;
        }
        return overlapOnContig == overlapOnRefSpan;
    }

    public List<GoodAndBadMappings> pickAndFilterConfigurations(Set<String> canonicalChromosomes, double scoreDiffTolerance) {
        return AlignedContig.filterSecondaryConfigurationsByMappingQualityThreshold(this.pickBestConfigurations(canonicalChromosomes, scoreDiffTolerance), 0);
    }

    @VisibleForTesting
    public List<GoodAndBadMappings> pickBestConfigurations(Set<String> canonicalChromosomes, double scoreDiffTolerance) {
        if (this.alignmentIntervals.size() == 1) {
            return Collections.singletonList(new GoodAndBadMappings(Collections.singletonList(this.alignmentIntervals.get(0))));
        }
        int maxCanonicalChrAlignerScore = this.alignmentIntervals.stream().filter(alignmentInterval -> canonicalChromosomes.contains(alignmentInterval.referenceSpan.getContig())).mapToInt(ai -> ai.alnScore).max().orElse(0);
        GoodAndBadMappings preFilteredAlignments = this.heuristicSpeedUpWhenFacingManyMappings(canonicalChromosomes, maxCanonicalChrAlignerScore);
        List goodMappings = preFilteredAlignments.goodMappings;
        List badMappings = preFilteredAlignments.badMappings;
        int newMaxCanonicalChrAlignerScore = goodMappings.stream().filter(alignmentInterval -> canonicalChromosomes.contains(alignmentInterval.referenceSpan.getContig())).mapToInt(ai -> ai.alnScore).max().orElse(0);
        AlignmentInterval goodMappingToNonCanonicalChromosome = AlignedContig.getBetterNonCanonicalMapping(canonicalChromosomes, goodMappings, newMaxCanonicalChrAlignerScore);
        if (goodMappingToNonCanonicalChromosome != null) {
            goodMappings.remove(goodMappingToNonCanonicalChromosome);
        }
        return AlignedContig.generateScoreAndPickConfigurations(goodMappings, badMappings, goodMappingToNonCanonicalChromosome, canonicalChromosomes, newMaxCanonicalChrAlignerScore, scoreDiffTolerance, this.contigName);
    }

    private static List<GoodAndBadMappings> generateScoreAndPickConfigurations(List<AlignmentInterval> goodMappings, List<AlignmentInterval> badMappings, AlignmentInterval goodMappingToNonCanonicalChromosome, Set<String> canonicalChromosomes, int maxCanonicalChrAlignerScore, double scoreDiffTolerance, String contigName) {
        List allConfigurations = Sets.powerSet(new HashSet<AlignmentInterval>(goodMappings)).stream().map(ArrayList::new).map(ls -> ls.stream().sorted(AlignedContig.getAlignmentIntervalComparator()).collect(Collectors.toList())).collect(Collectors.toList());
        List scores = allConfigurations.stream().map(configuration -> AlignedContig.computeScoreOfConfiguration(configuration, canonicalChromosomes, maxCanonicalChrAlignerScore)).collect(SVUtils.arrayListCollector(allConfigurations.size()));
        double maxScore = scores.stream().mapToDouble(Double::doubleValue).max().orElseThrow(() -> new GATKException("Cannot find best-scoring configuration on alignments of contig: " + contigName));
        return IntStream.range(0, allConfigurations.size()).filter(i -> {
            double s = (Double)scores.get(i);
            double tol = Math.max(Math.ulp(s), scoreDiffTolerance);
            return s >= maxScore || maxScore - s <= tol;
        }).mapToObj(p -> {
            ArrayList<AlignmentInterval> copy = new ArrayList<AlignmentInterval>(goodMappings);
            List pickedAlignments = (List)allConfigurations.get(p);
            copy.removeAll(pickedAlignments);
            copy.addAll(badMappings);
            return new GoodAndBadMappings(pickedAlignments, copy, goodMappingToNonCanonicalChromosome);
        }).collect(Collectors.toList());
    }

    @VisibleForTesting
    GoodAndBadMappings heuristicSpeedUpWhenFacingManyMappings(Set<String> canonicalChromosomes, int maxCanonicalChrAlignerScore) {
        List<AlignmentInterval> bads;
        List<AlignmentInterval> goods;
        if (this.alignmentIntervals.size() > 10) {
            goods = new ArrayList<AlignmentInterval>();
            bads = new ArrayList();
            for (AlignmentInterval alignment : this.alignmentIntervals) {
                boolean isGood;
                boolean bl = isGood = !canonicalChromosomes.contains(alignment.referenceSpan.getContig()) && alignment.alnScore > maxCanonicalChrAlignerScore || alignment.mapQual > 10;
                if (isGood) {
                    goods.add(alignment);
                    continue;
                }
                bads.add(alignment);
            }
        } else {
            goods = this.alignmentIntervals;
            bads = Collections.emptyList();
        }
        return new GoodAndBadMappings(goods, bads);
    }

    @VisibleForTesting
    static AlignmentInterval getBetterNonCanonicalMapping(Set<String> canonicalChromosomes, List<AlignmentInterval> goodMappings, int maxCanonicalChrAlignerScore) {
        ArrayList<AlignmentInterval> canonicalMappings = new ArrayList<AlignmentInterval>(goodMappings.size());
        ArrayList<AlignmentInterval> nonCanonicalMapping = new ArrayList<AlignmentInterval>();
        for (AlignmentInterval alignment : goodMappings) {
            if (canonicalChromosomes.contains(alignment.referenceSpan.getContig())) {
                canonicalMappings.add(alignment);
                continue;
            }
            nonCanonicalMapping.add(alignment);
        }
        if (canonicalMappings.isEmpty()) {
            return null;
        }
        if (nonCanonicalMapping.size() == 1 && (canonicalMappings.size() > 1 || ((AlignmentInterval)canonicalMappings.get(0)).containsGapOfEqualOrLargerSize(50))) {
            double nonCanonicalScore;
            double canonicalScore = AlignedContig.computeScoreOfConfiguration(canonicalMappings, canonicalChromosomes, maxCanonicalChrAlignerScore);
            return canonicalScore > (nonCanonicalScore = AlignedContig.computeScoreOfConfiguration(nonCanonicalMapping, canonicalChromosomes, maxCanonicalChrAlignerScore)) ? null : (AlignmentInterval)nonCanonicalMapping.get(0);
        }
        return null;
    }

    @VisibleForTesting
    static double computeScoreOfConfiguration(List<AlignmentInterval> configuration, Set<String> canonicalChromosomes, int maxCanonicalChrAlignerScore) {
        double tigExplainQual = AlignedContig.computeTigExplainQualOfOneConfiguration(configuration, canonicalChromosomes, maxCanonicalChrAlignerScore);
        int redundancy = 0;
        for (int i = 0; i < configuration.size() - 1; ++i) {
            for (int j = i + 1; j < configuration.size(); ++j) {
                int overlap = AlignmentInterval.overlapOnContig(configuration.get(i), configuration.get(j));
                redundancy += overlap;
            }
        }
        return tigExplainQual - (double)redundancy;
    }

    private static double computeTigExplainQualOfOneConfiguration(List<AlignmentInterval> configuration, Set<String> canonicalChromosomes, int maxCanonicalChrAlignerScore) {
        double tigExplainedQual = 0.0;
        for (AlignmentInterval alignmentInterval : configuration) {
            int len = alignmentInterval.getSizeOnRead();
            double weight = canonicalChromosomes.contains(alignmentInterval.referenceSpan.getContig()) ? (double)alignmentInterval.mapQual / 60.0 : Math.max((double)alignmentInterval.mapQual / 60.0, alignmentInterval.alnScore > maxCanonicalChrAlignerScore ? 1.0 : 0.0);
            tigExplainedQual += weight * (double)len;
        }
        return tigExplainedQual;
    }

    @VisibleForTesting
    static List<GoodAndBadMappings> filterSecondaryConfigurationsByMappingQualityThreshold(List<GoodAndBadMappings> differentConfigurationsForOneContig, int mqThreshold) {
        if (differentConfigurationsForOneContig.size() == 1) {
            return differentConfigurationsForOneContig;
        }
        List<GoodAndBadMappings> configurationsWithMappingAboveMQThreshold = Utils.stream(differentConfigurationsForOneContig).filter(rep -> rep.getGoodMappings().stream().mapToInt(ai -> ai.mapQual).min().orElse(mqThreshold) > mqThreshold).collect(Collectors.toList());
        if (configurationsWithMappingAboveMQThreshold.size() != 1) {
            return differentConfigurationsForOneContig;
        }
        return configurationsWithMappingAboveMQThreshold;
    }

    public String toString() {
        return "(" + this.contigName + ", " + this.alignmentIntervals.stream().map(AlignmentInterval::toPackedString).collect(Collectors.toList()) + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AlignedContig that = (AlignedContig)o;
        if (!this.contigName.equals(that.contigName)) {
            return false;
        }
        if (!Arrays.equals(this.contigSequence, that.contigSequence)) {
            return false;
        }
        return this.alignmentIntervals.equals(that.alignmentIntervals);
    }

    public int hashCode() {
        int result = this.contigName.hashCode();
        result = 31 * result + Arrays.hashCode(this.contigSequence);
        result = 31 * result + this.alignmentIntervals.hashCode();
        return result;
    }

    void serialize(Kryo kryo, Output output) {
        output.writeString(this.contigName);
        output.writeInt(this.contigSequence.length);
        for (byte base : this.contigSequence) {
            output.writeByte(base);
        }
        output.writeInt(this.alignmentIntervals.size());
        this.alignmentIntervals.forEach(it -> it.serialize(kryo, output));
    }

    static Comparator<AlignmentInterval> getAlignmentIntervalComparator() {
        Comparator<AlignmentInterval> comparePos = Comparator.comparingInt(aln -> aln.startInAssembledContig);
        Comparator<AlignmentInterval> compareRefTig = Comparator.comparing(aln -> aln.referenceSpan.getContig());
        Comparator<AlignmentInterval> compareRefSpanStart = Comparator.comparingInt(aln -> aln.referenceSpan.getStart());
        return comparePos.thenComparing(compareRefTig).thenComparing(compareRefSpanStart);
    }

    public static final class Serializer
    extends com.esotericsoftware.kryo.Serializer<AlignedContig> {
        public void write(Kryo kryo, Output output, AlignedContig alignedContig) {
            alignedContig.serialize(kryo, output);
        }

        public AlignedContig read(Kryo kryo, Input input, Class<AlignedContig> clazz) {
            return new AlignedContig(kryo, input);
        }
    }

    private static final class TempMaxOverlapInfo {
        final Tuple2<Integer, Integer> maxFront;
        final Tuple2<Integer, Integer> maxRear;

        TempMaxOverlapInfo() {
            this.maxFront = new Tuple2((Object)-1, (Object)-1);
            this.maxRear = new Tuple2((Object)-1, (Object)-1);
        }

        TempMaxOverlapInfo(Tuple2<Integer, Integer> maxFront, Tuple2<Integer, Integer> maxRear) {
            this.maxFront = maxFront;
            this.maxRear = maxRear;
        }
    }

    @VisibleForTesting
    public static final class GoodAndBadMappings {
        private final List<AlignmentInterval> goodMappings;
        private final List<AlignmentInterval> badMappings;
        private final AlignmentInterval goodMappingToNonCanonicalChromosome;

        public GoodAndBadMappings(@Nonnull List<AlignmentInterval> goodMappings) {
            this(goodMappings, Collections.emptyList(), null);
        }

        public GoodAndBadMappings(@Nonnull List<AlignmentInterval> goodMappings, @Nonnull List<AlignmentInterval> badMappings, AlignmentInterval goodMappingToNonCanonicalChr) {
            this.goodMappings = goodMappings;
            this.badMappings = badMappings;
            this.goodMappingToNonCanonicalChromosome = goodMappingToNonCanonicalChr;
        }

        public GoodAndBadMappings(@Nonnull List<AlignmentInterval> goodMappings, @Nonnull List<AlignmentInterval> badMappings) {
            this(goodMappings, badMappings, null);
        }

        public List<AlignmentInterval> getGoodMappings() {
            return this.goodMappings;
        }

        public List<AlignmentInterval> getBadMappings() {
            return this.badMappings;
        }

        public AlignmentInterval getMayBeNullGoodMappingToNonCanonicalChromosome() {
            return this.goodMappingToNonCanonicalChromosome;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            GoodAndBadMappings that = (GoodAndBadMappings)o;
            if (!this.goodMappings.equals(that.goodMappings)) {
                return false;
            }
            if (!this.badMappings.equals(that.badMappings)) {
                return false;
            }
            return Objects.equals(this.goodMappingToNonCanonicalChromosome, that.goodMappingToNonCanonicalChromosome);
        }

        public int hashCode() {
            int result = this.goodMappings.hashCode();
            result = 31 * result + this.badMappings.hashCode();
            result = 31 * result + (this.goodMappingToNonCanonicalChromosome != null ? this.goodMappingToNonCanonicalChromosome.hashCode() : 0);
            return result;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("GoodAndBadMappings{");
            sb.append("goodMappings=").append(this.goodMappings);
            sb.append(", badMappings=").append(this.badMappings);
            if (this.goodMappingToNonCanonicalChromosome != null) {
                sb.append(", goodMappingToNonCanonicalChromosome=").append(this.goodMappingToNonCanonicalChromosome);
            }
            sb.append('}');
            return sb.toString();
        }
    }
}

