/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.spark.sv.discovery.alignment;

import com.esotericsoftware.kryo.DefaultSerializer;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.google.common.annotations.VisibleForTesting;
import htsjdk.samtools.Cigar;
import htsjdk.samtools.CigarElement;
import htsjdk.samtools.CigarOperator;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFlag;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMTag;
import htsjdk.samtools.TextCigarCodec;
import htsjdk.samtools.util.Locatable;
import htsjdk.samtools.util.SequenceUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import org.broadinstitute.hellbender.tools.spark.sv.discovery.alignment.ContigAlignmentsModifier;
import org.broadinstitute.hellbender.tools.spark.sv.utils.SVInterval;
import org.broadinstitute.hellbender.tools.spark.sv.utils.Strand;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.Tail;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.bwa.BwaMemAlignment;
import org.broadinstitute.hellbender.utils.param.ParamUtils;
import org.broadinstitute.hellbender.utils.read.CigarUtils;
import org.broadinstitute.hellbender.utils.read.GATKRead;
import org.broadinstitute.hellbender.utils.read.ReadUtils;
import scala.Tuple2;

@DefaultSerializer(value=Serializer.class)
public final class AlignmentInterval {
    public static final int NO_NM = -1;
    public static final int NO_AS = -1;
    public static final String SA_TAG_INTERVAL_SEPARATOR_STR = ";";
    public static final String SA_TAG_FIELD_SEPARATOR = ",";
    public static final String NO_VALUE_STR = ".";
    public final SimpleInterval referenceSpan;
    public final int startInAssembledContig;
    public final int endInAssembledContig;
    public final Cigar cigarAlong5to3DirectionOfContig;
    public final boolean forwardStrand;
    public final int mapQual;
    public final int mismatches;
    public final int alnScore;
    public final ContigAlignmentsModifier.AlnModType alnModType;
    @VisibleForTesting
    public static final String PACKED_STRING_REP_SEPARATOR = "_";

    public AlignmentInterval(String samSAtagString) {
        Strand strand;
        String terminationTrimmedString;
        Utils.nonNull(samSAtagString, "input str cannot be null");
        int firstSeparatorIndex = samSAtagString.indexOf(SA_TAG_INTERVAL_SEPARATOR_STR);
        if (firstSeparatorIndex < 0) {
            terminationTrimmedString = samSAtagString;
        } else if (firstSeparatorIndex == samSAtagString.length() - 1) {
            terminationTrimmedString = samSAtagString.substring(0, firstSeparatorIndex);
        } else {
            throw new IllegalArgumentException("the input string cannot contain more than one interval");
        }
        String[] parts = terminationTrimmedString.split(SA_TAG_FIELD_SEPARATOR);
        if (parts.length < 5) {
            throw new IllegalArgumentException("the input SA string at least must contain 5 parts: " + samSAtagString);
        }
        int nextPartsIndex = 0;
        String referenceContig = parts[nextPartsIndex++];
        int start = Integer.parseInt(parts[nextPartsIndex++]);
        boolean forwardStrand = (strand = AlignmentInterval.parseStrand(parts[nextPartsIndex++])) == Strand.POSITIVE;
        Cigar originalCigar = TextCigarCodec.decode((String)parts[nextPartsIndex++]);
        Cigar cigar = forwardStrand ? originalCigar : CigarUtils.invertCigar(originalCigar);
        int mappingQuality = ParamUtils.inRange(AlignmentInterval.parseZeroOrPositiveInt(parts[nextPartsIndex++], 255, "invalid mapping quality"), 0, 255, "the mapping quality must be in the range [0, 255]");
        int mismatches = parts.length > nextPartsIndex ? AlignmentInterval.parseZeroOrPositiveInt(parts[nextPartsIndex++], -1, "invalid number of mismatches") : -1;
        int alignmentScore = parts.length > nextPartsIndex ? AlignmentInterval.parseZeroOrPositiveInt(parts[nextPartsIndex], -1, "invalid alignment score") : -1;
        this.referenceSpan = new SimpleInterval(referenceContig, start, Math.max(start, cigar.getReferenceLength() + start - 1));
        this.startInAssembledContig = 1 + CigarUtils.countClippedBases(cigar, Tail.LEFT);
        this.endInAssembledContig = CigarUtils.countUnclippedReadBases(cigar) - CigarUtils.countClippedBases(cigar, Tail.RIGHT);
        this.cigarAlong5to3DirectionOfContig = cigar;
        this.mapQual = mappingQuality;
        this.mismatches = mismatches;
        this.alnScore = alignmentScore;
        this.forwardStrand = forwardStrand;
        this.alnModType = ContigAlignmentsModifier.AlnModType.NONE;
    }

    public String toSATagString() {
        return this.appendSATagString(new StringBuilder(100)).toString();
    }

    public String toString() {
        return this.toSATagString();
    }

    public StringBuilder appendSATagString(StringBuilder builder) {
        Utils.nonNull(builder);
        builder.append(this.referenceSpan.getContig()).append(SA_TAG_FIELD_SEPARATOR).append(this.referenceSpan.getStart()).append(SA_TAG_FIELD_SEPARATOR).append(this.forwardStrand ? Strand.POSITIVE.toString() : Strand.NEGATIVE.toString()).append(SA_TAG_FIELD_SEPARATOR).append(this.forwardStrand ? this.cigarAlong5to3DirectionOfContig.toString() : CigarUtils.invertCigar(this.cigarAlong5to3DirectionOfContig).toString()).append(SA_TAG_FIELD_SEPARATOR).append(this.mapQual);
        if (this.mismatches != -1 || this.alnScore != -1) {
            builder.append(SA_TAG_FIELD_SEPARATOR);
            if (this.mismatches == -1) {
                builder.append(NO_VALUE_STR).append(SA_TAG_FIELD_SEPARATOR).append(this.alnScore);
            } else if (this.alnScore == -1) {
                builder.append(this.mismatches);
            } else {
                builder.append(this.mismatches).append(SA_TAG_FIELD_SEPARATOR).append(this.alnScore);
            }
        }
        return builder;
    }

    private static int parseZeroOrPositiveInt(String str, int defaultValue, String errorMessage) {
        if (str.equals(NO_VALUE_STR)) {
            return defaultValue;
        }
        try {
            return ParamUtils.isPositiveOrZero(Integer.parseInt(str), errorMessage + ": " + str);
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException(errorMessage + "; not a valid integer in: " + str, ex);
        }
    }

    private static Strand parseStrand(String strandText) {
        try {
            return Strand.decode(strandText);
        }
        catch (NoSuchElementException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    @VisibleForTesting
    public AlignmentInterval(SAMRecord samRecord) {
        Utils.validateArg(!Utils.nonNull(samRecord).getReadUnmappedFlag(), "sam record being used to construct AlignmentInterval is unmapped: " + samRecord.toString());
        boolean isMappedReverse = samRecord.getReadNegativeStrandFlag();
        this.referenceSpan = new SimpleInterval((Locatable)samRecord);
        Cigar cigar = isMappedReverse ? CigarUtils.invertCigar(samRecord.getCigar()) : samRecord.getCigar();
        this.startInAssembledContig = 1 + CigarUtils.countClippedBases(cigar, Tail.LEFT);
        this.endInAssembledContig = CigarUtils.countUnclippedReadBases(cigar) - CigarUtils.countClippedBases(cigar, Tail.RIGHT);
        this.cigarAlong5to3DirectionOfContig = cigar;
        this.forwardStrand = !isMappedReverse;
        this.mapQual = samRecord.getMappingQuality();
        this.mismatches = ReadUtils.getOptionalIntAttribute(samRecord, SAMTag.NM.name()).orElse(-1);
        this.alnScore = ReadUtils.getOptionalIntAttribute(samRecord, SAMTag.AS.name()).orElse(-1);
        this.alnModType = ContigAlignmentsModifier.AlnModType.NONE;
    }

    public AlignmentInterval(GATKRead read) {
        Cigar cigar;
        Utils.validateArg(!Utils.nonNull(read).isUnmapped(), "read being used to construct AlignmentInterval is unmapped: " + read.toString());
        boolean isMappedReverse = read.isReverseStrand();
        this.referenceSpan = new SimpleInterval(read);
        this.cigarAlong5to3DirectionOfContig = cigar = isMappedReverse ? CigarUtils.invertCigar(read.getCigar()) : read.getCigar();
        this.startInAssembledContig = 1 + CigarUtils.countClippedBases(cigar, Tail.LEFT);
        this.endInAssembledContig = CigarUtils.countUnclippedReadBases(cigar) - CigarUtils.countClippedBases(cigar, Tail.RIGHT);
        this.forwardStrand = !isMappedReverse;
        this.mapQual = read.getMappingQuality();
        this.mismatches = ReadUtils.getOptionalIntAttribute(read, SAMTag.NM.name()).orElse(-1);
        this.alnScore = ReadUtils.getOptionalIntAttribute(read, SAMTag.AS.name()).orElse(-1);
        this.alnModType = ContigAlignmentsModifier.AlnModType.NONE;
    }

    @VisibleForTesting
    public AlignmentInterval(BwaMemAlignment alignment, List<String> refNames, int unclippedContigLength) {
        this.referenceSpan = new SimpleInterval(refNames.get(alignment.getRefId()), alignment.getRefStart() + 1, alignment.getRefEnd());
        this.forwardStrand = 0 == (alignment.getSamFlag() & SAMFlag.READ_REVERSE_STRAND.intValue());
        this.cigarAlong5to3DirectionOfContig = this.forwardStrand ? TextCigarCodec.decode((String)alignment.getCigar()) : CigarUtils.invertCigar(TextCigarCodec.decode((String)alignment.getCigar()));
        Utils.validateArg(this.cigarAlong5to3DirectionOfContig.getReadLength() + CigarUtils.countClippedBases(this.cigarAlong5to3DirectionOfContig, CigarOperator.HARD_CLIP) == unclippedContigLength, "contig length provided in constructor and inferred length by computation are different: " + unclippedContigLength + "\t" + alignment.toString());
        this.mapQual = Math.max(0, alignment.getMapQual());
        this.mismatches = alignment.getNMismatches();
        if (this.forwardStrand) {
            this.startInAssembledContig = alignment.getSeqStart() + 1;
            this.endInAssembledContig = alignment.getSeqEnd();
        } else {
            this.startInAssembledContig = unclippedContigLength - alignment.getSeqEnd() + 1;
            this.endInAssembledContig = unclippedContigLength - alignment.getSeqStart();
        }
        this.alnScore = alignment.getAlignerScore();
        this.alnModType = ContigAlignmentsModifier.AlnModType.NONE;
    }

    public AlignmentInterval(SimpleInterval referenceSpan, int startInAssembledContig, int endInAssembledContig, Cigar cigarAlong5to3DirectionOfContig, boolean forwardStrand, int mapQual, int mismatches, int alignerScore, ContigAlignmentsModifier.AlnModType modType) {
        AlignmentInterval.checkValidArgument(cigarAlong5to3DirectionOfContig, referenceSpan, startInAssembledContig, endInAssembledContig);
        this.referenceSpan = referenceSpan;
        this.startInAssembledContig = startInAssembledContig;
        this.endInAssembledContig = endInAssembledContig;
        this.cigarAlong5to3DirectionOfContig = cigarAlong5to3DirectionOfContig;
        this.forwardStrand = forwardStrand;
        this.mapQual = mapQual;
        this.mismatches = mismatches;
        this.alnScore = alignerScore;
        this.alnModType = modType;
    }

    @VisibleForTesting
    static void checkValidArgument(Cigar cigar, SimpleInterval referenceSpan, int readStart, int readEnd) {
        boolean validState;
        int softClippedBases = CigarUtils.convertTerminalInsertionToSoftClip(cigar).getCigarElements().stream().filter(ce -> ce.getOperator().equals((Object)CigarOperator.S)).mapToInt(CigarElement::getLength).sum();
        int readLength = cigar.getReadLength() - softClippedBases;
        int referenceLength = cigar.getReferenceLength();
        boolean bl = validState = referenceLength == referenceSpan.size() && readLength == readEnd - readStart + 1;
        if (!validState) {
            throw new IllegalArgumentException("Encountering invalid arguments for constructing alignment,\tcigar: " + cigar.toString() + " ref.span: " + referenceSpan.toString() + " read span: " + readStart + "-" + readEnd);
        }
    }

    public boolean containsGapOfEqualOrLargerSize(int gapSize) {
        return this.cigarAlong5to3DirectionOfContig.getCigarElements().stream().anyMatch(cigarElement -> cigarElement.getOperator().isIndel() && cigarElement.getLength() >= gapSize);
    }

    public int getSizeOnRead() {
        return this.endInAssembledContig - this.startInAssembledContig + 1;
    }

    public boolean containsOnRef(AlignmentInterval other) {
        return this.referenceSpan.contains(other.referenceSpan);
    }

    public boolean containsOnRead(AlignmentInterval other) {
        return this.startInAssembledContig <= other.startInAssembledContig && this.endInAssembledContig >= other.endInAssembledContig;
    }

    @VisibleForTesting
    public static int overlapOnContig(AlignmentInterval one, AlignmentInterval two) {
        return Math.max(0, Math.min(one.endInAssembledContig + 1, two.endInAssembledContig + 1) - Math.max(one.startInAssembledContig, two.startInAssembledContig));
    }

    public static int overlapOnRefSpan(AlignmentInterval one, AlignmentInterval two) {
        if (!one.referenceSpan.getContig().equals(two.referenceSpan.getContig())) {
            return 0;
        }
        boolean dummyChr = false;
        SVInterval intOne = new SVInterval(0, one.referenceSpan.getStart(), one.referenceSpan.getEnd() + 1);
        SVInterval intTwo = new SVInterval(0, two.referenceSpan.getStart(), two.referenceSpan.getEnd() + 1);
        return intOne.overlapLen(intTwo);
    }

    AlignmentInterval(Kryo kryo, Input input) {
        String chr = input.readString();
        int refStart = input.readInt();
        int refEnd = input.readInt();
        this.referenceSpan = new SimpleInterval(chr, refStart, refEnd);
        this.startInAssembledContig = input.readInt();
        this.endInAssembledContig = input.readInt();
        this.cigarAlong5to3DirectionOfContig = TextCigarCodec.decode((String)input.readString());
        this.forwardStrand = input.readBoolean();
        this.mapQual = input.readInt();
        this.mismatches = input.readInt();
        this.alnScore = input.readInt();
        this.alnModType = ContigAlignmentsModifier.AlnModType.values()[input.readInt()];
    }

    void serialize(Kryo kryo, Output output) {
        output.writeString(this.referenceSpan.getContig());
        output.writeInt(this.referenceSpan.getStart());
        output.writeInt(this.referenceSpan.getEnd());
        output.writeInt(this.startInAssembledContig);
        output.writeInt(this.endInAssembledContig);
        output.writeString(TextCigarCodec.encode((Cigar)this.cigarAlong5to3DirectionOfContig));
        output.writeBoolean(this.forwardStrand);
        output.writeInt(this.mapQual);
        output.writeInt(this.mismatches);
        output.writeInt(this.alnScore);
        output.writeInt(this.alnModType.ordinal());
    }

    public Cigar cigarAlongReference() {
        return this.forwardStrand ? this.cigarAlong5to3DirectionOfContig : CigarUtils.invertCigar(this.cigarAlong5to3DirectionOfContig);
    }

    public String toPackedString() {
        return String.join((CharSequence)PACKED_STRING_REP_SEPARATOR, String.valueOf(this.startInAssembledContig), String.valueOf(this.endInAssembledContig), this.referenceSpan.toString(), this.forwardStrand ? "+" : "-", TextCigarCodec.encode((Cigar)this.cigarAlong5to3DirectionOfContig), String.valueOf(this.mapQual), String.valueOf(this.mismatches), String.valueOf(this.alnScore), this.alnModType.toString());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AlignmentInterval that = (AlignmentInterval)o;
        if (this.startInAssembledContig != that.startInAssembledContig) {
            return false;
        }
        if (this.endInAssembledContig != that.endInAssembledContig) {
            return false;
        }
        if (this.forwardStrand != that.forwardStrand) {
            return false;
        }
        if (this.mapQual != that.mapQual) {
            return false;
        }
        if (this.mismatches != that.mismatches) {
            return false;
        }
        if (this.alnScore != that.alnScore) {
            return false;
        }
        if (!this.referenceSpan.equals(that.referenceSpan)) {
            return false;
        }
        if (!this.cigarAlong5to3DirectionOfContig.equals((Object)that.cigarAlong5to3DirectionOfContig)) {
            return false;
        }
        return this.alnModType == that.alnModType;
    }

    public int hashCode() {
        int result = this.referenceSpan.hashCode();
        result = 31 * result + this.startInAssembledContig;
        result = 31 * result + this.endInAssembledContig;
        result = 31 * result + this.cigarAlong5to3DirectionOfContig.hashCode();
        result = 31 * result + (this.forwardStrand ? 1 : 0);
        result = 31 * result + this.mapQual;
        result = 31 * result + this.mismatches;
        result = 31 * result + this.alnScore;
        result = 31 * result + this.alnModType.ordinal();
        return result;
    }

    public SAMRecord toSAMRecord(SAMFileHeader header, String name, byte[] unclippedBases, boolean hardClip, int otherFlags, Collection<? extends SAMRecord.SAMTagAndValue> otherAttributes) {
        byte[] bases;
        Utils.nonNull(header, "the input header cannot be null");
        SAMRecord result = new SAMRecord(header);
        if (hardClip && SAMFlag.SECONDARY_ALIGNMENT.isUnset(otherFlags) && SAMFlag.SUPPLEMENTARY_ALIGNMENT.isUnset(otherFlags)) {
            throw new IllegalArgumentException("you cannot request hard-clipping on a primary non-supplementary alignment record");
        }
        result.setReadName(name);
        result.setFlags(otherFlags);
        result.setReadNegativeStrandFlag(!this.forwardStrand);
        byte[] byArray = unclippedBases == null ? null : (bases = hardClip ? Arrays.copyOfRange(unclippedBases, this.startInAssembledContig - 1, this.endInAssembledContig) : (byte[])unclippedBases.clone());
        if (!this.forwardStrand && bases != null) {
            SequenceUtil.reverseComplement((byte[])bases);
        }
        result.setReadBases(bases);
        Cigar cigar = this.forwardStrand ? this.cigarAlong5to3DirectionOfContig : CigarUtils.invertCigar(this.cigarAlong5to3DirectionOfContig);
        result.setCigar(AlignmentInterval.softOrHardReclip(cigar, hardClip ? CigarOperator.H : CigarOperator.S));
        result.setReferenceName(this.referenceSpan.getContig());
        result.setAlignmentStart(this.referenceSpan.getStart());
        result.setMappingQuality(this.mapQual);
        if (otherAttributes != null && !otherAttributes.isEmpty()) {
            for (SAMRecord.SAMTagAndValue sAMTagAndValue : otherAttributes) {
                Utils.nonNull(sAMTagAndValue, "other attributes contain null attributes");
                result.setAttribute(sAMTagAndValue.tag, sAMTagAndValue.value);
            }
        }
        if (this.mismatches != -1) {
            result.setAttribute(SAMTag.NM.name(), (Object)this.mismatches);
        }
        if (this.alnScore != -1) {
            result.setAttribute(SAMTag.AS.name(), (Object)this.alnScore);
        }
        return result;
    }

    @VisibleForTesting
    static Cigar softOrHardReclip(Cigar cigar, CigarOperator clipOperator) {
        Utils.nonNull(cigar, "the input cigar cannot be null");
        List elements = cigar.getCigarElements();
        int elementsSize = elements.size();
        if (elementsSize < 1) {
            return new Cigar();
        }
        if (((CigarElement)elements.get(0)).getOperator().isClipping() || ((CigarElement)elements.get(elementsSize - 1)).getOperator().isClipping()) {
            ArrayList<CigarElement> resultElements = new ArrayList<CigarElement>(elements.size());
            CigarElement lastElement = null;
            for (CigarElement element : elements) {
                CigarOperator operator = element.getOperator();
                if (operator.isClipping()) {
                    if (lastElement != null && lastElement.getOperator().isClipping()) {
                        int newLength = element.getLength() + lastElement.getLength();
                        lastElement = new CigarElement(newLength, clipOperator);
                        resultElements.set(resultElements.size() - 1, lastElement);
                        continue;
                    }
                    if (operator != clipOperator) {
                        lastElement = new CigarElement(element.getLength(), clipOperator);
                        resultElements.add(lastElement);
                        continue;
                    }
                    lastElement = element;
                    resultElements.add(lastElement);
                    continue;
                }
                lastElement = element;
                resultElements.add(lastElement);
            }
            return new Cigar(resultElements);
        }
        return new Cigar(elements);
    }

    public Tuple2<Integer, Integer> readIntervalAlignedToRefSpan(SimpleInterval otherRefSpan) {
        int start;
        int end;
        if (!Utils.nonNull(otherRefSpan).overlaps(this.referenceSpan)) {
            end = -1;
            start = -1;
        } else if (otherRefSpan.contains(this.referenceSpan)) {
            start = this.startInAssembledContig;
            end = this.endInAssembledContig;
        } else {
            int distOnRefForEnd;
            int distOnRefForStart;
            int hardClipOffset;
            CigarElement firstCigarElement = this.cigarAlong5to3DirectionOfContig.getFirstCigarElement();
            int n = hardClipOffset = firstCigarElement.getOperator().equals((Object)CigarOperator.H) ? firstCigarElement.getLength() : 0;
            if (this.forwardStrand) {
                distOnRefForStart = Math.max(0, otherRefSpan.getStart() - this.referenceSpan.getStart());
                distOnRefForEnd = Math.max(0, this.referenceSpan.getEnd() - otherRefSpan.getEnd());
            } else {
                distOnRefForStart = Math.max(0, this.referenceSpan.getEnd() - otherRefSpan.getEnd());
                distOnRefForEnd = Math.max(0, otherRefSpan.getStart() - this.referenceSpan.getStart());
            }
            int walkDistOnReadFromStart = 0;
            if (distOnRefForStart != 0) {
                int startPosOnRead = this.startInAssembledContig - hardClipOffset;
                walkDistOnReadFromStart = CigarUtils.computeAssociatedDistOnRead(this.cigarAlong5to3DirectionOfContig, startPosOnRead, distOnRefForStart, false);
            }
            int walkDistOnReadFromEnd = 0;
            if (distOnRefForEnd != 0) {
                int startPosOnRead = this.endInAssembledContig - hardClipOffset;
                walkDistOnReadFromEnd = CigarUtils.computeAssociatedDistOnRead(this.cigarAlong5to3DirectionOfContig, startPosOnRead, distOnRefForEnd, true);
            }
            start = this.startInAssembledContig + walkDistOnReadFromStart;
            end = this.endInAssembledContig - walkDistOnReadFromEnd;
        }
        return new Tuple2((Object)start, (Object)end);
    }

    public static final class Serializer
    extends com.esotericsoftware.kryo.Serializer<AlignmentInterval> {
        public void write(Kryo kryo, Output output, AlignmentInterval alignmentInterval) {
            alignmentInterval.serialize(kryo, output);
        }

        public AlignmentInterval read(Kryo kryo, Input input, Class<AlignmentInterval> clazz) {
            return new AlignmentInterval(kryo, input);
        }
    }
}

