/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.spark.sv.discovery.alignment;

import htsjdk.samtools.SAMFileHeader;
import java.io.Serializable;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Logger;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.api.java.function.Function;
import org.broadinstitute.hellbender.tools.spark.sv.discovery.alignment.AlignedContig;
import org.broadinstitute.hellbender.tools.spark.sv.discovery.alignment.AlignedContigGenerator;
import org.broadinstitute.hellbender.tools.spark.sv.discovery.alignment.AssemblyContigWithFineTunedAlignments;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.read.GATKRead;
import scala.Tuple2;

public class AssemblyContigAlignmentsRDDProcessor {
    public static JavaRDD<AssemblyContigWithFineTunedAlignments> createOptimalCoverageAlignmentSetsForContigs(JavaRDD<GATKRead> assemblyAlignments, SAMFileHeader header, Set<String> canonicalChromosomes, double scoreDiffTolerance, Logger toolLogger) {
        JavaRDD<AlignedContig> parsedContigAlignments = AssemblyContigAlignmentsRDDProcessor.convertRawAlignmentsToAlignedContigAndFilterByQuality(assemblyAlignments, header, toolLogger);
        return parsedContigAlignments.flatMap((FlatMapFunction & Serializable)tig -> tig.reconstructContigFromBestConfiguration(canonicalChromosomes, scoreDiffTolerance).iterator());
    }

    private static JavaRDD<AlignedContig> convertRawAlignmentsToAlignedContigAndFilterByQuality(JavaRDD<GATKRead> assemblyAlignments, SAMFileHeader header, Logger toolLogger) {
        assemblyAlignments.cache();
        toolLogger.info("Processing " + assemblyAlignments.count() + " raw alignments from " + assemblyAlignments.map(GATKRead::getName).distinct().count() + " contigs.");
        JavaRDD parsedContigAlignments = new SAMFormattedContigAlignmentParser(assemblyAlignments, header, false).getAlignedContigs().filter(AlignedContig::hasGoodMQ).cache();
        assemblyAlignments.unpersist();
        toolLogger.info("Filtering on MQ left " + parsedContigAlignments.count() + " contigs.");
        return parsedContigAlignments;
    }

    public static final class SAMFormattedContigAlignmentParser
    extends AlignedContigGenerator
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final JavaRDD<GATKRead> unfilteredContigAlignments;
        private final SAMFileHeader header;
        private final boolean splitGapped;

        public SAMFormattedContigAlignmentParser(JavaRDD<GATKRead> unfilteredContigAlignments, SAMFileHeader header, boolean splitGapped) {
            this.unfilteredContigAlignments = unfilteredContigAlignments;
            this.header = header;
            this.splitGapped = splitGapped;
        }

        @Override
        public JavaRDD<AlignedContig> getAlignedContigs() {
            return this.unfilteredContigAlignments.filter((Function & Serializable)r -> !r.isSecondaryAlignment()).groupBy(GATKRead::getName).map(Tuple2::_2).map((Function & Serializable)gatkReads -> AlignedContig.parseReadsAndOptionallySplitGappedAlignments(Utils.stream(gatkReads).map(r -> r.convertToSAMRecord(this.header)).collect(Collectors.toList()), 50, this.splitGapped));
        }
    }
}

