/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.spark.sv.discovery.alignment;

import com.esotericsoftware.kryo.DefaultSerializer;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.util.Locatable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.broadinstitute.hellbender.tools.spark.sv.discovery.alignment.AlignedContig;
import org.broadinstitute.hellbender.tools.spark.sv.discovery.alignment.AlignmentInterval;
import org.broadinstitute.hellbender.tools.spark.sv.discovery.inference.SimpleChimera;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.Utils;

@DefaultSerializer(value=Serializer.class)
public final class AssemblyContigWithFineTunedAlignments {
    private static final AlignedContig.Serializer contigSerializer = new AlignedContig.Serializer();
    private static final List<String> emptyInsertionMappings = Collections.emptyList();
    private final AlignedContig sourceTig;
    private final List<String> insertionMappings;
    private final boolean hasEquallyGoodAlnConfigurations;
    private final String saTAGForGoodMappingToNonCanonicalChromosome;
    public static final String NO_GOOD_MAPPING_TO_NON_CANONICAL_CHROMOSOME = "NONE";

    public AssemblyContigWithFineTunedAlignments(AlignedContig contig) {
        this(Utils.nonNull(contig), emptyInsertionMappings, false, NO_GOOD_MAPPING_TO_NON_CANONICAL_CHROMOSOME);
    }

    public AssemblyContigWithFineTunedAlignments(AlignedContig contig, List<String> insertionMappings, boolean hasEquallyGoodAlnConfigurations, AlignmentInterval goodMappingToNonCanonicalChromosome) {
        this(Utils.nonNull(contig), Utils.nonNull(insertionMappings), hasEquallyGoodAlnConfigurations, goodMappingToNonCanonicalChromosome == null ? NO_GOOD_MAPPING_TO_NON_CANONICAL_CHROMOSOME : goodMappingToNonCanonicalChromosome.toSATagString());
    }

    public AssemblyContigWithFineTunedAlignments(AlignedContig contig, List<String> insertionMappings, boolean hasEquallyGoodAlnConfigurations, String saTAGForGoodMappingToNonCanonicalChromosome) {
        this.sourceTig = contig;
        this.insertionMappings = insertionMappings;
        this.hasEquallyGoodAlnConfigurations = hasEquallyGoodAlnConfigurations;
        this.saTAGForGoodMappingToNonCanonicalChromosome = saTAGForGoodMappingToNonCanonicalChromosome;
    }

    AssemblyContigWithFineTunedAlignments(Kryo kryo, Input input) {
        this.sourceTig = contigSerializer.read(kryo, input, (Class)AlignedContig.class);
        int insertionMappingsSize = input.readInt();
        this.insertionMappings = new ArrayList<String>(insertionMappingsSize);
        for (int i = 0; i < insertionMappingsSize; ++i) {
            this.insertionMappings.add(input.readString());
        }
        this.hasEquallyGoodAlnConfigurations = input.readBoolean();
        this.saTAGForGoodMappingToNonCanonicalChromosome = input.readString();
    }

    public AlignedContig getSourceContig() {
        return this.sourceTig;
    }

    public List<AlignmentInterval> getAlignments() {
        return this.sourceTig.getAlignments();
    }

    public AlignmentInterval getHeadAlignment() {
        return this.sourceTig.getHeadAlignment();
    }

    public AlignmentInterval getTailAlignment() {
        return this.sourceTig.getTailAlignment();
    }

    public String getContigName() {
        return this.sourceTig.getContigName();
    }

    public byte[] getContigSequence() {
        return this.sourceTig.getContigSequence();
    }

    public List<String> getInsertionMappings() {
        return this.insertionMappings;
    }

    public final boolean hasChimericAlignments() {
        return this.sourceTig.getAlignments().size() > 1;
    }

    public final String getSAtagForGoodMappingToNonCanonicalChromosome() {
        return this.saTAGForGoodMappingToNonCanonicalChromosome;
    }

    public SimpleChimera extractSimpleChimera(SAMSequenceDictionary referenceDictionary) {
        if (!this.sourceTig.hasOnly2Alignments()) {
            throw new IllegalArgumentException("assembly contig sent to the wrong path: assumption that contig has only 2 good alignments is violated for\n" + this);
        }
        List<AlignmentInterval> alignments = this.sourceTig.getAlignments();
        AlignmentInterval alignmentOne = alignments.get(0);
        AlignmentInterval alignmentTwo = alignments.get(1);
        return new SimpleChimera(alignmentOne, alignmentTwo, this.insertionMappings, this.sourceTig.getContigName(), this.saTAGForGoodMappingToNonCanonicalChromosome, referenceDictionary);
    }

    public AlignmentSignatureBasicType getAlignmentSignatureBasicType() {
        if (this.hasEquallyGoodAlnConfigurations || this.hasIncompletePicture()) {
            return AlignmentSignatureBasicType.UNKNOWN;
        }
        if (this.getAlignments().size() < 2) {
            if (this.getAlignments().size() == 1 && this.insertionMappings.isEmpty()) {
                return AlignmentSignatureBasicType.NORMAL;
            }
            return AlignmentSignatureBasicType.UNKNOWN;
        }
        if (this.sourceTig.hasOnly2Alignments()) {
            return AlignmentSignatureBasicType.SIMPLE_CHIMERA;
        }
        return AlignmentSignatureBasicType.COMPLEX;
    }

    public ReasonForAlignmentClassificationFailure getReasonForAlignmentClassificationFailure() {
        if (this.hasEquallyGoodAlnConfigurations) {
            return ReasonForAlignmentClassificationFailure.AMBIGUOUS;
        }
        if (this.hasIncompletePicture()) {
            return ReasonForAlignmentClassificationFailure.INCOMPLETE;
        }
        if (!this.insertionMappings.isEmpty() && !this.hasChimericAlignments()) {
            return ReasonForAlignmentClassificationFailure.UNINFORMATIVE;
        }
        throw new UnsupportedOperationException("operating on contig without a suspicious alignment signature, contig: " + this.toString());
    }

    public final boolean hasEquallyGoodAlnConfigurations() {
        return this.hasEquallyGoodAlnConfigurations;
    }

    final boolean hasIncompletePicture() {
        if (!this.hasChimericAlignments()) {
            return false;
        }
        if (this.sourceTig.hasOnly2Alignments()) {
            return AssemblyContigWithFineTunedAlignments.hasIncompletePictureFromTwoAlignments(this.getHeadAlignment(), this.getTailAlignment());
        }
        return this.hasIncompletePictureFromMultipleAlignments();
    }

    public static boolean hasIncompletePictureFromTwoAlignments(AlignmentInterval headAlignment, AlignmentInterval tailAlignment) {
        SimpleInterval referenceSpanOne = headAlignment.referenceSpan;
        SimpleInterval referenceSpanTwo = tailAlignment.referenceSpan;
        if (!referenceSpanOne.getContig().equals(referenceSpanTwo.getContig())) {
            return false;
        }
        if (AssemblyContigWithFineTunedAlignments.oneRefSpanContainsTheOther(referenceSpanOne, referenceSpanTwo)) {
            return true;
        }
        if (headAlignment.forwardStrand != tailAlignment.forwardStrand) {
            return referenceSpanOne.overlaps(referenceSpanTwo);
        }
        if (headAlignment.forwardStrand) {
            return referenceSpanOne.getStart() > referenceSpanTwo.getStart() && referenceSpanOne.getStart() <= referenceSpanTwo.getEnd();
        }
        return referenceSpanTwo.getStart() > referenceSpanOne.getStart() && referenceSpanTwo.getStart() <= referenceSpanOne.getEnd();
    }

    private boolean hasIncompletePictureFromMultipleAlignments() {
        int goodAlignmentsCount = this.sourceTig.getAlignments().size();
        AlignmentInterval head = this.sourceTig.getHeadAlignment();
        AlignmentInterval tail = this.sourceTig.getTailAlignment();
        if (!head.referenceSpan.getContig().equals(tail.referenceSpan.getContig()) || head.forwardStrand != tail.forwardStrand) {
            return true;
        }
        SimpleInterval referenceSpanHead = head.referenceSpan;
        SimpleInterval referenceSpanTail = tail.referenceSpan;
        if (AssemblyContigWithFineTunedAlignments.oneRefSpanContainsTheOther(referenceSpanHead, referenceSpanTail)) {
            return true;
        }
        SimpleInterval validRegion = new SimpleInterval(referenceSpanHead.getContig(), Math.min(referenceSpanHead.getStart(), referenceSpanTail.getStart()), Math.max(referenceSpanHead.getEnd(), referenceSpanTail.getEnd()));
        boolean notCompleteDupRegion = this.sourceTig.getAlignments().subList(1, goodAlignmentsCount - 1).stream().map(ai -> ai.referenceSpan).anyMatch(middle -> middle.overlaps(validRegion) && !validRegion.contains((Locatable)middle));
        if (notCompleteDupRegion) {
            return true;
        }
        if (head.forwardStrand) {
            return referenceSpanHead.getStart() >= referenceSpanTail.getStart();
        }
        return referenceSpanHead.getEnd() <= referenceSpanTail.getEnd();
    }

    private static boolean oneRefSpanContainsTheOther(SimpleInterval one, SimpleInterval two) {
        return one.contains(two) || two.contains(one);
    }

    void serialize(Kryo kryo, Output output) {
        contigSerializer.write(kryo, output, this.sourceTig);
        output.writeInt(this.insertionMappings.size());
        for (String mapping : this.insertionMappings) {
            output.writeString(mapping);
        }
        output.writeBoolean(this.hasEquallyGoodAlnConfigurations);
        output.writeString(this.saTAGForGoodMappingToNonCanonicalChromosome);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("AssemblyContigWithFineTunedAlignments{");
        sb.append("sourceTig=").append(this.sourceTig);
        sb.append(", insertionMappings=").append(this.insertionMappings);
        sb.append(", hasEquallyGoodAlnConfigurations=").append(this.hasEquallyGoodAlnConfigurations);
        sb.append(", saTAGForGoodMappingToNonCanonicalChromosome='").append(this.saTAGForGoodMappingToNonCanonicalChromosome).append('\'');
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AssemblyContigWithFineTunedAlignments that = (AssemblyContigWithFineTunedAlignments)o;
        if (this.hasEquallyGoodAlnConfigurations != that.hasEquallyGoodAlnConfigurations) {
            return false;
        }
        if (!this.sourceTig.equals(that.sourceTig)) {
            return false;
        }
        if (!this.insertionMappings.equals(that.insertionMappings)) {
            return false;
        }
        return this.saTAGForGoodMappingToNonCanonicalChromosome.equals(that.saTAGForGoodMappingToNonCanonicalChromosome);
    }

    public int hashCode() {
        int result = this.sourceTig.hashCode();
        result = 31 * result + this.insertionMappings.hashCode();
        result = 31 * result + (this.hasEquallyGoodAlnConfigurations ? 1 : 0);
        result = 31 * result + this.saTAGForGoodMappingToNonCanonicalChromosome.hashCode();
        return result;
    }

    public static final class Serializer
    extends com.esotericsoftware.kryo.Serializer<AssemblyContigWithFineTunedAlignments> {
        public void write(Kryo kryo, Output output, AssemblyContigWithFineTunedAlignments alignedContig) {
            alignedContig.serialize(kryo, output);
        }

        public AssemblyContigWithFineTunedAlignments read(Kryo kryo, Input input, Class<AssemblyContigWithFineTunedAlignments> clazz) {
            return new AssemblyContigWithFineTunedAlignments(kryo, input);
        }
    }

    public static enum ReasonForAlignmentClassificationFailure {
        INCOMPLETE,
        AMBIGUOUS,
        UNINFORMATIVE;

    }

    public static enum AlignmentSignatureBasicType {
        NORMAL,
        UNKNOWN,
        SIMPLE_CHIMERA,
        COMPLEX;

    }
}

