/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.spark.sv.discovery.alignment;

import com.google.common.annotations.VisibleForTesting;
import htsjdk.samtools.Cigar;
import htsjdk.samtools.CigarElement;
import htsjdk.samtools.CigarOperator;
import htsjdk.samtools.TextCigarCodec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.tools.spark.sv.discovery.alignment.AlignmentInterval;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.Tail;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.read.CigarBuilder;
import org.broadinstitute.hellbender.utils.read.CigarUtils;
import scala.Tuple2;
import scala.Tuple3;

public final class ContigAlignmentsModifier {
    public static AlignmentInterval clipAlignmentInterval(AlignmentInterval input, int clipLengthOnRead, boolean clipFrom3PrimeEnd) {
        Utils.nonNull(input);
        if (clipLengthOnRead < 0) {
            throw new IllegalArgumentException("requesting negative clip length: " + clipLengthOnRead + " on " + input.toPackedString());
        }
        Utils.validateArg(clipLengthOnRead < input.endInAssembledContig - input.startInAssembledContig + 1, "input alignment to be clipped away: " + input.toPackedString() + "\twith clip length: " + clipLengthOnRead);
        Tuple2<SimpleInterval, Cigar> newRefSpanAndCigar = ContigAlignmentsModifier.computeNewRefSpanAndCigar(input, clipLengthOnRead, clipFrom3PrimeEnd);
        Tuple2<Integer, Integer> newContigStartAndEnd = ContigAlignmentsModifier.computeNewReadSpan(input.startInAssembledContig, input.endInAssembledContig, (Cigar)newRefSpanAndCigar._2, clipLengthOnRead, clipFrom3PrimeEnd);
        return new AlignmentInterval((SimpleInterval)newRefSpanAndCigar._1, (Integer)newContigStartAndEnd._1, (Integer)newContigStartAndEnd._2, (Cigar)newRefSpanAndCigar._2, input.forwardStrand, input.mapQual, -1, -1, AlnModType.UNDERGONE_OVERLAP_REMOVAL);
    }

    private static Tuple2<Integer, Integer> computeNewReadSpan(int originalContigStart, int originalContigEnd, Cigar newCigarAlong5to3DirectionOfContig, int clipLengthOnRead, boolean clipFrom3PrimeEnd) {
        int newTigEnd;
        int newTigStart;
        if (clipFrom3PrimeEnd) {
            newTigStart = originalContigStart;
            newTigEnd = Math.min(originalContigEnd - clipLengthOnRead, CigarUtils.countUnclippedReadBases(newCigarAlong5to3DirectionOfContig) - CigarUtils.countClippedBases(newCigarAlong5to3DirectionOfContig, Tail.RIGHT));
        } else {
            newTigStart = Math.max(originalContigStart + clipLengthOnRead, CigarUtils.countClippedBases(newCigarAlong5to3DirectionOfContig, Tail.LEFT) + 1);
            newTigEnd = originalContigEnd;
        }
        return new Tuple2((Object)newTigStart, (Object)newTigEnd);
    }

    @VisibleForTesting
    static Tuple2<SimpleInterval, Cigar> computeNewRefSpanAndCigar(AlignmentInterval input, int clipLengthOnRead, boolean clipFrom3PrimeEnd) {
        Utils.validateArg(input.cigarAlong5to3DirectionOfContig.getCigarElements().stream().map(CigarElement::getOperator).noneMatch(op -> op.equals((Object)CigarOperator.N) || op.isPadding()), "Input alignment contains padding or skip operations, which is currently unsupported: " + input.toPackedString());
        Tuple3<List<CigarElement>, List<CigarElement>, List<CigarElement>> threeSections = ContigAlignmentsModifier.splitCigarByLeftAndRightClipping(input);
        List leftClippings = (List)threeSections._1();
        List unclippedCigarElementsForThisAlignment = (List)threeSections._2();
        List rightClippings = (List)threeSections._3();
        int readBasesConsumed = 0;
        int refBasesConsumed = 0;
        ArrayList cigarElements = new ArrayList(unclippedCigarElementsForThisAlignment);
        if (clipFrom3PrimeEnd) {
            Collections.reverse(cigarElements);
        }
        ArrayList<CigarElement> newMiddleSection = new ArrayList<CigarElement>(unclippedCigarElementsForThisAlignment.size());
        for (int idx = 0; idx < cigarElements.size(); ++idx) {
            CigarElement ce = (CigarElement)cigarElements.get(idx);
            if (ce.getOperator().consumesReadBases()) {
                if (readBasesConsumed + ce.getLength() < clipLengthOnRead) {
                    readBasesConsumed += ce.getLength();
                } else {
                    if (!ce.getOperator().isAlignment() && !ce.getOperator().equals((Object)CigarOperator.I)) {
                        throw new GATKException.ShouldNeverReachHereException("Logic error, should not reach here: operation consumes read bases but is neither alignment nor insertion.\n Original cigar(" + TextCigarCodec.encode((Cigar)input.cigarAlong5to3DirectionOfContig) + ")\tclipLengthOnRead(" + clipLengthOnRead + ")\t" + (clipFrom3PrimeEnd ? "clipFrom3PrimeEnd" : "clipFrom5PrimeEnd"));
                    }
                    newMiddleSection.add(new CigarElement(clipLengthOnRead, CigarOperator.S));
                    int leftOverBasesForCurrOp = readBasesConsumed + ce.getLength() - clipLengthOnRead;
                    if (leftOverBasesForCurrOp != 0) {
                        newMiddleSection.add(new CigarElement(leftOverBasesForCurrOp, ce.getOperator().isAlignment() ? CigarOperator.M : CigarOperator.S));
                    }
                    newMiddleSection.addAll(cigarElements.subList(idx + 1, cigarElements.size()));
                    refBasesConsumed += ce.getOperator().isAlignment() ? clipLengthOnRead - readBasesConsumed : 0;
                    break;
                }
            }
            if (!ce.getOperator().consumesReferenceBases()) continue;
            refBasesConsumed += ce.getLength();
        }
        String messageWhenErred = input.toPackedString() + "\tclip length: " + clipLengthOnRead + "\tclip from end: " + (clipFrom3PrimeEnd ? "3" : "5") + " of read";
        if (newMiddleSection.size() < 2) {
            throw new GATKException("The input alignment after clipping contains no or only one operation. This indicates a logic error or too large a clipping length (whole alignment being clipped away) or invalid input cigar.\n" + messageWhenErred);
        }
        CigarElement firstOp = (CigarElement)newMiddleSection.get(0);
        CigarElement secondOp = (CigarElement)newMiddleSection.get(1);
        if (firstOp.getOperator().equals((Object)CigarOperator.S) && secondOp.getOperator().isIndel()) {
            if (newMiddleSection.size() < 3) {
                throw new GATKException("After clipping, the new cigar would contain NO aligned bases (i.e. either clipped or gap or mix), This indicates a logic error or too large a clipping length (whole alignment being clipped away) or invalid input cigar.\n" + messageWhenErred);
            }
            refBasesConsumed += secondOp.getOperator().consumesReferenceBases() ? secondOp.getLength() : 0;
            if (secondOp.getOperator().equals((Object)CigarOperator.D)) {
                newMiddleSection.remove(1);
            } else {
                newMiddleSection.remove(0);
                newMiddleSection.set(0, new CigarElement(firstOp.getLength() + secondOp.getLength(), CigarOperator.S));
            }
        }
        if (clipFrom3PrimeEnd) {
            Collections.reverse(newMiddleSection);
        }
        Cigar newCigar = new CigarBuilder().addAll(leftClippings).addAll(newMiddleSection).addAll(rightClippings).make();
        SimpleInterval newRefSpan = clipFrom3PrimeEnd == input.forwardStrand ? new SimpleInterval(input.referenceSpan.getContig(), input.referenceSpan.getStart(), input.referenceSpan.getEnd() - refBasesConsumed) : new SimpleInterval(input.referenceSpan.getContig(), input.referenceSpan.getStart() + refBasesConsumed, input.referenceSpan.getEnd());
        return new Tuple2((Object)newRefSpan, (Object)newCigar);
    }

    @VisibleForTesting
    static Tuple3<List<CigarElement>, List<CigarElement>, List<CigarElement>> splitCigarByLeftAndRightClipping(AlignmentInterval input) {
        List cigarElements = input.cigarAlong5to3DirectionOfContig.getCigarElements();
        ArrayList<CigarElement> left = new ArrayList<CigarElement>(cigarElements.size());
        ArrayList<CigarElement> middle = new ArrayList<CigarElement>(cigarElements.size());
        ArrayList<CigarElement> right = new ArrayList<CigarElement>(cigarElements.size());
        int readBasesConsumed = 0;
        for (CigarElement ce : cigarElements) {
            if (readBasesConsumed < input.startInAssembledContig - 1) {
                left.add(ce);
            } else if (readBasesConsumed < input.endInAssembledContig) {
                middle.add(ce);
            } else {
                right.add(ce);
            }
            readBasesConsumed += ce.getOperator().consumesReadBases() || ce.getOperator().equals((Object)CigarOperator.H) ? ce.getLength() : 0;
        }
        if (middle.isEmpty()) {
            throw new GATKException("Logic error: cigar elements corresponding to alignment block is empty. " + input.toPackedString());
        }
        return new Tuple3(left, middle, right);
    }

    @VisibleForTesting
    public static Iterable<AlignmentInterval> splitGappedAlignment(AlignmentInterval oneRegion, int sensitivity, int unclippedContigLen) {
        return new GapSplitter(oneRegion, unclippedContigLen).splitGaps(sensitivity);
    }

    private static class GapSplitter {
        private static final int NOT_SET = -1;
        int alignmentStartContig = -1;
        int alignmentStartIdx = -1;
        int alignmentStartRef = -1;
        int alignmentEndContig = -1;
        int alignmentEndIdx = -1;
        int alignmentEndRef = -1;
        final AlignmentInterval oneRegion;
        final int unclippedContigLen;
        final List<CigarElement> cigarElements;

        public GapSplitter(AlignmentInterval oneRegion, int unclippedContigLen) {
            this.oneRegion = oneRegion;
            this.unclippedContigLen = unclippedContigLen;
            this.cigarElements = oneRegion.cigarAlong5to3DirectionOfContig.getCigarElements();
        }

        public List<AlignmentInterval> splitGaps(int sensitivity) {
            int nElements = this.cigarElements.size();
            if (nElements <= 1) {
                return new ArrayList<AlignmentInterval>(Collections.singletonList(this.oneRegion));
            }
            int contigOffset = 0;
            int elementIdx = 0;
            if (this.cigarElements.get(0).getOperator() == CigarOperator.H) {
                contigOffset += this.cigarElements.get(0).getLength();
                ++elementIdx;
            }
            if (this.cigarElements.get(nElements - 1).getOperator() == CigarOperator.H) {
                --nElements;
            }
            int refOffset = this.oneRegion.referenceSpan.getStart();
            if (!this.oneRegion.forwardStrand) {
                refOffset = -this.oneRegion.referenceSpan.getEnd();
            }
            ArrayList<AlignmentInterval> result = new ArrayList<AlignmentInterval>();
            while (elementIdx < nElements) {
                CigarElement element = this.cigarElements.get(elementIdx);
                CigarOperator op = element.getOperator();
                int len = element.getLength();
                if (op.isAlignment()) {
                    if (this.alignmentStartContig == -1) {
                        this.alignmentStartContig = contigOffset;
                        this.alignmentStartIdx = elementIdx;
                        this.alignmentStartRef = refOffset;
                    }
                    this.alignmentEndContig = contigOffset + len;
                    this.alignmentEndIdx = elementIdx + 1;
                    this.alignmentEndRef = refOffset + len;
                } else if (op.isIndel() && len >= sensitivity && this.alignmentStartContig != -1) {
                    result.add(this.grabCurrentInterval());
                    this.alignmentStartContig = -1;
                }
                if (op.consumesReadBases()) {
                    contigOffset += len;
                }
                if (op.consumesReferenceBases()) {
                    refOffset += len;
                }
                ++elementIdx;
            }
            if (this.alignmentStartContig != -1) {
                result.add(this.grabCurrentInterval());
            }
            if (result.size() < 2) {
                return new ArrayList<AlignmentInterval>(Collections.singletonList(this.oneRegion));
            }
            return result;
        }

        private AlignmentInterval grabCurrentInterval() {
            ArrayList<CigarElement> alignmentElements = new ArrayList<CigarElement>();
            int initialSoftClipLen = this.alignmentStartContig;
            CigarElement initialHardClip = this.cigarElements.get(0);
            if (initialHardClip.getOperator() == CigarOperator.H) {
                alignmentElements.add(initialHardClip);
                initialSoftClipLen -= initialHardClip.getLength();
            }
            if (initialSoftClipLen > 0) {
                alignmentElements.add(new CigarElement(initialSoftClipLen, CigarOperator.S));
            }
            alignmentElements.addAll(this.cigarElements.subList(this.alignmentStartIdx, this.alignmentEndIdx));
            int finalSoftClipLen = this.unclippedContigLen - this.alignmentEndContig;
            CigarElement finalHardClip = this.cigarElements.get(this.cigarElements.size() - 1);
            if (finalHardClip.getOperator() == CigarOperator.H) {
                if ((finalSoftClipLen -= finalHardClip.getLength()) > 0) {
                    alignmentElements.add(new CigarElement(finalSoftClipLen, CigarOperator.S));
                }
                alignmentElements.add(finalHardClip);
            } else if (finalSoftClipLen > 0) {
                alignmentElements.add(new CigarElement(finalSoftClipLen, CigarOperator.S));
            }
            String refContig = this.oneRegion.referenceSpan.getContig();
            SimpleInterval refSpan = this.oneRegion.forwardStrand ? new SimpleInterval(refContig, this.alignmentStartRef, this.alignmentEndRef - 1) : new SimpleInterval(refContig, -this.alignmentEndRef + 1, -this.alignmentStartRef);
            return new AlignmentInterval(refSpan, this.alignmentStartContig + 1, this.alignmentEndContig, new Cigar(alignmentElements), this.oneRegion.forwardStrand, this.oneRegion.mapQual, -1, -1, AlnModType.FROM_SPLIT_GAPPED_ALIGNMENT);
        }
    }

    public static enum AlnModType {
        NONE,
        UNDERGONE_OVERLAP_REMOVAL,
        EXTRACTED_FROM_LARGER_ALIGNMENT,
        FROM_SPLIT_GAPPED_ALIGNMENT;


        public String toString() {
            switch (this) {
                case NONE: {
                    return ModTypeString.O.name();
                }
                case UNDERGONE_OVERLAP_REMOVAL: {
                    return ModTypeString.H.name();
                }
                case EXTRACTED_FROM_LARGER_ALIGNMENT: {
                    return ModTypeString.E.name();
                }
                case FROM_SPLIT_GAPPED_ALIGNMENT: {
                    return ModTypeString.S.name();
                }
            }
            throw new IllegalArgumentException();
        }

        public static enum ModTypeString {
            O,
            H,
            E,
            S;

        }
    }
}

