/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.spark.sv.discovery.inference;

import com.esotericsoftware.kryo.DefaultSerializer;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.google.common.annotations.VisibleForTesting;
import htsjdk.samtools.Cigar;
import htsjdk.samtools.CigarElement;
import htsjdk.samtools.CigarOperator;
import htsjdk.samtools.TextCigarCodec;
import htsjdk.samtools.util.SequenceUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.tools.spark.sv.discovery.alignment.AlignmentInterval;
import org.broadinstitute.hellbender.tools.spark.sv.discovery.inference.SimpleChimera;
import org.broadinstitute.hellbender.tools.spark.sv.utils.SVUtils;
import org.broadinstitute.hellbender.tools.spark.sv.utils.Strand;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.read.CigarUtils;

public abstract class BreakpointComplications {
    protected String homologyForwardStrandRep = "";
    protected String insertedSequenceForwardStrandRep = "";

    public String getHomologyForwardStrandRep() {
        return this.homologyForwardStrandRep;
    }

    public String getInsertedSequenceForwardStrandRep() {
        return this.insertedSequenceForwardStrandRep;
    }

    public String toString() {
        return "homology: " + this.homologyForwardStrandRep + "\tinserted sequence: " + this.insertedSequenceForwardStrandRep;
    }

    public Map<String, Object> toVariantAttributes() {
        HashMap<String, Object> attributeMap = new HashMap<String, Object>();
        if (!this.getInsertedSequenceForwardStrandRep().isEmpty()) {
            attributeMap.put("INSSEQ", this.getInsertedSequenceForwardStrandRep());
            attributeMap.put("INSLEN", this.getInsertedSequenceForwardStrandRep().length());
        }
        if (!this.getHomologyForwardStrandRep().isEmpty()) {
            attributeMap.put("HOMSEQ", this.getHomologyForwardStrandRep());
            attributeMap.put("HOMLEN", this.getHomologyForwardStrandRep().length());
        }
        return attributeMap;
    }

    public boolean hasDuplicationAnnotation() {
        return false;
    }

    protected BreakpointComplications() {
    }

    @VisibleForTesting
    BreakpointComplications(String homologyForwardStrandRep, String insertedSequenceForwardStrandRep) {
        this.homologyForwardStrandRep = homologyForwardStrandRep;
        this.insertedSequenceForwardStrandRep = insertedSequenceForwardStrandRep;
    }

    protected BreakpointComplications(Kryo kryo, Input input) {
        this.homologyForwardStrandRep = input.readString();
        this.insertedSequenceForwardStrandRep = input.readString();
    }

    protected void serialize(Kryo kryo, Output output) {
        output.writeString(this.homologyForwardStrandRep);
        output.writeString(this.insertedSequenceForwardStrandRep);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BreakpointComplications that = (BreakpointComplications)o;
        if (!this.homologyForwardStrandRep.equals(that.homologyForwardStrandRep)) {
            return false;
        }
        return this.insertedSequenceForwardStrandRep.equals(that.insertedSequenceForwardStrandRep);
    }

    public int hashCode() {
        int result = this.homologyForwardStrandRep.hashCode();
        result = 31 * result + this.insertedSequenceForwardStrandRep.hashCode();
        return result;
    }

    @VisibleForTesting
    static String inferHomology(AlignmentInterval first, AlignmentInterval second, byte[] contigSequence, boolean firstAfterSecond) {
        if (first.endInAssembledContig >= second.startInAssembledContig) {
            byte[] homologyBytes = Arrays.copyOfRange(contigSequence, second.startInAssembledContig - 1, first.endInAssembledContig);
            return new String(BreakpointComplications.reverseComplementIfNecessary(homologyBytes, first, second, firstAfterSecond));
        }
        return "";
    }

    @VisibleForTesting
    static String inferInsertedSequence(AlignmentInterval first, AlignmentInterval second, byte[] contigSequence, boolean firstAfterSecond) {
        if (first.endInAssembledContig < second.startInAssembledContig - 1) {
            byte[] insertedSequenceBytes = Arrays.copyOfRange(contigSequence, first.endInAssembledContig, second.startInAssembledContig - 1);
            return new String(BreakpointComplications.reverseComplementIfNecessary(insertedSequenceBytes, first, second, firstAfterSecond));
        }
        return "";
    }

    private static byte[] reverseComplementIfNecessary(byte[] seq, AlignmentInterval first, AlignmentInterval second, boolean firstAfterSecond) {
        if (first.forwardStrand == second.forwardStrand) {
            if (!first.forwardStrand) {
                SequenceUtil.reverseComplement((byte[])seq, (int)0, (int)seq.length);
            }
        } else if (firstAfterSecond == first.forwardStrand) {
            SequenceUtil.reverseComplement((byte[])seq, (int)0, (int)seq.length);
        }
        return seq;
    }

    @DefaultSerializer(value=Serializer.class)
    static final class InterChromosomeBreakpointComplications
    extends BNDTypeBreakpointComplications {
        @VisibleForTesting
        InterChromosomeBreakpointComplications(String homologyForwardStrandRep, String insertedSequenceForwardStrandRep) {
            super(homologyForwardStrandRep, insertedSequenceForwardStrandRep);
        }

        InterChromosomeBreakpointComplications(SimpleChimera simpleChimera, byte[] contigSeq, boolean firstAfterSecond) {
            super(simpleChimera, contigSeq, firstAfterSecond);
        }

        private InterChromosomeBreakpointComplications(Kryo kryo, Input input) {
            super(kryo, input);
        }

        @Override
        protected void serialize(Kryo kryo, Output output) {
            super.serialize(kryo, output);
        }

        public static final class Serializer
        extends com.esotericsoftware.kryo.Serializer<InterChromosomeBreakpointComplications> {
            public void write(Kryo kryo, Output output, InterChromosomeBreakpointComplications breakpointComplications) {
                breakpointComplications.serialize(kryo, output);
            }

            public InterChromosomeBreakpointComplications read(Kryo kryo, Input input, Class<InterChromosomeBreakpointComplications> klass) {
                return new InterChromosomeBreakpointComplications(kryo, input);
            }
        }
    }

    @DefaultSerializer(value=Serializer.class)
    static final class IntraChrRefOrderSwapBreakpointComplications
    extends BNDTypeBreakpointComplications {
        @VisibleForTesting
        IntraChrRefOrderSwapBreakpointComplications(String homologyForwardStrandRep, String insertedSequenceForwardStrandRep) {
            super(homologyForwardStrandRep, insertedSequenceForwardStrandRep);
        }

        IntraChrRefOrderSwapBreakpointComplications(SimpleChimera simpleChimera, byte[] contigSeq, boolean firstAfterSecond) {
            super(simpleChimera, contigSeq, firstAfterSecond);
        }

        private IntraChrRefOrderSwapBreakpointComplications(Kryo kryo, Input input) {
            super(kryo, input);
        }

        @Override
        protected void serialize(Kryo kryo, Output output) {
            super.serialize(kryo, output);
        }

        public static final class Serializer
        extends com.esotericsoftware.kryo.Serializer<IntraChrRefOrderSwapBreakpointComplications> {
            public void write(Kryo kryo, Output output, IntraChrRefOrderSwapBreakpointComplications breakpointComplications) {
                breakpointComplications.serialize(kryo, output);
            }

            public IntraChrRefOrderSwapBreakpointComplications read(Kryo kryo, Input input, Class<IntraChrRefOrderSwapBreakpointComplications> klass) {
                return new IntraChrRefOrderSwapBreakpointComplications(kryo, input);
            }
        }
    }

    public static final class InvertedDuplicationBreakpointComplications
    extends BNDTypeBreakpointComplications {
        static final List<Strand> DEFAULT_INV_DUP_REF_ORIENTATION = Collections.singletonList(Strand.POSITIVE);
        static final List<Strand> DEFAULT_INV_DUP_CTG_ORIENTATIONS_FR = Arrays.asList(Strand.POSITIVE, Strand.NEGATIVE);
        static final List<Strand> DEFAULT_INV_DUP_CTG_ORIENTATIONS_RF = Arrays.asList(Strand.NEGATIVE, Strand.POSITIVE);
        private SimpleInterval dupSeqRepeatUnitRefSpan = null;
        private int dupSeqRepeatNumOnRef = 0;
        private int dupSeqRepeatNumOnCtg = 0;
        private List<Strand> dupSeqStrandOnRef = null;
        private List<Strand> dupSeqStrandOnCtg = null;
        private List<String> cigarStringsForDupSeqOnCtg = null;
        private boolean dupAnnotIsFromOptimization = false;
        private SimpleInterval invertedTransInsertionRefSpan = null;

        public SimpleInterval getDupSeqRepeatUnitRefSpan() {
            return this.dupSeqRepeatUnitRefSpan;
        }

        int getDupSeqRepeatNumOnRef() {
            return this.dupSeqRepeatNumOnRef;
        }

        int getDupSeqRepeatNumOnCtg() {
            return this.dupSeqRepeatNumOnCtg;
        }

        List<Strand> getDupSeqOrientationsOnCtg() {
            return this.dupSeqStrandOnCtg;
        }

        List<String> getCigarStringsForDupSeqOnCtg() {
            return this.cigarStringsForDupSeqOnCtg;
        }

        SimpleInterval getInvertedTransInsertionRefSpan() {
            return this.invertedTransInsertionRefSpan;
        }

        boolean isDupAnnotIsFromOptimization() {
            return this.dupAnnotIsFromOptimization;
        }

        @VisibleForTesting
        InvertedDuplicationBreakpointComplications(String homologyForwardStrandRep, String insertedSequenceForwardStrandRep, SimpleInterval dupSeqRepeatUnitRefSpan, int dupSeqRepeatNumOnRef, int dupSeqRepeatNumOnCtg, List<Strand> dupSeqStrandOnRef, List<Strand> dupSeqStrandOnCtg, List<String> cigarStringsForDupSeqOnCtg, boolean dupAnnotIsFromOptimization, SimpleInterval invertedTransInsertionRefSpan) {
            super(homologyForwardStrandRep, insertedSequenceForwardStrandRep);
            this.dupSeqRepeatUnitRefSpan = dupSeqRepeatUnitRefSpan;
            this.dupSeqRepeatNumOnRef = dupSeqRepeatNumOnRef;
            this.dupSeqRepeatNumOnCtg = dupSeqRepeatNumOnCtg;
            this.dupSeqStrandOnRef = dupSeqStrandOnRef;
            this.dupSeqStrandOnCtg = dupSeqStrandOnCtg;
            this.cigarStringsForDupSeqOnCtg = cigarStringsForDupSeqOnCtg;
            this.dupAnnotIsFromOptimization = dupAnnotIsFromOptimization;
            this.invertedTransInsertionRefSpan = invertedTransInsertionRefSpan;
        }

        InvertedDuplicationBreakpointComplications(SimpleChimera simpleChimera, byte[] contigSeq, boolean firstAfterSecond) {
            this.resolveComplicationForInvDup(simpleChimera, contigSeq, firstAfterSecond);
        }

        InvertedDuplicationBreakpointComplications(Kryo kryo, Input input) {
            super(kryo, input);
            int i;
            String ctg = input.readString();
            int start = input.readInt();
            int end = input.readInt();
            this.dupSeqRepeatUnitRefSpan = new SimpleInterval(ctg, start, end);
            this.dupSeqRepeatNumOnRef = input.readInt();
            this.dupSeqRepeatNumOnCtg = input.readInt();
            this.dupSeqStrandOnRef = new ArrayList<Strand>(this.dupSeqRepeatNumOnRef);
            for (i = 0; i < this.dupSeqRepeatNumOnRef; ++i) {
                this.dupSeqStrandOnRef.add(Strand.values()[input.readInt()]);
            }
            this.dupSeqStrandOnCtg = new ArrayList<Strand>(this.dupSeqRepeatNumOnCtg);
            for (i = 0; i < this.dupSeqRepeatNumOnCtg; ++i) {
                this.dupSeqStrandOnCtg.add(Strand.values()[input.readInt()]);
            }
            int cigarCounts = input.readInt();
            this.cigarStringsForDupSeqOnCtg = new ArrayList<String>(cigarCounts);
            for (int i2 = 0; i2 < cigarCounts; ++i2) {
                this.cigarStringsForDupSeqOnCtg.add(input.readString());
            }
            this.dupAnnotIsFromOptimization = input.readBoolean();
            if (input.readBoolean()) {
                ctg = input.readString();
                start = input.readInt();
                end = input.readInt();
                this.invertedTransInsertionRefSpan = new SimpleInterval(ctg, start, end);
            }
        }

        private void resolveComplicationForInvDup(SimpleChimera simpleChimera, byte[] contigSeq, boolean firstAfterSecond) {
            int jumpLandingRefLoc;
            AlignmentInterval firstAlignmentInterval = simpleChimera.regionWithLowerCoordOnContig;
            AlignmentInterval secondAlignmentInterval = simpleChimera.regionWithHigherCoordOnContig;
            this.insertedSequenceForwardStrandRep = InvertedDuplicationBreakpointComplications.inferInsertedSequence(firstAlignmentInterval, secondAlignmentInterval, contigSeq, firstAfterSecond);
            this.dupSeqRepeatNumOnRef = 1;
            this.dupSeqRepeatNumOnCtg = 2;
            this.dupSeqStrandOnRef = DEFAULT_INV_DUP_REF_ORIENTATION;
            int jumpStartRefLoc = firstAlignmentInterval.forwardStrand ? firstAlignmentInterval.referenceSpan.getEnd() : firstAlignmentInterval.referenceSpan.getStart();
            int n = jumpLandingRefLoc = secondAlignmentInterval.forwardStrand ? secondAlignmentInterval.referenceSpan.getStart() : secondAlignmentInterval.referenceSpan.getEnd();
            if (firstAlignmentInterval.forwardStrand) {
                int alpha = firstAlignmentInterval.referenceSpan.getStart();
                int omega = secondAlignmentInterval.referenceSpan.getStart();
                this.dupSeqRepeatUnitRefSpan = new SimpleInterval(firstAlignmentInterval.referenceSpan.getContig(), Math.max(alpha, omega), Math.min(jumpStartRefLoc, jumpLandingRefLoc));
                if (alpha <= omega && jumpStartRefLoc < jumpLandingRefLoc || alpha > omega && jumpLandingRefLoc < jumpStartRefLoc) {
                    this.invertedTransInsertionRefSpan = new SimpleInterval(firstAlignmentInterval.referenceSpan.getContig(), Math.min(jumpStartRefLoc, jumpLandingRefLoc) + 1, Math.max(jumpStartRefLoc, jumpLandingRefLoc));
                }
                this.dupSeqStrandOnCtg = DEFAULT_INV_DUP_CTG_ORIENTATIONS_FR;
            } else {
                int alpha = firstAlignmentInterval.referenceSpan.getEnd();
                int omega = secondAlignmentInterval.referenceSpan.getEnd();
                this.dupSeqRepeatUnitRefSpan = new SimpleInterval(firstAlignmentInterval.referenceSpan.getContig(), Math.max(jumpStartRefLoc, jumpLandingRefLoc), Math.min(alpha, omega));
                if (alpha >= omega && jumpLandingRefLoc < jumpStartRefLoc || alpha < omega && jumpStartRefLoc < jumpLandingRefLoc) {
                    this.invertedTransInsertionRefSpan = new SimpleInterval(firstAlignmentInterval.referenceSpan.getContig(), Math.min(jumpStartRefLoc, jumpLandingRefLoc) + 1, Math.max(jumpStartRefLoc, jumpLandingRefLoc));
                }
                this.dupSeqStrandOnCtg = DEFAULT_INV_DUP_CTG_ORIENTATIONS_RF;
            }
            this.cigarStringsForDupSeqOnCtg = SmallDuplicationWithPreciseDupRangeBreakpointComplications.DEFAULT_CIGAR_STRINGS_FOR_DUP_SEQ_ON_CTG;
            this.dupAnnotIsFromOptimization = false;
        }

        @Override
        protected void serialize(Kryo kryo, Output output) {
            super.serialize(kryo, output);
            output.writeString(this.dupSeqRepeatUnitRefSpan.getContig());
            output.writeInt(this.dupSeqRepeatUnitRefSpan.getStart());
            output.writeInt(this.dupSeqRepeatUnitRefSpan.getEnd());
            output.writeInt(this.dupSeqRepeatNumOnRef);
            output.writeInt(this.dupSeqRepeatNumOnCtg);
            this.dupSeqStrandOnRef.forEach(s -> output.writeInt(s.ordinal()));
            this.dupSeqStrandOnCtg.forEach(s -> output.writeInt(s.ordinal()));
            output.writeInt(this.cigarStringsForDupSeqOnCtg.size());
            this.cigarStringsForDupSeqOnCtg.forEach(arg_0 -> ((Output)output).writeString(arg_0));
            output.writeBoolean(this.dupAnnotIsFromOptimization);
            output.writeBoolean(this.invertedTransInsertionRefSpan != null);
            if (this.invertedTransInsertionRefSpan != null) {
                output.writeString(this.invertedTransInsertionRefSpan.getContig());
                output.writeInt(this.invertedTransInsertionRefSpan.getStart());
                output.writeInt(this.invertedTransInsertionRefSpan.getEnd());
            }
        }

        @Override
        public final String toString() {
            String toPrint = super.toString();
            toPrint = toPrint + String.format("\ttandem duplication repeat unit ref span: %s\tref repeat num: %d\tctg repeat num: %d\tdupSeqStrandOnRef: %s\tdupSeqStrandOnCtg: %s\tcigarStringsForDupSeqOnCtg: %s\ttandupAnnotationIsFromSimpleOptimization: %s\tinvertedTransInsertionRefSpan: %s", this.dupSeqRepeatUnitRefSpan == null ? "" : this.dupSeqRepeatUnitRefSpan, this.dupSeqRepeatNumOnRef, this.dupSeqRepeatNumOnCtg, this.dupSeqStrandOnRef == null ? "" : this.dupSeqStrandOnRef.stream().map(Strand::toString).collect(SVUtils.arrayListCollector(this.dupSeqStrandOnRef.size())).toString(), this.dupSeqStrandOnCtg == null ? "" : this.dupSeqStrandOnCtg.stream().map(Strand::toString).collect(SVUtils.arrayListCollector(this.dupSeqStrandOnCtg.size())).toString(), this.cigarStringsForDupSeqOnCtg == null ? "" : this.cigarStringsForDupSeqOnCtg, this.isDupAnnotIsFromOptimization() ? "true" : "false", this.invertedTransInsertionRefSpan == null ? "" : this.invertedTransInsertionRefSpan);
            return toPrint;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            InvertedDuplicationBreakpointComplications that = (InvertedDuplicationBreakpointComplications)o;
            if (this.dupSeqRepeatNumOnRef != that.dupSeqRepeatNumOnRef) {
                return false;
            }
            if (this.dupSeqRepeatNumOnCtg != that.dupSeqRepeatNumOnCtg) {
                return false;
            }
            if (this.dupAnnotIsFromOptimization != that.dupAnnotIsFromOptimization) {
                return false;
            }
            if (this.dupSeqRepeatUnitRefSpan != null ? !this.dupSeqRepeatUnitRefSpan.equals(that.dupSeqRepeatUnitRefSpan) : that.dupSeqRepeatUnitRefSpan != null) {
                return false;
            }
            if (this.dupSeqStrandOnRef != null ? !this.dupSeqStrandOnRef.equals(that.dupSeqStrandOnRef) : that.dupSeqStrandOnRef != null) {
                return false;
            }
            if (this.dupSeqStrandOnCtg != null ? !this.dupSeqStrandOnCtg.equals(that.dupSeqStrandOnCtg) : that.dupSeqStrandOnCtg != null) {
                return false;
            }
            if (this.cigarStringsForDupSeqOnCtg != null ? !this.cigarStringsForDupSeqOnCtg.equals(that.cigarStringsForDupSeqOnCtg) : that.cigarStringsForDupSeqOnCtg != null) {
                return false;
            }
            return this.invertedTransInsertionRefSpan != null ? this.invertedTransInsertionRefSpan.equals(that.invertedTransInsertionRefSpan) : that.invertedTransInsertionRefSpan == null;
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + (this.dupSeqRepeatUnitRefSpan != null ? this.dupSeqRepeatUnitRefSpan.hashCode() : 0);
            result = 31 * result + this.dupSeqRepeatNumOnRef;
            result = 31 * result + this.dupSeqRepeatNumOnCtg;
            if (this.dupSeqStrandOnRef != null) {
                for (Strand strand : this.dupSeqStrandOnRef) {
                    result = 31 * result + strand.ordinal();
                }
            }
            if (this.dupSeqStrandOnCtg != null) {
                for (Strand strand : this.dupSeqStrandOnCtg) {
                    result = 31 * result + strand.ordinal();
                }
            }
            result = 31 * result + (this.cigarStringsForDupSeqOnCtg != null ? this.cigarStringsForDupSeqOnCtg.hashCode() : 0);
            result = 31 * result + (this.dupAnnotIsFromOptimization ? 1 : 0);
            result = 31 * result + (this.invertedTransInsertionRefSpan != null ? this.invertedTransInsertionRefSpan.hashCode() : 0);
            return result;
        }

        public static final class Serializer
        extends com.esotericsoftware.kryo.Serializer<InvertedDuplicationBreakpointComplications> {
            public void write(Kryo kryo, Output output, InvertedDuplicationBreakpointComplications breakpointComplications) {
                breakpointComplications.serialize(kryo, output);
            }

            public InvertedDuplicationBreakpointComplications read(Kryo kryo, Input input, Class<InvertedDuplicationBreakpointComplications> klass) {
                return new InvertedDuplicationBreakpointComplications(kryo, input);
            }
        }
    }

    @DefaultSerializer(value=Serializer.class)
    public static final class IntraChrStrandSwitchBreakpointComplications
    extends BNDTypeBreakpointComplications {
        @VisibleForTesting
        IntraChrStrandSwitchBreakpointComplications(String homologyForwardStrandRep, String insertedSequenceForwardStrandRep) {
            super(homologyForwardStrandRep, insertedSequenceForwardStrandRep);
        }

        IntraChrStrandSwitchBreakpointComplications(Kryo kryo, Input input) {
            super(kryo, input);
        }

        IntraChrStrandSwitchBreakpointComplications(SimpleChimera simpleChimera, byte[] contigSeq, boolean firstAfterSecond) {
            this.resolveComplicationForSimpleStrandSwitch(simpleChimera, contigSeq, firstAfterSecond);
        }

        void resolveComplicationForSimpleStrandSwitch(SimpleChimera simpleChimera, byte[] contigSeq, boolean firstAfterSecond) {
            AlignmentInterval firstAlignmentInterval = simpleChimera.regionWithLowerCoordOnContig;
            AlignmentInterval secondAlignmentInterval = simpleChimera.regionWithHigherCoordOnContig;
            this.homologyForwardStrandRep = IntraChrStrandSwitchBreakpointComplications.inferHomology(firstAlignmentInterval, secondAlignmentInterval, contigSeq, firstAfterSecond);
            this.insertedSequenceForwardStrandRep = IntraChrStrandSwitchBreakpointComplications.inferInsertedSequence(firstAlignmentInterval, secondAlignmentInterval, contigSeq, firstAfterSecond);
        }

        public static final class Serializer
        extends com.esotericsoftware.kryo.Serializer<IntraChrStrandSwitchBreakpointComplications> {
            public void write(Kryo kryo, Output output, IntraChrStrandSwitchBreakpointComplications breakpointComplications) {
                breakpointComplications.serialize(kryo, output);
            }

            public IntraChrStrandSwitchBreakpointComplications read(Kryo kryo, Input input, Class<IntraChrStrandSwitchBreakpointComplications> klass) {
                return new IntraChrStrandSwitchBreakpointComplications(kryo, input);
            }
        }
    }

    static abstract class BNDTypeBreakpointComplications
    extends BreakpointComplications {
        protected BNDTypeBreakpointComplications() {
        }

        @VisibleForTesting
        BNDTypeBreakpointComplications(String homologyForwardStrandRep, String insertedSequenceForwardStrandRep) {
            super(homologyForwardStrandRep, insertedSequenceForwardStrandRep);
        }

        protected BNDTypeBreakpointComplications(SimpleChimera simpleChimera, byte[] contigSeq, boolean firstAfterSecond) {
            this.homologyForwardStrandRep = BNDTypeBreakpointComplications.inferHomology(simpleChimera.regionWithLowerCoordOnContig, simpleChimera.regionWithHigherCoordOnContig, contigSeq, firstAfterSecond);
            this.insertedSequenceForwardStrandRep = BNDTypeBreakpointComplications.inferInsertedSequence(simpleChimera.regionWithLowerCoordOnContig, simpleChimera.regionWithHigherCoordOnContig, contigSeq, firstAfterSecond);
        }

        protected BNDTypeBreakpointComplications(Kryo kryo, Input input) {
            super(kryo, input);
        }

        @Override
        protected void serialize(Kryo kryo, Output output) {
            super.serialize(kryo, output);
        }
    }

    @DefaultSerializer(value=Serializer.class)
    public static final class SmallDuplicationWithImpreciseDupRangeBreakpointComplications
    extends SmallDuplicationBreakpointComplications {
        private SimpleInterval impreciseDupAffectedRefRange = null;

        SimpleInterval getImpreciseDupAffectedRefRange() {
            return this.impreciseDupAffectedRefRange;
        }

        @VisibleForTesting
        SmallDuplicationWithImpreciseDupRangeBreakpointComplications(String homologyForwardStrandRep, String insertedSequenceForwardStrandRep, SimpleInterval dupSeqRepeatUnitRefSpan, int dupSeqRepeatNumOnRef, int dupSeqRepeatNumOnCtg, List<Strand> dupSeqStrandOnRef, List<Strand> dupSeqStrandOnCtg, SimpleInterval impreciseDupAffectedRefRange) {
            super(homologyForwardStrandRep, insertedSequenceForwardStrandRep, dupSeqRepeatUnitRefSpan, dupSeqRepeatNumOnRef, dupSeqRepeatNumOnCtg, dupSeqStrandOnRef, dupSeqStrandOnCtg);
            this.impreciseDupAffectedRefRange = impreciseDupAffectedRefRange;
        }

        private SmallDuplicationWithImpreciseDupRangeBreakpointComplications(Kryo kryo, Input input) {
            super(kryo, input);
            String chr = input.readString();
            int start = input.readInt();
            int end = input.readInt();
            this.impreciseDupAffectedRefRange = new SimpleInterval(chr, start, end);
        }

        @Override
        public final String toString() {
            return super.toString() + "\timprecise:";
        }

        @Override
        public final Map<String, Object> toVariantAttributes() {
            Map<String, Object> parentAttributesToBeFilled = super.toVariantAttributes();
            parentAttributesToBeFilled.put("DUP_ANNOTATIONS_IMPRECISE", "");
            parentAttributesToBeFilled.put("DUP_IMPRECISE_AFFECTED_RANGE", this.impreciseDupAffectedRefRange.toString());
            return parentAttributesToBeFilled;
        }

        SmallDuplicationWithImpreciseDupRangeBreakpointComplications(SimpleChimera simpleChimera, byte[] contigSeq, boolean firstAfterSecond) {
            boolean b;
            SimpleChimera.DistancesBetweenAlignmentsOnRefAndOnRead distances = simpleChimera.getDistancesBetweenAlignmentsOnRefAndOnRead();
            if (distances.gapBetweenAlignRegionsOnRef > 0) {
                throw new GATKException.ShouldNeverReachHereException("Simple chimera being sent down the wrong path, where the signature indicates a simple deletion but complication being resolve for small duplication. \n" + simpleChimera.toString());
            }
            boolean bl = b = distances.gapBetweenAlignRegionsOnRef < 0 && distances.gapBetweenAlignRegionsOnCtg < 0;
            if (!b) {
                throw new GATKException.ShouldNeverReachHereException("Simple chimera being sent down the wrong path, where the signature indicates simple duplication but complication being resolved for complex small duplication. \n" + simpleChimera.toString());
            }
            TandemRepeatStructure duplicationComplication = new TandemRepeatStructure(distances.gapBetweenAlignRegionsOnRef, distances.gapBetweenAlignRegionsOnCtg);
            boolean isExpansion = distances.gapBetweenAlignRegionsOnRef < distances.gapBetweenAlignRegionsOnCtg;
            int repeatUnitSpanStart = distances.leftAlnRefEnd - duplicationComplication.pseudoHomologyLen - duplicationComplication.repeatedSeqLen * duplicationComplication.lowerRepeatNumberEstimate + 1;
            int repeatUnitSpanEnd = repeatUnitSpanStart + duplicationComplication.repeatedSeqLen - 1;
            this.homologyForwardStrandRep = SmallDuplicationWithImpreciseDupRangeBreakpointComplications.inferHomology(simpleChimera.regionWithLowerCoordOnContig, simpleChimera.regionWithHigherCoordOnContig, contigSeq, firstAfterSecond);
            this.dupSeqRepeatUnitRefSpan = new SimpleInterval(simpleChimera.regionWithLowerCoordOnContig.referenceSpan.getContig(), repeatUnitSpanStart, repeatUnitSpanEnd);
            this.dupSeqRepeatNumOnRef = isExpansion ? duplicationComplication.lowerRepeatNumberEstimate : duplicationComplication.higherRepeatNumberEstimate;
            this.dupSeqRepeatNumOnCtg = isExpansion ? duplicationComplication.higherRepeatNumberEstimate : duplicationComplication.lowerRepeatNumberEstimate;
            this.dupSeqStrandOnRef = new ArrayList<Strand>(Collections.nCopies(this.dupSeqRepeatNumOnRef, Strand.POSITIVE));
            this.dupSeqStrandOnCtg = new ArrayList<Strand>(Collections.nCopies(this.dupSeqRepeatNumOnCtg, Strand.POSITIVE));
            this.impreciseDupAffectedRefRange = SmallDuplicationWithImpreciseDupRangeBreakpointComplications.computeAffectedRefRegion(simpleChimera, isExpansion, distances, duplicationComplication);
            if (this.insertedSequenceForwardStrandRep.isEmpty() && this.dupSeqRepeatNumOnCtg != this.dupSeqRepeatNumOnRef && null == this.dupSeqRepeatUnitRefSpan) {
                throw new GATKException.ShouldNeverReachHereException("An identified breakpoint pair seem to suggest insertion but the inserted sequence is empty: " + simpleChimera.toString());
            }
        }

        private static SimpleInterval computeAffectedRefRegion(SimpleChimera simpleChimera, boolean isExpansion, SimpleChimera.DistancesBetweenAlignmentsOnRefAndOnRead distances, TandemRepeatStructure duplicationComplication) {
            SimpleInterval rightRefSpan;
            SimpleInterval leftRefSpan;
            if (simpleChimera.isForwardStrandRepresentation) {
                leftRefSpan = simpleChimera.regionWithLowerCoordOnContig.referenceSpan;
                rightRefSpan = simpleChimera.regionWithHigherCoordOnContig.referenceSpan;
            } else {
                leftRefSpan = simpleChimera.regionWithHigherCoordOnContig.referenceSpan;
                rightRefSpan = simpleChimera.regionWithLowerCoordOnContig.referenceSpan;
            }
            if (isExpansion) {
                return new SimpleInterval(leftRefSpan.getContig(), distances.rightAlnRefStart, distances.leftAlnRefEnd);
            }
            return new SimpleInterval(leftRefSpan.getContig(), rightRefSpan.getStart() - duplicationComplication.repeatedSeqLen, leftRefSpan.getEnd() + duplicationComplication.repeatedSeqLen);
        }

        @Override
        protected void serialize(Kryo kryo, Output output) {
            super.serialize(kryo, output);
            output.writeString(this.impreciseDupAffectedRefRange.getContig());
            output.writeInt(this.impreciseDupAffectedRefRange.getStart());
            output.writeInt(this.impreciseDupAffectedRefRange.getEnd());
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            SmallDuplicationWithImpreciseDupRangeBreakpointComplications that = (SmallDuplicationWithImpreciseDupRangeBreakpointComplications)o;
            return this.impreciseDupAffectedRefRange.equals(that.impreciseDupAffectedRefRange);
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + this.impreciseDupAffectedRefRange.hashCode();
            return result;
        }

        public static final class Serializer
        extends com.esotericsoftware.kryo.Serializer<SmallDuplicationWithImpreciseDupRangeBreakpointComplications> {
            public void write(Kryo kryo, Output output, SmallDuplicationWithImpreciseDupRangeBreakpointComplications breakpointComplications) {
                breakpointComplications.serialize(kryo, output);
            }

            public SmallDuplicationWithImpreciseDupRangeBreakpointComplications read(Kryo kryo, Input input, Class<SmallDuplicationWithImpreciseDupRangeBreakpointComplications> klass) {
                return new SmallDuplicationWithImpreciseDupRangeBreakpointComplications(kryo, input);
            }
        }

        private static final class TandemRepeatStructure {
            private static final int MAX_LOWER_CN = 10;
            final int lowerRepeatNumberEstimate;
            final int higherRepeatNumberEstimate;
            final int repeatedSeqLen;
            final int pseudoHomologyLen;

            @VisibleForTesting
            TandemRepeatStructure(int distBetweenAlignRegionsOnRef, int distBetweenAlignRegionsOnCtg) {
                int overlapOnHigherCNSequence;
                int overlapOnLowerCNSequence;
                boolean isExpansion;
                boolean bl = isExpansion = distBetweenAlignRegionsOnRef < distBetweenAlignRegionsOnCtg;
                if (isExpansion) {
                    overlapOnLowerCNSequence = Math.abs(distBetweenAlignRegionsOnRef);
                    overlapOnHigherCNSequence = Math.abs(distBetweenAlignRegionsOnCtg);
                } else {
                    overlapOnLowerCNSequence = Math.abs(distBetweenAlignRegionsOnCtg);
                    overlapOnHigherCNSequence = Math.abs(distBetweenAlignRegionsOnRef);
                }
                int higherCnEst = 0;
                int lowerCnEst = 0;
                int unitLen = 0;
                int pseudoHomLen = 0;
                double err = Double.MAX_VALUE;
                for (int cn2 = 1; cn2 < 10; ++cn2) {
                    for (int cn1 = cn2 + 1; cn1 <= 2 * cn2; ++cn1) {
                        int dupLenUpperBound = cn1 == 2 * cn2 ? overlapOnLowerCNSequence : overlapOnHigherCNSequence;
                        for (int l = 2; l <= dupLenUpperBound; ++l) {
                            for (int lambda = 0; lambda < l; ++lambda) {
                                int d1 = (2 * cn2 - cn1) * l + lambda;
                                int d2 = cn2 * l + lambda;
                                double newErr = Math.abs(overlapOnHigherCNSequence - d1) + Math.abs(overlapOnLowerCNSequence - d2);
                                if (newErr < err) {
                                    err = newErr;
                                    higherCnEst = cn1;
                                    lowerCnEst = cn2;
                                    unitLen = l;
                                    pseudoHomLen = lambda;
                                }
                                if (!(err < 1.0)) continue;
                                this.lowerRepeatNumberEstimate = lowerCnEst;
                                this.higherRepeatNumberEstimate = higherCnEst;
                                this.repeatedSeqLen = unitLen;
                                this.pseudoHomologyLen = pseudoHomLen;
                                return;
                            }
                        }
                    }
                }
                this.lowerRepeatNumberEstimate = lowerCnEst;
                this.higherRepeatNumberEstimate = higherCnEst;
                this.repeatedSeqLen = unitLen;
                this.pseudoHomologyLen = pseudoHomLen;
            }
        }
    }

    @DefaultSerializer(value=Serializer.class)
    public static final class SmallDuplicationWithPreciseDupRangeBreakpointComplications
    extends SmallDuplicationBreakpointComplications {
        public static final List<String> DEFAULT_CIGAR_STRINGS_FOR_DUP_SEQ_ON_CTG = Collections.emptyList();
        private List<String> cigarStringsForDupSeqOnCtg = null;

        final List<String> getCigarStringsForDupSeqOnCtgForwardStrandRep() {
            return this.cigarStringsForDupSeqOnCtg;
        }

        @VisibleForTesting
        SmallDuplicationWithPreciseDupRangeBreakpointComplications(String homologyForwardStrandRep, String insertedSequenceForwardStrandRep, SimpleInterval dupSeqRepeatUnitRefSpan, int dupSeqRepeatNumOnRef, int dupSeqRepeatNumOnCtg, List<Strand> dupSeqStrandOnRef, List<Strand> dupSeqStrandOnCtg, List<String> cigarStringsForDupSeqOnCtg) {
            super(homologyForwardStrandRep, insertedSequenceForwardStrandRep, dupSeqRepeatUnitRefSpan, dupSeqRepeatNumOnRef, dupSeqRepeatNumOnCtg, dupSeqStrandOnRef, dupSeqStrandOnCtg);
            this.cigarStringsForDupSeqOnCtg = cigarStringsForDupSeqOnCtg;
        }

        private SmallDuplicationWithPreciseDupRangeBreakpointComplications(Kryo kryo, Input input) {
            super(kryo, input);
            int cigarCounts = input.readInt();
            this.cigarStringsForDupSeqOnCtg = new ArrayList<String>(cigarCounts);
            for (int i = 0; i < cigarCounts; ++i) {
                this.cigarStringsForDupSeqOnCtg.add(input.readString());
            }
        }

        @Override
        public final String toString() {
            return super.toString() + "\tprecise cigarStringsForDupSeqOnCtg:\t" + (this.cigarStringsForDupSeqOnCtg.isEmpty() ? "" : this.cigarStringsForDupSeqOnCtg);
        }

        @Override
        public Map<String, Object> toVariantAttributes() {
            Map<String, Object> parentAttributesToBeFilled = super.toVariantAttributes();
            if (!this.getCigarStringsForDupSeqOnCtgForwardStrandRep().isEmpty()) {
                parentAttributesToBeFilled.put("DUP_SEQ_CIGARS", StringUtils.join(this.getCigarStringsForDupSeqOnCtgForwardStrandRep(), (String)","));
            }
            return parentAttributesToBeFilled;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        SmallDuplicationWithPreciseDupRangeBreakpointComplications(SimpleChimera simpleChimera, byte[] contigSeq, boolean firstAfterSecond) {
            SimpleChimera.DistancesBetweenAlignmentsOnRefAndOnRead distances = simpleChimera.getDistancesBetweenAlignmentsOnRefAndOnRead();
            if (distances.gapBetweenAlignRegionsOnRef > 0) {
                throw new GATKException.ShouldNeverReachHereException("Simple chimera being sent down the wrong path, where the signature indicates a simple deletion but complication being resolve for small duplication. \n" + simpleChimera.toString());
            }
            if (distances.gapBetweenAlignRegionsOnRef < 0) {
                if (distances.gapBetweenAlignRegionsOnCtg < 0) throw new GATKException.ShouldNeverReachHereException("Simple chimera being sent down the wrong path, where the signature indicates complex duplication but complication being resolved for simple small duplication. \n" + simpleChimera.toString());
                this.resolveComplicationForSimpleTandupExpansion(simpleChimera, distances, contigSeq, firstAfterSecond);
            } else if (distances.gapBetweenAlignRegionsOnCtg < 0) {
                this.resolveComplicationForSimpleTandupContraction(simpleChimera, distances, contigSeq, firstAfterSecond);
            } else {
                if (distances.gapBetweenAlignRegionsOnCtg <= 0) throw new GATKException.ShouldNeverReachHereException("Detected badly parsed chimeric alignment for identifying SV breakpoints; no rearrangement found: " + simpleChimera.toString());
                throw new GATKException.ShouldNeverReachHereException("Simple chimera being sent down the wrong path, where the signature indicates an insertion but complication being resolve for small duplication. \n" + simpleChimera.toString());
            }
            if (!this.insertedSequenceForwardStrandRep.isEmpty() || this.dupSeqRepeatNumOnCtg == this.dupSeqRepeatNumOnRef || null != this.dupSeqRepeatUnitRefSpan) return;
            throw new GATKException.ShouldNeverReachHereException("An identified breakpoint pair seem to suggest insertion but the inserted sequence is empty: " + simpleChimera.toString());
        }

        private void resolveComplicationForSimpleTandupExpansion(SimpleChimera simpleChimera, SimpleChimera.DistancesBetweenAlignmentsOnRefAndOnRead distances, byte[] contigSeq, boolean firstAfterSecond) {
            AlignmentInterval firstContigRegion = simpleChimera.regionWithLowerCoordOnContig;
            AlignmentInterval secondContigRegion = simpleChimera.regionWithHigherCoordOnContig;
            SimpleInterval leftReferenceInterval = simpleChimera.isForwardStrandRepresentation ? simpleChimera.regionWithLowerCoordOnContig.referenceSpan : simpleChimera.regionWithHigherCoordOnContig.referenceSpan;
            this.insertedSequenceForwardStrandRep = distances.gapBetweenAlignRegionsOnCtg == 0 ? "" : SmallDuplicationWithPreciseDupRangeBreakpointComplications.inferInsertedSequence(firstContigRegion, secondContigRegion, contigSeq, firstAfterSecond);
            this.dupSeqRepeatUnitRefSpan = new SimpleInterval(leftReferenceInterval.getContig(), distances.rightAlnRefStart, distances.leftAlnRefEnd);
            this.dupSeqRepeatNumOnRef = 1;
            this.dupSeqRepeatNumOnCtg = 2;
            this.dupSeqStrandOnRef = Collections.singletonList(Strand.POSITIVE);
            this.dupSeqStrandOnCtg = Arrays.asList(Strand.POSITIVE, Strand.POSITIVE);
            this.cigarStringsForDupSeqOnCtg = new ArrayList<String>(2);
            if (firstContigRegion.forwardStrand) {
                this.cigarStringsForDupSeqOnCtg.add(TextCigarCodec.encode((Cigar)SmallDuplicationWithPreciseDupRangeBreakpointComplications.extractCigarForTandupExpansion(firstContigRegion, distances.leftAlnRefEnd, distances.rightAlnRefStart)));
                this.cigarStringsForDupSeqOnCtg.add(TextCigarCodec.encode((Cigar)SmallDuplicationWithPreciseDupRangeBreakpointComplications.extractCigarForTandupExpansion(secondContigRegion, distances.leftAlnRefEnd, distances.rightAlnRefStart)));
            } else {
                this.cigarStringsForDupSeqOnCtg.add(TextCigarCodec.encode((Cigar)CigarUtils.invertCigar(SmallDuplicationWithPreciseDupRangeBreakpointComplications.extractCigarForTandupExpansion(firstContigRegion, distances.leftAlnRefEnd, distances.rightAlnRefStart))));
                this.cigarStringsForDupSeqOnCtg.add(TextCigarCodec.encode((Cigar)CigarUtils.invertCigar(SmallDuplicationWithPreciseDupRangeBreakpointComplications.extractCigarForTandupExpansion(secondContigRegion, distances.leftAlnRefEnd, distances.rightAlnRefStart))));
                Collections.reverse(this.cigarStringsForDupSeqOnCtg);
            }
        }

        @VisibleForTesting
        static Cigar extractCigarForTandupExpansion(AlignmentInterval contigRegion, int alignmentIntervalOneReferenceIntervalSpanEnd, int alignmentIntervalTwoReferenceIntervalSpanBegin) {
            List elementList = contigRegion.cigarAlong5to3DirectionOfContig.getCigarElements();
            ArrayList<CigarElement> result = new ArrayList<CigarElement>(elementList.size());
            int refStart = contigRegion.referenceSpan.getStart();
            int refEnd = contigRegion.referenceSpan.getEnd();
            boolean isForwardStrand = contigRegion.forwardStrand;
            boolean initiatedCollection = false;
            int refPos = isForwardStrand ? refStart : refEnd;
            for (CigarElement cigarElement : elementList) {
                int overshootOutOfRepeatRegion;
                CigarOperator operator = cigarElement.getOperator();
                if (operator.isClipping()) continue;
                int opLen = cigarElement.getLength();
                int offsetIntoRepeatRegion = isForwardStrand ? refPos - alignmentIntervalTwoReferenceIntervalSpanBegin : alignmentIntervalOneReferenceIntervalSpanEnd - (refPos += operator.consumesReferenceBases() ? (isForwardStrand ? opLen : -opLen) : 0);
                int n = overshootOutOfRepeatRegion = isForwardStrand ? refPos - alignmentIntervalOneReferenceIntervalSpanEnd - 1 : alignmentIntervalTwoReferenceIntervalSpanBegin - refPos - 1;
                if (offsetIntoRepeatRegion <= 0) continue;
                if (overshootOutOfRepeatRegion <= 0) {
                    result.add(initiatedCollection ? cigarElement : new CigarElement(offsetIntoRepeatRegion, operator));
                    initiatedCollection = true;
                    continue;
                }
                result.add(new CigarElement(opLen - overshootOutOfRepeatRegion, operator));
                break;
            }
            return new Cigar(result);
        }

        private void resolveComplicationForSimpleTandupContraction(SimpleChimera simpleChimera, SimpleChimera.DistancesBetweenAlignmentsOnRefAndOnRead distances, byte[] contigSeq, boolean firstAfterSecond) {
            SimpleInterval leftReferenceInterval = simpleChimera.isForwardStrandRepresentation ? simpleChimera.regionWithLowerCoordOnContig.referenceSpan : simpleChimera.regionWithHigherCoordOnContig.referenceSpan;
            this.homologyForwardStrandRep = SmallDuplicationWithPreciseDupRangeBreakpointComplications.inferHomology(simpleChimera.regionWithLowerCoordOnContig, simpleChimera.regionWithHigherCoordOnContig, contigSeq, firstAfterSecond);
            this.dupSeqRepeatUnitRefSpan = new SimpleInterval(leftReferenceInterval.getContig(), distances.leftAlnRefEnd - (distances.firstAlnCtgEnd - distances.secondAlnCtgStart), distances.leftAlnRefEnd);
            this.dupSeqRepeatNumOnRef = 2;
            this.dupSeqRepeatNumOnCtg = 1;
            this.dupSeqStrandOnRef = Arrays.asList(Strand.POSITIVE, Strand.POSITIVE);
            this.dupSeqStrandOnCtg = Collections.singletonList(Strand.POSITIVE);
            this.cigarStringsForDupSeqOnCtg = DEFAULT_CIGAR_STRINGS_FOR_DUP_SEQ_ON_CTG;
        }

        @Override
        protected void serialize(Kryo kryo, Output output) {
            super.serialize(kryo, output);
            output.writeInt(this.cigarStringsForDupSeqOnCtg.size());
            this.cigarStringsForDupSeqOnCtg.forEach(arg_0 -> ((Output)output).writeString(arg_0));
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            SmallDuplicationWithPreciseDupRangeBreakpointComplications that = (SmallDuplicationWithPreciseDupRangeBreakpointComplications)o;
            return this.cigarStringsForDupSeqOnCtg.equals(that.cigarStringsForDupSeqOnCtg);
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + this.cigarStringsForDupSeqOnCtg.hashCode();
            return result;
        }

        public static final class Serializer
        extends com.esotericsoftware.kryo.Serializer<SmallDuplicationWithPreciseDupRangeBreakpointComplications> {
            public void write(Kryo kryo, Output output, SmallDuplicationWithPreciseDupRangeBreakpointComplications breakpointComplications) {
                breakpointComplications.serialize(kryo, output);
            }

            public SmallDuplicationWithPreciseDupRangeBreakpointComplications read(Kryo kryo, Input input, Class<SmallDuplicationWithPreciseDupRangeBreakpointComplications> klass) {
                return new SmallDuplicationWithPreciseDupRangeBreakpointComplications(kryo, input);
            }
        }
    }

    public static abstract class SmallDuplicationBreakpointComplications
    extends BreakpointComplications {
        protected SimpleInterval dupSeqRepeatUnitRefSpan = null;
        protected int dupSeqRepeatNumOnRef = 0;
        protected int dupSeqRepeatNumOnCtg = 0;
        protected List<Strand> dupSeqStrandOnRef = null;
        protected List<Strand> dupSeqStrandOnCtg = null;

        @VisibleForTesting
        SmallDuplicationBreakpointComplications(String homologyForwardStrandRep, String insertedSequenceForwardStrandRep, SimpleInterval dupSeqRepeatUnitRefSpan, int dupSeqRepeatNumOnRef, int dupSeqRepeatNumOnCtg, List<Strand> dupSeqStrandOnRef, List<Strand> dupSeqStrandOnCtg) {
            super(homologyForwardStrandRep, insertedSequenceForwardStrandRep);
            this.dupSeqRepeatUnitRefSpan = dupSeqRepeatUnitRefSpan;
            this.dupSeqRepeatNumOnRef = dupSeqRepeatNumOnRef;
            this.dupSeqRepeatNumOnCtg = dupSeqRepeatNumOnCtg;
            this.dupSeqStrandOnRef = dupSeqStrandOnRef;
            this.dupSeqStrandOnCtg = dupSeqStrandOnCtg;
        }

        SmallDuplicationBreakpointComplications() {
        }

        SmallDuplicationBreakpointComplications(Kryo kryo, Input input) {
            super(kryo, input);
            int i;
            String ctg = input.readString();
            int start = input.readInt();
            int end = input.readInt();
            this.dupSeqRepeatUnitRefSpan = new SimpleInterval(ctg, start, end);
            this.dupSeqRepeatNumOnRef = input.readInt();
            this.dupSeqRepeatNumOnCtg = input.readInt();
            this.dupSeqStrandOnRef = new ArrayList<Strand>(this.dupSeqRepeatNumOnRef);
            for (i = 0; i < this.dupSeqRepeatNumOnRef; ++i) {
                this.dupSeqStrandOnRef.add(Strand.values()[input.readInt()]);
            }
            this.dupSeqStrandOnCtg = new ArrayList<Strand>(this.dupSeqRepeatNumOnCtg);
            for (i = 0; i < this.dupSeqRepeatNumOnCtg; ++i) {
                this.dupSeqStrandOnCtg.add(Strand.values()[input.readInt()]);
            }
        }

        public final SimpleInterval getDupSeqRepeatUnitRefSpan() {
            return this.dupSeqRepeatUnitRefSpan;
        }

        public final int getDupSeqRepeatNumOnRef() {
            return this.dupSeqRepeatNumOnRef;
        }

        public final int getDupSeqRepeatNumOnCtg() {
            return this.dupSeqRepeatNumOnCtg;
        }

        public final List<Strand> getDupSeqOrientationsOnCtg() {
            return this.dupSeqStrandOnCtg;
        }

        @Override
        public Map<String, Object> toVariantAttributes() {
            Map<String, Object> parentAttributesToBeFilled = super.toVariantAttributes();
            parentAttributesToBeFilled.put("DUP_REPEAT_UNIT_REF_SPAN", this.getDupSeqRepeatUnitRefSpan().toString());
            parentAttributesToBeFilled.put("DUP_NUM", this.getDupSeqRepeatNumOnRef() + "," + this.getDupSeqRepeatNumOnCtg());
            parentAttributesToBeFilled.put("DUP_ORIENTATIONS", this.getDupSeqOrientationsOnCtg().stream().map(Strand::toString).collect(Collectors.joining()));
            parentAttributesToBeFilled.put(this.dupSeqRepeatNumOnRef < this.dupSeqRepeatNumOnCtg ? "EXPANSION" : "CONTRACTION", "");
            return parentAttributesToBeFilled;
        }

        @Override
        public String toString() {
            String toPrint = super.toString();
            toPrint = toPrint + String.format("\ttandem duplication repeat unit ref span: %s\tref repeat num: %d\tctg repeat num: %d\tdupSeqStrandOnRef: %s\tdupSeqStrandOnCtg: %s\t", this.dupSeqRepeatUnitRefSpan, this.dupSeqRepeatNumOnRef, this.dupSeqRepeatNumOnCtg, this.dupSeqStrandOnRef.stream().map(Strand::toString).collect(SVUtils.arrayListCollector(this.dupSeqStrandOnRef.size())).toString(), this.dupSeqStrandOnCtg.stream().map(Strand::toString).collect(SVUtils.arrayListCollector(this.dupSeqStrandOnCtg.size())).toString());
            return toPrint;
        }

        @Override
        public final boolean hasDuplicationAnnotation() {
            return true;
        }

        public final boolean isDupContraction() {
            return this.dupSeqRepeatNumOnRef > this.dupSeqRepeatNumOnCtg;
        }

        @Override
        protected void serialize(Kryo kryo, Output output) {
            super.serialize(kryo, output);
            output.writeString(this.dupSeqRepeatUnitRefSpan.getContig());
            output.writeInt(this.dupSeqRepeatUnitRefSpan.getStart());
            output.writeInt(this.dupSeqRepeatUnitRefSpan.getEnd());
            output.writeInt(this.dupSeqRepeatNumOnRef);
            output.writeInt(this.dupSeqRepeatNumOnCtg);
            this.dupSeqStrandOnRef.forEach(s -> output.writeInt(s.ordinal()));
            this.dupSeqStrandOnCtg.forEach(s -> output.writeInt(s.ordinal()));
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            SmallDuplicationBreakpointComplications that = (SmallDuplicationBreakpointComplications)o;
            if (this.dupSeqRepeatNumOnRef != that.dupSeqRepeatNumOnRef) {
                return false;
            }
            if (this.dupSeqRepeatNumOnCtg != that.dupSeqRepeatNumOnCtg) {
                return false;
            }
            if (!this.dupSeqRepeatUnitRefSpan.equals(that.dupSeqRepeatUnitRefSpan)) {
                return false;
            }
            if (!this.dupSeqStrandOnRef.equals(that.dupSeqStrandOnRef)) {
                return false;
            }
            return this.dupSeqStrandOnCtg.equals(that.dupSeqStrandOnCtg);
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + this.dupSeqRepeatUnitRefSpan.hashCode();
            result = 31 * result + this.dupSeqRepeatNumOnRef;
            result = 31 * result + this.dupSeqRepeatNumOnCtg;
            for (Strand strand : this.dupSeqStrandOnRef) {
                result = 31 * result + strand.ordinal();
            }
            for (Strand strand : this.dupSeqStrandOnCtg) {
                result = 31 * result + strand.ordinal();
            }
            return result;
        }
    }

    @DefaultSerializer(value=Serializer.class)
    public static final class SimpleInsDelOrReplacementBreakpointComplications
    extends BreakpointComplications {
        @VisibleForTesting
        public SimpleInsDelOrReplacementBreakpointComplications(String homologyForwardStrandRep, String insertedSequenceForwardStrandRep) {
            super(homologyForwardStrandRep, insertedSequenceForwardStrandRep);
        }

        SimpleInsDelOrReplacementBreakpointComplications(SimpleChimera simpleChimera, byte[] contigSeq, boolean firstAfterSecond) {
            SimpleChimera.DistancesBetweenAlignmentsOnRefAndOnRead distances = simpleChimera.getDistancesBetweenAlignmentsOnRefAndOnRead();
            int distBetweenAlignRegionsOnRef = distances.gapBetweenAlignRegionsOnRef;
            int distBetweenAlignRegionsOnCtg = distances.gapBetweenAlignRegionsOnCtg;
            if (distBetweenAlignRegionsOnRef > 0) {
                if (distBetweenAlignRegionsOnCtg >= 0) {
                    this.insertedSequenceForwardStrandRep = SimpleInsDelOrReplacementBreakpointComplications.inferInsertedSequence(simpleChimera.regionWithLowerCoordOnContig, simpleChimera.regionWithHigherCoordOnContig, contigSeq, firstAfterSecond);
                } else {
                    this.homologyForwardStrandRep = SimpleInsDelOrReplacementBreakpointComplications.inferHomology(simpleChimera.regionWithLowerCoordOnContig, simpleChimera.regionWithHigherCoordOnContig, contigSeq, firstAfterSecond);
                }
            } else if (distBetweenAlignRegionsOnRef == 0 && distBetweenAlignRegionsOnCtg > 0) {
                this.insertedSequenceForwardStrandRep = SimpleInsDelOrReplacementBreakpointComplications.inferInsertedSequence(simpleChimera.regionWithLowerCoordOnContig, simpleChimera.regionWithHigherCoordOnContig, contigSeq, firstAfterSecond);
            } else {
                throw new GATKException.ShouldNeverReachHereException("Inferring breakpoint complications with the wrong unit: using simple ins-del unit for simple chimera:\n" + simpleChimera.toString());
            }
            if (distBetweenAlignRegionsOnCtg > 0 && this.insertedSequenceForwardStrandRep.isEmpty()) {
                throw new GATKException.ShouldNeverReachHereException("An identified breakpoint pair seem to suggest insertion but the inserted sequence is empty: " + simpleChimera.toString());
            }
        }

        private SimpleInsDelOrReplacementBreakpointComplications(Kryo kryo, Input input) {
            super(kryo, input);
        }

        @Override
        protected void serialize(Kryo kryo, Output output) {
            super.serialize(kryo, output);
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            return super.equals(obj);
        }

        public static final class Serializer
        extends com.esotericsoftware.kryo.Serializer<SimpleInsDelOrReplacementBreakpointComplications> {
            public void write(Kryo kryo, Output output, SimpleInsDelOrReplacementBreakpointComplications breakpointComplications) {
                breakpointComplications.serialize(kryo, output);
            }

            public SimpleInsDelOrReplacementBreakpointComplications read(Kryo kryo, Input input, Class<SimpleInsDelOrReplacementBreakpointComplications> klass) {
                return new SimpleInsDelOrReplacementBreakpointComplications(kryo, input);
            }
        }
    }
}

