/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.spark.sv.discovery.inference;

import com.google.common.annotations.VisibleForTesting;
import htsjdk.samtools.Cigar;
import htsjdk.samtools.CigarOperator;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.TextCigarCodec;
import htsjdk.samtools.util.SequenceUtil;
import java.util.Arrays;
import java.util.List;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.tools.spark.sv.discovery.alignment.AlignmentInterval;
import org.broadinstitute.hellbender.tools.spark.sv.discovery.alignment.StrandSwitch;
import org.broadinstitute.hellbender.tools.spark.sv.discovery.inference.BreakpointComplications;
import org.broadinstitute.hellbender.tools.spark.sv.discovery.inference.SimpleChimera;
import org.broadinstitute.hellbender.utils.IntervalUtils;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.read.CigarUtils;
import scala.Tuple2;

@VisibleForTesting
public abstract class BreakpointsInference {
    protected String upstreamBreakpointRefContig;
    protected String downstreamBreakpointRefContig;
    protected int upstreamBreakpointRefPos;
    protected int downstreamBreakpointRefPos;
    protected byte[] altHaplotypeSequence;

    final Tuple2<SimpleInterval, SimpleInterval> getLeftJustifiedBreakpoints() {
        return new Tuple2((Object)new SimpleInterval(this.upstreamBreakpointRefContig, this.upstreamBreakpointRefPos, this.upstreamBreakpointRefPos), (Object)new SimpleInterval(this.downstreamBreakpointRefContig, this.downstreamBreakpointRefPos, this.downstreamBreakpointRefPos));
    }

    final byte[] getInferredAltHaplotypeSequence() {
        return this.altHaplotypeSequence;
    }

    abstract BreakpointComplications getComplications();

    protected BreakpointsInference(SimpleChimera simpleChimera, byte[] contigSequence, SAMSequenceDictionary referenceDictionary) {
        this.resolveComplications(simpleChimera, contigSequence, referenceDictionary);
    }

    static void validateInferredLocations(SimpleInterval leftBreakpoint, SimpleInterval rightBreakpoint, SAMSequenceDictionary referenceSequenceDictionary, String errorMessage) {
        if (IntervalUtils.isBefore(rightBreakpoint, leftBreakpoint, referenceSequenceDictionary)) {
            throw new GATKException.ShouldNeverReachHereException("Inferred novel adjacency reference locations have left location after right location." + errorMessage);
        }
        if (leftBreakpoint.getEnd() > referenceSequenceDictionary.getSequence(leftBreakpoint.getContig()).getSequenceLength()) {
            throw new GATKException.ShouldNeverReachHereException("Inferred breakpoint beyond reference sequence length." + errorMessage);
        }
        if (rightBreakpoint.getEnd() > referenceSequenceDictionary.getSequence(rightBreakpoint.getContig()).getSequenceLength()) {
            throw new GATKException.ShouldNeverReachHereException("Inferred breakpoint beyond reference sequence length. " + errorMessage);
        }
    }

    static BreakpointsInference getInferenceClass(SimpleChimera simpleChimera, byte[] contigSequence, SAMSequenceDictionary referenceDictionary) {
        switch (simpleChimera.inferType(referenceDictionary)) {
            case INTER_CHR_STRAND_SWITCH_55: 
            case INTER_CHR_STRAND_SWITCH_33: 
            case INTER_CHR_NO_SS_WITH_LEFT_MATE_FIRST_IN_PARTNER: 
            case INTER_CHR_NO_SS_WITH_LEFT_MATE_SECOND_IN_PARTNER: {
                return new InterChromosomeBreakpointsInference(simpleChimera, contigSequence, referenceDictionary);
            }
            case INTRA_CHR_REF_ORDER_SWAP: {
                return new IntraChrRefOrderSwapBreakpointsInference(simpleChimera, contigSequence, referenceDictionary);
            }
            case INTRA_CHR_STRAND_SWITCH_55: 
            case INTRA_CHR_STRAND_SWITCH_33: {
                if (simpleChimera.isCandidateInvertedDuplication()) {
                    return new InvertedDuplicationBreakpointsInference(simpleChimera, contigSequence, referenceDictionary);
                }
                return new IntraChrStrandSwitchBreakpointInference(simpleChimera, contigSequence, referenceDictionary);
            }
            case SIMPLE_DEL: 
            case RPL: 
            case SIMPLE_INS: {
                return new SimpleInsertionDeletionBreakpointsInference(simpleChimera, contigSequence, referenceDictionary);
            }
            case SMALL_DUP_EXPANSION: 
            case DEL_DUP_CONTRACTION: {
                return new SmallDuplicationWithPreciseDupRangeBreakpointsInference(simpleChimera, contigSequence, referenceDictionary);
            }
            case SMALL_DUP_CPX: {
                return new SmallDuplicationWithImpreciseDupRangeBreakpointsInference(simpleChimera, contigSequence, referenceDictionary);
            }
        }
        throw new GATKException.ShouldNeverReachHereException("Inferred type not recognized for simple chimera:\t" + simpleChimera.toString());
    }

    abstract void resolveComplications(SimpleChimera var1, byte[] var2, SAMSequenceDictionary var3);

    public String toString() {
        return "left: " + this.upstreamBreakpointRefContig + ":" + this.upstreamBreakpointRefPos + " right: " + this.downstreamBreakpointRefContig + ":" + this.downstreamBreakpointRefPos + " complications: " + this.getComplications().toString() + " alt seq: " + (this.getInferredAltHaplotypeSequence() == null ? "NULL" : (Object)this.getInferredAltHaplotypeSequence());
    }

    static final class InterChromosomeBreakpointsInference
    extends BNDTypeBreakpointsInference {
        private BreakpointComplications.InterChromosomeBreakpointComplications complications;

        @Override
        BreakpointComplications getComplications() {
            return this.complications;
        }

        @Override
        void resolveComplications(SimpleChimera simpleChimera, byte[] contigSequence, SAMSequenceDictionary referenceDictionary) {
            this.complications = new BreakpointComplications.InterChromosomeBreakpointComplications(simpleChimera, contigSequence, simpleChimera.firstContigRegionRefSpanAfterSecond(referenceDictionary));
        }

        InterChromosomeBreakpointsInference(SimpleChimera simpleChimera, byte[] contigSequence, SAMSequenceDictionary referenceDictionary) {
            super(simpleChimera, contigSequence, referenceDictionary);
            this.determineRefContigs(simpleChimera, referenceDictionary);
            this.extractRefPositions(simpleChimera, this.complications, referenceDictionary);
            InterChromosomeBreakpointsInference.validateInferredLocations(new SimpleInterval(this.upstreamBreakpointRefContig, this.upstreamBreakpointRefPos, this.upstreamBreakpointRefPos), new SimpleInterval(this.downstreamBreakpointRefContig, this.downstreamBreakpointRefPos, this.downstreamBreakpointRefPos), referenceDictionary, this.toString());
        }

        private void extractRefPositions(SimpleChimera ca, BreakpointComplications.InterChromosomeBreakpointComplications complication, SAMSequenceDictionary referenceDictionary) {
            block14: {
                int homologyLen;
                block13: {
                    homologyLen = complication.getHomologyForwardStrandRep().length();
                    boolean firstInPartner = InterChromosomeBreakpointsInference.isFirstInPartner(ca, referenceDictionary);
                    if (!firstInPartner) break block13;
                    switch (ca.strandSwitch) {
                        case NO_SWITCH: {
                            if (ca.isForwardStrandRepresentation) {
                                this.upstreamBreakpointRefPos = ca.regionWithLowerCoordOnContig.referenceSpan.getEnd() - homologyLen;
                                this.downstreamBreakpointRefPos = ca.regionWithHigherCoordOnContig.referenceSpan.getStart();
                            } else {
                                this.upstreamBreakpointRefPos = ca.regionWithLowerCoordOnContig.referenceSpan.getStart();
                                this.downstreamBreakpointRefPos = ca.regionWithHigherCoordOnContig.referenceSpan.getEnd() - homologyLen;
                            }
                            break block14;
                        }
                        case FORWARD_TO_REVERSE: {
                            this.upstreamBreakpointRefPos = ca.regionWithLowerCoordOnContig.referenceSpan.getEnd() - homologyLen;
                            this.downstreamBreakpointRefPos = ca.regionWithHigherCoordOnContig.referenceSpan.getEnd();
                            break block14;
                        }
                        case REVERSE_TO_FORWARD: {
                            this.upstreamBreakpointRefPos = ca.regionWithLowerCoordOnContig.referenceSpan.getStart();
                            this.downstreamBreakpointRefPos = ca.regionWithHigherCoordOnContig.referenceSpan.getStart() + homologyLen;
                            break block14;
                        }
                        default: {
                            throw new GATKException.ShouldNeverReachHereException("Unseen strand switch case for: " + ca.toString());
                        }
                    }
                }
                switch (ca.strandSwitch) {
                    case NO_SWITCH: {
                        if (ca.isForwardStrandRepresentation) {
                            this.upstreamBreakpointRefPos = ca.regionWithHigherCoordOnContig.referenceSpan.getStart();
                            this.downstreamBreakpointRefPos = ca.regionWithLowerCoordOnContig.referenceSpan.getEnd() - homologyLen;
                            break;
                        }
                        this.upstreamBreakpointRefPos = ca.regionWithHigherCoordOnContig.referenceSpan.getEnd() - homologyLen;
                        this.downstreamBreakpointRefPos = ca.regionWithLowerCoordOnContig.referenceSpan.getStart();
                        break;
                    }
                    case FORWARD_TO_REVERSE: {
                        this.upstreamBreakpointRefPos = ca.regionWithHigherCoordOnContig.referenceSpan.getEnd() - homologyLen;
                        this.downstreamBreakpointRefPos = ca.regionWithLowerCoordOnContig.referenceSpan.getEnd();
                        break;
                    }
                    case REVERSE_TO_FORWARD: {
                        this.upstreamBreakpointRefPos = ca.regionWithHigherCoordOnContig.referenceSpan.getStart();
                        this.downstreamBreakpointRefPos = ca.regionWithLowerCoordOnContig.referenceSpan.getStart() + homologyLen;
                        break;
                    }
                    default: {
                        throw new GATKException.ShouldNeverReachHereException("Unseen strand switch case for: " + ca.toString());
                    }
                }
            }
        }

        private void determineRefContigs(SimpleChimera ca, SAMSequenceDictionary referenceDictionary) {
            boolean firstInPartner = InterChromosomeBreakpointsInference.isFirstInPartner(ca, referenceDictionary);
            if (firstInPartner) {
                this.upstreamBreakpointRefContig = ca.regionWithLowerCoordOnContig.referenceSpan.getContig();
                this.downstreamBreakpointRefContig = ca.regionWithHigherCoordOnContig.referenceSpan.getContig();
            } else {
                this.upstreamBreakpointRefContig = ca.regionWithHigherCoordOnContig.referenceSpan.getContig();
                this.downstreamBreakpointRefContig = ca.regionWithLowerCoordOnContig.referenceSpan.getContig();
            }
        }

        private static boolean isFirstInPartner(SimpleChimera ca, SAMSequenceDictionary referenceDictionary) {
            switch (ca.strandSwitch) {
                case NO_SWITCH: {
                    return 0 > IntervalUtils.compareContigs(ca.regionWithLowerCoordOnContig.referenceSpan, ca.regionWithHigherCoordOnContig.referenceSpan, referenceDictionary);
                }
                case FORWARD_TO_REVERSE: 
                case REVERSE_TO_FORWARD: {
                    return ca.isForwardStrandRepresentation;
                }
            }
            throw new GATKException.ShouldNeverReachHereException("Unseen strand switch case for: " + ca.toString());
        }
    }

    static final class IntraChrRefOrderSwapBreakpointsInference
    extends BNDTypeBreakpointsInference {
        private BreakpointComplications.IntraChrRefOrderSwapBreakpointComplications complications;

        @Override
        BreakpointComplications getComplications() {
            return this.complications;
        }

        @Override
        void resolveComplications(SimpleChimera simpleChimera, byte[] contigSequence, SAMSequenceDictionary referenceDictionary) {
            this.complications = new BreakpointComplications.IntraChrRefOrderSwapBreakpointComplications(simpleChimera, contigSequence, simpleChimera.firstContigRegionRefSpanAfterSecond(referenceDictionary));
        }

        IntraChrRefOrderSwapBreakpointsInference(SimpleChimera simpleChimera, byte[] contigSequence, SAMSequenceDictionary referenceDictionary) {
            super(simpleChimera, contigSequence, referenceDictionary);
            int homologyLen = this.complications.getHomologyForwardStrandRep().length();
            Tuple2<SimpleInterval, SimpleInterval> coordinateSortedRefSpans = simpleChimera.getCoordinateSortedRefSpans(referenceDictionary);
            SimpleInterval leftRefSpan = (SimpleInterval)coordinateSortedRefSpans._1;
            SimpleInterval rightRefSpan = (SimpleInterval)coordinateSortedRefSpans._2;
            this.upstreamBreakpointRefContig = this.downstreamBreakpointRefContig = simpleChimera.regionWithLowerCoordOnContig.referenceSpan.getContig();
            this.upstreamBreakpointRefPos = leftRefSpan.getStart();
            this.downstreamBreakpointRefPos = rightRefSpan.getEnd() - homologyLen;
            IntraChrRefOrderSwapBreakpointsInference.validateInferredLocations(new SimpleInterval(this.upstreamBreakpointRefContig, this.upstreamBreakpointRefPos, this.upstreamBreakpointRefPos), new SimpleInterval(this.downstreamBreakpointRefContig, this.downstreamBreakpointRefPos, this.downstreamBreakpointRefPos), referenceDictionary, this.toString());
        }
    }

    static final class InvertedDuplicationBreakpointsInference
    extends BNDTypeBreakpointsInference {
        private BreakpointComplications.InvertedDuplicationBreakpointComplications complications;

        @Override
        BreakpointComplications getComplications() {
            return this.complications;
        }

        @Override
        void resolveComplications(SimpleChimera simpleChimera, byte[] contigSequence, SAMSequenceDictionary referenceDictionary) {
            this.complications = new BreakpointComplications.InvertedDuplicationBreakpointComplications(simpleChimera, contigSequence, simpleChimera.firstContigRegionRefSpanAfterSecond(referenceDictionary));
        }

        InvertedDuplicationBreakpointsInference(SimpleChimera simpleChimera, byte[] contigSequence, SAMSequenceDictionary referenceDictionary) {
            super(simpleChimera, contigSequence, referenceDictionary);
            this.upstreamBreakpointRefContig = this.downstreamBreakpointRefContig = simpleChimera.regionWithLowerCoordOnContig.referenceSpan.getContig();
            this.upstreamBreakpointRefPos = this.complications.getDupSeqRepeatUnitRefSpan().getStart() - 1;
            this.downstreamBreakpointRefPos = this.complications.getDupSeqRepeatUnitRefSpan().getEnd();
            this.altHaplotypeSequence = InvertedDuplicationBreakpointsInference.extractAltHaplotypeForInvDup(simpleChimera, contigSequence);
            InvertedDuplicationBreakpointsInference.validateInferredLocations(new SimpleInterval(this.upstreamBreakpointRefContig, this.upstreamBreakpointRefPos, this.upstreamBreakpointRefPos), new SimpleInterval(this.downstreamBreakpointRefContig, this.downstreamBreakpointRefPos, this.downstreamBreakpointRefPos), referenceDictionary, this.toString());
        }

        private static byte[] extractAltHaplotypeForInvDup(SimpleChimera simpleChimera, byte[] contigSeq) {
            boolean needRC;
            int end;
            int start;
            int alpha;
            AlignmentInterval firstAlignmentInterval = simpleChimera.regionWithLowerCoordOnContig;
            AlignmentInterval secondAlignmentInterval = simpleChimera.regionWithHigherCoordOnContig;
            if (firstAlignmentInterval.forwardStrand) {
                int omega;
                alpha = firstAlignmentInterval.referenceSpan.getStart();
                if (alpha <= (omega = secondAlignmentInterval.referenceSpan.getStart())) {
                    int walkOnReadUntilDuplicatedSequence = alpha == omega ? 0 : CigarUtils.computeAssociatedDistOnRead(firstAlignmentInterval.cigarAlong5to3DirectionOfContig, firstAlignmentInterval.startInAssembledContig, omega - alpha, false);
                    start = firstAlignmentInterval.startInAssembledContig + walkOnReadUntilDuplicatedSequence - 1;
                    end = secondAlignmentInterval.endInAssembledContig;
                    needRC = false;
                } else {
                    int walkOnReadUntilDuplicatedSequence = CigarUtils.computeAssociatedDistOnRead(secondAlignmentInterval.cigarAlong5to3DirectionOfContig, secondAlignmentInterval.endInAssembledContig, alpha - omega, true);
                    start = firstAlignmentInterval.startInAssembledContig - 1;
                    end = secondAlignmentInterval.endInAssembledContig - walkOnReadUntilDuplicatedSequence;
                    needRC = true;
                }
            } else {
                int omega;
                alpha = firstAlignmentInterval.referenceSpan.getEnd();
                if (alpha >= (omega = secondAlignmentInterval.referenceSpan.getEnd())) {
                    int walkOnReadUntilDuplicatedSequence = alpha == omega ? 0 : CigarUtils.computeAssociatedDistOnRead(firstAlignmentInterval.cigarAlong5to3DirectionOfContig, firstAlignmentInterval.startInAssembledContig, alpha - omega, false);
                    start = firstAlignmentInterval.startInAssembledContig + walkOnReadUntilDuplicatedSequence - 1;
                    end = secondAlignmentInterval.endInAssembledContig;
                    needRC = true;
                } else {
                    int walkOnReadUntilDuplicatedSequence = CigarUtils.computeAssociatedDistOnRead(secondAlignmentInterval.cigarAlong5to3DirectionOfContig, secondAlignmentInterval.endInAssembledContig, omega - alpha, true);
                    start = firstAlignmentInterval.startInAssembledContig - 1;
                    end = secondAlignmentInterval.endInAssembledContig - walkOnReadUntilDuplicatedSequence;
                    needRC = false;
                }
            }
            byte[] seq = Arrays.copyOfRange(contigSeq, start, end);
            if (needRC) {
                SequenceUtil.reverseComplement((byte[])seq, (int)0, (int)seq.length);
            }
            return seq;
        }
    }

    static final class IntraChrStrandSwitchBreakpointInference
    extends BNDTypeBreakpointsInference {
        private BreakpointComplications.IntraChrStrandSwitchBreakpointComplications complications;

        @Override
        BreakpointComplications getComplications() {
            return this.complications;
        }

        @Override
        void resolveComplications(SimpleChimera simpleChimera, byte[] contigSequence, SAMSequenceDictionary referenceDictionary) {
            this.complications = new BreakpointComplications.IntraChrStrandSwitchBreakpointComplications(simpleChimera, contigSequence, simpleChimera.firstContigRegionRefSpanAfterSecond(referenceDictionary));
        }

        IntraChrStrandSwitchBreakpointInference(SimpleChimera simpleChimera, byte[] contigSequence, SAMSequenceDictionary referenceDictionary) {
            super(simpleChimera, contigSequence, referenceDictionary);
            this.upstreamBreakpointRefContig = this.downstreamBreakpointRefContig = simpleChimera.regionWithLowerCoordOnContig.referenceSpan.getContig();
            int homologyLen = this.complications.getHomologyForwardStrandRep().length();
            Tuple2<SimpleInterval, SimpleInterval> coordinateSortedRefSpans = simpleChimera.getCoordinateSortedRefSpans(referenceDictionary);
            SimpleInterval leftReferenceInterval = (SimpleInterval)coordinateSortedRefSpans._1;
            SimpleInterval rightReferenceInterval = (SimpleInterval)coordinateSortedRefSpans._2;
            if (simpleChimera.strandSwitch == StrandSwitch.FORWARD_TO_REVERSE) {
                this.upstreamBreakpointRefPos = leftReferenceInterval.getEnd() - homologyLen;
                this.downstreamBreakpointRefPos = rightReferenceInterval.getEnd();
            } else {
                this.upstreamBreakpointRefPos = leftReferenceInterval.getStart();
                this.downstreamBreakpointRefPos = rightReferenceInterval.getStart() + homologyLen;
            }
            IntraChrStrandSwitchBreakpointInference.validateInferredLocations(new SimpleInterval(this.upstreamBreakpointRefContig, this.upstreamBreakpointRefPos, this.upstreamBreakpointRefPos), new SimpleInterval(this.downstreamBreakpointRefContig, this.downstreamBreakpointRefPos, this.downstreamBreakpointRefPos), referenceDictionary, this.toString());
        }
    }

    static abstract class BNDTypeBreakpointsInference
    extends BreakpointsInference {
        protected BNDTypeBreakpointsInference(SimpleChimera simpleChimera, byte[] contigSequence, SAMSequenceDictionary referenceDictionary) {
            super(simpleChimera, contigSequence, referenceDictionary);
            this.altHaplotypeSequence = new byte[0];
        }
    }

    static final class SmallDuplicationWithImpreciseDupRangeBreakpointsInference
    extends SmallDuplicationBreakpointsInference {
        private BreakpointComplications.SmallDuplicationWithImpreciseDupRangeBreakpointComplications complications;

        @Override
        BreakpointComplications getComplications() {
            return this.complications;
        }

        @Override
        void resolveComplications(SimpleChimera simpleChimera, byte[] contigSequence, SAMSequenceDictionary referenceDictionary) {
            this.complications = new BreakpointComplications.SmallDuplicationWithImpreciseDupRangeBreakpointComplications(simpleChimera, contigSequence, simpleChimera.firstContigRegionRefSpanAfterSecond(referenceDictionary));
        }

        SmallDuplicationWithImpreciseDupRangeBreakpointsInference(SimpleChimera simpleChimera, byte[] contigSequence, SAMSequenceDictionary referenceDictionary) {
            super(simpleChimera, contigSequence, referenceDictionary);
            SimpleChimera.DistancesBetweenAlignmentsOnRefAndOnRead distances = simpleChimera.getDistancesBetweenAlignmentsOnRefAndOnRead();
            int homologyLen = this.complications.getHomologyForwardStrandRep().length();
            Tuple2<SimpleInterval, SimpleInterval> coordinateSortedRefSpans = simpleChimera.getCoordinateSortedRefSpans(referenceDictionary);
            SimpleInterval leftReferenceInterval = (SimpleInterval)coordinateSortedRefSpans._1;
            SimpleInterval rightReferenceInterval = (SimpleInterval)coordinateSortedRefSpans._2;
            if (this.complications.isDupContraction()) {
                this.upstreamBreakpointRefPos = leftReferenceInterval.getEnd() - homologyLen;
                this.downstreamBreakpointRefPos = rightReferenceInterval.getStart() - 1;
                this.altHaplotypeSequence = Arrays.copyOfRange(contigSequence, distances.secondAlnCtgStart - 1, distances.firstAlnCtgEnd);
                if (!simpleChimera.isForwardStrandRepresentation) {
                    SequenceUtil.reverseComplement((byte[])this.altHaplotypeSequence);
                }
            } else {
                int expansionUnitDiff = this.complications.getDupSeqRepeatNumOnCtg() - this.complications.getDupSeqRepeatNumOnRef();
                this.upstreamBreakpointRefPos = leftReferenceInterval.getEnd() - homologyLen - expansionUnitDiff * this.complications.getDupSeqRepeatUnitRefSpan().size();
                this.downstreamBreakpointRefPos = rightReferenceInterval.getStart() - 1;
                Cigar cigar = simpleChimera.regionWithLowerCoordOnContig.cigarAlong5to3DirectionOfContig;
                int hardClipOffset = cigar.getFirstCigarElement().getOperator().equals((Object)CigarOperator.H) ? cigar.getFirstCigarElement().getLength() : 0;
                int distOnRead = CigarUtils.computeAssociatedDistOnRead(cigar, distances.firstAlnCtgEnd - hardClipOffset, -distances.gapBetweenAlignRegionsOnRef, true);
                int zeroBasedStart = distances.firstAlnCtgEnd - distOnRead;
                cigar = simpleChimera.regionWithHigherCoordOnContig.cigarAlong5to3DirectionOfContig;
                hardClipOffset = cigar.getFirstCigarElement().getOperator().equals((Object)CigarOperator.H) ? cigar.getFirstCigarElement().getLength() : 0;
                distOnRead = CigarUtils.computeAssociatedDistOnRead(cigar, distances.secondAlnCtgStart - hardClipOffset, -distances.gapBetweenAlignRegionsOnRef, false);
                int zeroBasedEnd = distances.secondAlnCtgStart + distOnRead - 1;
                this.altHaplotypeSequence = Arrays.copyOfRange(contigSequence, zeroBasedStart, zeroBasedEnd);
                if (!simpleChimera.isForwardStrandRepresentation) {
                    SequenceUtil.reverseComplement((byte[])this.altHaplotypeSequence);
                }
            }
            SmallDuplicationWithImpreciseDupRangeBreakpointsInference.validateInferredLocations(new SimpleInterval(this.upstreamBreakpointRefContig, this.upstreamBreakpointRefPos, this.upstreamBreakpointRefPos), new SimpleInterval(this.downstreamBreakpointRefContig, this.downstreamBreakpointRefPos, this.downstreamBreakpointRefPos), referenceDictionary, this.toString());
        }
    }

    static final class SmallDuplicationWithPreciseDupRangeBreakpointsInference
    extends SmallDuplicationBreakpointsInference {
        private BreakpointComplications.SmallDuplicationWithPreciseDupRangeBreakpointComplications complications;

        @Override
        BreakpointComplications getComplications() {
            return this.complications;
        }

        @Override
        void resolveComplications(SimpleChimera simpleChimera, byte[] contigSequence, SAMSequenceDictionary referenceDictionary) {
            this.complications = new BreakpointComplications.SmallDuplicationWithPreciseDupRangeBreakpointComplications(simpleChimera, contigSequence, simpleChimera.firstContigRegionRefSpanAfterSecond(referenceDictionary));
        }

        SmallDuplicationWithPreciseDupRangeBreakpointsInference(SimpleChimera simpleChimera, byte[] contigSequence, SAMSequenceDictionary referenceDictionary) {
            super(simpleChimera, contigSequence, referenceDictionary);
            int homologyLen = this.complications.getHomologyForwardStrandRep().length();
            SimpleChimera.DistancesBetweenAlignmentsOnRefAndOnRead distances = simpleChimera.getDistancesBetweenAlignmentsOnRefAndOnRead();
            Tuple2<SimpleInterval, SimpleInterval> coordinateSortedRefSpans = simpleChimera.getCoordinateSortedRefSpans(referenceDictionary);
            SimpleInterval leftReferenceInterval = (SimpleInterval)coordinateSortedRefSpans._1;
            SimpleInterval rightReferenceInterval = (SimpleInterval)coordinateSortedRefSpans._2;
            if (this.complications.isDupContraction()) {
                this.upstreamBreakpointRefPos = leftReferenceInterval.getEnd() - homologyLen;
                this.downstreamBreakpointRefPos = rightReferenceInterval.getStart() - 1;
                this.altHaplotypeSequence = new byte[0];
            } else {
                Cigar cigarForSecondCopyOnCtg;
                Cigar cigarForFirstCopyOnCtg;
                int expansionUnitDiff = this.complications.getDupSeqRepeatNumOnCtg() - this.complications.getDupSeqRepeatNumOnRef();
                this.upstreamBreakpointRefPos = leftReferenceInterval.getEnd() - homologyLen - expansionUnitDiff * this.complications.getDupSeqRepeatUnitRefSpan().size();
                this.downstreamBreakpointRefPos = rightReferenceInterval.getStart() - 1;
                List<String> cigarStringsForDupSeqOnCtg = this.complications.getCigarStringsForDupSeqOnCtgForwardStrandRep();
                if (simpleChimera.isForwardStrandRepresentation) {
                    cigarForFirstCopyOnCtg = TextCigarCodec.decode((String)cigarStringsForDupSeqOnCtg.get(0));
                    cigarForSecondCopyOnCtg = TextCigarCodec.decode((String)cigarStringsForDupSeqOnCtg.get(1));
                } else {
                    cigarForFirstCopyOnCtg = TextCigarCodec.decode((String)cigarStringsForDupSeqOnCtg.get(1));
                    cigarForSecondCopyOnCtg = TextCigarCodec.decode((String)cigarStringsForDupSeqOnCtg.get(0));
                }
                int zeroBasedStart = distances.firstAlnCtgEnd - cigarForFirstCopyOnCtg.getReadLength();
                int zeroBasedEnd = distances.secondAlnCtgStart + cigarForSecondCopyOnCtg.getReadLength() - 1;
                this.altHaplotypeSequence = Arrays.copyOfRange(contigSequence, zeroBasedStart, zeroBasedEnd);
                if (!simpleChimera.isForwardStrandRepresentation) {
                    SequenceUtil.reverseComplement((byte[])this.altHaplotypeSequence);
                }
            }
            SmallDuplicationWithPreciseDupRangeBreakpointsInference.validateInferredLocations(new SimpleInterval(this.upstreamBreakpointRefContig, this.upstreamBreakpointRefPos, this.upstreamBreakpointRefPos), new SimpleInterval(this.downstreamBreakpointRefContig, this.downstreamBreakpointRefPos, this.downstreamBreakpointRefPos), referenceDictionary, this.toString());
        }
    }

    static abstract class SmallDuplicationBreakpointsInference
    extends BreakpointsInference {
        SmallDuplicationBreakpointsInference(SimpleChimera simpleChimera, byte[] contigSequence, SAMSequenceDictionary referenceDictionary) {
            super(simpleChimera, contigSequence, referenceDictionary);
            this.upstreamBreakpointRefContig = this.downstreamBreakpointRefContig = simpleChimera.regionWithLowerCoordOnContig.referenceSpan.getContig();
        }
    }

    static final class SimpleInsertionDeletionBreakpointsInference
    extends BreakpointsInference {
        private BreakpointComplications.SimpleInsDelOrReplacementBreakpointComplications complications;

        @Override
        BreakpointComplications getComplications() {
            return this.complications;
        }

        @Override
        void resolveComplications(SimpleChimera simpleChimera, byte[] contigSequence, SAMSequenceDictionary referenceDictionary) {
            this.complications = new BreakpointComplications.SimpleInsDelOrReplacementBreakpointComplications(simpleChimera, contigSequence, simpleChimera.firstContigRegionRefSpanAfterSecond(referenceDictionary));
        }

        protected SimpleInsertionDeletionBreakpointsInference(SimpleChimera simpleChimera, byte[] contigSequence, SAMSequenceDictionary referenceDictionary) {
            super(simpleChimera, contigSequence, referenceDictionary);
            this.upstreamBreakpointRefContig = this.downstreamBreakpointRefContig = simpleChimera.regionWithLowerCoordOnContig.referenceSpan.getContig();
            Tuple2<SimpleInterval, SimpleInterval> coordinateSortedRefSpans = simpleChimera.getCoordinateSortedRefSpans(referenceDictionary);
            SimpleInterval leftReferenceInterval = (SimpleInterval)coordinateSortedRefSpans._1;
            SimpleInterval rightReferenceInterval = (SimpleInterval)coordinateSortedRefSpans._2;
            int homologyLen = this.complications.getHomologyForwardStrandRep().length();
            this.upstreamBreakpointRefPos = leftReferenceInterval.getEnd() - homologyLen;
            this.downstreamBreakpointRefPos = rightReferenceInterval.getStart() - 1;
            this.altHaplotypeSequence = this.complications.insertedSequenceForwardStrandRep.isEmpty() ? new byte[0] : this.complications.insertedSequenceForwardStrandRep.getBytes();
        }
    }
}

