/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.spark.sv.discovery.inference;

import com.google.common.annotations.VisibleForTesting;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.variant.variantcontext.VariantContext;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import org.apache.logging.log4j.Logger;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.PairFlatMapFunction;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.spark.broadcast.Broadcast;
import org.broadinstitute.hellbender.engine.BasicReference;
import org.broadinstitute.hellbender.engine.spark.datasources.ReferenceMultiSparkSource;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.tools.spark.sv.StructuralVariationDiscoveryArgumentCollection;
import org.broadinstitute.hellbender.tools.spark.sv.discovery.SimpleSVType;
import org.broadinstitute.hellbender.tools.spark.sv.discovery.SvDiscoveryInputMetaData;
import org.broadinstitute.hellbender.tools.spark.sv.discovery.SvDiscoveryUtils;
import org.broadinstitute.hellbender.tools.spark.sv.discovery.SvType;
import org.broadinstitute.hellbender.tools.spark.sv.discovery.alignment.AlignedContig;
import org.broadinstitute.hellbender.tools.spark.sv.discovery.alignment.AlignmentInterval;
import org.broadinstitute.hellbender.tools.spark.sv.discovery.alignment.StrandSwitch;
import org.broadinstitute.hellbender.tools.spark.sv.discovery.inference.NovelAdjacencyAndAltHaplotype;
import org.broadinstitute.hellbender.tools.spark.sv.discovery.inference.SimpleChimera;
import org.broadinstitute.hellbender.tools.spark.sv.discovery.inference.SimpleNovelAdjacencyAndChimericAlignmentEvidence;
import org.broadinstitute.hellbender.tools.spark.sv.utils.SVInterval;
import org.broadinstitute.hellbender.tools.spark.sv.utils.SVIntervalTree;
import scala.Tuple2;

public class ContigChimericAlignmentIterativeInterpreter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<VariantContext> discoverVariantsFromChimeras(SvDiscoveryInputMetaData svDiscoveryInputMetaData, JavaRDD<AlignedContig> alignedContigs) {
        Broadcast<SAMSequenceDictionary> referenceSequenceDictionaryBroadcast = svDiscoveryInputMetaData.getReferenceData().getReferenceSequenceDictionaryBroadcast();
        JavaPairRDD contigSeqAndChimeras = alignedContigs.filter((Function & Serializable)alignedContig -> alignedContig.getAlignments().size() > 1).mapToPair((PairFunction & Serializable)alignedContig -> {
            List<SimpleChimera> chimeras = ContigChimericAlignmentIterativeInterpreter.parseOneContig(alignedContig, (SAMSequenceDictionary)referenceSequenceDictionaryBroadcast.getValue(), true, 50, 60, true);
            return new Tuple2((Object)alignedContig.getContigSequence(), chimeras);
        });
        Broadcast<ReferenceMultiSparkSource> referenceBroadcast = svDiscoveryInputMetaData.getReferenceData().getReferenceBroadcast();
        List<SVInterval> assembledIntervals = svDiscoveryInputMetaData.getSampleSpecificData().getAssembledIntervals();
        Broadcast<SVIntervalTree<VariantContext>> cnvCallsBroadcast = svDiscoveryInputMetaData.getSampleSpecificData().getCnvCallsBroadcast();
        String sampleId = svDiscoveryInputMetaData.getSampleSpecificData().getSampleId();
        StructuralVariationDiscoveryArgumentCollection.DiscoverVariantsFromContigAlignmentsArgumentCollection discoverStageArgs = svDiscoveryInputMetaData.getDiscoverStageArgs();
        Logger toolLogger = svDiscoveryInputMetaData.getToolLogger();
        JavaPairRDD narlsAndSources = contigSeqAndChimeras.flatMapToPair((PairFlatMapFunction & Serializable)tigSeqAndChimeras -> {
            byte[] contigSeq = (byte[])tigSeqAndChimeras._1;
            List simpleChimeras = (List)tigSeqAndChimeras._2;
            Stream<Tuple2> novelAdjacencyAndSourceChimera = simpleChimeras.stream().map(ca -> new Tuple2((Object)new NovelAdjacencyAndAltHaplotype((SimpleChimera)ca, contigSeq, (SAMSequenceDictionary)referenceSequenceDictionaryBroadcast.getValue()), ca));
            return novelAdjacencyAndSourceChimera.iterator();
        }).groupByKey().cache();
        try {
            SvDiscoveryUtils.evaluateIntervalsAndNarls(assembledIntervals, narlsAndSources.map(Tuple2::_1).collect(), (SAMSequenceDictionary)referenceSequenceDictionaryBroadcast.getValue(), discoverStageArgs, toolLogger);
            List list = narlsAndSources.mapToPair((PairFunction & Serializable)noveltyAndEvidence -> new Tuple2((Object)ContigChimericAlignmentIterativeInterpreter.inferSimpleTypeFromNovelAdjacency((NovelAdjacencyAndAltHaplotype)noveltyAndEvidence._1, (BasicReference)referenceBroadcast.getValue()), (Object)new SimpleNovelAdjacencyAndChimericAlignmentEvidence((NovelAdjacencyAndAltHaplotype)noveltyAndEvidence._1, (Iterable)noveltyAndEvidence._2))).map((Function & Serializable)noveltyTypeAndEvidence -> ((SimpleNovelAdjacencyAndChimericAlignmentEvidence)noveltyTypeAndEvidence._2).produceAnnotatedVcFromAssemblyEvidence((SvType)noveltyTypeAndEvidence._1, (SAMSequenceDictionary)referenceSequenceDictionaryBroadcast.getValue(), cnvCallsBroadcast == null ? null : (SVIntervalTree)cnvCallsBroadcast.getValue(), sampleId).make()).collect();
            return list;
        }
        finally {
            narlsAndSources.unpersist();
        }
    }

    public static List<SimpleChimera> parseOneContig(AlignedContig alignedContig, SAMSequenceDictionary referenceDictionary, boolean filterAlignmentByMqOrLength, int uniqueRefSpanThreshold, int mapQualThresholdInclusive, boolean filterWhollyContainedAlignments) {
        if (alignedContig.getAlignments().size() < 2) {
            return new ArrayList<SimpleChimera>();
        }
        Iterator<AlignmentInterval> iterator = alignedContig.getAlignments().iterator();
        AlignmentInterval current = iterator.next();
        if (filterAlignmentByMqOrLength) {
            while (ContigChimericAlignmentIterativeInterpreter.mapQualTooLow(current, mapQualThresholdInclusive) && iterator.hasNext()) {
                current = iterator.next();
            }
        }
        ArrayList<SimpleChimera> results = new ArrayList<SimpleChimera>(alignedContig.getAlignments().size() - 1);
        ArrayList<String> insertionMappings = new ArrayList<String>();
        while (iterator.hasNext()) {
            SimpleChimera simpleChimera;
            AlignmentInterval next = iterator.next();
            if (filterAlignmentByMqOrLength) {
                if (ContigChimericAlignmentIterativeInterpreter.firstAlignmentIsTooShort(current, next, uniqueRefSpanThreshold) || AlignedContig.simpleChimeraWithStichableAlignments(current, next)) continue;
                if (ContigChimericAlignmentIterativeInterpreter.nextAlignmentMayBeInsertion(current, next, mapQualThresholdInclusive, uniqueRefSpanThreshold, filterWhollyContainedAlignments)) {
                    if (!iterator.hasNext()) break;
                    insertionMappings.add(next.toPackedString());
                    continue;
                }
            }
            if ((simpleChimera = new SimpleChimera(current, next, insertionMappings, alignedContig.getContigName(), "NONE", referenceDictionary)).isNeitherIncompleteNorSimpleTranslocation()) {
                results.add(simpleChimera);
            }
            current = next;
        }
        return results;
    }

    private static boolean mapQualTooLow(AlignmentInterval aln, int mapQThresholdInclusive) {
        return aln.mapQual < mapQThresholdInclusive;
    }

    @VisibleForTesting
    public static boolean firstAlignmentIsTooShort(AlignmentInterval first, AlignmentInterval second, Integer minAlignLength) {
        return first.referenceSpan.size() - AlignmentInterval.overlapOnContig(first, second) < minAlignLength;
    }

    @VisibleForTesting
    public static boolean nextAlignmentMayBeInsertion(AlignmentInterval current, AlignmentInterval next, Integer mapQThresholdInclusive, Integer minAlignLength, boolean filterWhollyContained) {
        boolean isNotUnique = ContigChimericAlignmentIterativeInterpreter.mapQualTooLow(next, mapQThresholdInclusive) || ContigChimericAlignmentIterativeInterpreter.firstAlignmentIsTooShort(next, current, minAlignLength);
        return isNotUnique || filterWhollyContained && (current.referenceSpan.contains(next.referenceSpan) || next.referenceSpan.contains(current.referenceSpan));
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SimpleSVType inferSimpleTypeFromNovelAdjacency(NovelAdjacencyAndAltHaplotype novelAdjacencyAndAltHaplotype, BasicReference reference) {
        void var7_13;
        boolean hasNoDupSeq;
        int start = novelAdjacencyAndAltHaplotype.getLeftJustifiedLeftRefLoc().getEnd();
        int end = novelAdjacencyAndAltHaplotype.getLeftJustifiedRightRefLoc().getStart();
        StrandSwitch strandSwitch = novelAdjacencyAndAltHaplotype.getStrandSwitch();
        boolean hasNoInsertedSeq = !novelAdjacencyAndAltHaplotype.hasInsertedSequence();
        boolean bl = hasNoDupSeq = !novelAdjacencyAndAltHaplotype.hasDuplicationAnnotation();
        if (strandSwitch == StrandSwitch.NO_SWITCH) {
            if (start == end) {
                if (hasNoDupSeq) {
                    if (hasNoInsertedSeq) {
                        throw new GATKException("Something went wrong in type inference, there's suspected insertion happening but no inserted sequence could be inferred " + novelAdjacencyAndAltHaplotype.toString());
                    }
                    SimpleSVType.Insertion insertion = new SimpleSVType.Insertion(novelAdjacencyAndAltHaplotype, reference);
                    return var7_13;
                } else {
                    SimpleSVType.DuplicationTandem duplicationTandem = new SimpleSVType.DuplicationTandem(novelAdjacencyAndAltHaplotype, reference);
                }
                return var7_13;
            } else if (hasNoDupSeq) {
                if (hasNoInsertedSeq) {
                    SimpleSVType.Deletion deletion = new SimpleSVType.Deletion(novelAdjacencyAndAltHaplotype, reference);
                    return var7_13;
                } else {
                    SimpleSVType.Deletion deletion = new SimpleSVType.Deletion(novelAdjacencyAndAltHaplotype, reference);
                }
                return var7_13;
            } else {
                if (!hasNoInsertedSeq) throw new GATKException("Something went wrong in novel adjacency interpretation:  inferring simple SV type from a novel adjacency between two different reference locations, but annotated with both inserted sequence and duplication, which is NOT simple.\n" + novelAdjacencyAndAltHaplotype.toString());
                SimpleSVType.Deletion deletion = new SimpleSVType.Deletion(novelAdjacencyAndAltHaplotype, reference);
            }
            return var7_13;
        } else {
            int svLength = novelAdjacencyAndAltHaplotype.getLeftJustifiedRightRefLoc().getStart() - novelAdjacencyAndAltHaplotype.getLeftJustifiedLeftRefLoc().getEnd();
            SimpleSVType.Inversion inversion = new SimpleSVType.Inversion(novelAdjacencyAndAltHaplotype, svLength, reference);
        }
        return var7_13;
    }
}

