/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.spark.sv.discovery.inference;

import com.esotericsoftware.kryo.DefaultSerializer;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import htsjdk.samtools.util.SequenceUtil;
import htsjdk.variant.variantcontext.VariantContextBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.broadinstitute.hellbender.tools.spark.sv.discovery.alignment.AlignmentInterval;
import org.broadinstitute.hellbender.tools.spark.sv.discovery.alignment.AssemblyContigWithFineTunedAlignments;
import org.broadinstitute.hellbender.tools.spark.sv.discovery.inference.CpxVariantInducingAssemblyContig;
import org.broadinstitute.hellbender.tools.spark.sv.discovery.inference.CpxVariantInterpreter;
import org.broadinstitute.hellbender.tools.spark.sv.discovery.inference.CpxVariantType;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import scala.Tuple2;

@DefaultSerializer(value=Serializer.class)
public final class CpxVariantCanonicalRepresentation {
    public static final String UNMAPPED_INSERTION = "UINS";
    private final SimpleInterval affectedRefRegion;
    private final List<SimpleInterval> referenceSegments;
    private final List<String> eventDescriptions;
    private final byte[] altSeq;

    @VisibleForTesting
    CpxVariantCanonicalRepresentation(SimpleInterval affectedRefRegion, List<SimpleInterval> referenceSegments, List<String> eventDescriptions, byte[] altSeq) {
        this.affectedRefRegion = affectedRefRegion;
        this.referenceSegments = referenceSegments;
        this.eventDescriptions = eventDescriptions;
        this.altSeq = altSeq;
    }

    private void checkBoundedBySharedSingleBase(CpxVariantInducingAssemblyContig cpxVariantInducingAssemblyContig) {
        boolean boundByOneSharedBase;
        boolean bl = boundByOneSharedBase = cpxVariantInducingAssemblyContig.getEventPrimaryChromosomeSegmentingLocations().iterator().next().size() == 1;
        if (!boundByOneSharedBase) {
            throw new CpxVariantInterpreter.UnhandledCaseSeen("run into unseen case where only one reference segmenting location is found but its size is not 1:\n" + cpxVariantInducingAssemblyContig.toString());
        }
        List<AlignmentInterval> contigAlignments = cpxVariantInducingAssemblyContig.getPreprocessedTig().getAlignments();
        SimpleInterval refRegionBoundedByAlphaAndOmega = cpxVariantInducingAssemblyContig.getBasicInfo().getRefRegionBoundedByAlphaAndOmega();
        boolean allMiddleAlignmentsDisjointFromAlphaOmega = contigAlignments.subList(1, contigAlignments.size() - 1).stream().allMatch(ai -> CpxVariantInducingAssemblyContig.alignmentIsDisjointFromAlphaOmega(ai.referenceSpan, refRegionBoundedByAlphaAndOmega));
        if (!allMiddleAlignmentsDisjointFromAlphaOmega) {
            throw new CpxVariantInterpreter.UnhandledCaseSeen("run into unseen case where only one reference segmenting location is found but some middle alignments are overlapping alpha-omega region:\t" + refRegionBoundedByAlphaAndOmega + "\n" + cpxVariantInducingAssemblyContig.toString());
        }
    }

    CpxVariantCanonicalRepresentation(CpxVariantInducingAssemblyContig cpxVariantInducingAssemblyContig) {
        CpxVariantInducingAssemblyContig.BasicInfo basicInfo = cpxVariantInducingAssemblyContig.getBasicInfo();
        List<AlignmentInterval> contigAlignments = cpxVariantInducingAssemblyContig.getPreprocessedTig().getAlignments();
        List<CpxVariantInducingAssemblyContig.Jump> jumps = cpxVariantInducingAssemblyContig.getJumps();
        List<SimpleInterval> segmentingLocations = cpxVariantInducingAssemblyContig.getEventPrimaryChromosomeSegmentingLocations();
        if (segmentingLocations.size() == 1) {
            this.checkBoundedBySharedSingleBase(cpxVariantInducingAssemblyContig);
        }
        Set<SimpleInterval> twoBaseBoundaries = cpxVariantInducingAssemblyContig.getTwoBaseBoundaries();
        this.affectedRefRegion = CpxVariantCanonicalRepresentation.getAffectedReferenceRegion(segmentingLocations);
        this.referenceSegments = CpxVariantCanonicalRepresentation.extractRefSegments(basicInfo, segmentingLocations, twoBaseBoundaries);
        this.eventDescriptions = CpxVariantCanonicalRepresentation.extractAltArrangements(basicInfo, contigAlignments, jumps, this.referenceSegments);
        this.altSeq = CpxVariantCanonicalRepresentation.extractAltHaplotypeSeq(cpxVariantInducingAssemblyContig.getPreprocessedTig(), this.referenceSegments, basicInfo);
    }

    @VisibleForTesting
    static SimpleInterval getAffectedReferenceRegion(List<SimpleInterval> eventPrimaryChromosomeSegmentingLocations) {
        int start = eventPrimaryChromosomeSegmentingLocations.get(0).getStart();
        int end = eventPrimaryChromosomeSegmentingLocations.get(eventPrimaryChromosomeSegmentingLocations.size() - 1).getEnd();
        return new SimpleInterval(eventPrimaryChromosomeSegmentingLocations.get(0).getContig(), start, end);
    }

    @VisibleForTesting
    static List<SimpleInterval> extractRefSegments(CpxVariantInducingAssemblyContig.BasicInfo basicInfo, List<SimpleInterval> segmentingLocations, Set<SimpleInterval> twoBaseBoundaries) {
        if (segmentingLocations.size() == 1) {
            return segmentingLocations;
        }
        String eventPrimaryChromosome = basicInfo.eventPrimaryChromosome;
        ArrayList<SimpleInterval> segments = new ArrayList<SimpleInterval>(segmentingLocations.size() - 1);
        Iterator<SimpleInterval> iterator = segmentingLocations.iterator();
        SimpleInterval leftBoundary = iterator.next();
        while (iterator.hasNext()) {
            SimpleInterval twoBaseSegment;
            SimpleInterval rightBoundary = iterator.next();
            if (rightBoundary.getStart() - leftBoundary.getEnd() > 1) {
                segments.add(new SimpleInterval(eventPrimaryChromosome, leftBoundary.getEnd(), rightBoundary.getStart()));
            } else if (rightBoundary.getStart() - leftBoundary.getEnd() == 1 && twoBaseBoundaries.contains(twoBaseSegment = new SimpleInterval(eventPrimaryChromosome, leftBoundary.getEnd(), rightBoundary.getStart()))) {
                segments.add(twoBaseSegment);
            }
            leftBoundary = rightBoundary;
        }
        return segments;
    }

    @VisibleForTesting
    static List<String> extractAltArrangements(CpxVariantInducingAssemblyContig.BasicInfo basicInfo, List<AlignmentInterval> contigAlignments, List<CpxVariantInducingAssemblyContig.Jump> jumps, List<SimpleInterval> segments) {
        if (segments.size() == 1 && segments.iterator().next().size() == 1) {
            return CpxVariantCanonicalRepresentation.descriptionsForSingleSharedBaseByHeadTail(basicInfo, (List<AlignmentInterval>)contigAlignments, jumps);
        }
        ImmutableList alignmentIntervalList = basicInfo.forwardStrandRep ? contigAlignments : ImmutableList.copyOf(contigAlignments).reverse();
        Iterator jumpGapSizeIterator = basicInfo.forwardStrandRep ? jumps.stream().map(jump -> jump.gapSize).iterator() : ImmutableList.copyOf(jumps).reverse().stream().map(jump -> jump.gapSize).iterator();
        Integer currentJumpGapSize = (Integer)jumpGapSizeIterator.next();
        boolean jumpIsLast = false;
        SimpleInterval regionBoundedByAlphaAndOmega = basicInfo.getRefRegionBoundedByAlphaAndOmega();
        ArrayList<String> descriptions = new ArrayList<String>(2 * segments.size());
        ArrayList<Tuple2> insertionsMappedToDisjointRegionsAndInsertionLocations = new ArrayList<Tuple2>();
        for (AlignmentInterval alignment : alignmentIntervalList) {
            if (CpxVariantInducingAssemblyContig.alignmentIsDisjointFromAlphaOmega(alignment.referenceSpan, regionBoundedByAlphaAndOmega)) {
                int indexABS = descriptions.size();
                insertionsMappedToDisjointRegionsAndInsertionLocations.add(new Tuple2((Object)alignment.referenceSpan, (Object)(basicInfo.forwardStrandRep == alignment.forwardStrand ? indexABS : -1 * indexABS)));
                if (currentJumpGapSize > 0) {
                    descriptions.add("UINS-" + currentJumpGapSize);
                }
            } else {
                int step;
                int stop;
                int start;
                if (basicInfo.forwardStrandRep == alignment.forwardStrand) {
                    start = 0;
                    stop = segments.size();
                    step = 1;
                } else {
                    start = segments.size() - 1;
                    stop = -1;
                    step = -1;
                }
                for (int i = start; i != stop; i += step) {
                    SimpleInterval currentSegment = segments.get(i);
                    if (!alignment.referenceSpan.contains(currentSegment)) continue;
                    if (basicInfo.forwardStrandRep) {
                        descriptions.add(String.valueOf((alignment.forwardStrand ? 1 : -1) * (i + 1)));
                        continue;
                    }
                    descriptions.add(String.valueOf((alignment.forwardStrand ? -1 : 1) * (i + 1)));
                }
                if (currentJumpGapSize > 0 && !jumpIsLast) {
                    descriptions.add("UINS-" + currentJumpGapSize);
                }
            }
            if (jumpGapSizeIterator.hasNext()) {
                currentJumpGapSize = (Integer)jumpGapSizeIterator.next();
                continue;
            }
            jumpIsLast = true;
        }
        ImmutableList reverse = ImmutableList.copyOf(insertionsMappedToDisjointRegionsAndInsertionLocations).reverse();
        for (Tuple2 pair : reverse) {
            int index = (Integer)pair._2;
            if (index > 0) {
                descriptions.add((Integer)pair._2, ((SimpleInterval)pair._1).toString());
                continue;
            }
            descriptions.add(-1 * (Integer)pair._2, "-" + ((SimpleInterval)pair._1).toString());
        }
        return descriptions;
    }

    private static List<String> descriptionsForSingleSharedBaseByHeadTail(CpxVariantInducingAssemblyContig.BasicInfo basicInfo, List<AlignmentInterval> contigAlignments, List<CpxVariantInducingAssemblyContig.Jump> jumps) {
        ArrayList<String> result = new ArrayList<String>(contigAlignments.size());
        result.add("1");
        if (jumps.get(0).isGapped()) {
            result.add("UINS-" + jumps.get((int)0).gapSize);
        }
        for (int i = 1; i < contigAlignments.size() - 1; ++i) {
            AlignmentInterval ai = contigAlignments.get(i);
            if (basicInfo.forwardStrandRep) {
                result.add(ai.forwardStrand ? ai.referenceSpan.toString() : "-" + ai.referenceSpan.toString());
            } else {
                result.add(ai.forwardStrand ? "-" + ai.referenceSpan.toString() : ai.referenceSpan.toString());
            }
            if (!jumps.get(i).isGapped()) continue;
            result.add("UINS-" + jumps.get((int)i).gapSize);
        }
        result.add("1");
        return result;
    }

    @VisibleForTesting
    static byte[] extractAltHaplotypeSeq(AssemblyContigWithFineTunedAlignments tigWithInsMappings, List<SimpleInterval> segments, CpxVariantInducingAssemblyContig.BasicInfo basicInfo) {
        int end;
        int start;
        SimpleInterval lastSegment;
        SimpleInterval firstSegment;
        AlignmentInterval head = tigWithInsMappings.getHeadAlignment();
        AlignmentInterval tail = tigWithInsMappings.getTailAlignment();
        if (segments.isEmpty()) {
            int start2 = head.endInAssembledContig;
            int end2 = tail.startInAssembledContig;
            byte[] altSeq = Arrays.copyOfRange(tigWithInsMappings.getContigSequence(), start2 - 1, end2);
            if (!basicInfo.forwardStrandRep) {
                SequenceUtil.reverseComplement((byte[])altSeq);
            }
            return altSeq;
        }
        if (basicInfo.forwardStrandRep) {
            firstSegment = segments.get(0);
            lastSegment = segments.get(segments.size() - 1);
        } else {
            firstSegment = segments.get(segments.size() - 1);
            lastSegment = segments.get(0);
        }
        if (!firstSegment.overlaps(head.referenceSpan)) {
            boolean firstSegmentNeighborsHeadAlignment;
            boolean bl = basicInfo.forwardStrandRep ? firstSegment.getStart() - head.referenceSpan.getEnd() == 1 : (firstSegmentNeighborsHeadAlignment = head.referenceSpan.getStart() - firstSegment.getEnd() == 1);
            if (!firstSegmentNeighborsHeadAlignment) {
                throw new CpxVariantInterpreter.UnhandledCaseSeen("1st segment is not overlapping with head alignment but it is not immediately before/after the head alignment either\n" + tigWithInsMappings.toString() + "\nSegments:\t" + segments.toString());
            }
            start = head.endInAssembledContig;
        } else {
            SimpleInterval intersect = firstSegment.intersect(head.referenceSpan);
            start = intersect.size() == 1 ? head.endInAssembledContig : (Integer)head.readIntervalAlignedToRefSpan((SimpleInterval)intersect)._1;
        }
        if (!lastSegment.overlaps(tail.referenceSpan)) {
            boolean expectedCase;
            boolean bl = basicInfo.forwardStrandRep ? tail.referenceSpan.getStart() - lastSegment.getEnd() == 1 : (expectedCase = lastSegment.getStart() - tail.referenceSpan.getEnd() == 1);
            if (!expectedCase) {
                throw new CpxVariantInterpreter.UnhandledCaseSeen(tigWithInsMappings.toString());
            }
            end = tail.startInAssembledContig;
        } else {
            SimpleInterval intersect = lastSegment.intersect(tail.referenceSpan);
            end = intersect.size() == 1 ? tail.startInAssembledContig : (Integer)tail.readIntervalAlignedToRefSpan((SimpleInterval)intersect)._2;
        }
        byte[] altSeq = Arrays.copyOfRange(tigWithInsMappings.getContigSequence(), start - 1, end);
        if (!basicInfo.forwardStrandRep) {
            SequenceUtil.reverseComplement((byte[])altSeq);
        }
        return altSeq;
    }

    @VisibleForTesting
    VariantContextBuilder toVariantContext(byte[] refBases) {
        HashMap<String, Object> typeSpecificAttributes = new HashMap<String, Object>();
        typeSpecificAttributes.put("ALT_ARRANGEMENT", String.join((CharSequence)",", this.eventDescriptions));
        if (!this.referenceSegments.isEmpty()) {
            typeSpecificAttributes.put("SEGMENTS", String.join((CharSequence)",", this.referenceSegments.stream().map(SimpleInterval::toString).collect(Collectors.toList())));
        }
        return new CpxVariantType(this.affectedRefRegion, refBases, this.altSeq.length, typeSpecificAttributes).getBasicInformation().attribute("SEQ_ALT_HAPLOTYPE", (Object)new String(this.altSeq));
    }

    SimpleInterval getAffectedRefRegion() {
        return this.affectedRefRegion;
    }

    List<SimpleInterval> getReferenceSegments() {
        return this.referenceSegments;
    }

    List<String> getEventDescriptions() {
        return this.eventDescriptions;
    }

    byte[] getAltSeq() {
        return this.altSeq;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("CpxVariantCanonicalRepresentation{");
        sb.append("affectedRefRegion=").append(this.affectedRefRegion);
        sb.append(", referenceSegments=").append(this.referenceSegments);
        sb.append(", eventDescriptions=").append(this.eventDescriptions);
        sb.append(", altSeq=").append(Arrays.toString(this.altSeq));
        sb.append('}');
        return sb.toString();
    }

    private CpxVariantCanonicalRepresentation(Kryo kryo, Input input) {
        String refRegionChr = input.readString();
        int refRegionStart = input.readInt();
        int refRegionEnd = input.readInt();
        this.affectedRefRegion = new SimpleInterval(refRegionChr, refRegionStart, refRegionEnd);
        int numSegments = input.readInt();
        this.referenceSegments = new ArrayList<SimpleInterval>(numSegments);
        for (int i = 0; i < numSegments; ++i) {
            String chr = input.readString();
            int start = input.readInt();
            int end = input.readInt();
            this.referenceSegments.add(new SimpleInterval(chr, start, end));
        }
        int numDescriptions = input.readInt();
        this.eventDescriptions = new ArrayList<String>(numDescriptions);
        for (int i = 0; i < numDescriptions; ++i) {
            this.eventDescriptions.add(input.readString());
        }
        this.altSeq = new byte[input.readInt()];
        input.read(this.altSeq);
    }

    public void serialize(Kryo kryo, Output output) {
        output.writeString(this.affectedRefRegion.getContig());
        output.writeInt(this.affectedRefRegion.getStart());
        output.writeInt(this.affectedRefRegion.getEnd());
        output.writeInt(this.referenceSegments.size());
        for (SimpleInterval segment : this.referenceSegments) {
            output.writeString(segment.getContig());
            output.writeInt(segment.getStart());
            output.writeInt(segment.getEnd());
        }
        output.writeInt(this.eventDescriptions.size());
        for (String description : this.eventDescriptions) {
            output.writeString(description);
        }
        output.writeInt(this.altSeq.length);
        output.write(this.altSeq);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CpxVariantCanonicalRepresentation that = (CpxVariantCanonicalRepresentation)o;
        if (!this.referenceSegments.equals(that.referenceSegments)) {
            return false;
        }
        if (!this.affectedRefRegion.equals(that.affectedRefRegion)) {
            return false;
        }
        if (!this.eventDescriptions.equals(that.eventDescriptions)) {
            return false;
        }
        return Arrays.equals(this.altSeq, that.altSeq);
    }

    public int hashCode() {
        int result = this.referenceSegments.hashCode();
        result = 31 * result + this.affectedRefRegion.hashCode();
        result = 31 * result + this.eventDescriptions.hashCode();
        result = 31 * result + Arrays.hashCode(this.altSeq);
        return result;
    }

    public static final class Serializer
    extends com.esotericsoftware.kryo.Serializer<CpxVariantCanonicalRepresentation> {
        public void write(Kryo kryo, Output output, CpxVariantCanonicalRepresentation x) {
            x.serialize(kryo, output);
        }

        public CpxVariantCanonicalRepresentation read(Kryo kryo, Input input, Class<CpxVariantCanonicalRepresentation> clazz) {
            return new CpxVariantCanonicalRepresentation(kryo, input);
        }
    }
}

