/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.spark.sv.discovery.inference;

import com.esotericsoftware.kryo.DefaultSerializer;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.google.common.annotations.VisibleForTesting;
import htsjdk.samtools.SAMSequenceDictionary;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.tools.spark.sv.discovery.alignment.AlignedContig;
import org.broadinstitute.hellbender.tools.spark.sv.discovery.alignment.AlignmentInterval;
import org.broadinstitute.hellbender.tools.spark.sv.discovery.alignment.AssemblyContigWithFineTunedAlignments;
import org.broadinstitute.hellbender.tools.spark.sv.discovery.alignment.StrandSwitch;
import org.broadinstitute.hellbender.tools.spark.sv.discovery.inference.SimpleChimera;
import org.broadinstitute.hellbender.utils.IntervalUtils;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.Utils;

@DefaultSerializer(value=Serializer.class)
public final class CpxVariantInducingAssemblyContig {
    private static final AssemblyContigWithFineTunedAlignments.Serializer contigSerializer = new AssemblyContigWithFineTunedAlignments.Serializer();
    private static final BasicInfo.Serializer basicInfoSerializer = new BasicInfo.Serializer();
    private static final Jump.Serializer jumpSerializer = new Jump.Serializer();
    private final AssemblyContigWithFineTunedAlignments contigWithFineTunedAlignments;
    private final BasicInfo basicInfo;
    private final List<Jump> jumps;
    private final List<SimpleInterval> eventPrimaryChromosomeSegmentingLocations;

    @VisibleForTesting
    CpxVariantInducingAssemblyContig(AssemblyContigWithFineTunedAlignments contigWithFineTunedAlignments, BasicInfo basicInfo, List<Jump> jumps, List<SimpleInterval> eventPrimaryChromosomeSegmentingLocations) {
        this.contigWithFineTunedAlignments = contigWithFineTunedAlignments;
        this.basicInfo = basicInfo;
        this.jumps = jumps;
        this.eventPrimaryChromosomeSegmentingLocations = eventPrimaryChromosomeSegmentingLocations;
    }

    CpxVariantInducingAssemblyContig(@Nonnull AssemblyContigWithFineTunedAlignments contigWithFineTunedAlignments, @Nonnull SAMSequenceDictionary refSequenceDictionary) {
        this.contigWithFineTunedAlignments = contigWithFineTunedAlignments;
        try {
            this.basicInfo = new BasicInfo(contigWithFineTunedAlignments.getSourceContig());
            this.jumps = CpxVariantInducingAssemblyContig.extractJumpsOnReference(contigWithFineTunedAlignments.getAlignments());
            this.eventPrimaryChromosomeSegmentingLocations = CpxVariantInducingAssemblyContig.extractSegmentingRefLocationsOnEventPrimaryChromosome(this.jumps, this.basicInfo, refSequenceDictionary);
        }
        catch (IllegalArgumentException | GATKException likelyNewEdgeCase) {
            throw new GATKException(this.toString(), likelyNewEdgeCase);
        }
    }

    @VisibleForTesting
    static List<Jump> extractJumpsOnReference(List<AlignmentInterval> alignmentConfiguration) {
        ArrayList<Jump> unsortedJumps = new ArrayList<Jump>(alignmentConfiguration.size() - 1);
        Iterator<AlignmentInterval> iterator = alignmentConfiguration.iterator();
        AlignmentInterval one = iterator.next();
        while (iterator.hasNext()) {
            AlignmentInterval two = iterator.next();
            unsortedJumps.add(new Jump(one, two));
            one = two;
        }
        return unsortedJumps;
    }

    @VisibleForTesting
    static List<SimpleInterval> extractSegmentingRefLocationsOnEventPrimaryChromosome(List<Jump> jumps, BasicInfo basicInfo, SAMSequenceDictionary refSequenceDictionary) {
        SimpleInterval regionBoundedByAlphaAndOmega = basicInfo.getRefRegionBoundedByAlphaAndOmega();
        return jumps.stream().flatMap(jump -> Stream.of(jump.start, jump.landing)).filter(loc -> !CpxVariantInducingAssemblyContig.alignmentIsDisjointFromAlphaOmega(loc, regionBoundedByAlphaAndOmega)).sorted((one, two) -> IntervalUtils.compareLocatables(one, two, refSequenceDictionary)).distinct().collect(Collectors.toList());
    }

    static boolean alignmentIsDisjointFromAlphaOmega(SimpleInterval alignmentRefSpan, SimpleInterval regionBoundedByAlphaAndOmega) {
        return !alignmentRefSpan.overlaps(regionBoundedByAlphaAndOmega);
    }

    AssemblyContigWithFineTunedAlignments getPreprocessedTig() {
        return this.contigWithFineTunedAlignments;
    }

    BasicInfo getBasicInfo() {
        return this.basicInfo;
    }

    List<Jump> getJumps() {
        return this.jumps;
    }

    List<SimpleInterval> getEventPrimaryChromosomeSegmentingLocations() {
        return this.eventPrimaryChromosomeSegmentingLocations;
    }

    @VisibleForTesting
    Set<SimpleInterval> getTwoBaseBoundaries() {
        SimpleInterval validRegion = new SimpleInterval(this.basicInfo.eventPrimaryChromosome, this.basicInfo.alpha.getStart(), this.basicInfo.omega.getEnd());
        String chr = this.basicInfo.eventPrimaryChromosome;
        HashSet<SimpleInterval> result = new HashSet<SimpleInterval>(2 * this.contigWithFineTunedAlignments.getAlignments().size());
        for (AlignmentInterval aln : this.contigWithFineTunedAlignments.getAlignments()) {
            SimpleInterval referenceSpan = aln.referenceSpan;
            if (!validRegion.contains(referenceSpan)) continue;
            SimpleInterval left = new SimpleInterval(chr, referenceSpan.getStart(), referenceSpan.getStart() + 1);
            SimpleInterval right = new SimpleInterval(chr, referenceSpan.getEnd() - 1, referenceSpan.getEnd());
            result.add(left);
            result.add(right);
        }
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("CpxVariantInducingAssemblyContig{");
        sb.append("contigWithFineTunedAlignments=").append(this.contigWithFineTunedAlignments);
        sb.append(", basicInfo=").append(this.basicInfo);
        sb.append(", jumps=").append(this.jumps);
        sb.append(", eventPrimaryChromosomeSegmentingLocations=").append(this.eventPrimaryChromosomeSegmentingLocations);
        sb.append('}');
        return sb.toString();
    }

    private CpxVariantInducingAssemblyContig(Kryo kryo, Input input) {
        this.contigWithFineTunedAlignments = contigSerializer.read(kryo, input, (Class)AssemblyContigWithFineTunedAlignments.class);
        this.basicInfo = basicInfoSerializer.read(kryo, input, (Class)BasicInfo.class);
        int numJumps = input.readInt();
        this.jumps = new ArrayList<Jump>(numJumps);
        for (int i = 0; i < numJumps; ++i) {
            this.jumps.add((Jump)jumpSerializer.read(kryo, input, (Class)Jump.class));
        }
        int numSegmentingLocs = input.readInt();
        this.eventPrimaryChromosomeSegmentingLocations = new ArrayList<SimpleInterval>(numJumps);
        for (int i = 0; i < numSegmentingLocs; ++i) {
            String chr = input.readString();
            int start = input.readInt();
            int end = input.readInt();
            this.eventPrimaryChromosomeSegmentingLocations.add(new SimpleInterval(chr, start, end));
        }
    }

    public void serialize(Kryo kryo, Output output) {
        contigSerializer.write(kryo, output, this.contigWithFineTunedAlignments);
        basicInfoSerializer.write(kryo, output, this.basicInfo);
        output.writeInt(this.jumps.size());
        for (Jump jump : this.jumps) {
            jumpSerializer.write(kryo, output, jump);
        }
        output.writeInt(this.eventPrimaryChromosomeSegmentingLocations.size());
        for (SimpleInterval segmentingLoc : this.eventPrimaryChromosomeSegmentingLocations) {
            output.writeString(segmentingLoc.getContig());
            output.writeInt(segmentingLoc.getStart());
            output.writeInt(segmentingLoc.getEnd());
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CpxVariantInducingAssemblyContig that = (CpxVariantInducingAssemblyContig)o;
        if (!this.contigWithFineTunedAlignments.equals(that.contigWithFineTunedAlignments)) {
            return false;
        }
        if (!this.basicInfo.equals(that.basicInfo)) {
            return false;
        }
        if (!this.jumps.equals(that.jumps)) {
            return false;
        }
        return this.eventPrimaryChromosomeSegmentingLocations.equals(that.eventPrimaryChromosomeSegmentingLocations);
    }

    public int hashCode() {
        int result = this.contigWithFineTunedAlignments.hashCode();
        result = 31 * result + this.basicInfo.hashCode();
        result = 31 * result + this.jumps.hashCode();
        result = 31 * result + this.eventPrimaryChromosomeSegmentingLocations.hashCode();
        return result;
    }

    @DefaultSerializer(value=Serializer.class)
    static final class Jump {
        final SimpleInterval start;
        final SimpleInterval landing;
        final StrandSwitch strandSwitch;
        final int gapSize;

        @VisibleForTesting
        Jump(SimpleInterval start, SimpleInterval landing, StrandSwitch strandSwitch, int gapSize) {
            this.start = start;
            this.landing = landing;
            this.strandSwitch = strandSwitch;
            this.gapSize = gapSize;
        }

        @VisibleForTesting
        Jump(AlignmentInterval one, AlignmentInterval two) {
            Utils.validateArg(AlignmentInterval.overlapOnContig(one, two) <= 0, "assumption that input alignments DO NOT overlap is violated.");
            this.strandSwitch = SimpleChimera.determineStrandSwitch(one, two);
            switch (this.strandSwitch) {
                case NO_SWITCH: {
                    if (one.forwardStrand) {
                        this.start = new SimpleInterval(one.referenceSpan.getContig(), one.referenceSpan.getEnd(), one.referenceSpan.getEnd());
                        this.landing = new SimpleInterval(two.referenceSpan.getContig(), two.referenceSpan.getStart(), two.referenceSpan.getStart());
                        break;
                    }
                    this.start = new SimpleInterval(one.referenceSpan.getContig(), one.referenceSpan.getStart(), one.referenceSpan.getStart());
                    this.landing = new SimpleInterval(two.referenceSpan.getContig(), two.referenceSpan.getEnd(), two.referenceSpan.getEnd());
                    break;
                }
                case FORWARD_TO_REVERSE: {
                    this.start = new SimpleInterval(one.referenceSpan.getContig(), one.referenceSpan.getEnd(), one.referenceSpan.getEnd());
                    this.landing = new SimpleInterval(two.referenceSpan.getContig(), two.referenceSpan.getEnd(), two.referenceSpan.getEnd());
                    break;
                }
                case REVERSE_TO_FORWARD: {
                    this.start = new SimpleInterval(one.referenceSpan.getContig(), one.referenceSpan.getStart(), one.referenceSpan.getStart());
                    this.landing = new SimpleInterval(two.referenceSpan.getContig(), two.referenceSpan.getStart(), two.referenceSpan.getStart());
                    break;
                }
                default: {
                    throw new NoSuchElementException("seeing a strand switch that doesn't make sense");
                }
            }
            this.gapSize = Math.max(0, two.startInAssembledContig - one.endInAssembledContig - 1);
        }

        boolean isGapped() {
            return this.gapSize > 0;
        }

        public String toString() {
            return "Jump start: " + this.start.toString() + "\tjump landing: " + this.landing.toString() + "\t" + this.strandSwitch.name() + "\t" + (this.gapSize > 0 ? "G" : "C");
        }

        private Jump(Kryo kryo, Input input) {
            String chr = input.readString();
            int beg = input.readInt();
            int end = input.readInt();
            this.start = new SimpleInterval(chr, beg, end);
            chr = input.readString();
            beg = input.readInt();
            end = input.readInt();
            this.landing = new SimpleInterval(chr, beg, end);
            this.strandSwitch = StrandSwitch.values()[input.readInt()];
            this.gapSize = input.readInt();
        }

        public void serialize(Kryo kryo, Output output) {
            output.writeString(this.start.getContig());
            output.writeInt(this.start.getStart());
            output.writeInt(this.start.getEnd());
            output.writeString(this.landing.getContig());
            output.writeInt(this.landing.getStart());
            output.writeInt(this.landing.getEnd());
            output.writeInt(this.strandSwitch.ordinal());
            output.writeInt(this.gapSize);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Jump jump = (Jump)o;
            if (this.gapSize != jump.gapSize) {
                return false;
            }
            if (!this.start.equals(jump.start)) {
                return false;
            }
            if (!this.landing.equals(jump.landing)) {
                return false;
            }
            return this.strandSwitch == jump.strandSwitch;
        }

        public int hashCode() {
            int result = this.start.hashCode();
            result = 31 * result + this.landing.hashCode();
            result = 31 * result + this.strandSwitch.ordinal();
            result = 31 * result + this.gapSize;
            return result;
        }

        public static final class Serializer
        extends com.esotericsoftware.kryo.Serializer<Jump> {
            public void write(Kryo kryo, Output output, Jump alignedContig) {
                alignedContig.serialize(kryo, output);
            }

            public Jump read(Kryo kryo, Input input, Class<Jump> clazz) {
                return new Jump(kryo, input);
            }
        }
    }

    @DefaultSerializer(value=Serializer.class)
    static final class BasicInfo {
        final String eventPrimaryChromosome;
        final boolean forwardStrandRep;
        final SimpleInterval alpha;
        final SimpleInterval omega;

        @VisibleForTesting
        BasicInfo(String eventPrimaryChromosome, boolean forwardStrandRep, SimpleInterval alpha, SimpleInterval omega) {
            this.eventPrimaryChromosome = eventPrimaryChromosome;
            this.forwardStrandRep = forwardStrandRep;
            this.alpha = alpha;
            this.omega = omega;
        }

        @VisibleForTesting
        BasicInfo(AlignedContig contig) {
            if (contig.isUnmapped()) {
                throw new GATKException("Trying to extract information from unmapped read: " + contig.toString());
            }
            AlignmentInterval head = contig.getHeadAlignment();
            AlignmentInterval tail = contig.getTailAlignment();
            this.eventPrimaryChromosome = head.referenceSpan.getContig();
            this.forwardStrandRep = head.forwardStrand;
            if (this.forwardStrandRep) {
                this.alpha = new SimpleInterval(head.referenceSpan.getContig(), head.referenceSpan.getStart(), head.referenceSpan.getStart());
                this.omega = new SimpleInterval(tail.referenceSpan.getContig(), tail.referenceSpan.getEnd(), tail.referenceSpan.getEnd());
            } else {
                this.alpha = new SimpleInterval(tail.referenceSpan.getContig(), tail.referenceSpan.getStart(), tail.referenceSpan.getStart());
                this.omega = new SimpleInterval(head.referenceSpan.getContig(), head.referenceSpan.getEnd(), head.referenceSpan.getEnd());
            }
        }

        SimpleInterval getRefRegionBoundedByAlphaAndOmega() {
            return new SimpleInterval(this.eventPrimaryChromosome, this.alpha.getStart(), this.omega.getEnd());
        }

        public String toString() {
            return "primary chr: " + this.eventPrimaryChromosome + "\tstrand rep:" + (this.forwardStrandRep ? (char)'+' : '-') + "\talpha: " + this.alpha.toString() + "\tomega: " + this.omega.toString();
        }

        BasicInfo(Kryo kryo, Input input) {
            this.eventPrimaryChromosome = input.readString();
            this.forwardStrandRep = input.readBoolean();
            String chr = input.readString();
            int start = input.readInt();
            int end = input.readInt();
            this.alpha = new SimpleInterval(chr, start, end);
            chr = input.readString();
            start = input.readInt();
            end = input.readInt();
            this.omega = new SimpleInterval(chr, start, end);
        }

        void serialize(Kryo kryo, Output output) {
            output.writeString(this.eventPrimaryChromosome);
            output.writeBoolean(this.forwardStrandRep);
            output.writeString(this.alpha.getContig());
            output.writeInt(this.alpha.getStart());
            output.writeInt(this.alpha.getEnd());
            output.writeString(this.omega.getContig());
            output.writeInt(this.omega.getStart());
            output.writeInt(this.omega.getEnd());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BasicInfo basicInfo = (BasicInfo)o;
            if (this.forwardStrandRep != basicInfo.forwardStrandRep) {
                return false;
            }
            if (!this.eventPrimaryChromosome.equals(basicInfo.eventPrimaryChromosome)) {
                return false;
            }
            if (!this.alpha.equals(basicInfo.alpha)) {
                return false;
            }
            return this.omega.equals(basicInfo.omega);
        }

        public int hashCode() {
            int result = this.eventPrimaryChromosome.hashCode();
            result = 31 * result + (this.forwardStrandRep ? 1 : 0);
            result = 31 * result + this.alpha.hashCode();
            result = 31 * result + this.omega.hashCode();
            return result;
        }

        public static final class Serializer
        extends com.esotericsoftware.kryo.Serializer<BasicInfo> {
            public void write(Kryo kryo, Output output, BasicInfo alignedContig) {
                alignedContig.serialize(kryo, output);
            }

            public BasicInfo read(Kryo kryo, Input input, Class<BasicInfo> clazz) {
                return new BasicInfo(kryo, input);
            }
        }
    }

    public static final class Serializer
    extends com.esotericsoftware.kryo.Serializer<CpxVariantInducingAssemblyContig> {
        public void write(Kryo kryo, Output output, CpxVariantInducingAssemblyContig alignedContig) {
            alignedContig.serialize(kryo, output);
        }

        public CpxVariantInducingAssemblyContig read(Kryo kryo, Input input, Class<CpxVariantInducingAssemblyContig> clazz) {
            return new CpxVariantInducingAssemblyContig(kryo, input);
        }
    }
}

