/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.spark.sv.discovery.inference;

import com.google.common.annotations.VisibleForTesting;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.VariantContextBuilder;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.spark.broadcast.Broadcast;
import org.broadinstitute.hellbender.engine.BasicReference;
import org.broadinstitute.hellbender.engine.spark.datasources.ReferenceMultiSparkSource;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.tools.spark.sv.discovery.SvDiscoveryInputMetaData;
import org.broadinstitute.hellbender.tools.spark.sv.discovery.alignment.AlignedContig;
import org.broadinstitute.hellbender.tools.spark.sv.discovery.alignment.AlignmentInterval;
import org.broadinstitute.hellbender.tools.spark.sv.discovery.alignment.AssemblyContigWithFineTunedAlignments;
import org.broadinstitute.hellbender.tools.spark.sv.discovery.alignment.ContigAlignmentsModifier;
import org.broadinstitute.hellbender.tools.spark.sv.discovery.inference.CpxVariantCanonicalRepresentation;
import org.broadinstitute.hellbender.tools.spark.sv.discovery.inference.CpxVariantInducingAssemblyContig;
import org.broadinstitute.hellbender.utils.IntervalUtils;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.Utils;
import scala.Tuple2;

public final class CpxVariantInterpreter {
    public static final int MIN_READ_SPAN_AFTER_DEOVERLAP = 2;

    public static List<VariantContext> makeInterpretation(JavaRDD<AssemblyContigWithFineTunedAlignments> assemblyContigs, SvDiscoveryInputMetaData svDiscoveryInputMetaData) {
        Broadcast<ReferenceMultiSparkSource> referenceBroadcast = svDiscoveryInputMetaData.getReferenceData().getReferenceBroadcast();
        Broadcast<SAMSequenceDictionary> referenceSequenceDictionaryBroadcast = svDiscoveryInputMetaData.getReferenceData().getReferenceSequenceDictionaryBroadcast();
        JavaPairRDD interpretationAndAssemblyEvidence = assemblyContigs.mapToPair((PairFunction & Serializable)tig -> CpxVariantInterpreter.getOneVariantFromOneContig(tig, (SAMSequenceDictionary)referenceSequenceDictionaryBroadcast.getValue())).groupByKey();
        return interpretationAndAssemblyEvidence.map((Function & Serializable)pair -> CpxVariantInterpreter.toVariantContext((CpxVariantCanonicalRepresentation)pair._1, (Iterable)pair._2, (BasicReference)referenceBroadcast.getValue())).collect();
    }

    public static Tuple2<CpxVariantCanonicalRepresentation, CpxVariantInducingAssemblyContig> getOneVariantFromOneContig(AssemblyContigWithFineTunedAlignments contigWithFineTunedAlignments, SAMSequenceDictionary refSequenceDictionary) {
        AssemblyContigWithFineTunedAlignments furtherProcessedContig = CpxVariantInterpreter.furtherPreprocess(contigWithFineTunedAlignments, refSequenceDictionary);
        CpxVariantInducingAssemblyContig cpxVariantInducingAssemblyContig = new CpxVariantInducingAssemblyContig(furtherProcessedContig, refSequenceDictionary);
        return new Tuple2((Object)new CpxVariantCanonicalRepresentation(cpxVariantInducingAssemblyContig), (Object)cpxVariantInducingAssemblyContig);
    }

    @VisibleForTesting
    static AssemblyContigWithFineTunedAlignments furtherPreprocess(AssemblyContigWithFineTunedAlignments contigWithFineTunedAlignments, SAMSequenceDictionary refSequenceDictionary) {
        List<AlignmentInterval> deOverlappedAlignmentConfiguration = CpxVariantInterpreter.deOverlapAlignments(contigWithFineTunedAlignments.getAlignments(), refSequenceDictionary);
        return new AssemblyContigWithFineTunedAlignments(new AlignedContig(contigWithFineTunedAlignments.getContigName(), contigWithFineTunedAlignments.getContigSequence(), deOverlappedAlignmentConfiguration), contigWithFineTunedAlignments.getInsertionMappings(), contigWithFineTunedAlignments.hasEquallyGoodAlnConfigurations(), contigWithFineTunedAlignments.getSAtagForGoodMappingToNonCanonicalChromosome());
    }

    @VisibleForTesting
    static List<AlignmentInterval> deOverlapAlignments(List<AlignmentInterval> originalAlignments, SAMSequenceDictionary refSequenceDictionary) {
        ArrayList<AlignmentInterval> result = new ArrayList<AlignmentInterval>(originalAlignments.size());
        int totalCount = originalAlignments.size();
        AlignmentInterval one = originalAlignments.get(0);
        for (int i = 1; i < totalCount; ++i) {
            AlignmentInterval two = originalAlignments.get(i);
            if (two.alnModType.equals((Object)ContigAlignmentsModifier.AlnModType.FROM_SPLIT_GAPPED_ALIGNMENT) && one.containsOnRead(two)) continue;
            int overlapOnContig = AlignmentInterval.overlapOnContig(one, two);
            if (overlapOnContig == 0) {
                if (one.getSizeOnRead() >= 2) {
                    result.add(one);
                }
                one = two;
                continue;
            }
            Tuple2<AlignmentInterval, AlignmentInterval> deoverlapped = CpxVariantInterpreter.removeOverlap(one, two, overlapOnContig, refSequenceDictionary, one.equals(originalAlignments.get(0)), two.equals(originalAlignments.get(totalCount - 1)));
            if (((AlignmentInterval)deoverlapped._1).getSizeOnRead() >= 2) {
                result.add((AlignmentInterval)deoverlapped._1);
            }
            one = (AlignmentInterval)deoverlapped._2;
        }
        result.add(one);
        AlignmentInterval head = (AlignmentInterval)result.get(0);
        AlignmentInterval tail = (AlignmentInterval)result.get(result.size() - 1);
        int overlap = AlignmentInterval.overlapOnContig(head, tail);
        if (overlap > 0) {
            throw new UnhandledCaseSeen("After alignment preprocessing, head and tail alignments should not overlap on read; otherwise it would mean some middle alignments are contained in head/tail which should not happen." + originalAlignments.stream().map(AlignmentInterval::toPackedString).collect(Collectors.toList()));
        }
        return result;
    }

    @VisibleForTesting
    static Tuple2<AlignmentInterval, AlignmentInterval> removeOverlap(AlignmentInterval one, AlignmentInterval two, int overlapOnRead, SAMSequenceDictionary dictionary, boolean firstIsAlignmentHead, boolean secondIsAlignmentTail) {
        AlignmentInterval reconstructedTwo;
        AlignmentInterval reconstructedOne;
        if (overlapOnRead <= 0) {
            throw new IllegalArgumentException("Overlap on read is non-positive for two alignments: " + one.toPackedString() + "\t" + two.toPackedString());
        }
        if (one.containsOnRead(two) || two.containsOnRead(one)) {
            throw new IllegalArgumentException("Two input alignments' overlap on read consumes completely one of them.\t" + one.toPackedString() + "\t" + two.toPackedString());
        }
        boolean oneYieldToTwo = firstIsAlignmentHead ? false : (secondIsAlignmentTail ? true : CpxVariantInterpreter.yieldOverlapToAlignmentTwo(one, two, dictionary));
        if (oneYieldToTwo) {
            reconstructedOne = ContigAlignmentsModifier.clipAlignmentInterval(one, overlapOnRead, true);
            reconstructedTwo = two;
        } else {
            reconstructedOne = one;
            reconstructedTwo = ContigAlignmentsModifier.clipAlignmentInterval(two, overlapOnRead, false);
        }
        return new Tuple2((Object)reconstructedOne, (Object)reconstructedTwo);
    }

    @VisibleForTesting
    static boolean yieldOverlapToAlignmentTwo(AlignmentInterval one, AlignmentInterval two, SAMSequenceDictionary refSequenceDictionary) {
        boolean oneYieldToTwo;
        Utils.validateArg(!one.containsOnRead(two) && !two.containsOnRead(one), "assumption that two alignments don't contain one another on their read span is violated.\n" + one.toPackedString() + "\n" + two.toPackedString());
        if (one.referenceSpan.getContig().equals(two.referenceSpan.getContig())) {
            int jumpLandingRefLoc;
            int jumpStartRefLoc;
            oneYieldToTwo = one.forwardStrand != two.forwardStrand ? (jumpStartRefLoc = one.referenceSpan.getEnd()) <= (jumpLandingRefLoc = two.referenceSpan.getStart()) == one.forwardStrand : one.forwardStrand;
        } else {
            if (refSequenceDictionary == null) {
                throw new IllegalArgumentException("despite input alignments mapped to different chromosomes, input reference sequence dictionary is null. " + one.toPackedString() + "\t" + two.toPackedString());
            }
            oneYieldToTwo = IntervalUtils.compareContigs(one.referenceSpan, two.referenceSpan, refSequenceDictionary) > 0;
        }
        return oneYieldToTwo;
    }

    public static VariantContext toVariantContext(CpxVariantCanonicalRepresentation cpxVariantCanonicalRepresentation, Iterable<CpxVariantInducingAssemblyContig> evidenceContigs, BasicReference reference) {
        SimpleInterval refRegion = cpxVariantCanonicalRepresentation.getAffectedRefRegion();
        byte[] refBases = reference.getBases(new SimpleInterval(refRegion.getContig(), refRegion.getStart(), refRegion.getStart()));
        VariantContextBuilder rawVariantContextBuilder = cpxVariantCanonicalRepresentation.toVariantContext(refBases);
        if (Utils.stream(evidenceContigs).anyMatch(evidenceContig -> evidenceContig.getPreprocessedTig().getAlignments().size() == 0)) {
            throw new GATKException("Some contigs were unmapped, yet seem to be used for inference.\n" + cpxVariantCanonicalRepresentation.toString() + Utils.stream(evidenceContigs).map(tig -> tig.getPreprocessedTig().getContigName()).collect(Collectors.toList()));
        }
        ArrayList contigNames = new ArrayList();
        ArrayList mayContainNoInfoOnNonCanonicalMapping = new ArrayList();
        ArrayList minFlankingMQs = new ArrayList();
        ArrayList minFlankingLengths = new ArrayList();
        Utils.stream(evidenceContigs).sorted(Comparator.comparing(tig -> tig.getPreprocessedTig().getContigName())).forEach(annotatedCpxInducingContig -> {
            AssemblyContigWithFineTunedAlignments preprocessedTig = annotatedCpxInducingContig.getPreprocessedTig();
            contigNames.add(preprocessedTig.getContigName());
            String saTagForGoodMappingToNonCanonicalChromosome = preprocessedTig.getSAtagForGoodMappingToNonCanonicalChromosome();
            if (!saTagForGoodMappingToNonCanonicalChromosome.equals("NONE")) {
                mayContainNoInfoOnNonCanonicalMapping.add(saTagForGoodMappingToNonCanonicalChromosome);
            } else {
                mayContainNoInfoOnNonCanonicalMapping.add(".");
            }
            minFlankingMQs.add(String.valueOf(Math.min(preprocessedTig.getHeadAlignment().mapQual, preprocessedTig.getTailAlignment().mapQual)));
            int minAlnLen = Math.min(preprocessedTig.getHeadAlignment().getSizeOnRead(), preprocessedTig.getTailAlignment().getSizeOnRead());
            minFlankingLengths.add(String.valueOf(minAlnLen));
        });
        HashMap<String, String> attributeMap = new HashMap<String, String>();
        attributeMap.put("TOTAL_MAPPINGS", String.valueOf(contigNames.size()));
        attributeMap.put("CTG_NAMES", String.join((CharSequence)",", contigNames));
        if (!mayContainNoInfoOnNonCanonicalMapping.equals(Collections.nCopies(contigNames.size(), "."))) {
            attributeMap.put("CTG_GOOD_NONCANONICAL_MAPPING", String.join((CharSequence)",", mayContainNoInfoOnNonCanonicalMapping));
        }
        attributeMap.put("HQ_MAPPINGS", String.valueOf(minFlankingMQs.stream().mapToInt(Integer::valueOf).filter(mq -> mq >= 60).count()));
        attributeMap.put("MAPPING_QUALITIES", String.join((CharSequence)",", minFlankingMQs));
        attributeMap.put("ALIGN_LENGTHS", String.join((CharSequence)",", minFlankingLengths));
        attributeMap.put("MAX_ALIGN_LENGTH", String.valueOf(minFlankingLengths.stream().mapToInt(Integer::valueOf).max().orElse(0)));
        attributeMap.forEach((arg_0, arg_1) -> ((VariantContextBuilder)rawVariantContextBuilder).attribute(arg_0, arg_1));
        return rawVariantContextBuilder.make();
    }

    static final class UnhandledCaseSeen
    extends GATKException.ShouldNeverReachHereException {
        private static final long serialVersionUID = 0L;

        UnhandledCaseSeen(String s) {
            super(s);
        }

        UnhandledCaseSeen(String s, Throwable throwable) {
            super(s, throwable);
        }

        UnhandledCaseSeen(Throwable throwable) {
            this("Seeing unhandled case", throwable);
        }
    }
}

