/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.spark.sv.discovery.inference;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.vcf.VCFHeader;
import htsjdk.variant.vcf.VCFHeaderLine;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.http.annotation.Experimental;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.ArgumentCollection;
import org.broadinstitute.barclay.argparser.BetaFeature;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.cmdline.programgroups.StructuralVariantDiscoveryProgramGroup;
import org.broadinstitute.hellbender.engine.filters.ReadFilter;
import org.broadinstitute.hellbender.engine.filters.ReadFilterLibrary;
import org.broadinstitute.hellbender.engine.spark.GATKSparkTool;
import org.broadinstitute.hellbender.engine.spark.datasources.VariantsSparkSource;
import org.broadinstitute.hellbender.tools.spark.sv.StructuralVariationDiscoveryArgumentCollection;
import org.broadinstitute.hellbender.tools.spark.sv.discovery.SvDiscoveryInputMetaData;
import org.broadinstitute.hellbender.tools.spark.sv.discovery.inference.SegmentedCpxVariantSimpleVariantExtractor;
import org.broadinstitute.hellbender.tools.spark.sv.utils.SVVCFWriter;
import org.broadinstitute.hellbender.utils.read.GATKRead;

@DocumentedFeature
@BetaFeature
@CommandLineProgramProperties(oneLineSummary="(Internal) Tries to extract simple variants from a provided GATK-SV CPX.vcf", summary="This tool is used in development and should not be of interest to most researchers. It is a prototype of complex structural variant re-interpretation. In particular, it tries to extract basic SVTYPE's from a user-provided GATK-SV CPX.vcf, and outputs two VCF files containing bare bone information on the simple variants.", programGroup=StructuralVariantDiscoveryProgramGroup.class)
@Experimental
public class CpxVariantReInterpreterSpark
extends GATKSparkTool {
    private static final long serialVersionUID = 1L;
    private final Logger localLogger = LogManager.getLogger(CpxVariantReInterpreterSpark.class);
    @ArgumentCollection
    private StructuralVariationDiscoveryArgumentCollection.DiscoverVariantsFromContigAlignmentsArgumentCollection discoverStageArgs = new StructuralVariationDiscoveryArgumentCollection.DiscoverVariantsFromContigAlignmentsArgumentCollection();
    @Argument(doc="file containing non-canonical chromosome names (e.g chrUn_KI270588v1) in the reference, human reference (hg19 or hg38) assumed when omitted", shortName="alt-tigs", fullName="non-canonical-contig-names-file", optional=true)
    public String nonCanonicalChromosomeNamesFile;
    @Argument(doc="file containing complex variants as output by GATK-SV", fullName="cpx-vcf")
    private String complexVCF;
    @Argument(doc="prefix for two files containing derived simple variants for complex variants having one/multiple entry in SEGMENT annotation", fullName="prefix-out-vcf")
    private String derivedSimpleVCFPrefix;

    @Override
    public boolean requiresReference() {
        return true;
    }

    @Override
    public boolean requiresReads() {
        return true;
    }

    @Override
    public List<ReadFilter> getDefaultReadFilters() {
        return Collections.singletonList(ReadFilterLibrary.MAPPED);
    }

    @Override
    protected void runTool(JavaSparkContext ctx) {
        SAMFileHeader headerForReads = this.getHeaderForReads();
        Set<VCFHeaderLine> defaultToolVCFHeaderLines = this.getDefaultToolVCFHeaderLines();
        SvDiscoveryInputMetaData svDiscoveryInputMetaData = new SvDiscoveryInputMetaData(ctx, this.discoverStageArgs, this.nonCanonicalChromosomeNamesFile, this.derivedSimpleVCFPrefix, null, null, null, null, headerForReads, this.getReference(), defaultToolVCFHeaderLines, this.localLogger);
        JavaRDD<VariantContext> complexVariants = new VariantsSparkSource(ctx).getParallelVariantContexts(this.complexVCF, this.getIntervals());
        JavaRDD<GATKRead> assemblyRawAlignments = this.getReads();
        SegmentedCpxVariantSimpleVariantExtractor.ExtractedSimpleVariants extract = SegmentedCpxVariantSimpleVariantExtractor.extract(complexVariants, svDiscoveryInputMetaData, assemblyRawAlignments);
        String derivedOneSegmentSimpleVCF = this.derivedSimpleVCFPrefix + "_1_seg.vcf";
        String derivedMultiSegmentSimpleVCF = this.derivedSimpleVCFPrefix + "_multi_seg.vcf";
        VCFHeader vcfHeader = VariantsSparkSource.getHeader(this.complexVCF);
        SVVCFWriter.writeVCF(extract.getReInterpretZeroOrOneSegmentCalls(), derivedOneSegmentSimpleVCF, vcfHeader.getSequenceDictionary(), defaultToolVCFHeaderLines, this.logger);
        SVVCFWriter.writeVCF(extract.getReInterpretMultiSegmentsCalls(), derivedMultiSegmentSimpleVCF, vcfHeader.getSequenceDictionary(), defaultToolVCFHeaderLines, this.logger);
    }
}

