/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.spark.sv.discovery.inference;

import htsjdk.variant.variantcontext.VariantContext;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Logger;
import org.broadinstitute.hellbender.engine.spark.datasources.ReferenceMultiSparkSource;
import org.broadinstitute.hellbender.tools.spark.sv.discovery.AnnotatedVariantProducer;
import org.broadinstitute.hellbender.tools.spark.sv.discovery.SimpleSVType;
import org.broadinstitute.hellbender.tools.spark.sv.evidence.EvidenceTargetLink;
import org.broadinstitute.hellbender.tools.spark.sv.evidence.ReadMetadata;
import org.broadinstitute.hellbender.tools.spark.sv.utils.PairedStrandedIntervalTree;
import org.broadinstitute.hellbender.utils.Utils;

public class ImpreciseVariantDetector {
    public static List<VariantContext> callImpreciseDeletionFromEvidenceLinks(PairedStrandedIntervalTree<EvidenceTargetLink> evidenceTargetLinks, ReadMetadata metadata, ReferenceMultiSparkSource reference, int impreciseVariantEvidenceThreshold, int maxCallableImpreciseVariantDeletionSize, Logger localLogger) {
        List<VariantContext> impreciseVariants = Utils.stream(evidenceTargetLinks).map(p -> (EvidenceTargetLink)p._2).filter(EvidenceTargetLink::isImpreciseDeletion).filter(e -> e.getDistance() < maxCallableImpreciseVariantDeletionSize).filter(e -> e.getReadPairs() + e.getSplitReads() > impreciseVariantEvidenceThreshold).map(e -> ImpreciseVariantDetector.createImpreciseDeletionVariant(e, metadata, reference)).collect(Collectors.toList());
        localLogger.info("Called " + impreciseVariants.size() + " imprecise deletion variants");
        return impreciseVariants;
    }

    private static VariantContext createImpreciseDeletionVariant(EvidenceTargetLink e, ReadMetadata metadata, ReferenceMultiSparkSource reference) {
        int svLength = e.getPairedStrandedIntervals().getLeft().getInterval().midpoint() - e.getPairedStrandedIntervals().getRight().getInterval().midpoint();
        SimpleSVType.ImpreciseDeletion svType = new SimpleSVType.ImpreciseDeletion(e, svLength, metadata, reference);
        return AnnotatedVariantProducer.produceAnnotatedVcFromEvidenceTargetLink(e, svType);
    }
}

