/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.spark.sv.discovery.inference;

import com.esotericsoftware.kryo.DefaultSerializer;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.google.common.annotations.VisibleForTesting;
import htsjdk.samtools.SAMSequenceDictionary;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.broadinstitute.hellbender.engine.BasicReference;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.tools.spark.sv.discovery.BreakEndVariantType;
import org.broadinstitute.hellbender.tools.spark.sv.discovery.SimpleSVType;
import org.broadinstitute.hellbender.tools.spark.sv.discovery.SvType;
import org.broadinstitute.hellbender.tools.spark.sv.discovery.alignment.StrandSwitch;
import org.broadinstitute.hellbender.tools.spark.sv.discovery.inference.BreakpointComplications;
import org.broadinstitute.hellbender.tools.spark.sv.discovery.inference.BreakpointsInference;
import org.broadinstitute.hellbender.tools.spark.sv.discovery.inference.SimpleChimera;
import org.broadinstitute.hellbender.tools.spark.sv.discovery.inference.TypeInferredFromSimpleChimera;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import scala.Tuple2;

@DefaultSerializer(value=Serializer.class)
public class NovelAdjacencyAndAltHaplotype {
    private final SimpleInterval leftJustifiedLeftRefLoc;
    private final SimpleInterval leftJustifiedRightRefLoc;
    private final StrandSwitch strandSwitch;
    private final BreakpointComplications complication;
    private final TypeInferredFromSimpleChimera type;
    private final byte[] altHaplotypeSequence;

    @VisibleForTesting
    public NovelAdjacencyAndAltHaplotype(SimpleInterval leftJustifiedLeftRefLoc, SimpleInterval leftJustifiedRightRefLoc, StrandSwitch strandSwitch, BreakpointComplications complication, TypeInferredFromSimpleChimera type, byte[] altHaplotypeSequence) {
        this.leftJustifiedLeftRefLoc = leftJustifiedLeftRefLoc;
        this.leftJustifiedRightRefLoc = leftJustifiedRightRefLoc;
        this.strandSwitch = strandSwitch;
        this.complication = complication;
        this.type = type;
        this.altHaplotypeSequence = altHaplotypeSequence;
    }

    public NovelAdjacencyAndAltHaplotype(SimpleChimera simpleChimera, byte[] contigSequence, SAMSequenceDictionary referenceDictionary) {
        this.strandSwitch = simpleChimera.strandSwitch;
        try {
            BreakpointsInference inferredClass = BreakpointsInference.getInferenceClass(simpleChimera, contigSequence, referenceDictionary);
            Tuple2<SimpleInterval, SimpleInterval> leftJustifiedBreakpoints = inferredClass.getLeftJustifiedBreakpoints();
            this.leftJustifiedLeftRefLoc = (SimpleInterval)leftJustifiedBreakpoints._1();
            this.leftJustifiedRightRefLoc = (SimpleInterval)leftJustifiedBreakpoints._2();
            this.complication = inferredClass.getComplications();
            this.type = simpleChimera.inferType(referenceDictionary);
            this.altHaplotypeSequence = inferredClass.getInferredAltHaplotypeSequence();
        }
        catch (IllegalArgumentException iaex) {
            throw new GATKException("Erred when inferring breakpoint location and event type from chimeric alignment:\n" + simpleChimera.toString(), iaex);
        }
    }

    public boolean hasInsertedSequence() {
        return !this.complication.getInsertedSequenceForwardStrandRep().isEmpty();
    }

    public boolean hasDuplicationAnnotation() {
        return this.complication.hasDuplicationAnnotation();
    }

    protected NovelAdjacencyAndAltHaplotype(Kryo kryo, Input input) {
        String contig1 = input.readString();
        int start1 = input.readInt();
        int end1 = input.readInt();
        this.leftJustifiedLeftRefLoc = new SimpleInterval(contig1, start1, end1);
        String contig2 = input.readString();
        int start2 = input.readInt();
        int end2 = input.readInt();
        this.leftJustifiedRightRefLoc = new SimpleInterval(contig2, start2, end2);
        this.strandSwitch = StrandSwitch.values()[input.readInt()];
        this.complication = (BreakpointComplications)kryo.readClassAndObject(input);
        this.type = TypeInferredFromSimpleChimera.values()[input.readInt()];
        boolean altSeqIsNull = input.readBoolean();
        if (altSeqIsNull) {
            this.altHaplotypeSequence = null;
        } else {
            int arraySize = input.readInt();
            this.altHaplotypeSequence = new byte[arraySize];
            for (int i = 0; i < arraySize; ++i) {
                this.altHaplotypeSequence[i] = input.readByte();
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NovelAdjacencyAndAltHaplotype that = (NovelAdjacencyAndAltHaplotype)o;
        if (!this.leftJustifiedLeftRefLoc.equals(that.leftJustifiedLeftRefLoc)) {
            return false;
        }
        if (!this.leftJustifiedRightRefLoc.equals(that.leftJustifiedRightRefLoc)) {
            return false;
        }
        if (this.strandSwitch != that.strandSwitch) {
            return false;
        }
        if (!this.complication.equals(that.complication)) {
            return false;
        }
        return Arrays.equals(this.altHaplotypeSequence, that.altHaplotypeSequence);
    }

    public int hashCode() {
        int result = this.leftJustifiedLeftRefLoc.hashCode();
        result = 31 * result + this.leftJustifiedRightRefLoc.hashCode();
        result = 31 * result + this.strandSwitch.ordinal();
        result = 31 * result + this.complication.hashCode();
        result = 31 * result + Arrays.hashCode(this.altHaplotypeSequence);
        return result;
    }

    protected void serialize(Kryo kryo, Output output) {
        output.writeString(this.leftJustifiedLeftRefLoc.getContig());
        output.writeInt(this.leftJustifiedLeftRefLoc.getStart());
        output.writeInt(this.leftJustifiedLeftRefLoc.getEnd());
        output.writeString(this.leftJustifiedRightRefLoc.getContig());
        output.writeInt(this.leftJustifiedRightRefLoc.getStart());
        output.writeInt(this.leftJustifiedRightRefLoc.getEnd());
        output.writeInt(this.strandSwitch.ordinal());
        kryo.writeClassAndObject(output, (Object)this.complication);
        output.writeInt(this.type.ordinal());
        if (this.altHaplotypeSequence == null) {
            output.writeBoolean(true);
        } else {
            output.writeBoolean(false);
            output.writeInt(this.altHaplotypeSequence.length);
            for (byte b : this.altHaplotypeSequence) {
                output.writeByte(b);
            }
        }
    }

    public SimpleInterval getLeftJustifiedLeftRefLoc() {
        return this.leftJustifiedLeftRefLoc;
    }

    public SimpleInterval getLeftJustifiedRightRefLoc() {
        return this.leftJustifiedRightRefLoc;
    }

    public StrandSwitch getStrandSwitch() {
        return this.strandSwitch;
    }

    public BreakpointComplications getComplication() {
        return this.complication;
    }

    public TypeInferredFromSimpleChimera getTypeInferredFromSimpleChimera() {
        return this.type;
    }

    public byte[] getAltHaplotypeSequence() {
        return this.altHaplotypeSequence;
    }

    public int getDistanceBetweenNovelAdjacencies() {
        if (this.leftJustifiedLeftRefLoc.getContig().equals(this.leftJustifiedRightRefLoc.getContig())) {
            return this.leftJustifiedRightRefLoc.getEnd() - this.leftJustifiedLeftRefLoc.getStart();
        }
        return -1;
    }

    public boolean isCandidateForFatInsertion() {
        return this.type.equals((Object)TypeInferredFromSimpleChimera.RPL) && this.leftJustifiedRightRefLoc.getEnd() - this.leftJustifiedLeftRefLoc.getStart() < 50;
    }

    public SimpleInterval getIntervalForFatInsertion() {
        if (this.isCandidateForFatInsertion()) {
            return new SimpleInterval(this.leftJustifiedLeftRefLoc.getContig(), this.leftJustifiedLeftRefLoc.getStart(), this.leftJustifiedRightRefLoc.getEnd());
        }
        throw new UnsupportedOperationException("trying to get interval from a novel adjacency that is not a fat insertion: " + this.toString());
    }

    @VisibleForTesting
    public List<SvType> toSimpleOrBNDTypes(BasicReference reference) {
        switch (this.type) {
            case INTER_CHR_STRAND_SWITCH_55: 
            case INTER_CHR_STRAND_SWITCH_33: 
            case INTER_CHR_NO_SS_WITH_LEFT_MATE_FIRST_IN_PARTNER: 
            case INTER_CHR_NO_SS_WITH_LEFT_MATE_SECOND_IN_PARTNER: {
                Tuple2<BreakEndVariantType, BreakEndVariantType> orderedMatesForTranslocSuspect = BreakEndVariantType.InterChromosomeBreakend.getOrderedMates(this, reference);
                return Arrays.asList((SvType)orderedMatesForTranslocSuspect._1, (SvType)orderedMatesForTranslocSuspect._2);
            }
            case INTRA_CHR_REF_ORDER_SWAP: {
                Tuple2<BreakEndVariantType, BreakEndVariantType> orderedMatesForTranslocSuspect = BreakEndVariantType.IntraChromosomeRefOrderSwap.getOrderedMates(this, reference);
                return Arrays.asList((SvType)orderedMatesForTranslocSuspect._1, (SvType)orderedMatesForTranslocSuspect._2);
            }
            case INTRA_CHR_STRAND_SWITCH_55: 
            case INTRA_CHR_STRAND_SWITCH_33: {
                if (this.complication.hasDuplicationAnnotation()) {
                    return Collections.singletonList(new SimpleSVType.DuplicationInverted(this, reference));
                }
                if (this.strandSwitch.equals((Object)StrandSwitch.FORWARD_TO_REVERSE)) {
                    Tuple2<BreakEndVariantType, BreakEndVariantType> orderedMatesForInversionSuspect = BreakEndVariantType.IntraChromosomalStrandSwitch55BreakEnd.getOrderedMates(this, reference);
                    return Arrays.asList((SvType)orderedMatesForInversionSuspect._1, (SvType)orderedMatesForInversionSuspect._2);
                }
                Tuple2<BreakEndVariantType, BreakEndVariantType> orderedMatesForInversionSuspect = BreakEndVariantType.IntraChromosomalStrandSwitch33BreakEnd.getOrderedMates(this, reference);
                return Arrays.asList((SvType)orderedMatesForInversionSuspect._1, (SvType)orderedMatesForInversionSuspect._2);
            }
            case SIMPLE_DEL: 
            case DEL_DUP_CONTRACTION: {
                return Collections.singletonList(new SimpleSVType.Deletion(this, reference));
            }
            case RPL: {
                if (this.isCandidateForFatInsertion()) {
                    return Collections.singletonList(new SimpleSVType.Insertion(this, reference));
                }
                SimpleSVType.Deletion deletion = new SimpleSVType.Deletion(this, reference);
                if (this.complication.getInsertedSequenceForwardStrandRep().length() < 50) {
                    return Collections.singletonList(deletion);
                }
                SimpleSVType.Insertion insertion = new SimpleSVType.Insertion(this, reference);
                return Arrays.asList(deletion, insertion);
            }
            case SIMPLE_INS: {
                return Collections.singletonList(new SimpleSVType.Insertion(this, reference));
            }
            case SMALL_DUP_EXPANSION: {
                BreakpointComplications.SmallDuplicationWithPreciseDupRangeBreakpointComplications duplicationComplication = (BreakpointComplications.SmallDuplicationWithPreciseDupRangeBreakpointComplications)this.getComplication();
                if (duplicationComplication.getDupSeqRepeatUnitRefSpan().size() < 50) {
                    return Collections.singletonList(new SimpleSVType.Insertion(this, reference));
                }
                return Collections.singletonList(new SimpleSVType.DuplicationTandem(this, reference));
            }
            case SMALL_DUP_CPX: {
                BreakpointComplications.SmallDuplicationWithImpreciseDupRangeBreakpointComplications duplicationComplication = (BreakpointComplications.SmallDuplicationWithImpreciseDupRangeBreakpointComplications)this.getComplication();
                if (duplicationComplication.isDupContraction()) {
                    return Collections.singletonList(new SimpleSVType.Deletion(this, reference));
                }
                if (duplicationComplication.getDupSeqRepeatUnitRefSpan().size() < 50) {
                    return Collections.singletonList(new SimpleSVType.Insertion(this, reference));
                }
                return Collections.singletonList(new SimpleSVType.DuplicationTandem(this, reference));
            }
        }
        throw new GATKException.ShouldNeverReachHereException("Inferred type not recognized");
    }

    public int getLengthForDupTandemExpansion() {
        BreakpointComplications.SmallDuplicationBreakpointComplications dupComplication = (BreakpointComplications.SmallDuplicationBreakpointComplications)this.getComplication();
        if (dupComplication.isDupContraction()) {
            throw new UnsupportedOperationException("Trying to extract length from a duplication contraction: " + this.toString());
        }
        return dupComplication.getInsertedSequenceForwardStrandRep().length() + (dupComplication.getDupSeqRepeatNumOnCtg() - dupComplication.getDupSeqRepeatNumOnRef()) * dupComplication.getDupSeqRepeatUnitRefSpan().size();
    }

    public String toString() {
        return String.format("%s\t%s\t%s\t%s", this.leftJustifiedLeftRefLoc.toString(), this.leftJustifiedRightRefLoc.toString(), this.strandSwitch.name(), this.complication.toString());
    }

    public static final class Serializer
    extends com.esotericsoftware.kryo.Serializer<NovelAdjacencyAndAltHaplotype> {
        public void write(Kryo kryo, Output output, NovelAdjacencyAndAltHaplotype novelAdjacencyAndAltHaplotype) {
            novelAdjacencyAndAltHaplotype.serialize(kryo, output);
        }

        public NovelAdjacencyAndAltHaplotype read(Kryo kryo, Input input, Class<NovelAdjacencyAndAltHaplotype> klass) {
            return new NovelAdjacencyAndAltHaplotype(kryo, input);
        }
    }
}

