/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.spark.sv.discovery.inference;

import com.google.common.annotations.VisibleForTesting;
import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.VariantContextBuilder;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.PairFlatMapFunction;
import org.apache.spark.broadcast.Broadcast;
import org.broadinstitute.hellbender.engine.BasicReference;
import org.broadinstitute.hellbender.engine.spark.datasources.ReferenceMultiSparkSource;
import org.broadinstitute.hellbender.tools.spark.sv.discovery.SimpleSVType;
import org.broadinstitute.hellbender.tools.spark.sv.discovery.SvDiscoverFromLocalAssemblyContigAlignmentsSpark;
import org.broadinstitute.hellbender.tools.spark.sv.discovery.SvDiscoveryInputMetaData;
import org.broadinstitute.hellbender.tools.spark.sv.discovery.alignment.AlignedContig;
import org.broadinstitute.hellbender.tools.spark.sv.discovery.alignment.AssemblyContigWithFineTunedAlignments;
import org.broadinstitute.hellbender.tools.spark.sv.discovery.inference.ContigChimericAlignmentIterativeInterpreter;
import org.broadinstitute.hellbender.tools.spark.sv.utils.SVInterval;
import org.broadinstitute.hellbender.tools.spark.sv.utils.SVUtils;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.read.GATKRead;
import scala.Tuple2;
import scala.Tuple3;

public abstract class SegmentedCpxVariantSimpleVariantExtractor
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static int EVENT_SIZE_THRESHOLD = 49;
    private static final String CPX_DERIVED_POSTFIX_STRING = "CPX_DERIVED";
    private static final Allele altSymbAlleleDel = Allele.create((String)SimpleSVType.createBracketedSymbAlleleString("DEL"));
    private static final Allele altSymbAlleleIns = Allele.create((String)SimpleSVType.createBracketedSymbAlleleString("INS"));
    private static final Allele altSymbAlleleInv = Allele.create((String)SimpleSVType.createBracketedSymbAlleleString("INV"));

    private static String makeID(String typeName, String chr, int start, int stop) {
        return typeName + "_" + chr + "_" + start + "_" + stop + "_" + CPX_DERIVED_POSTFIX_STRING;
    }

    public static ExtractedSimpleVariants extract(JavaRDD<VariantContext> complexVariants, SvDiscoveryInputMetaData svDiscoveryInputMetaData, JavaRDD<GATKRead> assemblyRawAlignments) {
        Broadcast<ReferenceMultiSparkSource> referenceBroadcast = svDiscoveryInputMetaData.getReferenceData().getReferenceBroadcast();
        ZeroAndOneSegmentCpxVariantExtractor zeroAndOneSegmentCpxVariantExtractor = new ZeroAndOneSegmentCpxVariantExtractor();
        JavaRDD zeroOrOneSegmentComplexVariants = complexVariants.filter((Function & Serializable)vc -> SVUtils.getAttributeAsStringList(vc, "SEGMENTS").size() < 2).cache();
        List reInterpretedZeroAndOneSegmentCalls = zeroOrOneSegmentComplexVariants.flatMap((FlatMapFunction & Serializable)vc -> zeroAndOneSegmentCpxVariantExtractor.extract((VariantContext)vc, (BasicReference)referenceBroadcast.getValue()).iterator()).collect();
        zeroOrOneSegmentComplexVariants.unpersist(false);
        JavaRDD multiSegmentCalls = complexVariants.filter((Function & Serializable)vc -> SVUtils.getAttributeAsStringList(vc, "SEGMENTS").size() > 1).cache();
        MultiSegmentsCpxVariantExtractor multiSegmentsCpxVariantExtractor = new MultiSegmentsCpxVariantExtractor();
        List sourceWithLessAnnotations = multiSegmentCalls.flatMap((FlatMapFunction & Serializable)vc -> multiSegmentsCpxVariantExtractor.extract((VariantContext)vc, (BasicReference)referenceBroadcast.getValue()).iterator()).collect();
        List<VariantContext> sourceWithMoreAnnotations = SegmentedCpxVariantSimpleVariantExtractor.reInterpretMultiSegmentComplexVarThroughAlignmentPairIteration((JavaRDD<VariantContext>)multiSegmentCalls, svDiscoveryInputMetaData, assemblyRawAlignments);
        List<VariantContext> reInterpretMultiSegmentsCalls = SegmentedCpxVariantSimpleVariantExtractor.removeDuplicates(sourceWithLessAnnotations, sourceWithMoreAnnotations);
        multiSegmentCalls.unpersist(false);
        return new ExtractedSimpleVariants(reInterpretedZeroAndOneSegmentCalls, reInterpretMultiSegmentsCalls);
    }

    public static List<VariantContext> reInterpretMultiSegmentComplexVarThroughAlignmentPairIteration(JavaRDD<VariantContext> multiSegmentCalls, SvDiscoveryInputMetaData svDiscoveryInputMetaData, JavaRDD<GATKRead> assemblyRawAlignments) {
        Map contigNameToCpxVariantAttributes = multiSegmentCalls.flatMapToPair((PairFlatMapFunction & Serializable)complex -> {
            RelevantAttributes relevantAttributes = new RelevantAttributes((VariantContext)complex);
            return SVUtils.getAttributeAsStringList(complex, "CTG_NAMES").stream().map(name -> new Tuple2(name, (Object)relevantAttributes)).iterator();
        }).collectAsMap();
        HashSet relevantContigs = new HashSet(contigNameToCpxVariantAttributes.keySet());
        JavaRDD relevantAlignments = assemblyRawAlignments.filter((Function & Serializable)read -> relevantContigs.contains(read.getName()));
        JavaRDD analysisReadyContigs = SvDiscoverFromLocalAssemblyContigAlignmentsSpark.preprocess(svDiscoveryInputMetaData, (JavaRDD<GATKRead>)relevantAlignments).getContigsWithSignatureClassifiedAsComplex().map(AssemblyContigWithFineTunedAlignments::getSourceContig);
        List<VariantContext> pairIterationReInterpreted = ContigChimericAlignmentIterativeInterpreter.discoverVariantsFromChimeras(svDiscoveryInputMetaData, (JavaRDD<AlignedContig>)analysisReadyContigs);
        Broadcast<ReferenceMultiSparkSource> referenceBroadcast = svDiscoveryInputMetaData.getReferenceData().getReferenceBroadcast();
        return pairIterationReInterpreted.stream().map(vc -> {
            List consistentComplexVariantIDs = SVUtils.getAttributeAsStringList(vc, "CTG_NAMES").stream().map(contigNameToCpxVariantAttributes::get).filter(attributes -> SegmentedCpxVariantSimpleVariantExtractor.isConsistentWithCPX(vc, attributes)).map(attributes -> ((RelevantAttributes)attributes).id).collect(Collectors.toList());
            if (consistentComplexVariantIDs.isEmpty()) {
                return null;
            }
            return new VariantContextBuilder(vc).id(vc.getID() + "_" + CPX_DERIVED_POSTFIX_STRING).attribute("CPX_EVENT", (Object)String.join((CharSequence)",", consistentComplexVariantIDs)).make();
        }).filter(Objects::nonNull).map(SegmentedCpxVariantSimpleVariantExtractor::postProcessConvertShortDupToIns).flatMap(simple -> SegmentedCpxVariantSimpleVariantExtractor.postProcessConvertReplacementToFatInsOrInsAndDel(simple, (BasicReference)referenceBroadcast.getValue())).collect(Collectors.toList());
    }

    public static List<VariantContext> filterForConsistency(List<VariantContext> variants, Map<String, RelevantAttributes> contigNameToCpxVariantAttributes, BasicReference reference) {
        return variants.stream().map(vc -> {
            List consistentComplexVariantIDs = SVUtils.getAttributeAsStringList(vc, "CTG_NAMES").stream().map(contigNameToCpxVariantAttributes::get).filter(attributes -> SegmentedCpxVariantSimpleVariantExtractor.isConsistentWithCPX(vc, attributes)).map(attributes -> ((RelevantAttributes)attributes).id).collect(Collectors.toList());
            if (consistentComplexVariantIDs.isEmpty()) {
                return null;
            }
            return new VariantContextBuilder(vc).id(vc.getID() + "_" + CPX_DERIVED_POSTFIX_STRING).attribute("CPX_EVENT", (Object)String.join((CharSequence)",", consistentComplexVariantIDs)).make();
        }).filter(Objects::nonNull).map(SegmentedCpxVariantSimpleVariantExtractor::postProcessConvertShortDupToIns).flatMap(simple -> SegmentedCpxVariantSimpleVariantExtractor.postProcessConvertReplacementToFatInsOrInsAndDel(simple, reference)).collect(Collectors.toList());
    }

    @VisibleForTesting
    static VariantContext postProcessConvertShortDupToIns(VariantContext simple) {
        String type = simple.getAttributeAsString("SVTYPE", "");
        if (type.equals(SimpleSVType.SupportedType.DUP.name())) {
            SimpleInterval duplicatedRegion = new SimpleInterval(simple.getAttributeAsString("DUP_REPEAT_UNIT_REF_SPAN", ""));
            if (duplicatedRegion.size() > EVENT_SIZE_THRESHOLD) {
                return simple;
            }
            return new VariantContextBuilder(simple).alleles(Arrays.asList(simple.getReference(), altSymbAlleleIns)).rmAttribute("SVTYPE").attribute("SVTYPE", (Object)SimpleSVType.SupportedType.INS.name()).make();
        }
        return simple;
    }

    @VisibleForTesting
    static Stream<VariantContext> postProcessConvertReplacementToFatInsOrInsAndDel(VariantContext simple, BasicReference reference) {
        String type = simple.getAttributeAsString("SVTYPE", "");
        if (type.equals(SimpleSVType.SupportedType.DEL.name())) {
            int deletionLen = -simple.getAttributeAsInt("SVLEN", 0);
            int insLen = simple.getAttributeAsInt("INSLEN", 0);
            if (insLen > EVENT_SIZE_THRESHOLD && deletionLen > EVENT_SIZE_THRESHOLD) {
                HashMap<String, Object> attributes = new HashMap<String, Object>(simple.getAttributes());
                attributes.remove("INSSEQ_MAP");
                attributes.remove("SVLEN");
                attributes.remove("SVTYPE");
                VariantContextBuilder newInsertion = SegmentedCpxVariantSimpleVariantExtractor.makeInsertion(simple.getContig(), simple.getStart(), simple.getStart(), insLen, simple.getReference());
                attributes.forEach((arg_0, arg_1) -> ((VariantContextBuilder)newInsertion).attribute(arg_0, arg_1));
                newInsertion.rmAttribute("HOMSEQ").rmAttribute("HOMLEN");
                newInsertion.rmAttribute("END").attribute("END", (Object)simple.getStart());
                VariantContextBuilder newDeletion = SegmentedCpxVariantSimpleVariantExtractor.makeDeletion(new SimpleInterval(simple.getContig(), simple.getStart(), simple.getEnd()), simple.getReference());
                attributes.forEach((arg_0, arg_1) -> ((VariantContextBuilder)newDeletion).attribute(arg_0, arg_1));
                newDeletion.rmAttribute("INSSEQ").rmAttribute("INSLEN").rmAttribute("SEQ_ALT_HAPLOTYPE");
                newInsertion.attribute("LINK", (Object)SegmentedCpxVariantSimpleVariantExtractor.makeID(SimpleSVType.SupportedType.DEL.name(), simple.getContig(), simple.getStart(), simple.getEnd()));
                newDeletion.attribute("LINK", (Object)SegmentedCpxVariantSimpleVariantExtractor.makeID(SimpleSVType.SupportedType.INS.name(), simple.getContig(), simple.getStart(), simple.getStart()));
                return Stream.of(newDeletion.make(), newInsertion.make());
            }
            if (insLen > EVENT_SIZE_THRESHOLD && deletionLen <= EVENT_SIZE_THRESHOLD) {
                String fatInsertionID = simple.getID().replace("DEL", "INS");
                HashMap<String, Object> attributes = new HashMap<String, Object>(simple.getAttributes());
                attributes.remove("INSSEQ_MAP");
                attributes.remove("HOMLEN");
                attributes.remove("HOMSEQ");
                attributes.remove("SVLEN");
                attributes.remove("SVTYPE");
                byte[] referenceBases = reference.getBases(new SimpleInterval(simple.getContig(), simple.getStart(), simple.getEnd()));
                VariantContextBuilder fatInsertion = SegmentedCpxVariantSimpleVariantExtractor.makeInsertion(simple.getContig(), simple.getStart(), simple.getEnd(), insLen, Allele.create((byte[])referenceBases, (boolean)true));
                attributes.forEach((arg_0, arg_1) -> ((VariantContextBuilder)fatInsertion).attribute(arg_0, arg_1));
                fatInsertion.id(fatInsertionID);
                return Stream.of(fatInsertion.make());
            }
            if (insLen <= EVENT_SIZE_THRESHOLD && deletionLen > EVENT_SIZE_THRESHOLD) {
                return Stream.of(simple);
            }
            return Stream.empty();
        }
        return Stream.of(simple);
    }

    @VisibleForTesting
    static boolean isConsistentWithCPX(VariantContext simple, RelevantAttributes attributes) {
        String typeString = simple.getAttributeAsString("SVTYPE", "");
        if (typeString.equals(SimpleSVType.SupportedType.DEL.name())) {
            List refSegments = attributes.referenceSegments;
            List altArrangement = attributes.altArrangements;
            Tuple3<Set<SimpleInterval>, Set<Integer>, List<Integer>> missingAndPresentAndInvertedSegments = SegmentedCpxVariantSimpleVariantExtractor.getMissingAndPresentAndInvertedSegments(refSegments, altArrangement);
            Set missingSegments = (Set)missingAndPresentAndInvertedSegments._1();
            return SegmentedCpxVariantSimpleVariantExtractor.deletionConsistencyCheck(simple, missingSegments);
        }
        return !typeString.equals(SimpleSVType.SupportedType.INV.name());
    }

    @VisibleForTesting
    static boolean deletionConsistencyCheck(VariantContext simple, Set<SimpleInterval> missingSegments) {
        if (missingSegments.isEmpty()) {
            return false;
        }
        SimpleInterval deletedRange = new SimpleInterval(simple.getContig(), simple.getStart() + 1, simple.getEnd());
        boolean dummyChr = false;
        SVInterval intervalOne = new SVInterval(0, deletedRange.getStart() - 1, deletedRange.getEnd());
        for (SimpleInterval missing : missingSegments) {
            if (!missing.overlaps(deletedRange)) {
                return false;
            }
            SVInterval intervalTwo = new SVInterval(0, missing.getStart() - 1, missing.getEnd());
            if (Math.abs(missing.size() - deletedRange.size()) > 2) {
                return false;
            }
            if (2 < Math.abs(Math.min(missing.size(), deletedRange.size()) - intervalTwo.overlapLen(intervalOne))) continue;
            return true;
        }
        return false;
    }

    private static Map<AnnotatedInterval, Tuple2<TreeSet<String>, TreeSet<String>>> getAnnotatedIntervalToSourceCpxIDsAndContigNames(List<VariantContext> extractedSimpleVariants) {
        return extractedSimpleVariants.stream().map(x$0 -> new AnnotatedInterval((VariantContext)x$0)).collect(Collectors.toCollection(HashSet::new)).stream().map(ai -> ((AnnotatedInterval)ai).sourceVC).collect(Collectors.toMap(x$0 -> new AnnotatedInterval((VariantContext)x$0), simpleVC -> {
            TreeSet<String> complexEvents = new TreeSet<String>(SVUtils.getAttributeAsStringList(simpleVC, "CPX_EVENT"));
            TreeSet<String> sourceCtgNames = new TreeSet<String>(SVUtils.getAttributeAsStringList(simpleVC, "CTG_NAMES"));
            return new Tuple2(complexEvents, sourceCtgNames);
        }));
    }

    @VisibleForTesting
    public static List<VariantContext> removeDuplicates(List<VariantContext> sourceWithLessAnnotations, List<VariantContext> sourceWithMoreAnnotations) {
        Map<AnnotatedInterval, Tuple2<TreeSet<String>, TreeSet<String>>> rangeToAnnotationsFromSourceWithLessAnnotations = SegmentedCpxVariantSimpleVariantExtractor.getAnnotatedIntervalToSourceCpxIDsAndContigNames(sourceWithLessAnnotations);
        Map<AnnotatedInterval, Tuple2<TreeSet<String>, TreeSet<String>>> rangeToAnnotationsFromSourceWithMoreAnnotations = SegmentedCpxVariantSimpleVariantExtractor.getAnnotatedIntervalToSourceCpxIDsAndContigNames(sourceWithMoreAnnotations);
        ArrayList<VariantContext> result = new ArrayList<VariantContext>(sourceWithMoreAnnotations.size() + sourceWithLessAnnotations.size());
        for (Map.Entry<AnnotatedInterval, Tuple2<TreeSet<String>, TreeSet<String>>> entry : rangeToAnnotationsFromSourceWithMoreAnnotations.entrySet()) {
            AnnotatedInterval interval2 = entry.getKey();
            Tuple2<TreeSet<String>, TreeSet<String>> sourceAttributes = entry.getValue();
            Tuple2<TreeSet<String>, TreeSet<String>> anotherSourceAttributes = rangeToAnnotationsFromSourceWithLessAnnotations.get(interval2);
            if (anotherSourceAttributes == null) {
                result.add(interval2.sourceVC);
                continue;
            }
            TreeSet sourceCpxIDs = (TreeSet)sourceAttributes._1;
            TreeSet sourceCtgNames = (TreeSet)sourceAttributes._2;
            sourceCpxIDs.addAll((Collection)anotherSourceAttributes._1);
            sourceCtgNames.addAll((Collection)anotherSourceAttributes._2);
            VariantContextBuilder variant = new VariantContextBuilder(interval2.sourceVC).rmAttribute("CPX_EVENT").attribute("CPX_EVENT", (Object)String.join((CharSequence)",", sourceCpxIDs)).rmAttribute("CTG_NAMES").attribute("CTG_NAMES", (Object)String.join((CharSequence)",", sourceCtgNames));
            result.add(variant.make());
            rangeToAnnotationsFromSourceWithLessAnnotations.remove(interval2);
        }
        rangeToAnnotationsFromSourceWithLessAnnotations.keySet().forEach(interval -> result.add(((AnnotatedInterval)interval).sourceVC));
        return result;
    }

    abstract List<VariantContext> extract(VariantContext var1, BasicReference var2);

    @VisibleForTesting
    static VariantContextBuilder getInsFromOneEnd(boolean fromFront, int idxFirstMatch, SimpleInterval insertionStartAndStop, Allele anchorBaseRefAllele, List<Integer> refSegmentLengths, List<String> altArrangement, boolean shouldIncreaseInsLenByOne) {
        int insLen = 0;
        if (fromFront) {
            for (int i = 0; i < idxFirstMatch; ++i) {
                insLen += SegmentedCpxVariantSimpleVariantExtractor.getInsLen(altArrangement.get(i), refSegmentLengths);
            }
        } else {
            for (int i = idxFirstMatch + 1; i < altArrangement.size(); ++i) {
                insLen += SegmentedCpxVariantSimpleVariantExtractor.getInsLen(altArrangement.get(i), refSegmentLengths);
            }
        }
        if (shouldIncreaseInsLenByOne) {
            ++insLen;
        }
        if (insLen > EVENT_SIZE_THRESHOLD) {
            return SegmentedCpxVariantSimpleVariantExtractor.makeInsertion(insertionStartAndStop.getContig(), insertionStartAndStop.getStart(), insertionStartAndStop.getEnd(), insLen, anchorBaseRefAllele);
        }
        return null;
    }

    @VisibleForTesting
    static int getInsLen(String description, List<Integer> refSegmentLengths) {
        if (description.startsWith("UINS")) {
            return Integer.valueOf(description.substring("UINS".length() + 1));
        }
        if (NumberUtils.isCreatable((String)description)) {
            int offset = description.startsWith("-") ? 1 : 0;
            return refSegmentLengths.get(Integer.valueOf(description.substring(offset)) - 1);
        }
        int offset = description.startsWith("-") ? 1 : 0;
        return new SimpleInterval(description.substring(offset)).size();
    }

    @VisibleForTesting
    static Tuple3<Set<SimpleInterval>, Set<Integer>, List<Integer>> getMissingAndPresentAndInvertedSegments(List<SimpleInterval> refSegments, List<String> altArrangements) {
        ArrayList invertedSegments = new ArrayList();
        TreeSet presentSegments = new TreeSet();
        altArrangements.forEach(s -> {
            if (s.startsWith("-") && !s.contains(":")) {
                invertedSegments.add(Integer.valueOf(s.substring(1)));
            }
            if (!(s.contains(":") || s.startsWith("UINS") || s.startsWith("-"))) {
                presentSegments.add(Integer.valueOf(s));
            }
        });
        Set missingSegments = IntStream.rangeClosed(1, refSegments.size()).boxed().filter(i -> !presentSegments.contains(i) && !invertedSegments.contains(i)).map(i -> (SimpleInterval)refSegments.get(i - 1)).collect(Collectors.toSet());
        return new Tuple3(missingSegments, presentSegments, invertedSegments);
    }

    private static Allele getAnchorBaseRefAllele(String chr, int pos, BasicReference reference) {
        return Allele.create((byte[])reference.getBases(SVUtils.makeOneBpInterval(chr, pos)), (boolean)true);
    }

    @VisibleForTesting
    static VariantContextBuilder makeDeletion(SimpleInterval delRange, Allele refAllele) {
        return new VariantContextBuilder().chr(delRange.getContig()).start((long)delRange.getStart()).stop((long)delRange.getEnd()).alleles(Arrays.asList(refAllele, altSymbAlleleDel)).id(SegmentedCpxVariantSimpleVariantExtractor.makeID(SimpleSVType.SupportedType.DEL.name(), delRange.getContig(), delRange.getStart(), delRange.getEnd())).attribute("END", (Object)delRange.getEnd()).attribute("SVLEN", (Object)(-delRange.size() + 1)).attribute("SVTYPE", (Object)SimpleSVType.SupportedType.DEL.name());
    }

    @VisibleForTesting
    static VariantContextBuilder makeInsertion(String chr, int pos, int end, int svLen, Allele refAllele) {
        return new VariantContextBuilder().chr(chr).start((long)pos).stop((long)end).alleles(Arrays.asList(refAllele, altSymbAlleleIns)).id(SegmentedCpxVariantSimpleVariantExtractor.makeID(SimpleSVType.SupportedType.INS.name(), chr, pos, end)).attribute("END", (Object)end).attribute("SVLEN", (Object)svLen).attribute("SVTYPE", (Object)SimpleSVType.SupportedType.INS.name());
    }

    @VisibleForTesting
    static VariantContextBuilder makeInversion(SimpleInterval invertedRegion, Allele refAllele) {
        return new VariantContextBuilder().chr(invertedRegion.getContig()).start((long)(invertedRegion.getStart() - 1)).stop((long)invertedRegion.getEnd()).alleles(Arrays.asList(refAllele, altSymbAlleleInv)).id(SegmentedCpxVariantSimpleVariantExtractor.makeID(SimpleSVType.SupportedType.INV.name(), invertedRegion.getContig(), invertedRegion.getStart() - 1, invertedRegion.getEnd())).attribute("END", (Object)invertedRegion.getEnd()).attribute("SVLEN", (Object)0).attribute("SVTYPE", (Object)SimpleSVType.SupportedType.INV.name());
    }

    @VisibleForTesting
    public static final class MultiSegmentsCpxVariantExtractor
    extends SegmentedCpxVariantSimpleVariantExtractor {
        private static final long serialVersionUID = 1L;

        @Override
        public List<VariantContext> extract(VariantContext complexVC, BasicReference reference) {
            List<SimpleInterval> refSegments = SVUtils.getAttributeAsStringList(complexVC, "SEGMENTS").stream().map(SimpleInterval::new).collect(Collectors.toList());
            List<String> altArrangement = SVUtils.getAttributeAsStringList(complexVC, "ALT_ARRANGEMENT");
            Tuple3<Set<SimpleInterval>, Set<Integer>, List<Integer>> missingAndPresentAndInvertedSegments = MultiSegmentsCpxVariantExtractor.getMissingAndPresentAndInvertedSegments(refSegments, altArrangement);
            Set missingSegments = (Set)missingAndPresentAndInvertedSegments._1();
            Set presentSegments = (Set)missingAndPresentAndInvertedSegments._2();
            List invertedSegments = (List)missingAndPresentAndInvertedSegments._3();
            ArrayList<VariantContextBuilder> result = new ArrayList<VariantContextBuilder>();
            int idx = MultiSegmentsCpxVariantExtractor.findAllSegments(altArrangement, refSegments.size());
            if (idx >= 0) {
                MultiSegmentsCpxVariantExtractor.whenAllSegmentsAppearAsIs(complexVC, reference, refSegments, altArrangement, result, idx);
            } else {
                if (!invertedSegments.isEmpty()) {
                    this.extractInversions(reference, refSegments, presentSegments, invertedSegments, result);
                }
                if (!missingSegments.isEmpty()) {
                    this.extractDeletions(reference, missingSegments, result);
                }
                this.extractFrontAndRearInsertions(complexVC, refSegments, altArrangement, reference, result);
            }
            String sourceID = complexVC.getID();
            List<String> evidenceContigs = SVUtils.getAttributeAsStringList(complexVC, "CTG_NAMES");
            List<String> mappingQualities = SVUtils.getAttributeAsStringList(complexVC, "MAPPING_QUALITIES");
            int maxAlignLength = complexVC.getAttributeAsInt("MAX_ALIGN_LENGTH", 0);
            return result.stream().map(vc -> vc.attribute("CPX_EVENT", (Object)sourceID).attribute("CTG_NAMES", (Object)evidenceContigs).attribute("MAPPING_QUALITIES", (Object)mappingQualities).attribute("MAX_ALIGN_LENGTH", (Object)maxAlignLength).make()).collect(Collectors.toList());
        }

        @VisibleForTesting
        static int findAllSegments(List<String> altArrangement, int segmentCount) {
            int idx = -1;
            int currentlyLookingForSegment = segmentCount;
            String segmentCountString = String.valueOf(segmentCount);
            for (int i = altArrangement.size() - 1; i >= 0; --i) {
                String description = altArrangement.get(i);
                if (description.equals(String.valueOf(currentlyLookingForSegment))) {
                    if (currentlyLookingForSegment == 1) {
                        return i;
                    }
                    --currentlyLookingForSegment;
                    continue;
                }
                currentlyLookingForSegment = description.equals(segmentCountString) ? segmentCount - 1 : segmentCount;
                idx = -1;
            }
            return idx;
        }

        private static void whenAllSegmentsAppearAsIs(VariantContext complexVC, BasicReference reference, List<SimpleInterval> refSegments, List<String> altArrangement, List<VariantContextBuilder> result, int idx) {
            Allele anchorBaseRefAlleleFront;
            SimpleInterval insertionPos;
            VariantContextBuilder frontIns;
            List<Integer> refSegmentLengths = refSegments.stream().map(SimpleInterval::size).collect(Collectors.toList());
            if (idx != 0 && (frontIns = MultiSegmentsCpxVariantExtractor.getInsFromOneEnd(true, idx, insertionPos = new SimpleInterval(complexVC.getContig(), complexVC.getStart() - 1, complexVC.getStart() - 1), anchorBaseRefAlleleFront = SegmentedCpxVariantSimpleVariantExtractor.getAnchorBaseRefAllele(insertionPos.getContig(), insertionPos.getStart(), reference), refSegmentLengths, altArrangement, true)) != null) {
                result.add(frontIns);
            }
            if (idx + refSegments.size() - 1 < altArrangement.size() - 1) {
                insertionPos = new SimpleInterval(complexVC.getContig(), complexVC.getEnd(), complexVC.getEnd());
                byte[] refBases = reference.getBases(insertionPos);
                Allele anchorBaseRefAlleleRear = Allele.create((byte[])refBases, (boolean)true);
                VariantContextBuilder rearIns = MultiSegmentsCpxVariantExtractor.getInsFromOneEnd(false, idx + refSegments.size() - 1, insertionPos, anchorBaseRefAlleleRear, refSegmentLengths, altArrangement, true);
                if (rearIns != null) {
                    result.add(rearIns);
                }
            }
        }

        private void extractInversions(BasicReference reference, List<SimpleInterval> refSegmentIntervals, Set<Integer> presentSegments, List<Integer> invertedSegments, List<VariantContextBuilder> result) {
            List inversions = invertedSegments.stream().filter(i -> ((SimpleInterval)refSegmentIntervals.get(i - 1)).size() > EVENT_SIZE_THRESHOLD && !presentSegments.contains(i)).map(i -> {
                SimpleInterval invertedSegment = (SimpleInterval)refSegmentIntervals.get(i - 1);
                byte[] ref = reference.getBases(SVUtils.makeOneBpInterval(invertedSegment.getContig(), invertedSegment.getStart()));
                Allele refAllele = Allele.create((byte[])ref, (boolean)true);
                return MultiSegmentsCpxVariantExtractor.makeInversion(invertedSegment, refAllele);
            }).collect(Collectors.toList());
            result.addAll(inversions);
        }

        private void extractDeletions(BasicReference reference, Set<SimpleInterval> missingSegments, List<VariantContextBuilder> result) {
            List deletions = MultiSegmentsCpxVariantExtractor.compactifyMissingSegments(missingSegments).stream().filter(gone -> gone.size() > EVENT_SIZE_THRESHOLD).map(gone -> {
                byte[] ref = reference.getBases(SVUtils.makeOneBpInterval(gone.getContig(), gone.getStart()));
                Allele refAllele = Allele.create((byte[])ref, (boolean)true);
                return MultiSegmentsCpxVariantExtractor.makeDeletion(new SimpleInterval(gone.getContig(), gone.getStart(), gone.getEnd() - 1), refAllele);
            }).collect(Collectors.toList());
            result.addAll(deletions);
        }

        @VisibleForTesting
        static List<SimpleInterval> compactifyMissingSegments(Set<SimpleInterval> missingSegments) {
            if (missingSegments.size() == 1) {
                return Collections.singletonList(missingSegments.iterator().next());
            }
            List sortedMissingSegments = missingSegments.stream().sorted(Comparator.comparing(SimpleInterval::getStart)).collect(Collectors.toList());
            ArrayList<SimpleInterval> result = new ArrayList<SimpleInterval>(missingSegments.size());
            Iterator iterator = sortedMissingSegments.iterator();
            SimpleInterval current = (SimpleInterval)iterator.next();
            while (iterator.hasNext()) {
                SimpleInterval next = (SimpleInterval)iterator.next();
                if (current.overlapsWithMargin(next, 1)) {
                    current = new SimpleInterval(current.getContig(), current.getStart(), next.getEnd());
                    continue;
                }
                result.add(current);
                current = next;
            }
            result.add(current);
            return result;
        }

        private void extractFrontAndRearInsertions(VariantContext complexVC, List<SimpleInterval> refSegmentIntervals, List<String> altArrangement, BasicReference reference, List<VariantContextBuilder> result) {
            Allele anchorBaseRefAlleleFront;
            SimpleInterval startAndStop;
            VariantContextBuilder frontIns;
            List<Integer> refSegmentLengths = refSegmentIntervals.stream().map(SimpleInterval::size).collect(Collectors.toList());
            int firstRefSegmentIdx = 0;
            for (String description : altArrangement) {
                if (!MultiSegmentsCpxVariantExtractor.descriptionIndicatesInsertion(description)) break;
                ++firstRefSegmentIdx;
            }
            if (firstRefSegmentIdx > 0 && (frontIns = MultiSegmentsCpxVariantExtractor.getInsFromOneEnd(true, firstRefSegmentIdx, startAndStop = SVUtils.makeOneBpInterval(complexVC.getContig(), complexVC.getStart()), anchorBaseRefAlleleFront = Allele.create((byte[])reference.getBases(startAndStop), (boolean)true), refSegmentLengths, altArrangement, true)) != null) {
                result.add(frontIns);
            }
            firstRefSegmentIdx = altArrangement.size() - 1;
            for (int i = altArrangement.size() - 1; i > -1 && MultiSegmentsCpxVariantExtractor.descriptionIndicatesInsertion(altArrangement.get(i)); --i) {
                --firstRefSegmentIdx;
            }
            if (firstRefSegmentIdx != altArrangement.size() - 1) {
                Allele anchorBaseRefAlleleRear;
                int pos = complexVC.getEnd();
                SimpleInterval insertionPos = SVUtils.makeOneBpInterval(complexVC.getContig(), pos);
                VariantContextBuilder rearIns = MultiSegmentsCpxVariantExtractor.getInsFromOneEnd(false, firstRefSegmentIdx, insertionPos, anchorBaseRefAlleleRear = Allele.create((byte[])reference.getBases(insertionPos), (boolean)true), refSegmentLengths, altArrangement, true);
                if (rearIns != null) {
                    result.add(rearIns);
                }
            }
        }

        @VisibleForTesting
        static boolean descriptionIndicatesInsertion(String description) {
            if (description.startsWith("UINS")) {
                return true;
            }
            return !NumberUtils.isCreatable((String)description);
        }
    }

    @VisibleForTesting
    public static final class ZeroAndOneSegmentCpxVariantExtractor
    extends SegmentedCpxVariantSimpleVariantExtractor {
        private static final long serialVersionUID = 1L;

        @Override
        public List<VariantContext> extract(VariantContext complexVC, BasicReference reference) {
            List<String> segments = SVUtils.getAttributeAsStringList(complexVC, "SEGMENTS");
            if (segments.isEmpty()) {
                return this.whenZeroSegments(complexVC, reference);
            }
            SimpleInterval refSegment = new SimpleInterval(segments.get(0));
            List<String> altArrangement = SVUtils.getAttributeAsStringList(complexVC, "ALT_ARRANGEMENT");
            int altSeqLength = complexVC.getAttributeAsString("SEQ_ALT_HAPLOTYPE", "").length();
            ArrayList<VariantContextBuilder> result = new ArrayList<VariantContextBuilder>();
            int asIsAppearanceIdx = altArrangement.indexOf("1");
            int invertedAppearanceIdx = altArrangement.indexOf("-1");
            if (invertedAppearanceIdx != -1 && refSegment.size() > EVENT_SIZE_THRESHOLD) {
                ZeroAndOneSegmentCpxVariantExtractor.whenInversionIsWarranted(refSegment, invertedAppearanceIdx, altArrangement, reference, result);
            } else if (asIsAppearanceIdx != -1) {
                ZeroAndOneSegmentCpxVariantExtractor.whenNoDeletionIsAllowed(refSegment, asIsAppearanceIdx, altArrangement, altSeqLength, reference, result);
            } else {
                ZeroAndOneSegmentCpxVariantExtractor.whenNoInvAndNoAsIsAppearance(refSegment, altSeqLength, reference, result);
            }
            String sourceID = complexVC.getID();
            List<String> evidenceContigs = SVUtils.getAttributeAsStringList(complexVC, "CTG_NAMES");
            List<String> mappingQualities = SVUtils.getAttributeAsStringList(complexVC, "MAPPING_QUALITIES");
            int maxAlignLength = complexVC.getAttributeAsInt("MAX_ALIGN_LENGTH", 0);
            return result.stream().map(vc -> vc.attribute("CPX_EVENT", (Object)sourceID).attribute("CTG_NAMES", (Object)evidenceContigs).attribute("MAPPING_QUALITIES", (Object)mappingQualities).attribute("MAX_ALIGN_LENGTH", (Object)maxAlignLength).make()).collect(Collectors.toList());
        }

        private List<VariantContext> whenZeroSegments(VariantContext complexVC, BasicReference reference) {
            Allele anchorBaseRefAllele = SegmentedCpxVariantSimpleVariantExtractor.getAnchorBaseRefAllele(complexVC.getContig(), complexVC.getStart(), reference);
            int altSeqLength = complexVC.getAttributeAsString("SEQ_ALT_HAPLOTYPE", "").length() - 2;
            List<String> mappingQualities = SVUtils.getAttributeAsStringList(complexVC, "MAPPING_QUALITIES");
            int maxAlignLength = complexVC.getAttributeAsInt("MAX_ALIGN_LENGTH", 0);
            VariantContext insertion = ZeroAndOneSegmentCpxVariantExtractor.makeInsertion(complexVC.getContig(), complexVC.getStart(), complexVC.getStart(), altSeqLength, anchorBaseRefAllele).attribute("CPX_EVENT", (Object)complexVC.getID()).attribute("CTG_NAMES", complexVC.getAttribute("CTG_NAMES")).attribute("MAPPING_QUALITIES", mappingQualities).attribute("MAX_ALIGN_LENGTH", (Object)maxAlignLength).make();
            return Collections.singletonList(insertion);
        }

        private static void whenInversionIsWarranted(SimpleInterval refSegment, int invertedAppearanceIdx, List<String> altArrangement, BasicReference reference, List<VariantContextBuilder> result) {
            Allele anchorBaseRefAllele = SegmentedCpxVariantSimpleVariantExtractor.getAnchorBaseRefAllele(refSegment.getContig(), refSegment.getStart(), reference);
            result.add(ZeroAndOneSegmentCpxVariantExtractor.makeInversion(refSegment, anchorBaseRefAllele));
            Allele anchorBaseRefAlleleFront = SegmentedCpxVariantSimpleVariantExtractor.getAnchorBaseRefAllele(refSegment.getContig(), refSegment.getStart() - 1, reference);
            Allele anchorBaseRefAlleleRear = SegmentedCpxVariantSimpleVariantExtractor.getAnchorBaseRefAllele(refSegment.getContig(), refSegment.getEnd(), reference);
            ZeroAndOneSegmentCpxVariantExtractor.extractFrontAndRearInsertions(refSegment, invertedAppearanceIdx, altArrangement, anchorBaseRefAlleleFront, anchorBaseRefAlleleRear, result);
        }

        private static void whenNoDeletionIsAllowed(SimpleInterval refSegment, int asIsAppearanceIdx, List<String> altArrangement, int altSeqLength, BasicReference reference, List<VariantContextBuilder> result) {
            int segmentSize = refSegment.size();
            if (altSeqLength - segmentSize > EVENT_SIZE_THRESHOLD) {
                Allele anchorBaseRefAlleleFront = SegmentedCpxVariantSimpleVariantExtractor.getAnchorBaseRefAllele(refSegment.getContig(), refSegment.getStart() - 1, reference);
                Allele anchorBaseRefAlleleRear = SegmentedCpxVariantSimpleVariantExtractor.getAnchorBaseRefAllele(refSegment.getContig(), refSegment.getEnd(), reference);
                if (altArrangement.get(altArrangement.size() - 1).equals("1")) {
                    VariantContextBuilder frontIns = SegmentedCpxVariantSimpleVariantExtractor.makeInsertion(refSegment.getContig(), refSegment.getStart() - 1, refSegment.getStart() - 1, altSeqLength - segmentSize, anchorBaseRefAlleleFront);
                    result.add(frontIns);
                } else if (altArrangement.get(0).equals("1")) {
                    VariantContextBuilder rearIns = SegmentedCpxVariantSimpleVariantExtractor.makeInsertion(refSegment.getContig(), refSegment.getEnd(), refSegment.getEnd(), altSeqLength - segmentSize, anchorBaseRefAlleleFront);
                    result.add(rearIns);
                } else {
                    ZeroAndOneSegmentCpxVariantExtractor.extractFrontAndRearInsertions(refSegment, asIsAppearanceIdx, altArrangement, anchorBaseRefAlleleFront, anchorBaseRefAlleleRear, result);
                }
            }
        }

        private static void whenNoInvAndNoAsIsAppearance(SimpleInterval refSegment, int altSeqLength, BasicReference reference, List<VariantContextBuilder> result) {
            if (refSegment.size() > EVENT_SIZE_THRESHOLD) {
                Allele anchorBaseRefAlleleFront = SegmentedCpxVariantSimpleVariantExtractor.getAnchorBaseRefAllele(refSegment.getContig(), refSegment.getStart(), reference);
                result.add(ZeroAndOneSegmentCpxVariantExtractor.makeDeletion(new SimpleInterval(refSegment.getContig(), refSegment.getStart(), refSegment.getEnd() - 1), anchorBaseRefAlleleFront));
                if (altSeqLength - 2 > EVENT_SIZE_THRESHOLD) {
                    result.add(ZeroAndOneSegmentCpxVariantExtractor.makeInsertion(refSegment.getContig(), refSegment.getStart(), refSegment.getStart(), altSeqLength, anchorBaseRefAlleleFront));
                }
            } else if (altSeqLength - 2 > EVENT_SIZE_THRESHOLD) {
                Allele fatInsertionRefAllele = Allele.create((byte[])reference.getBases(new SimpleInterval(refSegment.getContig(), refSegment.getStart(), refSegment.getEnd() - 1)), (boolean)true);
                result.add(ZeroAndOneSegmentCpxVariantExtractor.makeInsertion(refSegment.getContig(), refSegment.getStart(), refSegment.getEnd() - 1, altSeqLength - refSegment.size(), fatInsertionRefAllele));
            }
        }

        private static void extractFrontAndRearInsertions(SimpleInterval refSegment, int segmentIdx, List<String> altArrangement, Allele anchorBaseRefAlleleFront, Allele anchorBaseRefAlleleRear, List<VariantContextBuilder> result) {
            SimpleInterval rearInsPos;
            VariantContextBuilder rearIns;
            List<Integer> segmentLen = Collections.singletonList(refSegment.size());
            SimpleInterval frontInsPos = SVUtils.makeOneBpInterval(refSegment.getContig(), refSegment.getStart() - 1);
            VariantContextBuilder frontIns = ZeroAndOneSegmentCpxVariantExtractor.getInsFromOneEnd(true, segmentIdx, frontInsPos, anchorBaseRefAlleleFront, segmentLen, altArrangement, true);
            if (frontIns != null) {
                result.add(frontIns);
            }
            if ((rearIns = ZeroAndOneSegmentCpxVariantExtractor.getInsFromOneEnd(false, segmentIdx, rearInsPos = SVUtils.makeOneBpInterval(refSegment.getContig(), refSegment.getEnd()), anchorBaseRefAlleleRear, segmentLen, altArrangement, true)) != null) {
                result.add(rearIns);
            }
        }
    }

    private static final class AnnotatedInterval {
        private final VariantContext sourceVC;
        final SimpleInterval interval;
        final String id;
        final String type;
        final int svlen;
        final List<Allele> alleles;

        private AnnotatedInterval(VariantContext vc) {
            this.sourceVC = vc;
            this.interval = new SimpleInterval(vc.getContig(), vc.getStart(), vc.getEnd());
            this.id = vc.getID();
            this.type = vc.getAttributeAsString("SVTYPE", "");
            this.svlen = vc.getAttributeAsInt("SVLEN", 0);
            this.alleles = vc.getAlleles();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AnnotatedInterval interval1 = (AnnotatedInterval)o;
            if (this.svlen != interval1.svlen) {
                return false;
            }
            if (!this.interval.equals(interval1.interval)) {
                return false;
            }
            if (!this.id.equals(interval1.id)) {
                return false;
            }
            if (!this.type.equals(interval1.type)) {
                return false;
            }
            return this.alleles.equals(interval1.alleles);
        }

        public int hashCode() {
            int result = this.interval.hashCode();
            result = 31 * result + this.id.hashCode();
            result = 31 * result + this.type.hashCode();
            result = 31 * result + this.svlen;
            result = 31 * result + this.alleles.hashCode();
            return result;
        }
    }

    public static final class RelevantAttributes
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String id;
        private final List<SimpleInterval> referenceSegments;
        private final List<String> altArrangements;

        public RelevantAttributes(VariantContext multiSegmentComplexVar) {
            this.id = multiSegmentComplexVar.getID();
            this.referenceSegments = SVUtils.getAttributeAsStringList(multiSegmentComplexVar, "SEGMENTS").stream().map(SimpleInterval::new).collect(Collectors.toList());
            this.altArrangements = SVUtils.getAttributeAsStringList(multiSegmentComplexVar, "ALT_ARRANGEMENT");
        }
    }

    public static final class ExtractedSimpleVariants {
        private final List<VariantContext> reInterpretZeroOrOneSegmentCalls;
        private final List<VariantContext> reInterpretMultiSegmentsCalls;

        public ExtractedSimpleVariants(List<VariantContext> reInterpretZeroOrOneSegmentCalls, List<VariantContext> reInterpretMultiSegmentsCalls) {
            this.reInterpretZeroOrOneSegmentCalls = reInterpretZeroOrOneSegmentCalls;
            this.reInterpretMultiSegmentsCalls = reInterpretMultiSegmentsCalls;
        }

        public List<VariantContext> getReInterpretZeroOrOneSegmentCalls() {
            return this.reInterpretZeroOrOneSegmentCalls;
        }

        public List<VariantContext> getReInterpretMultiSegmentsCalls() {
            return this.reInterpretMultiSegmentsCalls;
        }

        public List<VariantContext> getMergedReinterpretedCalls() {
            ArrayList<VariantContext> merged = new ArrayList<VariantContext>(this.reInterpretZeroOrOneSegmentCalls);
            merged.addAll(this.reInterpretMultiSegmentsCalls);
            return merged;
        }
    }
}

