/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.spark.sv.discovery.inference;

import com.esotericsoftware.kryo.DefaultSerializer;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.google.common.annotations.VisibleForTesting;
import htsjdk.samtools.SAMSequenceDictionary;
import java.util.ArrayList;
import java.util.List;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.tools.spark.sv.discovery.alignment.AlignmentInterval;
import org.broadinstitute.hellbender.tools.spark.sv.discovery.alignment.AssemblyContigWithFineTunedAlignments;
import org.broadinstitute.hellbender.tools.spark.sv.discovery.alignment.StrandSwitch;
import org.broadinstitute.hellbender.tools.spark.sv.discovery.inference.TypeInferredFromSimpleChimera;
import org.broadinstitute.hellbender.utils.IntervalUtils;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import scala.Tuple2;

@DefaultSerializer(value=Serializer.class)
public class SimpleChimera {
    static final int SPLIT_PAIR_MIN_ALIGNMENT_LENGTH = 30;
    static final int SPLIT_PAIR_MIN_ALIGNMENT_MQ = 20;
    public final String sourceContigName;
    public final AlignmentInterval regionWithLowerCoordOnContig;
    public final AlignmentInterval regionWithHigherCoordOnContig;
    final StrandSwitch strandSwitch;
    final boolean isForwardStrandRepresentation;
    public final List<String> insertionMappings;
    public final String goodNonCanonicalMappingSATag;

    protected SimpleChimera(Kryo kryo, Input input) {
        this.sourceContigName = input.readString();
        this.regionWithLowerCoordOnContig = (AlignmentInterval)kryo.readObject(input, AlignmentInterval.class);
        this.regionWithHigherCoordOnContig = (AlignmentInterval)kryo.readObject(input, AlignmentInterval.class);
        this.strandSwitch = StrandSwitch.values()[input.readInt()];
        this.isForwardStrandRepresentation = input.readBoolean();
        int insertionsMappingSize = input.readInt();
        this.insertionMappings = new ArrayList<String>(insertionsMappingSize);
        for (int i = 0; i < insertionsMappingSize; ++i) {
            this.insertionMappings.add(input.readString());
        }
        this.goodNonCanonicalMappingSATag = input.readString();
    }

    @VisibleForTesting
    public SimpleChimera(String sourceContigName, AlignmentInterval regionWithLowerCoordOnContig, AlignmentInterval regionWithHigherCoordOnContig, StrandSwitch strandSwitch, boolean isForwardStrandRepresentation, List<String> insertionMappings, String goodNonCanonicalMappingSATag) {
        this.sourceContigName = sourceContigName;
        this.regionWithLowerCoordOnContig = regionWithLowerCoordOnContig;
        this.regionWithHigherCoordOnContig = regionWithHigherCoordOnContig;
        this.strandSwitch = strandSwitch;
        this.isForwardStrandRepresentation = isForwardStrandRepresentation;
        this.insertionMappings = insertionMappings;
        this.goodNonCanonicalMappingSATag = goodNonCanonicalMappingSATag;
    }

    public SimpleChimera(AlignmentInterval intervalWithLowerCoordOnContig, AlignmentInterval intervalWithHigherCoordOnContig, List<String> insertionMappings, String sourceContigName, String goodNonCanonicalMappingSATag, SAMSequenceDictionary referenceDictionary) {
        this.sourceContigName = sourceContigName;
        this.regionWithLowerCoordOnContig = intervalWithLowerCoordOnContig;
        this.regionWithHigherCoordOnContig = intervalWithHigherCoordOnContig;
        this.strandSwitch = SimpleChimera.determineStrandSwitch(intervalWithLowerCoordOnContig, intervalWithHigherCoordOnContig);
        this.isForwardStrandRepresentation = SimpleChimera.isForwardStrandRepresentation(intervalWithLowerCoordOnContig, intervalWithHigherCoordOnContig, this.strandSwitch, referenceDictionary);
        this.insertionMappings = insertionMappings;
        this.goodNonCanonicalMappingSATag = goodNonCanonicalMappingSATag;
    }

    public static boolean splitPairStrongEnoughEvidenceForCA(AlignmentInterval intervalOne, AlignmentInterval intervalTwo) {
        if (intervalOne.mapQual < 20 || intervalTwo.mapQual < 20) {
            return false;
        }
        return Math.min(intervalOne.getSizeOnRead(), intervalTwo.getSizeOnRead()) >= 30;
    }

    @VisibleForTesting
    static boolean isForwardStrandRepresentation(AlignmentInterval regionWithLowerCoordOnContig, AlignmentInterval regionWithHigherCoordOnContig, StrandSwitch strandSwitch, SAMSequenceDictionary referenceDictionary) {
        boolean mappedToSameChr = regionWithLowerCoordOnContig.referenceSpan.getContig().equals(regionWithHigherCoordOnContig.referenceSpan.getContig());
        if (mappedToSameChr) {
            switch (strandSwitch) {
                case NO_SWITCH: {
                    return regionWithLowerCoordOnContig.forwardStrand;
                }
                case FORWARD_TO_REVERSE: {
                    return regionWithLowerCoordOnContig.referenceSpan.getEnd() < regionWithHigherCoordOnContig.referenceSpan.getEnd();
                }
                case REVERSE_TO_FORWARD: {
                    return regionWithLowerCoordOnContig.referenceSpan.getStart() < regionWithHigherCoordOnContig.referenceSpan.getStart();
                }
            }
            throw new IllegalArgumentException("Seeing unexpected strand switch case: " + strandSwitch.name());
        }
        if (strandSwitch == StrandSwitch.NO_SWITCH) {
            return regionWithLowerCoordOnContig.forwardStrand;
        }
        return IntervalUtils.compareContigs(regionWithLowerCoordOnContig.referenceSpan, regionWithHigherCoordOnContig.referenceSpan, referenceDictionary) < 0;
    }

    @VisibleForTesting
    static StrandSwitch determineStrandSwitch(AlignmentInterval first, AlignmentInterval second) {
        if (first.forwardStrand == second.forwardStrand) {
            return StrandSwitch.NO_SWITCH;
        }
        return first.forwardStrand ? StrandSwitch.FORWARD_TO_REVERSE : StrandSwitch.REVERSE_TO_FORWARD;
    }

    boolean firstContigRegionRefSpanAfterSecond(SAMSequenceDictionary referenceDictionary) {
        return IntervalUtils.compareLocatables(this.regionWithLowerCoordOnContig.referenceSpan, this.regionWithHigherCoordOnContig.referenceSpan, referenceDictionary) > 0;
    }

    Tuple2<SimpleInterval, SimpleInterval> getCoordinateSortedRefSpans(SAMSequenceDictionary referenceDictionary) {
        if (this.firstContigRegionRefSpanAfterSecond(referenceDictionary)) {
            return new Tuple2((Object)this.regionWithHigherCoordOnContig.referenceSpan, (Object)this.regionWithLowerCoordOnContig.referenceSpan);
        }
        return new Tuple2((Object)this.regionWithLowerCoordOnContig.referenceSpan, (Object)this.regionWithHigherCoordOnContig.referenceSpan);
    }

    TypeInferredFromSimpleChimera inferType(SAMSequenceDictionary referenceDictionary) {
        if (this.isCandidateSimpleTranslocation()) {
            boolean sameChromosomeEvent = this.regionWithLowerCoordOnContig.referenceSpan.getContig().equals(this.regionWithHigherCoordOnContig.referenceSpan.getContig());
            if (sameChromosomeEvent) {
                return TypeInferredFromSimpleChimera.INTRA_CHR_REF_ORDER_SWAP;
            }
            if (this.strandSwitch.equals((Object)StrandSwitch.FORWARD_TO_REVERSE)) {
                return TypeInferredFromSimpleChimera.INTER_CHR_STRAND_SWITCH_55;
            }
            if (this.strandSwitch.equals((Object)StrandSwitch.REVERSE_TO_FORWARD)) {
                return TypeInferredFromSimpleChimera.INTER_CHR_STRAND_SWITCH_33;
            }
            if (this.isForwardStrandRepresentation != this.firstContigRegionRefSpanAfterSecond(referenceDictionary)) {
                return TypeInferredFromSimpleChimera.INTER_CHR_NO_SS_WITH_LEFT_MATE_FIRST_IN_PARTNER;
            }
            return TypeInferredFromSimpleChimera.INTER_CHR_NO_SS_WITH_LEFT_MATE_SECOND_IN_PARTNER;
        }
        if (this.strandSwitch.equals((Object)StrandSwitch.FORWARD_TO_REVERSE)) {
            return TypeInferredFromSimpleChimera.INTRA_CHR_STRAND_SWITCH_55;
        }
        if (this.strandSwitch.equals((Object)StrandSwitch.REVERSE_TO_FORWARD)) {
            return TypeInferredFromSimpleChimera.INTRA_CHR_STRAND_SWITCH_33;
        }
        DistancesBetweenAlignmentsOnRefAndOnRead distances = this.getDistancesBetweenAlignmentsOnRefAndOnRead();
        int distBetweenAlignRegionsOnRef = distances.gapBetweenAlignRegionsOnRef;
        int distBetweenAlignRegionsOnCtg = distances.gapBetweenAlignRegionsOnCtg;
        if (distBetweenAlignRegionsOnRef > 0) {
            if (distBetweenAlignRegionsOnCtg <= 0) {
                return TypeInferredFromSimpleChimera.SIMPLE_DEL;
            }
            return TypeInferredFromSimpleChimera.RPL;
        }
        if (distBetweenAlignRegionsOnRef < 0) {
            if (distBetweenAlignRegionsOnCtg >= 0) {
                return TypeInferredFromSimpleChimera.SMALL_DUP_EXPANSION;
            }
            return TypeInferredFromSimpleChimera.SMALL_DUP_CPX;
        }
        if (distBetweenAlignRegionsOnCtg > 0) {
            return TypeInferredFromSimpleChimera.SIMPLE_INS;
        }
        if (distBetweenAlignRegionsOnCtg < 0) {
            return TypeInferredFromSimpleChimera.DEL_DUP_CONTRACTION;
        }
        throw new GATKException.ShouldNeverReachHereException("Detected badly parsed chimeric alignment for identifying SV breakpoints; no rearrangement found: " + this.toString());
    }

    public boolean isNeitherIncompleteNorSimpleTranslocation() {
        if (this.hasIncompletePicture()) {
            return false;
        }
        return !this.isCandidateSimpleTranslocation();
    }

    @VisibleForTesting
    boolean isCandidateSimpleTranslocation() {
        if (this.hasIncompletePicture()) {
            return false;
        }
        if (!this.regionWithLowerCoordOnContig.referenceSpan.getContig().equals(this.regionWithHigherCoordOnContig.referenceSpan.getContig())) {
            return true;
        }
        if (!this.strandSwitch.equals((Object)StrandSwitch.NO_SWITCH)) {
            return false;
        }
        SimpleInterval referenceSpanOne = this.regionWithLowerCoordOnContig.referenceSpan;
        SimpleInterval referenceSpanTwo = this.regionWithHigherCoordOnContig.referenceSpan;
        if (this.regionWithLowerCoordOnContig.forwardStrand) {
            return referenceSpanOne.getStart() > referenceSpanTwo.getEnd();
        }
        return referenceSpanTwo.getStart() > referenceSpanOne.getEnd();
    }

    private boolean hasIncompletePicture() {
        return AssemblyContigWithFineTunedAlignments.hasIncompletePictureFromTwoAlignments(this.regionWithLowerCoordOnContig, this.regionWithHigherCoordOnContig);
    }

    @VisibleForTesting
    boolean isCandidateInvertedDuplication() {
        if (this.regionWithLowerCoordOnContig.forwardStrand == this.regionWithHigherCoordOnContig.forwardStrand) {
            return false;
        }
        return 2 * AlignmentInterval.overlapOnRefSpan(this.regionWithLowerCoordOnContig, this.regionWithHigherCoordOnContig) > Math.min(this.regionWithLowerCoordOnContig.getSizeOnRead(), this.regionWithHigherCoordOnContig.getSizeOnRead());
    }

    DistancesBetweenAlignmentsOnRefAndOnRead getDistancesBetweenAlignmentsOnRefAndOnRead() {
        SimpleInterval rightReferenceSpan;
        SimpleInterval leftReferenceSpan;
        if (!this.isNeitherIncompleteNorSimpleTranslocation() || !this.strandSwitch.equals((Object)StrandSwitch.NO_SWITCH)) {
            throw new UnsupportedOperationException("Assumption that the simple chimera is neither incomplete picture nor simple translocation is violated.\n" + this.toString());
        }
        AlignmentInterval firstContigRegion = this.regionWithLowerCoordOnContig;
        AlignmentInterval secondContigRegion = this.regionWithHigherCoordOnContig;
        if (this.isForwardStrandRepresentation) {
            leftReferenceSpan = firstContigRegion.referenceSpan;
            rightReferenceSpan = secondContigRegion.referenceSpan;
        } else {
            leftReferenceSpan = secondContigRegion.referenceSpan;
            rightReferenceSpan = firstContigRegion.referenceSpan;
        }
        int r1e = leftReferenceSpan.getEnd();
        int r2b = rightReferenceSpan.getStart();
        int c1e = firstContigRegion.endInAssembledContig;
        int c2b = secondContigRegion.startInAssembledContig;
        return new DistancesBetweenAlignmentsOnRefAndOnRead(r2b - r1e - 1, c2b - c1e - 1, r1e, r2b, c1e, c2b);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("SimpleChimera{");
        sb.append("sourceContigName='").append(this.sourceContigName).append('\'');
        sb.append(", regionWithLowerCoordOnContig=").append(this.regionWithLowerCoordOnContig);
        sb.append(", regionWithHigherCoordOnContig=").append(this.regionWithHigherCoordOnContig);
        sb.append(", strandSwitch=").append((Object)this.strandSwitch);
        sb.append(", isForwardStrandRepresentation=").append(this.isForwardStrandRepresentation);
        sb.append(", insertionMappings=").append(this.insertionMappings);
        sb.append(", goodNonCanonicalMappingSATag='").append(this.goodNonCanonicalMappingSATag).append('\'');
        sb.append('}');
        return sb.toString();
    }

    protected void serialize(Kryo kryo, Output output) {
        output.writeString(this.sourceContigName);
        kryo.writeObject(output, (Object)this.regionWithLowerCoordOnContig);
        kryo.writeObject(output, (Object)this.regionWithHigherCoordOnContig);
        output.writeInt(this.strandSwitch.ordinal());
        output.writeBoolean(this.isForwardStrandRepresentation);
        int insertionsMappingSize = this.insertionMappings.size();
        output.writeInt(insertionsMappingSize);
        this.insertionMappings.forEach(arg_0 -> ((Output)output).writeString(arg_0));
        output.writeString(this.goodNonCanonicalMappingSATag);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleChimera that = (SimpleChimera)o;
        if (this.isForwardStrandRepresentation != that.isForwardStrandRepresentation) {
            return false;
        }
        if (!this.sourceContigName.equals(that.sourceContigName)) {
            return false;
        }
        if (!this.regionWithLowerCoordOnContig.equals(that.regionWithLowerCoordOnContig)) {
            return false;
        }
        if (!this.regionWithHigherCoordOnContig.equals(that.regionWithHigherCoordOnContig)) {
            return false;
        }
        if (this.strandSwitch != that.strandSwitch) {
            return false;
        }
        if (!this.insertionMappings.equals(that.insertionMappings)) {
            return false;
        }
        return this.goodNonCanonicalMappingSATag.equals(that.goodNonCanonicalMappingSATag);
    }

    public int hashCode() {
        int result = this.sourceContigName.hashCode();
        result = 31 * result + this.regionWithLowerCoordOnContig.hashCode();
        result = 31 * result + this.regionWithHigherCoordOnContig.hashCode();
        result = 31 * result + this.strandSwitch.ordinal();
        result = 31 * result + (this.isForwardStrandRepresentation ? 1 : 0);
        result = 31 * result + this.insertionMappings.hashCode();
        result = 31 * result + this.goodNonCanonicalMappingSATag.hashCode();
        return result;
    }

    public static final class Serializer
    extends com.esotericsoftware.kryo.Serializer<SimpleChimera> {
        public void write(Kryo kryo, Output output, SimpleChimera simpleChimera) {
            simpleChimera.serialize(kryo, output);
        }

        public SimpleChimera read(Kryo kryo, Input input, Class<SimpleChimera> klass) {
            return new SimpleChimera(kryo, input);
        }
    }

    public static final class DistancesBetweenAlignmentsOnRefAndOnRead {
        final int gapBetweenAlignRegionsOnRef;
        final int gapBetweenAlignRegionsOnCtg;
        final int leftAlnRefEnd;
        final int rightAlnRefStart;
        final int firstAlnCtgEnd;
        final int secondAlnCtgStart;

        public DistancesBetweenAlignmentsOnRefAndOnRead(int gapBetweenAlignRegionsOnRef, int gapBetweenAlignRegionsOnCtg, int leftAlnRefEnd, int rightAlnRefStart, int firstAlnCtgEnd, int secondAlnCtgStart) {
            this.gapBetweenAlignRegionsOnRef = gapBetweenAlignRegionsOnRef;
            this.gapBetweenAlignRegionsOnCtg = gapBetweenAlignRegionsOnCtg;
            this.leftAlnRefEnd = leftAlnRefEnd;
            this.rightAlnRefStart = rightAlnRefStart;
            this.firstAlnCtgEnd = firstAlnCtgEnd;
            this.secondAlnCtgStart = secondAlnCtgStart;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DistancesBetweenAlignmentsOnRefAndOnRead that = (DistancesBetweenAlignmentsOnRefAndOnRead)o;
            if (this.gapBetweenAlignRegionsOnRef != that.gapBetweenAlignRegionsOnRef) {
                return false;
            }
            if (this.gapBetweenAlignRegionsOnCtg != that.gapBetweenAlignRegionsOnCtg) {
                return false;
            }
            if (this.leftAlnRefEnd != that.leftAlnRefEnd) {
                return false;
            }
            if (this.rightAlnRefStart != that.rightAlnRefStart) {
                return false;
            }
            if (this.firstAlnCtgEnd != that.firstAlnCtgEnd) {
                return false;
            }
            return this.secondAlnCtgStart == that.secondAlnCtgStart;
        }

        public int hashCode() {
            int result = this.gapBetweenAlignRegionsOnRef;
            result = 31 * result + this.gapBetweenAlignRegionsOnCtg;
            result = 31 * result + this.leftAlnRefEnd;
            result = 31 * result + this.rightAlnRefStart;
            result = 31 * result + this.firstAlnCtgEnd;
            result = 31 * result + this.secondAlnCtgStart;
            return result;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("DistancesBetweenAlignmentsOnRefAndOnRead{");
            sb.append("gapBetweenAlignRegionsOnRef=").append(this.gapBetweenAlignRegionsOnRef);
            sb.append(", gapBetweenAlignRegionsOnCtg=").append(this.gapBetweenAlignRegionsOnCtg);
            sb.append(", leftAlnRefEnd=").append(this.leftAlnRefEnd);
            sb.append(", rightAlnRefStart=").append(this.rightAlnRefStart);
            sb.append(", firstAlnCtgEnd=").append(this.firstAlnCtgEnd);
            sb.append(", secondAlnCtgStart=").append(this.secondAlnCtgStart);
            sb.append('}');
            return sb.toString();
        }
    }
}

