/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.spark.sv.discovery.inference;

import com.esotericsoftware.kryo.DefaultSerializer;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.util.StringUtil;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.VariantContextBuilder;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.tools.spark.sv.discovery.BreakEndVariantType;
import org.broadinstitute.hellbender.tools.spark.sv.discovery.SimpleSVType;
import org.broadinstitute.hellbender.tools.spark.sv.discovery.SvType;
import org.broadinstitute.hellbender.tools.spark.sv.discovery.alignment.AlignmentInterval;
import org.broadinstitute.hellbender.tools.spark.sv.discovery.inference.NovelAdjacencyAndAltHaplotype;
import org.broadinstitute.hellbender.tools.spark.sv.discovery.inference.SimpleChimera;
import org.broadinstitute.hellbender.tools.spark.sv.utils.SVInterval;
import org.broadinstitute.hellbender.tools.spark.sv.utils.SVIntervalTree;
import org.broadinstitute.hellbender.utils.Utils;

@DefaultSerializer(value=Serializer.class)
public final class SimpleNovelAdjacencyAndChimericAlignmentEvidence {
    private static final NovelAdjacencyAndAltHaplotype.Serializer narlSerializer = new NovelAdjacencyAndAltHaplotype.Serializer();
    private static final SimpleChimera.Serializer alignmentEvidenceSerializer = new SimpleChimera.Serializer();
    private final NovelAdjacencyAndAltHaplotype novelAdjacencyAndAltHaplotype;
    private final List<SimpleChimera> alignmentEvidence;

    public NovelAdjacencyAndAltHaplotype getNovelAdjacencyReferenceLocations() {
        return this.novelAdjacencyAndAltHaplotype;
    }

    public byte[] getAltHaplotypeSequence() {
        return this.novelAdjacencyAndAltHaplotype.getAltHaplotypeSequence();
    }

    public List<SimpleChimera> getAlignmentEvidence() {
        return this.alignmentEvidence;
    }

    public SimpleNovelAdjacencyAndChimericAlignmentEvidence(NovelAdjacencyAndAltHaplotype novelAdjacencyReferenceLocations, Iterable<SimpleChimera> alignmentEvidence) {
        this.novelAdjacencyAndAltHaplotype = Utils.nonNull(novelAdjacencyReferenceLocations);
        this.alignmentEvidence = Lists.newArrayList(Utils.nonNull(alignmentEvidence));
    }

    private SimpleNovelAdjacencyAndChimericAlignmentEvidence(Kryo kryo, Input input) {
        this.novelAdjacencyAndAltHaplotype = narlSerializer.read(kryo, input, (Class)NovelAdjacencyAndAltHaplotype.class);
        int evidenceCount = input.readInt();
        this.alignmentEvidence = new ArrayList<SimpleChimera>(evidenceCount);
        for (int i = 0; i < evidenceCount; ++i) {
            this.alignmentEvidence.add((SimpleChimera)alignmentEvidenceSerializer.read(kryo, input, (Class)SimpleChimera.class));
        }
    }

    public List<VariantContext> toVariantContexts(List<SvType> svTypes, String sampleId, SAMSequenceDictionary refDict, SVIntervalTree<VariantContext> cnvCalls) {
        if (svTypes.isEmpty() || svTypes.size() > 2) {
            throw new GATKException("Wrong number of variants sent for analysis: " + svTypes.toString() + "\nWe currently only support 1 (symbolic simple or CPX) or 2 (BND mate pairs) variants for producing annotated variants.");
        }
        if (svTypes.size() == 2) {
            SvType firstVar = svTypes.get(0);
            SvType secondVar = svTypes.get(1);
            String linkKey = firstVar instanceof BreakEndVariantType ? "MATEID" : "LINK";
            return this.produceLinkedAssemblyBasedVariants(firstVar, secondVar, refDict, cnvCalls, sampleId, linkKey);
        }
        VariantContext variantContext = this.produceAnnotatedVcFromAssemblyEvidence(svTypes.get(0), refDict, cnvCalls, sampleId).make();
        return Collections.singletonList(variantContext);
    }

    @VisibleForTesting
    public VariantContextBuilder produceAnnotatedVcFromAssemblyEvidence(SvType inferredType, SAMSequenceDictionary sequenceDictionary, SVIntervalTree<VariantContext> cnvCalls, String sampleId) {
        VariantContextBuilder vcBuilder = inferredType.getBasicInformation();
        this.novelAdjacencyAndAltHaplotype.getComplication().toVariantAttributes().forEach((arg_0, arg_1) -> ((VariantContextBuilder)vcBuilder).attribute(arg_0, arg_1));
        SimpleNovelAdjacencyAndChimericAlignmentEvidence.getAssemblyEvidenceRelatedAnnotations(this.alignmentEvidence).forEach((arg_0, arg_1) -> ((VariantContextBuilder)vcBuilder).attribute(arg_0, arg_1));
        byte[] altHaplotypeSequence = this.novelAdjacencyAndAltHaplotype.getAltHaplotypeSequence();
        if (inferredType instanceof BreakEndVariantType) {
            return SimpleNovelAdjacencyAndChimericAlignmentEvidence.annotateWithExternalCNVCalls(inferredType.getVariantChromosome(), inferredType.getVariantStart(), inferredType.getVariantStop(), vcBuilder, sequenceDictionary, cnvCalls, sampleId);
        }
        if (altHaplotypeSequence != null && altHaplotypeSequence.length != 0) {
            vcBuilder.attribute("SEQ_ALT_HAPLOTYPE", (Object)StringUtil.bytesToString((byte[])altHaplotypeSequence));
        }
        return SimpleNovelAdjacencyAndChimericAlignmentEvidence.annotateWithExternalCNVCalls(inferredType.getVariantChromosome(), inferredType.getVariantStart(), inferredType.getVariantStop(), vcBuilder, sequenceDictionary, cnvCalls, sampleId);
    }

    private static VariantContextBuilder annotateWithExternalCNVCalls(String recordContig, int pos, int end, VariantContextBuilder inputBuilder, SAMSequenceDictionary sequenceDictionary, SVIntervalTree<VariantContext> cnvCalls, String sampleId) {
        if (cnvCalls == null) {
            return inputBuilder;
        }
        SVInterval variantInterval = new SVInterval(sequenceDictionary.getSequenceIndex(recordContig), pos, end);
        String cnvCallAnnotation = Utils.stream(cnvCalls.overlappers(variantInterval)).map(overlapper -> SimpleNovelAdjacencyAndChimericAlignmentEvidence.formatExternalCNVCallAnnotation((VariantContext)overlapper.getValue(), sampleId)).collect(Collectors.joining(","));
        if (!cnvCallAnnotation.isEmpty()) {
            return inputBuilder.attribute("EXTERNAL_CNV_CALLS", (Object)cnvCallAnnotation);
        }
        return inputBuilder;
    }

    private static String formatExternalCNVCallAnnotation(VariantContext externalCNVCall, String sampleId) {
        return externalCNVCall.getID() + ":" + externalCNVCall.getGenotype(sampleId).getExtendedAttribute("CN") + ":" + externalCNVCall.getGenotype(sampleId).getExtendedAttribute("CNQ");
    }

    public List<VariantContext> produceLinkedAssemblyBasedVariants(SvType svType1, SvType svType2, SAMSequenceDictionary sequenceDictionary, SVIntervalTree<VariantContext> cnvCalls, String sampleId, String linkKey) {
        VariantContext firstVar = this.produceAnnotatedVcFromAssemblyEvidence(svType1, sequenceDictionary, cnvCalls, sampleId).make();
        VariantContext secondVar = this.produceAnnotatedVcFromAssemblyEvidence(svType2, sequenceDictionary, cnvCalls, sampleId).make();
        VariantContextBuilder builder1 = new VariantContextBuilder(firstVar);
        builder1.attribute(linkKey, (Object)secondVar.getID());
        VariantContextBuilder builder2 = new VariantContextBuilder(secondVar);
        builder2.attribute(linkKey, (Object)firstVar.getID());
        if (svType1 instanceof SimpleSVType.Deletion) {
            return Arrays.asList(builder1.rmAttribute("INSSEQ").rmAttribute("INSLEN").rmAttribute("SEQ_ALT_HAPLOTYPE").make(), builder2.make());
        }
        if (svType2 instanceof SimpleSVType.Deletion) {
            return Arrays.asList(builder1.make(), builder2.rmAttribute("INSSEQ").rmAttribute("INSLEN").rmAttribute("SEQ_ALT_HAPLOTYPE").make());
        }
        return Arrays.asList(builder1.make(), builder2.make());
    }

    private static Map<String, Object> getAssemblyEvidenceRelatedAnnotations(List<SimpleChimera> splitAlignmentEvidence) {
        List goodCanonicalMapping;
        List annotations = splitAlignmentEvidence.stream().sorted(Comparator.comparing(evidence -> evidence.sourceContigName)).map(ChimericContigAlignmentEvidenceAnnotations::new).collect(Collectors.toList());
        HashMap<String, Object> attributeMap = new HashMap<String, Object>();
        attributeMap.put("TOTAL_MAPPINGS", annotations.size());
        attributeMap.put("HQ_MAPPINGS", annotations.stream().filter(annotation -> annotation.minMQ == 60).count());
        attributeMap.put("MAPPING_QUALITIES", annotations.stream().map(annotation -> String.valueOf(annotation.minMQ)).collect(Collectors.joining(",")));
        attributeMap.put("ALIGN_LENGTHS", annotations.stream().map(annotation -> String.valueOf(annotation.minAL)).collect(Collectors.joining(",")));
        attributeMap.put("MAX_ALIGN_LENGTH", annotations.stream().map(annotation -> annotation.minAL).max(Comparator.naturalOrder()).orElse(0));
        attributeMap.put("CTG_NAMES", annotations.stream().map(annotation -> annotation.sourceContigName).collect(Collectors.joining(",")));
        List insertionMappings = annotations.stream().map(annotation -> annotation.insSeqMappings).flatMap(Collection::stream).sorted().collect(Collectors.toList());
        if (!insertionMappings.isEmpty()) {
            attributeMap.put("INSSEQ_MAP", insertionMappings.stream().collect(Collectors.joining(",")));
        }
        if (!(goodCanonicalMapping = annotations.stream().map(annotation -> annotation.goodNonCanonicalMappingSATag).filter(s -> !s.equals("NONE")).collect(Collectors.toList())).isEmpty()) {
            attributeMap.put("CTG_GOOD_NONCANONICAL_MAPPING", goodCanonicalMapping.stream().collect(Collectors.joining(",")));
        }
        return attributeMap;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleNovelAdjacencyAndChimericAlignmentEvidence that = (SimpleNovelAdjacencyAndChimericAlignmentEvidence)o;
        if (!this.novelAdjacencyAndAltHaplotype.equals(that.novelAdjacencyAndAltHaplotype)) {
            return false;
        }
        return this.alignmentEvidence.equals(that.alignmentEvidence);
    }

    public int hashCode() {
        int result = this.novelAdjacencyAndAltHaplotype.hashCode();
        result = 31 * result + this.alignmentEvidence.hashCode();
        return result;
    }

    private void serialize(Kryo kryo, Output output) {
        narlSerializer.write(kryo, output, this.novelAdjacencyAndAltHaplotype);
        output.writeInt(this.alignmentEvidence.size());
        this.alignmentEvidence.forEach(ev -> alignmentEvidenceSerializer.write(kryo, output, (SimpleChimera)ev));
    }

    public static final class Serializer
    extends com.esotericsoftware.kryo.Serializer<SimpleNovelAdjacencyAndChimericAlignmentEvidence> {
        public void write(Kryo kryo, Output output, SimpleNovelAdjacencyAndChimericAlignmentEvidence novelAdjacencyReferenceLocations) {
            novelAdjacencyReferenceLocations.serialize(kryo, output);
        }

        public SimpleNovelAdjacencyAndChimericAlignmentEvidence read(Kryo kryo, Input input, Class<SimpleNovelAdjacencyAndChimericAlignmentEvidence> klass) {
            return new SimpleNovelAdjacencyAndChimericAlignmentEvidence(kryo, input);
        }
    }

    public static final class ChimericContigAlignmentEvidenceAnnotations
    implements Serializable {
        private static final long serialVersionUID = 1L;
        final Integer minMQ;
        final Integer minAL;
        final String sourceContigName;
        final List<String> insSeqMappings;
        final String goodNonCanonicalMappingSATag;

        ChimericContigAlignmentEvidenceAnnotations(SimpleChimera simpleChimera) {
            this.minMQ = Math.min(simpleChimera.regionWithLowerCoordOnContig.mapQual, simpleChimera.regionWithHigherCoordOnContig.mapQual);
            this.minAL = Math.min(simpleChimera.regionWithLowerCoordOnContig.referenceSpan.size(), simpleChimera.regionWithHigherCoordOnContig.referenceSpan.size()) - AlignmentInterval.overlapOnContig(simpleChimera.regionWithLowerCoordOnContig, simpleChimera.regionWithHigherCoordOnContig);
            this.sourceContigName = simpleChimera.sourceContigName;
            this.insSeqMappings = simpleChimera.insertionMappings;
            this.goodNonCanonicalMappingSATag = simpleChimera.goodNonCanonicalMappingSATag;
        }
    }
}

