/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.spark.sv.discovery.inference;

import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.variant.variantcontext.VariantContext;
import java.io.Serializable;
import java.util.List;
import org.apache.logging.log4j.Logger;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.spark.broadcast.Broadcast;
import org.broadinstitute.hellbender.engine.BasicReference;
import org.broadinstitute.hellbender.engine.spark.datasources.ReferenceMultiSparkSource;
import org.broadinstitute.hellbender.tools.spark.sv.StructuralVariationDiscoveryArgumentCollection;
import org.broadinstitute.hellbender.tools.spark.sv.discovery.SvDiscoveryInputMetaData;
import org.broadinstitute.hellbender.tools.spark.sv.discovery.SvDiscoveryUtils;
import org.broadinstitute.hellbender.tools.spark.sv.discovery.SvType;
import org.broadinstitute.hellbender.tools.spark.sv.discovery.alignment.AssemblyContigWithFineTunedAlignments;
import org.broadinstitute.hellbender.tools.spark.sv.discovery.inference.NovelAdjacencyAndAltHaplotype;
import org.broadinstitute.hellbender.tools.spark.sv.discovery.inference.SimpleChimera;
import org.broadinstitute.hellbender.tools.spark.sv.discovery.inference.SimpleNovelAdjacencyAndChimericAlignmentEvidence;
import org.broadinstitute.hellbender.tools.spark.sv.utils.SVInterval;
import org.broadinstitute.hellbender.tools.spark.sv.utils.SVIntervalTree;
import scala.Tuple2;

public final class SimpleNovelAdjacencyInterpreter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<VariantContext> makeInterpretation(JavaRDD<AssemblyContigWithFineTunedAlignments> contigsWithSimpleChimera, SvDiscoveryInputMetaData svDiscoveryInputMetaData) {
        JavaPairRDD narlAndAltSeqAndEvidenceAndTypes = SimpleNovelAdjacencyInterpreter.inferTypeFromSingleContigSimpleChimera(contigsWithSimpleChimera, svDiscoveryInputMetaData).cache();
        try {
            List narls = narlAndAltSeqAndEvidenceAndTypes.keys().map(SimpleNovelAdjacencyAndChimericAlignmentEvidence::getNovelAdjacencyReferenceLocations).collect();
            SimpleNovelAdjacencyInterpreter.evaluateNarls(svDiscoveryInputMetaData, narls);
            Broadcast<SAMSequenceDictionary> referenceSequenceDictionaryBroadcast = svDiscoveryInputMetaData.getReferenceData().getReferenceSequenceDictionaryBroadcast();
            String sampleId = svDiscoveryInputMetaData.getSampleSpecificData().getSampleId();
            Broadcast<SVIntervalTree<VariantContext>> cnvCallsBroadcast = svDiscoveryInputMetaData.getSampleSpecificData().getCnvCallsBroadcast();
            List annotatedSimpleVariants = narlAndAltSeqAndEvidenceAndTypes.flatMap((FlatMapFunction & Serializable)pair -> ((SimpleNovelAdjacencyAndChimericAlignmentEvidence)pair._1).toVariantContexts((List)pair._2, sampleId, (SAMSequenceDictionary)referenceSequenceDictionaryBroadcast.getValue(), cnvCallsBroadcast == null ? null : (SVIntervalTree)cnvCallsBroadcast.getValue()).iterator()).collect();
            narlAndAltSeqAndEvidenceAndTypes.unpersist();
            List list = annotatedSimpleVariants;
            return list;
        }
        finally {
            narlAndAltSeqAndEvidenceAndTypes.unpersist();
        }
    }

    private static void evaluateNarls(SvDiscoveryInputMetaData svDiscoveryInputMetaData, List<NovelAdjacencyAndAltHaplotype> narls) {
        Broadcast<SAMSequenceDictionary> referenceSequenceDictionaryBroadcast = svDiscoveryInputMetaData.getReferenceData().getReferenceSequenceDictionaryBroadcast();
        List<SVInterval> assembledIntervals = svDiscoveryInputMetaData.getSampleSpecificData().getAssembledIntervals();
        StructuralVariationDiscoveryArgumentCollection.DiscoverVariantsFromContigAlignmentsArgumentCollection discoverStageArgs = svDiscoveryInputMetaData.getDiscoverStageArgs();
        Logger toolLogger = svDiscoveryInputMetaData.getToolLogger();
        SvDiscoveryUtils.evaluateIntervalsAndNarls(assembledIntervals, narls, (SAMSequenceDictionary)referenceSequenceDictionaryBroadcast.getValue(), discoverStageArgs, toolLogger);
    }

    private static JavaPairRDD<SimpleNovelAdjacencyAndChimericAlignmentEvidence, List<SvType>> inferTypeFromSingleContigSimpleChimera(JavaRDD<AssemblyContigWithFineTunedAlignments> assemblyContigs, SvDiscoveryInputMetaData svDiscoveryInputMetaData) {
        Broadcast<SAMSequenceDictionary> referenceSequenceDictionaryBroadcast = svDiscoveryInputMetaData.getReferenceData().getReferenceSequenceDictionaryBroadcast();
        Broadcast<ReferenceMultiSparkSource> referenceBroadcast = svDiscoveryInputMetaData.getReferenceData().getReferenceBroadcast();
        return assemblyContigs.filter((Function & Serializable)tig -> SimpleChimera.splitPairStrongEnoughEvidenceForCA(tig.getHeadAlignment(), tig.getTailAlignment())).mapToPair((PairFunction & Serializable)tig -> SimpleNovelAdjacencyInterpreter.getNovelAdjacencyAndEvidence(tig, (SAMSequenceDictionary)referenceSequenceDictionaryBroadcast.getValue())).groupByKey().mapToPair((PairFunction & Serializable)noveltyAndEvidence -> SimpleNovelAdjacencyInterpreter.inferType((Tuple2<NovelAdjacencyAndAltHaplotype, Iterable<SimpleChimera>>)noveltyAndEvidence, referenceBroadcast));
    }

    private static Tuple2<NovelAdjacencyAndAltHaplotype, SimpleChimera> getNovelAdjacencyAndEvidence(AssemblyContigWithFineTunedAlignments assemblyContigWithFineTunedAlignments, SAMSequenceDictionary refSeqDict) {
        SimpleChimera simpleChimera = assemblyContigWithFineTunedAlignments.extractSimpleChimera(refSeqDict);
        byte[] contigSequence = assemblyContigWithFineTunedAlignments.getContigSequence();
        NovelAdjacencyAndAltHaplotype novelAdjacencyAndAltHaplotype = new NovelAdjacencyAndAltHaplotype(simpleChimera, contigSequence, refSeqDict);
        return new Tuple2((Object)novelAdjacencyAndAltHaplotype, (Object)simpleChimera);
    }

    private static Tuple2<SimpleNovelAdjacencyAndChimericAlignmentEvidence, List<SvType>> inferType(Tuple2<NovelAdjacencyAndAltHaplotype, Iterable<SimpleChimera>> noveltyAndEvidence, Broadcast<ReferenceMultiSparkSource> referenceBroadcast) {
        NovelAdjacencyAndAltHaplotype novelAdjacencyAndAltHaplotype = (NovelAdjacencyAndAltHaplotype)noveltyAndEvidence._1;
        Iterable simpleChimeras = (Iterable)noveltyAndEvidence._2;
        List<SvType> inferredTypes = novelAdjacencyAndAltHaplotype.toSimpleOrBNDTypes((BasicReference)referenceBroadcast.getValue());
        SimpleNovelAdjacencyAndChimericAlignmentEvidence simpleNovelAdjacencyAndChimericAlignmentEvidence = new SimpleNovelAdjacencyAndChimericAlignmentEvidence(novelAdjacencyAndAltHaplotype, simpleChimeras);
        return new Tuple2((Object)simpleNovelAdjacencyAndChimericAlignmentEvidence, inferredTypes);
    }
}

