/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.spark.sv.evidence;

import com.esotericsoftware.kryo.DefaultSerializer;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordComparator;
import htsjdk.samtools.SAMSequenceRecord;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.tools.spark.sv.utils.SVFileUtils;
import org.broadinstitute.hellbender.tools.spark.sv.utils.SVInterval;
import org.broadinstitute.hellbender.tools.spark.sv.utils.SVUtils;
import org.broadinstitute.hellbender.utils.SequenceDictionaryUtils;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.bwa.BwaMemAlignment;
import org.broadinstitute.hellbender.utils.bwa.BwaMemAlignmentUtils;
import org.broadinstitute.hellbender.utils.fermi.FermiLiteAssembly;
import org.broadinstitute.hellbender.utils.gcs.BucketUtils;

@DefaultSerializer(value=Serializer.class)
public final class AlignedAssemblyOrExcuse {
    private final int assemblyId;
    private final String errorMessage;
    private final FermiLiteAssembly assembly;
    private final List<List<BwaMemAlignment>> contigAlignments;
    private final int secondsInAssembly;

    public int getSecondsInAssembly() {
        return this.secondsInAssembly;
    }

    public int getAssemblyId() {
        return this.assemblyId;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public boolean isNotFailure() {
        return this.errorMessage == null;
    }

    public FermiLiteAssembly getAssembly() {
        return this.assembly;
    }

    public List<List<BwaMemAlignment>> getContigAlignments() {
        return this.contigAlignments;
    }

    public AlignedAssemblyOrExcuse(int assemblyId, String errorMessage) {
        this.assemblyId = assemblyId;
        this.errorMessage = errorMessage;
        this.assembly = null;
        this.contigAlignments = null;
        this.secondsInAssembly = 0;
    }

    public AlignedAssemblyOrExcuse(int assemblyId, FermiLiteAssembly assembly, int secondsInAssembly, List<List<BwaMemAlignment>> contigAlignments) {
        Utils.validate(assembly.getNContigs() == contigAlignments.size(), "Number of contigs in assembly doesn't match length of list of alignments.");
        Utils.validateArg(assembly.getContigs().stream().noneMatch(contig -> contig.getConnections() == null), "Some assembly has contigs that have null connections");
        this.assemblyId = assemblyId;
        this.errorMessage = null;
        this.assembly = assembly;
        this.contigAlignments = contigAlignments;
        this.secondsInAssembly = secondsInAssembly;
    }

    private AlignedAssemblyOrExcuse(Kryo kryo, Input input) {
        this.assemblyId = input.readInt();
        this.errorMessage = input.readString();
        this.secondsInAssembly = input.readInt();
        if (this.errorMessage != null) {
            this.assembly = null;
            this.contigAlignments = null;
        } else {
            int idx;
            int nContigs = input.readInt();
            ArrayList<FermiLiteAssembly.Contig> contigs = new ArrayList<FermiLiteAssembly.Contig>(nContigs);
            for (idx = 0; idx != nContigs; ++idx) {
                contigs.add(AlignedAssemblyOrExcuse.readContig(input));
            }
            for (idx = 0; idx != nContigs; ++idx) {
                int nConnections = input.readInt();
                if (nConnections == 0) continue;
                ArrayList<FermiLiteAssembly.Connection> connections = new ArrayList<FermiLiteAssembly.Connection>(nConnections);
                for (int connIdx = 0; connIdx != nConnections; ++connIdx) {
                    connections.add(AlignedAssemblyOrExcuse.readConnection(input, contigs));
                }
                ((FermiLiteAssembly.Contig)contigs.get(idx)).setConnections(connections);
            }
            this.assembly = new FermiLiteAssembly(contigs);
            ArrayList<List<BwaMemAlignment>> contigAlignments = new ArrayList<List<BwaMemAlignment>>(nContigs);
            for (int idx2 = 0; idx2 != nContigs; ++idx2) {
                int nAlignments = input.readInt();
                ArrayList<BwaMemAlignment> alignments = new ArrayList<BwaMemAlignment>(nAlignments);
                for (int alnIdx = 0; alnIdx != nAlignments; ++alnIdx) {
                    alignments.add(AlignedAssemblyOrExcuse.readAlignment(input));
                }
                contigAlignments.add(alignments);
            }
            this.contigAlignments = contigAlignments;
        }
    }

    private static void writeContig(FermiLiteAssembly.Contig contig, Output output) {
        output.writeInt(contig.getSequence().length);
        output.writeBytes(contig.getSequence());
        boolean hasCoverage = contig.getPerBaseCoverage() != null;
        output.writeBoolean(hasCoverage);
        if (hasCoverage) {
            output.writeBytes(contig.getPerBaseCoverage());
        }
        output.writeInt(contig.getNSupportingReads());
    }

    private static FermiLiteAssembly.Contig readContig(Input input) {
        int sequenceLen = input.readInt();
        byte[] sequence = new byte[sequenceLen];
        input.readBytes(sequence);
        byte[] perBaseCoverage = null;
        if (input.readBoolean()) {
            perBaseCoverage = new byte[sequenceLen];
            input.readBytes(perBaseCoverage);
        }
        int nSupportingReads = input.readInt();
        return new FermiLiteAssembly.Contig(sequence, perBaseCoverage, nSupportingReads);
    }

    private static void writeConnection(FermiLiteAssembly.Connection connection, Map<FermiLiteAssembly.Contig, Integer> contigMap, Output output) {
        output.writeInt(contigMap.get(connection.getTarget()).intValue());
        output.writeInt(connection.getOverlapLen());
        output.writeBoolean(connection.isRC());
        output.writeBoolean(connection.isTargetRC());
    }

    private static FermiLiteAssembly.Connection readConnection(Input input, List<FermiLiteAssembly.Contig> contigs) {
        FermiLiteAssembly.Contig target = contigs.get(input.readInt());
        int overlapLen = input.readInt();
        boolean isRC = input.readBoolean();
        boolean isTargetRC = input.readBoolean();
        return new FermiLiteAssembly.Connection(target, overlapLen, isRC, isTargetRC);
    }

    private static void writeAlignment(BwaMemAlignment alignment, Output output) {
        output.writeInt(alignment.getSamFlag());
        output.writeInt(alignment.getRefId());
        output.writeInt(alignment.getRefStart());
        output.writeInt(alignment.getRefEnd());
        output.writeInt(alignment.getSeqStart());
        output.writeInt(alignment.getSeqEnd());
        output.writeInt(alignment.getMapQual());
        output.writeInt(alignment.getNMismatches());
        output.writeInt(alignment.getAlignerScore());
        output.writeInt(alignment.getSuboptimalScore());
        output.writeString(alignment.getCigar());
        output.writeString(alignment.getMDTag());
        output.writeString(alignment.getXATag());
        output.writeInt(alignment.getMateRefId());
        output.writeInt(alignment.getMateRefStart());
        output.writeInt(alignment.getTemplateLen());
    }

    private static BwaMemAlignment readAlignment(Input input) {
        int samFlag = input.readInt();
        int refId = input.readInt();
        int refStart = input.readInt();
        int refEnd = input.readInt();
        int seqStart = input.readInt();
        int seqEnd = input.readInt();
        int mapQual = input.readInt();
        int nMismatches = input.readInt();
        int alignerScore = input.readInt();
        int suboptimalScore = input.readInt();
        String cigar = input.readString();
        String mdTag = input.readString();
        String xaTag = input.readString();
        int mateRefId = input.readInt();
        int mateRefStart = input.readInt();
        int templateLen = input.readInt();
        return new BwaMemAlignment(samFlag, refId, refStart, refEnd, seqStart, seqEnd, mapQual, nMismatches, alignerScore, suboptimalScore, cigar, mdTag, xaTag, mateRefId, mateRefStart, templateLen);
    }

    private void serialize(Kryo kryo, Output output) {
        output.writeInt(this.assemblyId);
        output.writeString(this.errorMessage);
        output.writeInt(this.secondsInAssembly);
        if (this.errorMessage == null) {
            int nContigs = this.assembly.getNContigs();
            HashMap<FermiLiteAssembly.Contig, Integer> contigMap = new HashMap<FermiLiteAssembly.Contig, Integer>();
            output.writeInt(nContigs);
            for (int idx = 0; idx != nContigs; ++idx) {
                FermiLiteAssembly.Contig contig = this.assembly.getContig(idx);
                AlignedAssemblyOrExcuse.writeContig(contig, output);
                contigMap.put(contig, idx);
            }
            for (FermiLiteAssembly.Contig contig : this.assembly.getContigs()) {
                List connections = contig.getConnections();
                output.writeInt(connections.size());
                for (FermiLiteAssembly.Connection connection : connections) {
                    AlignedAssemblyOrExcuse.writeConnection(connection, contigMap, output);
                }
            }
            for (List list : this.contigAlignments) {
                output.writeInt(list.size());
                for (BwaMemAlignment alignment : list) {
                    AlignedAssemblyOrExcuse.writeAlignment(alignment, output);
                }
            }
        }
    }

    public Stream<SAMRecord> toSAMStreamForAlignmentsOfThisAssembly(SAMFileHeader header, List<String> refNames, SAMReadGroupRecord contigAlignmentsReadGroup) {
        return IntStream.range(0, this.contigAlignments.size()).boxed().flatMap(contigIdx -> BwaMemAlignmentUtils.toSAMStreamForRead(AlignedAssemblyOrExcuse.formatContigName(this.assemblyId, contigIdx), this.assembly.getContig(contigIdx.intValue()).getSequence(), this.contigAlignments.get((int)contigIdx), header, refNames, contigAlignmentsReadGroup));
    }

    public static String formatContigName(int assemblyId, int contigIdx) {
        return AlignedAssemblyOrExcuse.formatAssemblyID(assemblyId) + ":" + AlignedAssemblyOrExcuse.formatContigID(contigIdx);
    }

    public static String formatAssemblyID(int assemblyId) {
        return String.format("asm%06d", assemblyId);
    }

    private static String formatContigID(int contigIdx) {
        return String.format("tig%05d", contigIdx);
    }

    public static void writeIntervalFile(String intervalFile, SAMFileHeader header, List<SVInterval> intervals, List<AlignedAssemblyOrExcuse> intervalDispositions) {
        Utils.validate(intervalFile != null && header != null && intervals != null && intervalDispositions != null, "At least one of the arguments is null.");
        HashMap resultsMap = new HashMap();
        intervalDispositions.forEach(alignedAssemblyOrExcuse -> resultsMap.put(alignedAssemblyOrExcuse.getAssemblyId(), alignedAssemblyOrExcuse));
        try (OutputStreamWriter writer = new OutputStreamWriter(new BufferedOutputStream(BucketUtils.createFile(intervalFile)));){
            List contigs = header.getSequenceDictionary().getSequences();
            int nIntervals = intervals.size();
            for (int intervalIdx = 0; intervalIdx != nIntervals; ++intervalIdx) {
                SVInterval interval = intervals.get(intervalIdx);
                Utils.nonNull(interval, "interval is null for " + intervalIdx);
                String seqName = ((SAMSequenceRecord)contigs.get(interval.getContig())).getSequenceName();
                AlignedAssemblyOrExcuse alignedAssemblyOrExcuse2 = (AlignedAssemblyOrExcuse)resultsMap.get(intervalIdx);
                String disposition = alignedAssemblyOrExcuse2 == null ? "unknown" : (alignedAssemblyOrExcuse2.getErrorMessage() != null ? alignedAssemblyOrExcuse2.getErrorMessage() : "produced " + alignedAssemblyOrExcuse2.getAssembly().getNContigs() + " contigs in " + alignedAssemblyOrExcuse2.getSecondsInAssembly() + " secs.");
                writer.write(intervalIdx + "\t" + seqName + ":" + interval.getStart() + "-" + interval.getEnd() + "\t" + disposition + "\n");
            }
        }
        catch (IOException ioe) {
            throw new UserException.CouldNotCreateOutputFile("Can't write intervals file " + intervalFile, (Exception)ioe);
        }
    }

    static void writeAssemblySAMFile(String outputAssembliesFile, List<AlignedAssemblyOrExcuse> alignedAssemblyOrExcuseList, SAMFileHeader header, SAMFileHeader.SortOrder assemblyAlnSortOrder) {
        String sampleId = SVUtils.getSampleId(header);
        SAMReadGroupRecord contigAlignmentsReadGroup = new SAMReadGroupRecord("GATKSVContigAlignments");
        contigAlignmentsReadGroup.setSample(sampleId);
        SAMFileHeader cleanHeader = new SAMFileHeader(header.getSequenceDictionary());
        cleanHeader.addReadGroup(contigAlignmentsReadGroup);
        cleanHeader.setSortOrder(assemblyAlnSortOrder);
        SAMRecordComparator samRecordComparator = SVUtils.getSamRecordComparator(assemblyAlnSortOrder);
        List<String> refNames = SequenceDictionaryUtils.getContigNamesList(cleanHeader.getSequenceDictionary());
        Stream samRecordStream = alignedAssemblyOrExcuseList.stream().filter(AlignedAssemblyOrExcuse::isNotFailure).flatMap(aa -> aa.toSAMStreamForAlignmentsOfThisAssembly(cleanHeader, refNames, contigAlignmentsReadGroup)).sorted(samRecordComparator);
        SVFileUtils.writeSAMFile(outputAssembliesFile, samRecordStream.iterator(), cleanHeader, true);
    }

    public static final class Serializer
    extends com.esotericsoftware.kryo.Serializer<AlignedAssemblyOrExcuse> {
        public void write(Kryo kryo, Output output, AlignedAssemblyOrExcuse alignedAssemblyOrExcuse) {
            alignedAssemblyOrExcuse.serialize(kryo, output);
        }

        public AlignedAssemblyOrExcuse read(Kryo kryo, Input input, Class<AlignedAssemblyOrExcuse> klass) {
            return new AlignedAssemblyOrExcuse(kryo, input);
        }
    }
}

