/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.spark.sv.evidence;

import com.esotericsoftware.kryo.DefaultSerializer;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.google.common.annotations.VisibleForTesting;
import htsjdk.samtools.Cigar;
import htsjdk.samtools.TextCigarCodec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.tools.spark.sv.evidence.ReadMetadata;
import org.broadinstitute.hellbender.tools.spark.sv.evidence.TemplateFragmentOrdinal;
import org.broadinstitute.hellbender.tools.spark.sv.utils.SVInterval;
import org.broadinstitute.hellbender.tools.spark.sv.utils.StrandedInterval;
import org.broadinstitute.hellbender.tools.spark.sv.utils.TextMDCodec;
import org.broadinstitute.hellbender.utils.read.GATKRead;

@DefaultSerializer(value=Serializer.class)
public class BreakpointEvidence {
    private static final SVInterval.Serializer intervalSerializer = new SVInterval.Serializer();
    private final SVInterval location;
    private final int weight;
    private boolean validated;

    public BreakpointEvidence(SVInterval location, int weight, boolean validated) {
        this.location = location;
        this.weight = weight;
        this.validated = validated;
    }

    protected BreakpointEvidence(Kryo kryo, Input input) {
        this.location = intervalSerializer.read(kryo, input, (Class)SVInterval.class);
        this.weight = input.readInt();
        this.validated = input.readBoolean();
    }

    public SVInterval getLocation() {
        return this.location;
    }

    public int getWeight() {
        return this.weight;
    }

    public boolean isValidated() {
        return this.validated;
    }

    public void setValidated(boolean validated) {
        this.validated = validated;
    }

    public Boolean isEvidenceUpstreamOfBreakpoint() {
        return null;
    }

    public boolean hasDistalTargets(ReadMetadata readMetadata, int minEvidenceMapQ) {
        return false;
    }

    public List<StrandedInterval> getDistalTargets(ReadMetadata readMetadata, int minEvidenceMapq) {
        return null;
    }

    public String toString() {
        return this.location.toString() + "^" + this.weight;
    }

    public String stringRep(ReadMetadata readMetadata, int minEvidenceMapq) {
        String dtString = this.hasDistalTargets(readMetadata, minEvidenceMapq) ? this.getDistalTargets(readMetadata, minEvidenceMapq).stream().map(strandedInterval -> strandedInterval.getInterval().toString() + (strandedInterval.getStrand() ? "1" : "0")).collect(Collectors.joining(";")) : "";
        return this.location.toString() + "\t" + this.weight + "\t" + this.getClass().getSimpleName() + "\t" + dtString;
    }

    @VisibleForTesting
    boolean equalFields(BreakpointEvidence that) {
        return this.location.equals(that.location) && this.weight == that.weight && this.validated == that.validated;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BreakpointEvidence)) {
            return false;
        }
        BreakpointEvidence evidence = (BreakpointEvidence)o;
        return this.weight == evidence.weight && this.validated == evidence.validated && Objects.equals(this.location, evidence.location);
    }

    public int hashCode() {
        return Objects.hash(this.location, this.weight, this.validated);
    }

    protected void serialize(Kryo kryo, Output output) {
        intervalSerializer.write(kryo, output, this.location);
        output.writeInt(this.weight);
        output.writeBoolean(this.validated);
    }

    static SVInterval fixedWidthInterval(int contigID, int contigOffset, int offsetUncertainty) {
        int width = 2 * offsetUncertainty;
        int start = contigOffset - offsetUncertainty;
        if (start < 1) {
            width += start - 1;
            start = 1;
        }
        return new SVInterval(contigID, start, start + width);
    }

    @DefaultSerializer(value=Serializer.class)
    public static final class WeirdTemplateSize
    extends DiscordantReadPairEvidence {
        private final int mateStartPosition;
        private final boolean mateReverseStrand;
        private static final int WEIRD_TEMPLATE_SIZE_WEIGHT = 1;

        WeirdTemplateSize(GATKRead read, ReadMetadata metadata) {
            super(read, metadata, 1);
            this.mateStartPosition = read.getMateStart();
            this.mateReverseStrand = read.mateIsReverseStrand();
        }

        private WeirdTemplateSize(Kryo kryo, Input input) {
            super(kryo, input);
            this.mateStartPosition = input.readInt();
            this.mateReverseStrand = input.readBoolean();
        }

        @VisibleForTesting
        WeirdTemplateSize(SVInterval interval, int weight, String templateName, TemplateFragmentOrdinal fragmentOrdinal, boolean validated, boolean forwardStrand, String cigarString, int mappingQuality, int templateSize, String readGroup, SVInterval target, boolean targetForwardStrand, int targetQuality) {
            super(interval, weight, templateName, fragmentOrdinal, validated, forwardStrand, cigarString, mappingQuality, templateSize, readGroup, target, targetForwardStrand, targetQuality);
            this.mateStartPosition = target.getStart();
            this.mateReverseStrand = !targetForwardStrand;
        }

        @Override
        protected void serialize(Kryo kryo, Output output) {
            super.serialize(kryo, output);
            output.writeInt(this.mateStartPosition);
            output.writeBoolean(this.mateReverseStrand);
        }

        @Override
        public String toString() {
            return super.toString() + "\tTemplateSize\t" + this.target + "\t" + this.getTemplateSize();
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof WeirdTemplateSize)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            WeirdTemplateSize that = (WeirdTemplateSize)o;
            return this.mateStartPosition == that.mateStartPosition && this.mateReverseStrand == that.mateReverseStrand;
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.mateStartPosition, this.mateReverseStrand);
        }

        public static final class Serializer
        extends com.esotericsoftware.kryo.Serializer<WeirdTemplateSize> {
            public void write(Kryo kryo, Output output, WeirdTemplateSize weirdTemplateSize) {
                weirdTemplateSize.serialize(kryo, output);
            }

            public WeirdTemplateSize read(Kryo kryo, Input input, Class<WeirdTemplateSize> klass) {
                return new WeirdTemplateSize(kryo, input);
            }
        }
    }

    @DefaultSerializer(value=Serializer.class)
    public static final class SameStrandPair
    extends DiscordantReadPairEvidence {
        private static final int SAME_STRAND_WEIGHT = 1;

        SameStrandPair(GATKRead read, ReadMetadata metadata) {
            super(read, metadata, 1);
        }

        private SameStrandPair(Kryo kryo, Input input) {
            super(kryo, input);
        }

        @VisibleForTesting
        SameStrandPair(SVInterval interval, int weight, String templateName, TemplateFragmentOrdinal fragmentOrdinal, boolean validated, boolean forwardStrand, String cigarString, int mappingQuality, int templateSize, String readGroup, SVInterval target, boolean targetForwardStrand, int targetQuality) {
            super(interval, weight, templateName, fragmentOrdinal, validated, forwardStrand, cigarString, mappingQuality, templateSize, readGroup, target, targetForwardStrand, targetQuality);
        }

        @Override
        public String toString() {
            return super.toString() + "\tSameStrandPair\t" + this.target;
        }

        @Override
        public boolean equals(Object o) {
            return this == o || o instanceof SameStrandPair && super.equals(o);
        }

        public static final class Serializer
        extends com.esotericsoftware.kryo.Serializer<SameStrandPair> {
            public void write(Kryo kryo, Output output, SameStrandPair sameStrandPair) {
                sameStrandPair.serialize(kryo, output);
            }

            public SameStrandPair read(Kryo kryo, Input input, Class<SameStrandPair> klass) {
                return new SameStrandPair(kryo, input);
            }
        }
    }

    @DefaultSerializer(value=Serializer.class)
    public static final class OutiesPair
    extends DiscordantReadPairEvidence {
        private static final int OUTIES_PAIR_WEIGHT = 1;

        OutiesPair(GATKRead read, ReadMetadata metadata) {
            super(read, metadata, 1);
        }

        private OutiesPair(Kryo kryo, Input input) {
            super(kryo, input);
        }

        @VisibleForTesting
        OutiesPair(SVInterval interval, int weight, String templateName, TemplateFragmentOrdinal fragmentOrdinal, boolean validated, boolean forwardStrand, String cigarString, int mappingQuality, int templateSize, String readGroup, SVInterval target, boolean targetForwardStrand, int targetQuality) {
            super(interval, weight, templateName, fragmentOrdinal, validated, forwardStrand, cigarString, mappingQuality, templateSize, readGroup, target, targetForwardStrand, targetQuality);
        }

        @Override
        protected void serialize(Kryo kryo, Output output) {
            super.serialize(kryo, output);
        }

        @Override
        public String toString() {
            return super.toString() + "\tOutiesPair\t" + this.target;
        }

        @Override
        public boolean equals(Object o) {
            return this == o || o instanceof OutiesPair && super.equals(o);
        }

        public static final class Serializer
        extends com.esotericsoftware.kryo.Serializer<OutiesPair> {
            public void write(Kryo kryo, Output output, OutiesPair mateUnmapped) {
                mateUnmapped.serialize(kryo, output);
            }

            public OutiesPair read(Kryo kryo, Input input, Class<OutiesPair> klass) {
                return new OutiesPair(kryo, input);
            }
        }
    }

    @DefaultSerializer(value=Serializer.class)
    public static final class InterContigPair
    extends DiscordantReadPairEvidence {
        private static final int INTER_CONTIG_PAIR_WEIGHT = 1;

        InterContigPair(GATKRead read, ReadMetadata metadata) {
            super(read, metadata, 1);
        }

        private InterContigPair(Kryo kryo, Input input) {
            super(kryo, input);
        }

        @VisibleForTesting
        InterContigPair(SVInterval interval, int weight, String templateName, TemplateFragmentOrdinal fragmentOrdinal, boolean validated, boolean forwardStrand, String cigarString, int mappingQuality, int templateSize, String readGroup, SVInterval target, boolean targetForwardStrand, int targetQuality) {
            super(interval, weight, templateName, fragmentOrdinal, validated, forwardStrand, cigarString, mappingQuality, templateSize, readGroup, target, targetForwardStrand, targetQuality);
        }

        @Override
        public String toString() {
            return super.toString() + "\tIntercontigPair\t" + this.target;
        }

        @Override
        public boolean equals(Object o) {
            return this == o || o instanceof InterContigPair && super.equals(o);
        }

        public static final class Serializer
        extends com.esotericsoftware.kryo.Serializer<InterContigPair> {
            public void write(Kryo kryo, Output output, InterContigPair interContigPair) {
                interContigPair.serialize(kryo, output);
            }

            public InterContigPair read(Kryo kryo, Input input, Class<InterContigPair> klass) {
                return new InterContigPair(kryo, input);
            }
        }
    }

    public static abstract class DiscordantReadPairEvidence
    extends ReadEvidence {
        protected final SVInterval target;
        protected final boolean targetForwardStrand;
        protected final int targetQuality;
        public static final int MATE_ALIGNMENT_LENGTH_UNCERTAINTY = 2;

        public DiscordantReadPairEvidence(GATKRead read, ReadMetadata metadata, int weight) {
            super(read, metadata, weight);
            this.target = this.getMateTargetInterval(read, metadata);
            this.targetForwardStrand = this.getMateForwardStrand(read);
            this.targetQuality = read.hasAttribute("MQ") ? read.getAttributeAsInteger("MQ") : Integer.MAX_VALUE;
        }

        public DiscordantReadPairEvidence(Kryo kryo, Input input) {
            super(kryo, input);
            this.target = intervalSerializer.read(kryo, input, (Class)SVInterval.class);
            this.targetForwardStrand = input.readBoolean();
            this.targetQuality = input.readInt();
        }

        private DiscordantReadPairEvidence(SVInterval interval, int weight, String templateName, TemplateFragmentOrdinal fragmentOrdinal, boolean validated, boolean forwardStrand, String cigarString, int mappingQuality, int templateSize, String readGroup, SVInterval target, boolean targetForwardStrand, int targetQuality) {
            super(interval, weight, templateName, fragmentOrdinal, validated, forwardStrand, cigarString, mappingQuality, templateSize, readGroup);
            this.target = target;
            this.targetForwardStrand = targetForwardStrand;
            this.targetQuality = targetQuality;
        }

        @Override
        protected void serialize(Kryo kryo, Output output) {
            super.serialize(kryo, output);
            intervalSerializer.write(kryo, output, this.target);
            output.writeBoolean(this.targetForwardStrand);
            output.writeInt(this.targetQuality);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof DiscordantReadPairEvidence)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            DiscordantReadPairEvidence that = (DiscordantReadPairEvidence)o;
            return this.targetForwardStrand == that.targetForwardStrand && this.targetQuality == that.targetQuality && Objects.equals(this.target, that.target);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.target, this.targetForwardStrand, this.targetQuality);
        }

        @Override
        public boolean hasDistalTargets(ReadMetadata readMetadata, int minEvidenceMapQ) {
            return this.getLocation().isUpstreamOf(this.target) && this.isTargetHighQuality(readMetadata, minEvidenceMapQ);
        }

        private boolean isTargetHighQuality(ReadMetadata readMetadata, int minEvidenceMapq) {
            return this.targetQuality >= minEvidenceMapq && !this.target.overlaps(this.getLocation()) && !readMetadata.ignoreCrossContigID(this.target.getContig());
        }

        @Override
        public List<StrandedInterval> getDistalTargets(ReadMetadata readMetadata, int minEvidenceMapq) {
            if (this.hasDistalTargets(readMetadata, minEvidenceMapq)) {
                return Collections.singletonList(new StrandedInterval(this.target, this.targetForwardStrand));
            }
            return Collections.emptyList();
        }

        protected SVInterval getMateTargetInterval(GATKRead read, ReadMetadata metadata) {
            int mateContigIndex = metadata.getContigID(read.getMateContig());
            int mateStartPosition = read.getMateStart();
            boolean mateReverseStrand = read.mateIsReverseStrand();
            int maxAllowableFragmentSize = metadata.getFragmentLengthStatistics(read.getReadGroup()).getMaxNonOutlierFragmentSize();
            int mateAlignmentLength = read.hasAttribute("MC") ? TextCigarCodec.decode((String)read.getAttributeAsString("MC")).getPaddedReferenceLength() : read.getLength();
            return new SVInterval(mateContigIndex, Math.max(0, mateReverseStrand ? mateStartPosition - maxAllowableFragmentSize + mateAlignmentLength : mateStartPosition + mateAlignmentLength - 2), mateReverseStrand ? mateStartPosition + 2 : mateStartPosition + maxAllowableFragmentSize);
        }

        protected boolean getMateForwardStrand(GATKRead read) {
            return !read.mateIsReverseStrand();
        }
    }

    @DefaultSerializer(value=Serializer.class)
    public static final class MateUnmapped
    extends ReadEvidence {
        private static final int MATE_UNMAPPED_WEIGHT = 1;

        MateUnmapped(GATKRead read, ReadMetadata metadata) {
            super(read, metadata, 1);
        }

        private MateUnmapped(Kryo kryo, Input input) {
            super(kryo, input);
        }

        @VisibleForTesting
        MateUnmapped(SVInterval interval, int weight, String templateName, TemplateFragmentOrdinal fragmentOrdinal, boolean validated, boolean forwardStrand, String cigarString, int mappingQuality, int templateSize, String readGroup) {
            super(interval, weight, templateName, fragmentOrdinal, validated, forwardStrand, cigarString, mappingQuality, templateSize, readGroup);
        }

        @Override
        public String toString() {
            return super.toString() + "\tUnmappedMate";
        }

        @Override
        public boolean equals(Object o) {
            return this == o || o instanceof MateUnmapped && super.equals(o);
        }

        public static final class Serializer
        extends com.esotericsoftware.kryo.Serializer<MateUnmapped> {
            public void write(Kryo kryo, Output output, MateUnmapped mateUnmapped) {
                mateUnmapped.serialize(kryo, output);
            }

            public MateUnmapped read(Kryo kryo, Input input, Class<MateUnmapped> klass) {
                return new MateUnmapped(kryo, input);
            }
        }
    }

    @DefaultSerializer(value=Serializer.class)
    public static final class LargeIndel
    extends ReadEvidence {
        private static final int UNCERTAINTY = 4;
        private static final int LARGE_INDEL_WEIGHT = 1;

        LargeIndel(GATKRead read, ReadMetadata metadata, int contigOffset) {
            super(read, metadata, contigOffset, 4, true, 1);
            if (this.getCigarString() == null || this.getCigarString().isEmpty()) {
                throw new GATKException("Read has no cigar string.");
            }
        }

        private LargeIndel(Kryo kryo, Input input) {
            super(kryo, input);
        }

        @VisibleForTesting
        LargeIndel(SVInterval interval, int weight, String templateName, TemplateFragmentOrdinal fragmentOrdinal, boolean validated, boolean forwardStrand, String cigarString, int mappingQuality, int templateSize, String readGroup) {
            super(interval, weight, templateName, fragmentOrdinal, validated, forwardStrand, cigarString, mappingQuality, templateSize, readGroup);
        }

        @Override
        protected void serialize(Kryo kryo, Output output) {
            super.serialize(kryo, output);
        }

        @Override
        public String toString() {
            return super.toString() + "\tIndel\t" + this.getCigarString();
        }

        @Override
        public boolean equals(Object o) {
            return this == o || o instanceof LargeIndel && super.equals(o);
        }

        public static final class Serializer
        extends com.esotericsoftware.kryo.Serializer<LargeIndel> {
            public void write(Kryo kryo, Output output, LargeIndel largeIndel) {
                largeIndel.serialize(kryo, output);
            }

            public LargeIndel read(Kryo kryo, Input input, Class<LargeIndel> klass) {
                return new LargeIndel(kryo, input);
            }
        }
    }

    @DefaultSerializer(value=Serializer.class)
    public static final class SplitRead
    extends ReadEvidence {
        @VisibleForTesting
        static final int UNCERTAINTY = 3;
        private static final String SA_TAG_NAME = "SA";
        private static final int SPLIT_READ_WEIGHT = 1;
        private final String tagSA;
        private boolean primaryAlignmentClippedAtStart;
        private boolean primaryAlignmentForwardStrand;
        private final List<SAMapping> saMappings;

        public SplitRead(GATKRead read, ReadMetadata metadata, boolean primaryAlignmentClippedAtAlignmentStart) {
            super(read, metadata, primaryAlignmentClippedAtAlignmentStart ? read.getStart() : read.getEnd(), 3, !primaryAlignmentClippedAtAlignmentStart, 1);
            boolean bl = this.primaryAlignmentForwardStrand = !read.isReverseStrand();
            if (this.getCigarString() == null || this.getCigarString().isEmpty()) {
                throw new GATKException("Read has no cigar string.");
            }
            this.primaryAlignmentClippedAtStart = primaryAlignmentClippedAtAlignmentStart;
            this.tagSA = read.hasAttribute(SA_TAG_NAME) ? read.getAttributeAsString(SA_TAG_NAME) : null;
            this.saMappings = this.parseSATag(this.tagSA);
        }

        private SplitRead(Kryo kryo, Input input) {
            super(kryo, input);
            this.tagSA = input.readString();
            this.primaryAlignmentClippedAtStart = input.readBoolean();
            this.saMappings = this.parseSATag(this.tagSA);
        }

        @VisibleForTesting
        SplitRead(SVInterval interval, int weight, String templateName, TemplateFragmentOrdinal fragmentOrdinal, boolean validated, boolean forwardStrand, String cigarString, int mappingQuality, int templateSize, String readGroup, boolean primaryAlignmentClippedAtStart, boolean primaryAlignmentForwardStrand, String tagSA) {
            super(interval, weight, templateName, fragmentOrdinal, validated, forwardStrand, cigarString, mappingQuality, templateSize, readGroup);
            this.primaryAlignmentClippedAtStart = primaryAlignmentClippedAtStart;
            this.primaryAlignmentForwardStrand = primaryAlignmentForwardStrand;
            this.tagSA = tagSA;
            this.saMappings = this.parseSATag(tagSA);
        }

        @Override
        protected void serialize(Kryo kryo, Output output) {
            super.serialize(kryo, output);
            output.writeString(this.tagSA);
            output.writeBoolean(this.primaryAlignmentClippedAtStart);
        }

        @Override
        public String toString() {
            return super.toString() + "\tSplit\t" + this.getCigarString() + "\t" + (this.tagSA == null ? " SA: None" : " SA: " + this.tagSA);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SplitRead)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            SplitRead splitRead = (SplitRead)o;
            return this.primaryAlignmentClippedAtStart == splitRead.primaryAlignmentClippedAtStart && this.primaryAlignmentForwardStrand == splitRead.primaryAlignmentForwardStrand && Objects.equals(this.tagSA, splitRead.tagSA) && Objects.equals(this.saMappings, splitRead.saMappings);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.tagSA, this.primaryAlignmentClippedAtStart, this.primaryAlignmentForwardStrand, this.saMappings);
        }

        private List<SAMapping> parseSATag(String tagSA) {
            if (tagSA == null) {
                return null;
            }
            String[] saStrings = tagSA.split(";");
            ArrayList<SAMapping> supplementaryAlignments = new ArrayList<SAMapping>(saStrings.length);
            for (String saString : saStrings) {
                String[] saFields = saString.split(",", -1);
                if (saFields.length != 6) {
                    throw new GATKException("Could not parse SATag: " + saString);
                }
                String contigId = saFields[0];
                int pos = Integer.parseInt(saFields[1]);
                boolean strand = "+".equals(saFields[2]);
                String cigarString = saFields[3];
                int mapQ = Integer.parseInt(saFields[4]);
                int mismatches = Integer.parseInt(saFields[5]);
                SAMapping saMapping = new SAMapping(contigId, pos, strand, cigarString, mapQ, mismatches);
                supplementaryAlignments.add(saMapping);
            }
            return supplementaryAlignments;
        }

        @Override
        public boolean hasDistalTargets(ReadMetadata readMetadata, int minEvidenceMapQ) {
            return this.saMappings != null && this.saMappings.size() == 1 && this.hasHighQualitySupplementaryMappings(readMetadata, minEvidenceMapQ);
        }

        private boolean hasHighQualitySupplementaryMappings(ReadMetadata readMetadata, int minEvidenceMapq) {
            boolean hqMappingFound = false;
            if (this.saMappings != null) {
                for (SAMapping mapping : this.saMappings) {
                    SVInterval saInterval;
                    int mapQ = mapping.getMapq();
                    if (!this.isHighQualityMapping(readMetadata, mapQ, saInterval = this.saMappingToSVInterval(readMetadata, mapping, SplitRead.calculateDistalTargetStrand(mapping, !this.primaryAlignmentClippedAtStart, this.primaryAlignmentForwardStrand)), minEvidenceMapq)) continue;
                    hqMappingFound = true;
                    break;
                }
            }
            return hqMappingFound;
        }

        private boolean isHighQualityMapping(ReadMetadata readMetadata, int mapQ, SVInterval saInterval, int minEvidenceMapq) {
            return mapQ >= minEvidenceMapq && (saInterval.getContig() == this.getLocation().getContig() || !readMetadata.ignoreCrossContigID(saInterval.getContig()) && !readMetadata.ignoreCrossContigID(this.getLocation().getContig())) && !saInterval.overlaps(this.getLocation());
        }

        @Override
        public List<StrandedInterval> getDistalTargets(ReadMetadata readMetadata, int minEvidenceMapq) {
            if (this.hasDistalTargets(readMetadata, minEvidenceMapq)) {
                ArrayList<StrandedInterval> supplementaryAlignments = new ArrayList<StrandedInterval>(this.saMappings.size());
                for (SAMapping saMapping : this.saMappings) {
                    boolean strand;
                    SVInterval saInterval;
                    int mapQ = saMapping.getMapq();
                    if (!this.isHighQualityMapping(readMetadata, mapQ, saInterval = this.saMappingToSVInterval(readMetadata, saMapping, strand = SplitRead.calculateDistalTargetStrand(saMapping, !this.primaryAlignmentClippedAtStart, this.primaryAlignmentForwardStrand)), minEvidenceMapq)) continue;
                    supplementaryAlignments.add(new StrandedInterval(saInterval, strand));
                }
                return supplementaryAlignments;
            }
            return null;
        }

        @VisibleForTesting
        static boolean calculateDistalTargetStrand(SAMapping saMapping, boolean primaryEvidenceRightClipped, boolean primaryAlignmentForwardStrand) {
            boolean primaryAlignmentRightClippedOnRead;
            boolean bl = primaryAlignmentRightClippedOnRead = primaryAlignmentForwardStrand == primaryEvidenceRightClipped;
            if (primaryAlignmentRightClippedOnRead) {
                return !saMapping.isForwardStrand();
            }
            return saMapping.isForwardStrand();
        }

        private SVInterval saMappingToSVInterval(ReadMetadata readMetadata, SAMapping saMapping, boolean saEvidenceDownstreamOfBreakpoint) {
            int contigId = readMetadata.getContigID(saMapping.getContigName());
            Cigar saCigar = TextCigarCodec.decode((String)saMapping.getCigar());
            int pos = saEvidenceDownstreamOfBreakpoint ? saMapping.getStart() + saCigar.getPaddedReferenceLength() : saMapping.getStart();
            return new SVInterval(contigId, Math.max(1, pos - 3), pos + 3 + 1);
        }

        static final class SAMapping {
            private final String contigName;
            private final int start;
            private final boolean forwardStrand;
            private final String cigar;
            private final int mapq;
            private final int mismatches;

            public SAMapping(String contigName, int start, boolean strand, String cigar, int mapq, int mismatches) {
                this.contigName = contigName;
                this.start = start;
                this.forwardStrand = strand;
                this.cigar = cigar;
                this.mapq = mapq;
                this.mismatches = mismatches;
            }

            public String getContigName() {
                return this.contigName;
            }

            public int getStart() {
                return this.start;
            }

            public boolean isForwardStrand() {
                return this.forwardStrand;
            }

            public String getCigar() {
                return this.cigar;
            }

            public int getMapq() {
                return this.mapq;
            }

            public int getMismatches() {
                return this.mismatches;
            }
        }

        public static final class Serializer
        extends com.esotericsoftware.kryo.Serializer<SplitRead> {
            public void write(Kryo kryo, Output output, SplitRead splitRead) {
                splitRead.serialize(kryo, output);
            }

            public SplitRead read(Kryo kryo, Input input, Class<SplitRead> klass) {
                return new SplitRead(kryo, input);
            }
        }
    }

    @DefaultSerializer(value=Serializer.class)
    public static class ReadEvidence
    extends BreakpointEvidence {
        private static final int SINGLE_READ_WEIGHT = 1;
        private final String templateName;
        private final TemplateFragmentOrdinal fragmentOrdinal;
        private final boolean forwardStrand;
        private final String cigarString;
        private final int mappingQuality;
        private final int templateSize;
        private final String readGroup;

        protected ReadEvidence(GATKRead read, ReadMetadata metadata, int readWeight) {
            super(ReadEvidence.restOfFragmentInterval(read, metadata), readWeight, false);
            this.templateName = read.getName();
            if (this.templateName == null) {
                throw new GATKException("Read has no name.");
            }
            this.fragmentOrdinal = TemplateFragmentOrdinal.forRead(read);
            this.forwardStrand = !read.isReverseStrand();
            this.cigarString = read.getCigar().toString();
            this.mappingQuality = read.getMappingQuality();
            this.templateSize = read.getFragmentLength();
            this.readGroup = read.getReadGroup();
        }

        protected ReadEvidence(GATKRead read, ReadMetadata metadata, int contigOffset, int offsetUncertainty, boolean forwardStrand, int readWeight) {
            super(ReadEvidence.fixedWidthInterval(metadata.getContigID(read.getContig()), contigOffset, offsetUncertainty), readWeight, false);
            this.templateName = read.getName();
            if (this.templateName == null) {
                throw new GATKException("Read has no name.");
            }
            this.fragmentOrdinal = TemplateFragmentOrdinal.forRead(read);
            this.forwardStrand = forwardStrand;
            this.cigarString = read.getCigar().toString();
            this.mappingQuality = read.getMappingQuality();
            this.templateSize = read.getFragmentLength();
            this.readGroup = read.getReadGroup();
        }

        @VisibleForTesting
        ReadEvidence(SVInterval interval, int weight, String templateName, TemplateFragmentOrdinal fragmentOrdinal, boolean validated, boolean forwardStrand, String cigarString, int mappingQuality, int templateSize, String readGroup) {
            super(interval, weight, validated);
            this.templateName = templateName;
            this.fragmentOrdinal = fragmentOrdinal;
            this.forwardStrand = forwardStrand;
            this.cigarString = cigarString;
            this.mappingQuality = mappingQuality;
            this.templateSize = templateSize;
            this.readGroup = readGroup;
        }

        protected ReadEvidence(Kryo kryo, Input input) {
            super(kryo, input);
            this.templateName = input.readString();
            this.fragmentOrdinal = TemplateFragmentOrdinal.values()[input.readByte()];
            this.forwardStrand = input.readBoolean();
            this.cigarString = input.readString();
            this.mappingQuality = input.readInt();
            this.templateSize = input.readInt();
            this.readGroup = input.readString();
        }

        @Override
        protected void serialize(Kryo kryo, Output output) {
            super.serialize(kryo, output);
            output.writeString(this.templateName);
            output.writeByte(this.fragmentOrdinal.ordinal());
            output.writeBoolean(this.forwardStrand);
            output.writeString(this.cigarString);
            output.writeInt(this.mappingQuality);
            output.writeInt(this.templateSize);
            output.writeString(this.readGroup);
        }

        public boolean getForwardStrand() {
            return this.forwardStrand;
        }

        public String getTemplateName() {
            return this.templateName;
        }

        public TemplateFragmentOrdinal getFragmentOrdinal() {
            return this.fragmentOrdinal;
        }

        public String getCigarString() {
            return this.cigarString;
        }

        public int getMappingQuality() {
            return this.mappingQuality;
        }

        public int getTemplateSize() {
            return this.templateSize;
        }

        public String getReadGroup() {
            return this.readGroup;
        }

        @Override
        public Boolean isEvidenceUpstreamOfBreakpoint() {
            return this.forwardStrand;
        }

        @Override
        public String toString() {
            return super.toString() + "\t" + this.templateName + (Object)((Object)this.fragmentOrdinal);
        }

        @Override
        public String stringRep(ReadMetadata readMetadata, int minEvidenceMapq) {
            return super.stringRep(readMetadata, minEvidenceMapq) + "\t" + this.templateName + (Object)((Object)this.fragmentOrdinal) + "\t" + (this.forwardStrand ? "1" : "0") + "\t" + this.templateSize + "\t" + this.cigarString + "\t" + this.mappingQuality;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ReadEvidence)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ReadEvidence that = (ReadEvidence)o;
            return this.forwardStrand == that.forwardStrand && this.mappingQuality == that.mappingQuality && this.templateSize == that.templateSize && Objects.equals(this.templateName, that.templateName) && this.fragmentOrdinal == that.fragmentOrdinal && Objects.equals(this.cigarString, that.cigarString) && Objects.equals(this.readGroup, that.readGroup);
        }

        @Override
        public int hashCode() {
            return Objects.hash(new Object[]{super.hashCode(), this.templateName, this.fragmentOrdinal, this.forwardStrand, this.cigarString, this.mappingQuality, this.templateSize, this.readGroup});
        }

        private static SVInterval restOfFragmentInterval(GATKRead read, ReadMetadata metadata) {
            int start;
            int width;
            int templateLen = metadata.getFragmentLengthStatistics(read.getReadGroup()).getMaxNonOutlierFragmentSize();
            if (read.isReverseStrand()) {
                int leadingMismatches = ReadEvidence.getLeadingMismatches(read, true);
                int readStart = read.getStart() + leadingMismatches;
                start = readStart - (width = readStart - (read.getUnclippedEnd() + 1 - templateLen));
                if (start < 1) {
                    width += start - 1;
                    start = 1;
                }
            } else {
                int trailingMismatches = ReadEvidence.getLeadingMismatches(read, false);
                int readEnd = read.getEnd() + 1 - trailingMismatches;
                width = read.getUnclippedStart() + templateLen - readEnd;
                start = readEnd;
            }
            return new SVInterval(metadata.getContigID(read.getContig()), start, start + width);
        }

        @VisibleForTesting
        static int getLeadingMismatches(GATKRead read, boolean fromStart) {
            int leadingMismatches = 0;
            if (read.hasAttribute("MD")) {
                TextMDCodec.MDElement mdElement;
                int idx;
                String mdString = read.getAttributeAsString("MD");
                List<TextMDCodec.MDElement> mdElements = TextMDCodec.parseMDString(mdString);
                int n = idx = fromStart ? 0 : mdElements.size() - 1;
                while ((fromStart ? idx < mdElements.size() : idx >= 0) && (!((mdElement = mdElements.get(idx)) instanceof TextMDCodec.MatchMDElement) || mdElement.getLength() <= 0)) {
                    leadingMismatches += mdElement.getLength();
                    idx += fromStart ? 1 : -1;
                }
            }
            return leadingMismatches;
        }

        public static final class Serializer
        extends com.esotericsoftware.kryo.Serializer<ReadEvidence> {
            public void write(Kryo kryo, Output output, ReadEvidence evidence) {
                evidence.serialize(kryo, output);
            }

            public ReadEvidence read(Kryo kryo, Input input, Class<ReadEvidence> klass) {
                return new ReadEvidence(kryo, input);
            }
        }
    }

    @DefaultSerializer(value=Serializer.class)
    public static final class TemplateSizeAnomaly
    extends BreakpointEvidence {
        private final int readCount;

        public TemplateSizeAnomaly(SVInterval interval, int weight, int readCount) {
            super(interval, weight, false);
            this.readCount = readCount;
        }

        protected TemplateSizeAnomaly(Kryo kryo, Input input) {
            super(kryo, input);
            this.readCount = input.readInt();
        }

        @Override
        protected void serialize(Kryo kryo, Output output) {
            super.serialize(kryo, output);
            output.writeInt(this.readCount);
        }

        @Override
        public String toString() {
            return super.toString() + "\tTemplateSizeAnomaly\t" + this.readCount;
        }

        @Override
        public String stringRep(ReadMetadata readMetadata, int minEvidenceMapq) {
            return super.stringRep(readMetadata, minEvidenceMapq) + "\t" + this.readCount;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TemplateSizeAnomaly)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            TemplateSizeAnomaly that = (TemplateSizeAnomaly)o;
            return this.readCount == that.readCount;
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.readCount);
        }

        public Integer getReadCount() {
            return this.readCount;
        }

        public static final class Serializer
        extends com.esotericsoftware.kryo.Serializer<TemplateSizeAnomaly> {
            public void write(Kryo kryo, Output output, TemplateSizeAnomaly templateSizeAnomaly) {
                templateSizeAnomaly.serialize(kryo, output);
            }

            public TemplateSizeAnomaly read(Kryo kryo, Input input, Class<TemplateSizeAnomaly> klass) {
                return new TemplateSizeAnomaly(kryo, input);
            }
        }
    }

    @DefaultSerializer(value=Serializer.class)
    public static final class ExternalEvidence
    extends BreakpointEvidence {
        public ExternalEvidence(int contigID, int start, int end, int weight) {
            this(new SVInterval(contigID, start, end), weight);
        }

        public ExternalEvidence(SVInterval interval, int weight) {
            super(interval, weight, false);
        }

        public ExternalEvidence(Kryo kryo, Input input) {
            super(kryo, input);
        }

        @Override
        public String toString() {
            return super.toString() + "\tExternalEvidence";
        }

        public static final class Serializer
        extends com.esotericsoftware.kryo.Serializer<ExternalEvidence> {
            public void write(Kryo kryo, Output output, ExternalEvidence externalEvidence) {
                externalEvidence.serialize(kryo, output);
            }

            public ExternalEvidence read(Kryo kryo, Input input, Class<ExternalEvidence> klass) {
                return new ExternalEvidence(kryo, input);
            }
        }
    }

    public static final class Serializer
    extends com.esotericsoftware.kryo.Serializer<BreakpointEvidence> {
        public void write(Kryo kryo, Output output, BreakpointEvidence evidence) {
            evidence.serialize(kryo, output);
        }

        public BreakpointEvidence read(Kryo kryo, Input input, Class<BreakpointEvidence> klass) {
            return new BreakpointEvidence(kryo, input);
        }
    }
}

