/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.spark.sv.evidence;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import org.apache.commons.collections4.iterators.SingletonIterator;
import org.broadinstitute.hellbender.tools.spark.sv.evidence.BreakpointEvidence;
import org.broadinstitute.hellbender.tools.spark.sv.evidence.PartitionCrossingChecker;
import org.broadinstitute.hellbender.tools.spark.sv.utils.SVInterval;

public final class BreakpointEvidenceClusterer
implements Function<BreakpointEvidence, Iterator<BreakpointEvidence>> {
    private final int gapSize;
    private final PartitionCrossingChecker partitionCrossingChecker;
    private SVInterval curInterval;
    private int curWeight;
    private static final Iterator<BreakpointEvidence> EMPTY_ITERATOR = Collections.emptyIterator();

    public BreakpointEvidenceClusterer(int gapSize, PartitionCrossingChecker partitionCrossingChecker) {
        this.gapSize = gapSize;
        this.partitionCrossingChecker = partitionCrossingChecker;
        this.curWeight = 0;
    }

    @Override
    public Iterator<BreakpointEvidence> apply(BreakpointEvidence evidence) {
        if (this.partitionCrossingChecker.onBoundary(evidence.getLocation())) {
            if (this.curInterval == null) {
                return new SingletonIterator((Object)evidence);
            }
            ArrayList<BreakpointEvidence> evList = new ArrayList<BreakpointEvidence>(2);
            evList.add(new BreakpointEvidence(this.curInterval, this.curWeight, true));
            evList.add(evidence);
            this.curInterval = null;
            return evList.iterator();
        }
        SingletonIterator result = EMPTY_ITERATOR;
        SVInterval interval = evidence.getLocation();
        int weight = evidence.getWeight();
        if (this.curInterval == null) {
            this.curInterval = interval;
            this.curWeight = weight;
        } else if (this.curInterval.gapLen(interval) < this.gapSize) {
            this.curInterval = this.curInterval.join(interval);
            this.curWeight += weight;
        } else {
            result = new SingletonIterator((Object)new BreakpointEvidence(this.curInterval, this.curWeight, true));
            this.curInterval = interval;
            this.curWeight = weight;
        }
        return result;
    }
}

