/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.spark.sv.evidence;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Output;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import org.apache.logging.log4j.LogManager;
import org.apache.spark.api.java.JavaSparkContext;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.BetaFeature;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.engine.spark.GATKSparkTool;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.tools.spark.sv.StructuralVariationDiscoveryArgumentCollection;
import org.broadinstitute.hellbender.tools.spark.sv.evidence.ReadMetadata;
import org.broadinstitute.hellbender.tools.spark.sv.evidence.SVReadFilter;
import picard.cmdline.programgroups.DiagnosticsAndQCProgramGroup;

@DocumentedFeature
@BetaFeature
@CommandLineProgramProperties(oneLineSummary="(Internal) Collects read metrics relevant to structural variant discovery", summary="This tool is used in development and should not be of interest to most researchers.  It executes the first step in the workflow that the StructuralVariationDiscoveryPipelineSpark tool undertakes, but is packaged as a separately runnable tool for the convenience of developers. This tool takes a SAM/BAM/CRAM as input and calculates metrics about the reads: fragment length statistics by read group, mean length, coverage, partition statistics, etc.", programGroup=DiagnosticsAndQCProgramGroup.class)
public class CalcMetadataSpark
extends GATKSparkTool {
    private static final long serialVersionUID = 1L;
    @Argument(doc="output file for metadata", shortName="O", fullName="output")
    private String outputFile;
    @Argument(doc="write metadata as serialized binary data, rather than as human-readable text", fullName="write-as-binary")
    private boolean writeAsBinary = false;

    @Override
    public boolean requiresReads() {
        return true;
    }

    @Override
    protected void runTool(JavaSparkContext ctx) {
        StructuralVariationDiscoveryArgumentCollection.FindBreakpointEvidenceSparkArgumentCollection params = new StructuralVariationDiscoveryArgumentCollection.FindBreakpointEvidenceSparkArgumentCollection();
        ReadMetadata readMetadata = new ReadMetadata(Collections.emptySet(), this.getHeaderForReads(), 10000, this.getUnfilteredReads(), new SVReadFilter(params), LogManager.getLogger(CalcMetadataSpark.class));
        if (!this.writeAsBinary) {
            ReadMetadata.writeMetadata(readMetadata, this.outputFile);
        } else {
            try (FileOutputStream os = new FileOutputStream(this.outputFile);){
                new ReadMetadata.Serializer().write(new Kryo(), new Output((OutputStream)os), readMetadata);
            }
            catch (IOException ioe) {
                throw new UserException("Can't create output file " + this.outputFile, ioe);
            }
        }
    }
}

