/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.spark.sv.evidence;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.broadinstitute.hellbender.tools.spark.sv.evidence.BreakpointEvidence;
import org.broadinstitute.hellbender.tools.spark.sv.evidence.ReadMetadata;
import org.broadinstitute.hellbender.tools.spark.sv.utils.SVInterval;
import org.broadinstitute.hellbender.tools.spark.sv.utils.SVIntervalTree;
import org.broadinstitute.hellbender.tools.spark.sv.utils.StrandedInterval;
import org.broadinstitute.hellbender.utils.Utils;

public class EvidenceOverlapChecker {
    private final SVIntervalTree<List<BreakpointEvidence>> evidenceTree;
    private final ReadMetadata readMetadata;
    private final int minEvidenceMapQ;

    EvidenceOverlapChecker(Iterator<BreakpointEvidence> evidenceItr, ReadMetadata readMetadata, int minEvidenceMapQ) {
        this.readMetadata = readMetadata;
        this.minEvidenceMapQ = minEvidenceMapQ;
        this.evidenceTree = new SVIntervalTree();
        Utils.stream(evidenceItr).forEach(evidence -> EvidenceOverlapChecker.addToTree(this.evidenceTree, evidence.getLocation(), evidence));
    }

    private static <T> void addToTree(SVIntervalTree<List<T>> tree, SVInterval interval, T value) {
        SVIntervalTree.Entry<List<T>> entry = tree.find(interval);
        if (entry != null) {
            entry.getValue().add(value);
        } else {
            ArrayList<T> valueList = new ArrayList<T>(1);
            valueList.add(value);
            tree.put(interval, valueList);
        }
    }

    OverlapperIterator overlappers(BreakpointEvidence evidence) {
        return new OverlapperIterator(evidence, this.evidenceTree);
    }

    OverlapAndCoherenceIterator overlappersWithCoherence(BreakpointEvidence evidence) {
        return new OverlapAndCoherenceIterator(evidence, this.evidenceTree, this.readMetadata, this.minEvidenceMapQ);
    }

    Iterator<SVIntervalTree.Entry<List<BreakpointEvidence>>> getTreeIterator() {
        return this.evidenceTree.iterator();
    }

    static class OverlapAndCoherenceIterator
    implements Iterator<ImmutablePair<BreakpointEvidence, Boolean>> {
        private final ReadMetadata readMetadata;
        private final int minEvidenceMapQ;
        private final Iterator<SVIntervalTree.Entry<List<BreakpointEvidence>>> treeItr;
        private Iterator<BreakpointEvidence> listItr;
        private final boolean checkCoherence;
        private final Boolean isForwardStrand;
        private final List<StrandedInterval> distalTargets;

        OverlapAndCoherenceIterator(BreakpointEvidence evidence, SVIntervalTree<List<BreakpointEvidence>> evidenceTree, ReadMetadata readMetadata, int minEvidenceMapQ) {
            this.readMetadata = readMetadata;
            this.minEvidenceMapQ = minEvidenceMapQ;
            this.treeItr = evidenceTree.overlappers(evidence.getLocation());
            this.isForwardStrand = evidence.isEvidenceUpstreamOfBreakpoint();
            this.checkCoherence = this.isForwardStrand != null && evidence.hasDistalTargets(readMetadata, minEvidenceMapQ);
            this.distalTargets = this.checkCoherence ? new ArrayList<StrandedInterval>(evidence.getDistalTargets(readMetadata, minEvidenceMapQ)) : null;
        }

        @Override
        public boolean hasNext() {
            if (this.listItr != null && this.listItr.hasNext()) {
                return true;
            }
            while (this.treeItr.hasNext()) {
                this.listItr = this.treeItr.next().getValue().iterator();
                if (!this.listItr.hasNext()) continue;
                return true;
            }
            return false;
        }

        @Override
        public ImmutablePair<BreakpointEvidence, Boolean> next() {
            Boolean overlapperStrand;
            if (!this.hasNext()) {
                throw new NoSuchElementException("No next element.");
            }
            BreakpointEvidence overlapper = this.listItr.next();
            Boolean isCoherent = false;
            if (this.checkCoherence && (overlapperStrand = overlapper.isEvidenceUpstreamOfBreakpoint()) == this.isForwardStrand && overlapper.hasDistalTargets(this.readMetadata, this.minEvidenceMapQ)) {
                block0: for (StrandedInterval distalTarget : this.distalTargets) {
                    for (StrandedInterval overlapperDistalTarget : overlapper.getDistalTargets(this.readMetadata, this.minEvidenceMapQ)) {
                        if (distalTarget.getStrand() != overlapperDistalTarget.getStrand() || !distalTarget.getInterval().overlaps(overlapperDistalTarget.getInterval())) continue;
                        isCoherent = true;
                        continue block0;
                    }
                }
            }
            return new ImmutablePair((Object)overlapper, (Object)isCoherent);
        }
    }

    static class OverlapperIterator
    implements Iterator<BreakpointEvidence> {
        private final Iterator<SVIntervalTree.Entry<List<BreakpointEvidence>>> treeItr;
        private Iterator<BreakpointEvidence> listItr;

        OverlapperIterator(BreakpointEvidence evidence, SVIntervalTree<List<BreakpointEvidence>> evidenceTree) {
            this.treeItr = evidenceTree.overlappers(evidence.getLocation());
            this.listItr = null;
        }

        @Override
        public boolean hasNext() {
            if (this.listItr != null && this.listItr.hasNext()) {
                return true;
            }
            while (this.treeItr.hasNext()) {
                this.listItr = this.treeItr.next().getValue().iterator();
                if (!this.listItr.hasNext()) continue;
                return true;
            }
            return false;
        }

        @Override
        public BreakpointEvidence next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No next element.");
            }
            return this.listItr.next();
        }
    }
}

