/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.spark.sv.evidence;

import com.esotericsoftware.kryo.DefaultSerializer;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.util.Set;
import org.broadinstitute.hellbender.tools.spark.sv.evidence.ReadMetadata;
import org.broadinstitute.hellbender.tools.spark.sv.utils.PairedStrandedIntervals;
import org.broadinstitute.hellbender.tools.spark.sv.utils.SVInterval;
import org.broadinstitute.hellbender.tools.spark.sv.utils.StrandedInterval;
import org.broadinstitute.hellbender.utils.Utils;

@DefaultSerializer(value=Serializer.class)
public final class EvidenceTargetLink {
    private static final StrandedInterval.Serializer intervalSerializer = new StrandedInterval.Serializer();
    final StrandedInterval source;
    final StrandedInterval target;
    final int splitReads;
    final int readPairs;
    private final Set<String> readPairTemplateNames;
    private final Set<String> splitReadTemplateNames;

    public EvidenceTargetLink(StrandedInterval source, StrandedInterval target, int splitReads, int readPairs, Set<String> readPairTemplateNames, Set<String> splitReadTemplateNames) {
        this.splitReadTemplateNames = splitReadTemplateNames;
        Utils.validateArg(source != null, "Can't construct EvidenceTargetLink with null source interval");
        if (source.getInterval().isUpstreamOf(target.getInterval())) {
            this.source = source;
            this.target = target;
        } else {
            this.source = target;
            this.target = source;
        }
        this.splitReads = splitReads;
        this.readPairs = readPairs;
        this.readPairTemplateNames = readPairTemplateNames;
    }

    public Set<String> getReadPairTemplateNames() {
        return this.readPairTemplateNames;
    }

    public Set<String> getSplitReadTemplateNames() {
        return this.splitReadTemplateNames;
    }

    public EvidenceTargetLink(Kryo kryo, Input input) {
        this.source = intervalSerializer.read(kryo, input, (Class)StrandedInterval.class);
        this.target = intervalSerializer.read(kryo, input, (Class)StrandedInterval.class);
        this.splitReads = input.readInt();
        this.readPairs = input.readInt();
        this.readPairTemplateNames = (Set)kryo.readClassAndObject(input);
        this.splitReadTemplateNames = (Set)kryo.readClassAndObject(input);
    }

    protected void serialize(Kryo kryo, Output output) {
        intervalSerializer.write(kryo, output, this.source);
        intervalSerializer.write(kryo, output, this.target);
        output.writeInt(this.splitReads);
        output.writeInt(this.readPairs);
        kryo.writeClassAndObject(output, this.readPairTemplateNames);
        kryo.writeClassAndObject(output, this.splitReadTemplateNames);
    }

    public String toBedpeString(ReadMetadata readMetadata) {
        SVInterval sourceInterval = this.source.getInterval();
        SVInterval targetInterval = this.target.getInterval();
        return readMetadata.getContigName(sourceInterval.getContig()) + "\t" + (sourceInterval.getStart() - 1) + "\t" + sourceInterval.getEnd() + "\t" + readMetadata.getContigName(targetInterval.getContig()) + "\t" + (targetInterval.getStart() - 1) + "\t" + targetInterval.getEnd() + "\t" + this.getId(readMetadata) + "\t" + (this.readPairs + this.splitReads) + "\t" + (this.source.getStrand() ? "+" : "-") + "\t" + (this.target.getStrand() ? "+" : "-") + "\tSR:" + Utils.join(",", this.splitReadTemplateNames) + "\tRP:" + Utils.join(",", this.readPairTemplateNames);
    }

    private String getId(ReadMetadata readMetadata) {
        SVInterval sourceInterval = this.source.getInterval();
        SVInterval targetInterval = this.target.getInterval();
        return readMetadata.getContigName(sourceInterval.getContig()) + "_" + (sourceInterval.getStart() - 1) + "_" + sourceInterval.getEnd() + "_" + readMetadata.getContigName(targetInterval.getContig()) + "_" + (targetInterval.getStart() - 1) + "_" + targetInterval.getEnd() + "_" + (this.source.getStrand() ? "P" : "M") + (this.target.getStrand() ? "P" : "M") + "_" + this.splitReads + "_" + this.readPairs;
    }

    public int getSplitReads() {
        return this.splitReads;
    }

    public int getReadPairs() {
        return this.readPairs;
    }

    public PairedStrandedIntervals getPairedStrandedIntervals() {
        return new PairedStrandedIntervals(this.source, this.target);
    }

    public boolean isImpreciseDeletion() {
        return this.getPairedStrandedIntervals().getLeft().getInterval().getContig() == this.getPairedStrandedIntervals().getRight().getInterval().getContig() && this.getPairedStrandedIntervals().getLeft().getStrand() && !this.getPairedStrandedIntervals().getRight().getStrand();
    }

    public int getDistance() {
        if (this.getPairedStrandedIntervals().getLeft().getInterval().getContig() != this.getPairedStrandedIntervals().getRight().getInterval().getContig()) {
            return -1;
        }
        return this.getPairedStrandedIntervals().getRight().getInterval().getStart() - this.getPairedStrandedIntervals().getLeft().getInterval().getEnd();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EvidenceTargetLink link = (EvidenceTargetLink)o;
        if (this.splitReads != link.splitReads) {
            return false;
        }
        if (this.readPairs != link.readPairs) {
            return false;
        }
        if (!this.source.equals(link.source)) {
            return false;
        }
        return this.target.equals(link.target);
    }

    public int hashCode() {
        int result = this.source.hashCode();
        result = 31 * result + this.target.hashCode();
        result = 31 * result + this.splitReads;
        result = 31 * result + this.readPairs;
        return result;
    }

    public String toString() {
        return "EvidenceTargetLink{source=" + this.source + ", target=" + this.target + ", splitReads=" + this.splitReads + ", readPairs=" + this.readPairs + '}';
    }

    public static final class Serializer
    extends com.esotericsoftware.kryo.Serializer<EvidenceTargetLink> {
        public void write(Kryo kryo, Output output, EvidenceTargetLink evidence) {
            evidence.serialize(kryo, output);
        }

        public EvidenceTargetLink read(Kryo kryo, Input input, Class<EvidenceTargetLink> klass) {
            return new EvidenceTargetLink(kryo, input);
        }
    }
}

