/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.spark.sv.evidence;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import org.broadinstitute.hellbender.tools.spark.sv.evidence.BreakpointEvidence;
import org.broadinstitute.hellbender.tools.spark.sv.evidence.EvidenceTargetLink;
import org.broadinstitute.hellbender.tools.spark.sv.evidence.ReadMetadata;
import org.broadinstitute.hellbender.tools.spark.sv.utils.PairedStrandedIntervalTree;
import org.broadinstitute.hellbender.tools.spark.sv.utils.SVInterval;
import org.broadinstitute.hellbender.tools.spark.sv.utils.StrandedInterval;
import org.broadinstitute.hellbender.utils.Utils;
import scala.Tuple2;

public class EvidenceTargetLinkClusterer {
    private final ReadMetadata readMetadata;
    private final int minEvidenceMapq;

    public EvidenceTargetLinkClusterer(ReadMetadata readMetadata, int minEvidenceMapq) {
        this.readMetadata = readMetadata;
        this.minEvidenceMapq = minEvidenceMapq;
    }

    public Iterator<EvidenceTargetLink> cluster(Iterator<BreakpointEvidence> breakpointEvidenceIterator) throws Exception {
        ArrayList links = new ArrayList();
        PairedStrandedIntervalTree<EvidenceTargetLink> currentLinks = new PairedStrandedIntervalTree<EvidenceTargetLink>();
        while (breakpointEvidenceIterator.hasNext()) {
            BreakpointEvidence nextEvidence = breakpointEvidenceIterator.next();
            if (!nextEvidence.hasDistalTargets(this.readMetadata, this.minEvidenceMapq)) continue;
            Utils.validate(nextEvidence instanceof BreakpointEvidence.SplitRead || nextEvidence instanceof BreakpointEvidence.DiscordantReadPairEvidence, "Unknown evidence type with distal target: " + nextEvidence);
            EvidenceTargetLink updatedLink = null;
            String templateName = ((BreakpointEvidence.ReadEvidence)nextEvidence).getTemplateName();
            EvidenceTargetLink nextEvidenceLink = new EvidenceTargetLink(new StrandedInterval(nextEvidence.getLocation(), nextEvidence.isEvidenceUpstreamOfBreakpoint()), nextEvidence.getDistalTargets(this.readMetadata, this.minEvidenceMapq).get(0), nextEvidence instanceof BreakpointEvidence.SplitRead ? 1 : 0, nextEvidence instanceof BreakpointEvidence.DiscordantReadPairEvidence ? 1 : 0, nextEvidence instanceof BreakpointEvidence.DiscordantReadPairEvidence ? Collections.singleton(templateName) : new HashSet<String>(), nextEvidence instanceof BreakpointEvidence.SplitRead ? Collections.singleton(templateName) : new HashSet<String>());
            Iterator it = currentLinks.overlappers(nextEvidenceLink.getPairedStrandedIntervals());
            if (it.hasNext()) {
                Tuple2 matchingETL = it.next();
                EvidenceTargetLink oldLink = (EvidenceTargetLink)matchingETL._2();
                if (nextEvidence instanceof BreakpointEvidence.DiscordantReadPairEvidence && oldLink.getReadPairTemplateNames().contains(templateName) || nextEvidence instanceof BreakpointEvidence.SplitRead && oldLink.getSplitReadTemplateNames().contains(templateName)) continue;
                it.remove();
                SVInterval newSource = oldLink.source.getInterval().intersect(nextEvidenceLink.source.getInterval());
                SVInterval newTarget = oldLink.target.getInterval().intersect(nextEvidenceLink.target.getInterval());
                int newSplitReadCount = nextEvidence instanceof BreakpointEvidence.SplitRead ? oldLink.splitReads + 1 : oldLink.splitReads;
                int newReadPairCount = nextEvidence instanceof BreakpointEvidence.DiscordantReadPairEvidence ? oldLink.readPairs + 1 : oldLink.readPairs;
                HashSet<String> readPairTemplateNames = new HashSet<String>(oldLink.getReadPairTemplateNames());
                if (nextEvidence instanceof BreakpointEvidence.DiscordantReadPairEvidence) {
                    readPairTemplateNames.add(templateName);
                }
                HashSet<String> splitReadTemplateNames = new HashSet<String>(oldLink.getSplitReadTemplateNames());
                if (nextEvidence instanceof BreakpointEvidence.SplitRead) {
                    splitReadTemplateNames.add(templateName);
                }
                updatedLink = new EvidenceTargetLink(new StrandedInterval(newSource, oldLink.source.getStrand()), new StrandedInterval(newTarget, oldLink.target.getStrand()), newSplitReadCount, newReadPairCount, readPairTemplateNames, splitReadTemplateNames);
            }
            if (updatedLink == null) {
                updatedLink = nextEvidenceLink;
            }
            currentLinks.put(updatedLink.getPairedStrandedIntervals(), updatedLink);
        }
        currentLinks.forEach(entry -> links.add(entry._2()));
        return links.iterator();
    }
}

