/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.spark.sv.evidence;

import java.io.Serializable;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.broadcast.Broadcast;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.ArgumentCollection;
import org.broadinstitute.barclay.argparser.BetaFeature;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.cmdline.programgroups.StructuralVariantDiscoveryProgramGroup;
import org.broadinstitute.hellbender.engine.spark.GATKSparkTool;
import org.broadinstitute.hellbender.tools.spark.sv.StructuralVariationDiscoveryArgumentCollection;
import org.broadinstitute.hellbender.tools.spark.sv.evidence.FindBreakpointEvidenceSpark;
import org.broadinstitute.hellbender.tools.spark.sv.evidence.ReadClassifier;
import org.broadinstitute.hellbender.tools.spark.sv.evidence.ReadMetadata;
import org.broadinstitute.hellbender.tools.spark.sv.evidence.SVReadFilter;
import org.broadinstitute.hellbender.tools.spark.sv.utils.SVInterval;
import org.broadinstitute.hellbender.tools.spark.sv.utils.SVIntervalTree;
import org.broadinstitute.hellbender.tools.spark.utils.FlatMapGluer;
import org.broadinstitute.hellbender.utils.read.GATKRead;
import org.broadinstitute.hellbender.utils.read.SAMRecordToGATKReadAdapter;

@DocumentedFeature
@BetaFeature
@CommandLineProgramProperties(oneLineSummary="(Internal) Extracts evidence of structural variations from reads", summary="This tool is used in development and should not be of interest to most researchers.  It packages one step of the structural variation workflow as a separate tool for the convenience of developers. This tool examines a SAM/BAM/CRAM for reads, or groups of reads, that demonstrate evidence of a structural variation in the vicinity.  It records this evidence as a group of text files in a specified output directory on Spark's HDFS file system.", programGroup=StructuralVariantDiscoveryProgramGroup.class)
public final class ExtractSVEvidenceSpark
extends GATKSparkTool {
    private static final long serialVersionUID = 1L;
    @ArgumentCollection
    private final StructuralVariationDiscoveryArgumentCollection.FindBreakpointEvidenceSparkArgumentCollection params = new StructuralVariationDiscoveryArgumentCollection.FindBreakpointEvidenceSparkArgumentCollection();
    @Argument(doc="HDFS path for output", shortName="O", fullName="output")
    private String outputDir;

    @Override
    public boolean requiresReads() {
        return true;
    }

    @Override
    protected void runTool(JavaSparkContext ctx) {
        JavaRDD<GATKRead> unfilteredReads = this.getUnfilteredReads();
        SVReadFilter filter = new SVReadFilter(this.params);
        ReadMetadata readMetadata = FindBreakpointEvidenceSpark.buildMetadata(this.params, this.getHeaderForReads(), unfilteredReads, filter, this.logger);
        Broadcast broadcastMetadata = ctx.broadcast((Object)readMetadata);
        int allowedOverhang = this.params.allowedShortFragmentOverhang;
        int minEvidenceMapQ = this.params.minEvidenceMapQ;
        SVIntervalTree<SVInterval> highCoverageSubintervalTree = FindBreakpointEvidenceSpark.findGenomewideHighCoverageIntervalsToIgnore(this.params, readMetadata, ctx, this.getHeaderForReads(), unfilteredReads, filter, this.logger, (Broadcast<ReadMetadata>)broadcastMetadata);
        Broadcast broadcastHighCoverageSubIntervals = ctx.broadcast(highCoverageSubintervalTree);
        unfilteredReads.mapPartitions((FlatMapFunction & Serializable)readItr -> {
            SAMRecordToGATKReadAdapter sentinel = new SAMRecordToGATKReadAdapter(null);
            return FlatMapGluer.applyMapFunc(new ReadClassifier((ReadMetadata)broadcastMetadata.value(), sentinel, allowedOverhang, filter, (SVIntervalTree)broadcastHighCoverageSubIntervals.getValue()), readItr, sentinel);
        }, true).map((Function & Serializable)e -> e.stringRep((ReadMetadata)broadcastMetadata.getValue(), minEvidenceMapQ)).saveAsTextFile(this.outputDir);
    }
}

