/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.spark.sv.evidence;

import com.google.common.annotations.VisibleForTesting;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.tribble.Feature;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Logger;
import org.apache.spark.Partitioner;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.Function2;
import org.apache.spark.api.java.function.PairFlatMapFunction;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.spark.broadcast.Broadcast;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.ArgumentCollection;
import org.broadinstitute.barclay.argparser.BetaFeature;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.cmdline.programgroups.StructuralVariantDiscoveryProgramGroup;
import org.broadinstitute.hellbender.engine.FeatureDataSource;
import org.broadinstitute.hellbender.engine.spark.GATKSparkTool;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.tools.spark.sv.StructuralVariationDiscoveryArgumentCollection;
import org.broadinstitute.hellbender.tools.spark.sv.evidence.AlignedAssemblyOrExcuse;
import org.broadinstitute.hellbender.tools.spark.sv.evidence.BreakpointDensityFilter;
import org.broadinstitute.hellbender.tools.spark.sv.evidence.BreakpointEvidence;
import org.broadinstitute.hellbender.tools.spark.sv.evidence.BreakpointEvidenceClusterer;
import org.broadinstitute.hellbender.tools.spark.sv.evidence.EvidenceTargetLink;
import org.broadinstitute.hellbender.tools.spark.sv.evidence.EvidenceTargetLinkClusterer;
import org.broadinstitute.hellbender.tools.spark.sv.evidence.FermiLiteAssemblyHandler;
import org.broadinstitute.hellbender.tools.spark.sv.evidence.IntervalCoverageFinder;
import org.broadinstitute.hellbender.tools.spark.sv.evidence.KmerAndInterval;
import org.broadinstitute.hellbender.tools.spark.sv.evidence.KmerCleaner;
import org.broadinstitute.hellbender.tools.spark.sv.evidence.KmerCounter;
import org.broadinstitute.hellbender.tools.spark.sv.evidence.PartitionCrossingChecker;
import org.broadinstitute.hellbender.tools.spark.sv.evidence.QNameAndInterval;
import org.broadinstitute.hellbender.tools.spark.sv.evidence.QNameFinder;
import org.broadinstitute.hellbender.tools.spark.sv.evidence.QNameIntervalFinder;
import org.broadinstitute.hellbender.tools.spark.sv.evidence.QNameKmerizer;
import org.broadinstitute.hellbender.tools.spark.sv.evidence.ReadClassifier;
import org.broadinstitute.hellbender.tools.spark.sv.evidence.ReadMetadata;
import org.broadinstitute.hellbender.tools.spark.sv.evidence.ReadsForQNamesFinder;
import org.broadinstitute.hellbender.tools.spark.sv.evidence.SVReadFilter;
import org.broadinstitute.hellbender.tools.spark.sv.evidence.XGBoostEvidenceFilter;
import org.broadinstitute.hellbender.tools.spark.sv.utils.ComplexityPartitioner;
import org.broadinstitute.hellbender.tools.spark.sv.utils.SVFastqUtils;
import org.broadinstitute.hellbender.tools.spark.sv.utils.SVFileUtils;
import org.broadinstitute.hellbender.tools.spark.sv.utils.SVInterval;
import org.broadinstitute.hellbender.tools.spark.sv.utils.SVIntervalTree;
import org.broadinstitute.hellbender.tools.spark.sv.utils.SVKmer;
import org.broadinstitute.hellbender.tools.spark.sv.utils.SVKmerLong;
import org.broadinstitute.hellbender.tools.spark.sv.utils.SVKmerizer;
import org.broadinstitute.hellbender.tools.spark.sv.utils.SVLocation;
import org.broadinstitute.hellbender.tools.spark.sv.utils.SVUtils;
import org.broadinstitute.hellbender.tools.spark.utils.FlatMapGluer;
import org.broadinstitute.hellbender.tools.spark.utils.HopscotchUniqueMultiMap;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.bwa.BwaMemIndexCache;
import org.broadinstitute.hellbender.utils.gcs.BucketUtils;
import org.broadinstitute.hellbender.utils.read.GATKRead;
import org.broadinstitute.hellbender.utils.read.SAMRecordToGATKReadAdapter;
import org.broadinstitute.hellbender.utils.spark.SparkUtils;
import scala.Tuple2;

@DocumentedFeature
@BetaFeature
@CommandLineProgramProperties(oneLineSummary="(Internal) Produces local assemblies of genomic regions that may harbor structural variants", summary="This tool is used in development and should not be of interest to most researchers.  It packages the identification of genomic regions that might contain structural variation and the generation of local assemblies of these regions as a separate tool, independent of the calling of structural variations from these assemblies Most researchers will run StructuralVariationDiscoveryPipelineSpark, which both generates local assemblies of interesting genomic regions, and then calls structural variants from these assemblies. This tool identifies genomic regions that may harbor structural variants by integrating evidence from split reads, discordant read pairs, template-length anomalies, and copy-number variation.  It then prepares local assemblies of these regions for structural variant calling.  In addition to the reads that align to these regions, reads sharing kmers (fixed-length subsequences) with the reads aligned in these regions are extracted to produce the local assemblies. The local assemblies are done with FermiLite, and the assembled contigs are aligned to reference with BWA-MEM. The output is a file of aligned contigs from local assemblies to be used in calling structural variants.", programGroup=StructuralVariantDiscoveryProgramGroup.class)
public final class FindBreakpointEvidenceSpark
extends GATKSparkTool {
    private static final long serialVersionUID = 1L;
    public static final int DEPTH_WINDOW_SIZE = 100000;
    @ArgumentCollection
    private final StructuralVariationDiscoveryArgumentCollection.FindBreakpointEvidenceSparkArgumentCollection params = new StructuralVariationDiscoveryArgumentCollection.FindBreakpointEvidenceSparkArgumentCollection();
    @Argument(doc="sam file for aligned contigs", shortName="O", fullName="output")
    private String outputAssemblyAlignments;

    @Override
    public boolean requiresReads() {
        return true;
    }

    @Override
    protected void runTool(JavaSparkContext ctx) {
        this.validateParams();
        FindBreakpointEvidenceSpark.gatherEvidenceAndWriteContigSamFile(ctx, this.params, this.getHeaderForReads(), this.getUnfilteredReads(), this.outputAssemblyAlignments, this.logger);
    }

    public static AssembledEvidenceResults gatherEvidenceAndWriteContigSamFile(JavaSparkContext ctx, StructuralVariationDiscoveryArgumentCollection.FindBreakpointEvidenceSparkArgumentCollection params, SAMFileHeader header, JavaRDD<GATKRead> unfilteredReads, String outputAssemblyAlignments, Logger logger) {
        SVReadFilter filter = new SVReadFilter(params);
        ReadMetadata readMetadata = FindBreakpointEvidenceSpark.buildMetadata(params, header, unfilteredReads, filter, logger);
        FindBreakpointEvidenceSpark.log("Metadata retrieved.", logger);
        EvidenceScanResults evidenceScanResults = FindBreakpointEvidenceSpark.getMappedQNamesSet(params, readMetadata, ctx, header, unfilteredReads, filter, logger);
        List<SVInterval> intervals = evidenceScanResults.intervals;
        if (intervals.isEmpty()) {
            return new AssembledEvidenceResults(evidenceScanResults.readMetadata, intervals, new ArrayList<AlignedAssemblyOrExcuse>(), evidenceScanResults.evidenceTargetLinks);
        }
        HopscotchUniqueMultiMap<String, Integer, QNameAndInterval> qNamesMultiMap = evidenceScanResults.qNamesForAssemblyMultiMap;
        List<Object> alignedAssemblyOrExcuseList = params.intervalOnlyAssembly ? new ArrayList() : FindBreakpointEvidenceSpark.addAssemblyQNames(params, readMetadata, ctx, qNamesMultiMap, intervals.size(), unfilteredReads, filter, logger);
        FermiLiteAssemblyHandler fermiLiteAssemblyHandler = new FermiLiteAssemblyHandler(params.alignerIndexImageFile, params.maxFASTQSize, params.fastqDir, params.writeGFAs, params.popVariantBubbles, params.removeShadowedContigs, params.expandAssemblyGraph, params.zDropoff);
        alignedAssemblyOrExcuseList.addAll(FindBreakpointEvidenceSpark.handleAssemblies(ctx, qNamesMultiMap, unfilteredReads, filter, intervals.size(), params.includeMappingLocation, fermiLiteAssemblyHandler));
        alignedAssemblyOrExcuseList.sort(Comparator.comparingInt(AlignedAssemblyOrExcuse::getAssemblyId));
        if (params.intervalFile != null) {
            AlignedAssemblyOrExcuse.writeIntervalFile(params.intervalFile, header, intervals, alignedAssemblyOrExcuseList);
        }
        if (outputAssemblyAlignments != null) {
            AlignedAssemblyOrExcuse.writeAssemblySAMFile(outputAssemblyAlignments, alignedAssemblyOrExcuseList, header, params.assembliesSortOrder);
            FindBreakpointEvidenceSpark.log("Wrote SAM file of aligned contigs.", logger);
        }
        return new AssembledEvidenceResults(evidenceScanResults.readMetadata, intervals, alignedAssemblyOrExcuseList, evidenceScanResults.evidenceTargetLinks);
    }

    private void validateParams() {
        if (!this.outputAssemblyAlignments.endsWith(".bam") && !this.outputAssemblyAlignments.endsWith(".sam")) {
            throw new UserException("Output assembly alignments does not end with \".bam\" or \".sam\": " + this.outputAssemblyAlignments);
        }
        this.params.validate();
    }

    public static ReadMetadata buildMetadata(StructuralVariationDiscoveryArgumentCollection.FindBreakpointEvidenceSparkArgumentCollection params, SAMFileHeader header, JavaRDD<GATKRead> unfilteredReads, SVReadFilter filter, Logger logger) {
        Utils.validate(header.getSortOrder() == SAMFileHeader.SortOrder.coordinate, "The reads must be coordinate sorted.");
        Set<Integer> crossContigsToIgnoreSet = params.crossContigsToIgnoreFile == null ? Collections.emptySet() : FindBreakpointEvidenceSpark.readCrossContigsToIgnoreFile(params.crossContigsToIgnoreFile, header.getSequenceDictionary());
        ReadMetadata readMetadata = new ReadMetadata(crossContigsToIgnoreSet, header, params.maxTrackedFragmentLength, unfilteredReads, filter, logger);
        if (params.metadataFile != null) {
            ReadMetadata.writeMetadata(readMetadata, params.metadataFile);
        }
        return readMetadata;
    }

    private static EvidenceScanResults getMappedQNamesSet(StructuralVariationDiscoveryArgumentCollection.FindBreakpointEvidenceSparkArgumentCollection params, ReadMetadata readMetadata, JavaSparkContext ctx, SAMFileHeader header, JavaRDD<GATKRead> unfilteredReads, SVReadFilter filter, Logger logger) {
        Broadcast broadcastMetadata = ctx.broadcast((Object)readMetadata);
        List<List<BreakpointEvidence>> externalEvidence = FindBreakpointEvidenceSpark.readExternalEvidence(params.externalEvidenceFile, readMetadata, params.externalEvidenceWeight, params.externalEvidenceUncertainty);
        FindBreakpointEvidenceSpark.log("External evidence retrieved.", logger);
        SVIntervalTree<SVInterval> highCoverageSubintervalTree = FindBreakpointEvidenceSpark.findGenomewideHighCoverageIntervalsToIgnore(params, readMetadata, ctx, header, unfilteredReads, filter, logger, (Broadcast<ReadMetadata>)broadcastMetadata);
        Broadcast broadcastHighCoverageSubIntervals = ctx.broadcast(highCoverageSubintervalTree);
        Broadcast broadcastExternalEvidence = ctx.broadcast(externalEvidence);
        Tuple2<List<SVInterval>, List<EvidenceTargetLink>> intervalsAndEvidenceTargetLinks = FindBreakpointEvidenceSpark.getIntervalsAndEvidenceTargetLinks(params, (Broadcast<ReadMetadata>)broadcastMetadata, (Broadcast<List<List<BreakpointEvidence>>>)broadcastExternalEvidence, header, unfilteredReads, filter, logger, (Broadcast<SVIntervalTree<SVInterval>>)broadcastHighCoverageSubIntervals);
        List<SVInterval> intervals = (List<SVInterval>)intervalsAndEvidenceTargetLinks._1();
        SparkUtils.destroyBroadcast(broadcastExternalEvidence, "external evidence");
        int nIntervals = intervals.size();
        FindBreakpointEvidenceSpark.log("Discovered " + nIntervals + " intervals.", logger);
        if (nIntervals == 0) {
            return new EvidenceScanResults(readMetadata, intervals, (List)intervalsAndEvidenceTargetLinks._2(), null);
        }
        if (params.exclusionIntervalsFile != null) {
            intervals = FindBreakpointEvidenceSpark.removeIntervalsNearGapsAndLog(intervals, params.exclusionIntervalPadding, readMetadata, params.exclusionIntervalsFile, logger);
        }
        int nIntervalsAfterGapRemoval = intervals.size();
        Iterator intervalIterator = intervals.iterator();
        block0: while (intervalIterator.hasNext()) {
            SVInterval interval = (SVInterval)intervalIterator.next();
            Iterator<SVIntervalTree.Entry<SVInterval>> overlappers = highCoverageSubintervalTree.overlappers(interval);
            while (overlappers.hasNext()) {
                SVIntervalTree.Entry<SVInterval> next = overlappers.next();
                if (next.getInterval().overlapLen(interval) != interval.getLength()) continue;
                intervalIterator.remove();
                continue block0;
            }
        }
        int nIntervalsAfterDepthCleaning = intervals.size();
        FindBreakpointEvidenceSpark.log("Removed " + (nIntervalsAfterGapRemoval - nIntervalsAfterDepthCleaning) + " intervals that were entirely high-depth.", logger);
        HopscotchUniqueMultiMap<String, Integer, QNameAndInterval> qNamesMultiMap = FindBreakpointEvidenceSpark.getQNames(params, ctx, (Broadcast<ReadMetadata>)broadcastMetadata, intervals, unfilteredReads, filter, (Broadcast<SVIntervalTree<SVInterval>>)broadcastHighCoverageSubIntervals);
        SparkUtils.destroyBroadcast(broadcastHighCoverageSubIntervals, "high-coverage subintervals");
        SparkUtils.destroyBroadcast(broadcastMetadata, "read metadata");
        if (params.qNamesMappedFile != null) {
            QNameAndInterval.writeQNames(params.qNamesMappedFile, qNamesMultiMap);
        }
        FindBreakpointEvidenceSpark.log("Discovered " + qNamesMultiMap.size() + " mapped template names.", logger);
        return new EvidenceScanResults(readMetadata, intervals, (List)intervalsAndEvidenceTargetLinks._2(), qNamesMultiMap);
    }

    static SVIntervalTree<SVInterval> findGenomewideHighCoverageIntervalsToIgnore(StructuralVariationDiscoveryArgumentCollection.FindBreakpointEvidenceSparkArgumentCollection params, ReadMetadata readMetadata, JavaSparkContext ctx, SAMFileHeader header, JavaRDD<GATKRead> unfilteredReads, SVReadFilter filter, Logger logger, Broadcast<ReadMetadata> broadcastMetadata) {
        int capacity = header.getSequenceDictionary().getSequences().stream().mapToInt(seqRec -> (seqRec.getSequenceLength() + 100000 - 1) / 100000).sum();
        ArrayList<SVInterval> depthIntervals = new ArrayList<SVInterval>(capacity);
        for (SAMSequenceRecord sequenceRecord : header.getSequenceDictionary().getSequences()) {
            int contigID = readMetadata.getContigID(sequenceRecord.getSequenceName());
            int contigLength = sequenceRecord.getSequenceLength();
            for (int i2 = 1; i2 < contigLength; i2 += 100000) {
                depthIntervals.add(new SVInterval(contigID, i2, Math.min(contigLength, i2 + 100000)));
            }
        }
        List<SVInterval> highCoverageSubintervals = FindBreakpointEvidenceSpark.findHighCoverageSubintervalsAndLog(params, ctx, broadcastMetadata, depthIntervals, unfilteredReads, filter, logger);
        SVIntervalTree<SVInterval> highCoverageSubintervalTree = new SVIntervalTree<SVInterval>();
        highCoverageSubintervals.forEach(i -> highCoverageSubintervalTree.put((SVInterval)i, (SVInterval)i));
        return highCoverageSubintervalTree;
    }

    private static Set<Integer> readCrossContigsToIgnoreFile(String crossContigsToIgnoreFile, SAMSequenceDictionary dictionary) {
        HashSet<Integer> ignoreSet = new HashSet<Integer>();
        try (BufferedReader rdr = new BufferedReader(new InputStreamReader(BucketUtils.openFile(crossContigsToIgnoreFile)));){
            String line;
            while ((line = rdr.readLine()) != null) {
                int tigId = dictionary.getSequenceIndex(line);
                if (tigId == -1) {
                    throw new UserException("crossContigToIgnoreFile contains an unrecognized contig name: " + line);
                }
                ignoreSet.add(tigId);
            }
        }
        catch (IOException ioe) {
            throw new UserException("Can't read crossContigToIgnore file " + crossContigsToIgnoreFile, ioe);
        }
        return ignoreSet;
    }

    @VisibleForTesting
    static List<List<BreakpointEvidence>> readExternalEvidence(String path, ReadMetadata readMetadata, int externalEvidenceWeight, int externalEvidenceUncertainty) {
        int idx;
        int nPartitions = readMetadata.getNPartitions();
        ArrayList<List<BreakpointEvidence>> evidenceByPartition = new ArrayList<List<BreakpointEvidence>>(nPartitions);
        for (int idx2 = 0; idx2 != nPartitions; ++idx2) {
            evidenceByPartition.add(new ArrayList());
        }
        if (path == null) {
            return evidenceByPartition;
        }
        Object[] partitionBoundaries = new SVLocation[nPartitions + 1];
        for (idx = 0; idx != nPartitions; ++idx) {
            ReadMetadata.PartitionBounds bounds = readMetadata.getPartitionBounds(idx);
            partitionBoundaries[idx] = new SVLocation(bounds.getFirstContigID(), bounds.getFirstStart());
        }
        partitionBoundaries[nPartitions] = new SVLocation(Integer.MAX_VALUE, Integer.MAX_VALUE);
        for (idx = 0; idx != nPartitions; ++idx) {
            if (partitionBoundaries[idx].compareTo(partitionBoundaries[idx + 1]) <= 0) continue;
            throw new GATKException("Partition boundaries are not coordinate sorted.");
        }
        Map<String, Integer> contigNameMap = readMetadata.getContigNameMap();
        SVLocation prevLocation = new SVLocation(0, 0);
        int partitionIdx = 0;
        try (FeatureDataSource dataSource = new FeatureDataSource(path, null, 0, null);){
            for (Feature feature : dataSource) {
                Integer contigID = contigNameMap.get(feature.getContig());
                if (contigID == null) {
                    throw new UserException(path + " contains a contig name not present in the BAM header: " + feature.getContig());
                }
                int featureStart = feature.getStart();
                SVLocation featureLocation = new SVLocation(contigID, featureStart);
                if (prevLocation.compareTo(featureLocation) > 0) {
                    throw new UserException("Features in " + path + " are not coordinate sorted.");
                }
                prevLocation = featureLocation;
                while (featureLocation.compareTo(partitionBoundaries[partitionIdx + 1]) >= 0) {
                    ++partitionIdx;
                }
                List partitionEvidence = (List)evidenceByPartition.get(partitionIdx);
                int featureEnd = feature.getEnd();
                if (featureEnd - featureStart <= 2 * externalEvidenceUncertainty) {
                    partitionEvidence.add(new BreakpointEvidence.ExternalEvidence(contigID, featureStart, featureEnd, externalEvidenceWeight));
                    continue;
                }
                SVInterval interval1 = BreakpointEvidence.fixedWidthInterval(contigID, featureStart, externalEvidenceUncertainty);
                partitionEvidence.add(new BreakpointEvidence.ExternalEvidence(interval1, externalEvidenceWeight));
                SVInterval interval2 = BreakpointEvidence.fixedWidthInterval(contigID, featureEnd, externalEvidenceUncertainty);
                SVLocation startLocation2 = interval2.getStartLocation();
                int partitionIdx2 = partitionIdx;
                if (startLocation2.compareTo(partitionBoundaries[partitionIdx + 1]) >= 0 && (partitionIdx2 = Arrays.binarySearch(partitionBoundaries, interval2.getStartLocation())) < 0 && (partitionIdx2 ^= 0xFFFFFFFF) > 0) {
                    --partitionIdx2;
                }
                ((List)evidenceByPartition.get(partitionIdx2)).add(new BreakpointEvidence.ExternalEvidence(interval2, externalEvidenceWeight));
            }
        }
        return evidenceByPartition;
    }

    private static List<AlignedAssemblyOrExcuse> addAssemblyQNames(StructuralVariationDiscoveryArgumentCollection.FindBreakpointEvidenceSparkArgumentCollection params, ReadMetadata readMetadata, JavaSparkContext ctx, HopscotchUniqueMultiMap<String, Integer, QNameAndInterval> qNamesMultiMap, int nIntervals, JavaRDD<GATKRead> unfilteredReads, SVReadFilter filter, Logger logger) {
        Tuple2<List<AlignedAssemblyOrExcuse>, HopscotchUniqueMultiMap<SVKmer, Integer, KmerAndInterval>> kmerIntervalsAndDispositions = FindBreakpointEvidenceSpark.getKmerAndIntervalsSet(params, readMetadata, ctx, qNamesMultiMap, nIntervals, unfilteredReads, filter, logger);
        HopscotchUniqueMultiMap<SVKmer, Integer, KmerAndInterval> kmersAndIntervals = FindBreakpointEvidenceSpark.removeUbiquitousKmers(params, readMetadata, ctx, (HopscotchUniqueMultiMap)kmerIntervalsAndDispositions._2(), unfilteredReads, filter, logger);
        qNamesMultiMap.addAll(FindBreakpointEvidenceSpark.getAssemblyQNames(params, ctx, kmersAndIntervals, unfilteredReads, filter));
        if (params.qNamesAssemblyFile != null) {
            QNameAndInterval.writeQNames(params.qNamesAssemblyFile, qNamesMultiMap);
        }
        FindBreakpointEvidenceSpark.log("Discovered " + qNamesMultiMap.size() + " unique template names for assembly.", logger);
        return (List)kmerIntervalsAndDispositions._1();
    }

    private static Tuple2<List<AlignedAssemblyOrExcuse>, HopscotchUniqueMultiMap<SVKmer, Integer, KmerAndInterval>> getKmerAndIntervalsSet(StructuralVariationDiscoveryArgumentCollection.FindBreakpointEvidenceSparkArgumentCollection params, ReadMetadata readMetadata, JavaSparkContext ctx, HopscotchUniqueMultiMap<String, Integer, QNameAndInterval> qNamesMultiMap, int nIntervals, JavaRDD<GATKRead> unfilteredReads, SVReadFilter filter, Logger logger) {
        Set<SVKmer> kmerKillSet = SVFileUtils.readKmersFile(params.kmersToIgnoreFile, params.kSize);
        if (params.adapterSequence != null) {
            SVKmerizer.stream(params.adapterSequence, params.kSize, 0, (SVKmer)new SVKmerLong()).forEach(kmer -> kmerKillSet.add(kmer.canonical(params.kSize)));
        }
        FindBreakpointEvidenceSpark.log("Ignoring " + kmerKillSet.size() + " genomically common kmers.", logger);
        Tuple2<List<AlignedAssemblyOrExcuse>, List<KmerAndInterval>> kmerIntervalsAndDispositions = FindBreakpointEvidenceSpark.getKmerIntervals(params, readMetadata, ctx, qNamesMultiMap, nIntervals, kmerKillSet, unfilteredReads, filter, logger);
        HopscotchUniqueMultiMap kmerMultiMap = new HopscotchUniqueMultiMap((Collection)kmerIntervalsAndDispositions._2());
        FindBreakpointEvidenceSpark.log("Discovered " + kmerMultiMap.size() + " kmers.", logger);
        return new Tuple2(kmerIntervalsAndDispositions._1(), kmerMultiMap);
    }

    @VisibleForTesting
    static List<AlignedAssemblyOrExcuse> handleAssemblies(JavaSparkContext ctx, HopscotchUniqueMultiMap<String, Integer, QNameAndInterval> qNamesMultiMap, JavaRDD<GATKRead> unfilteredReads, SVReadFilter filter, int nIntervals, boolean includeMappingLocation, LocalAssemblyHandler localAssemblyHandler) {
        int[] counts = new int[nIntervals];
        for (QNameAndInterval qNameAndInterval : qNamesMultiMap) {
            int n = qNameAndInterval.getIntervalId();
            counts[n] = counts[n] + 1;
        }
        ComplexityPartitioner partitioner = new ComplexityPartitioner(counts);
        Broadcast broadcastQNamesMultiMap = ctx.broadcast(qNamesMultiMap);
        List intervalDispositions = unfilteredReads.mapPartitionsToPair((PairFlatMapFunction & Serializable)readItr -> new ReadsForQNamesFinder((HopscotchUniqueMultiMap)broadcastQNamesMultiMap.value(), nIntervals, includeMappingLocation, (Iterator<GATKRead>)readItr, filter).iterator(), false).combineByKey((Function & Serializable)x -> x, SVUtils::concatenateLists, SVUtils::concatenateLists, (Partitioner)partitioner, false, null).map(localAssemblyHandler::apply).collect();
        SparkUtils.destroyBroadcast(broadcastQNamesMultiMap, "QNames multi map");
        BwaMemIndexCache.closeAllDistributedInstances(ctx);
        return intervalDispositions;
    }

    private static HopscotchUniqueMultiMap<SVKmer, Integer, KmerAndInterval> removeUbiquitousKmers(StructuralVariationDiscoveryArgumentCollection.FindBreakpointEvidenceSparkArgumentCollection params, ReadMetadata readMetadata, JavaSparkContext ctx, HopscotchUniqueMultiMap<SVKmer, Integer, KmerAndInterval> kmersAndIntervals, JavaRDD<GATKRead> unfilteredReads, SVReadFilter filter, Logger logger) {
        Broadcast broadcastKmersAndIntervals = ctx.broadcast(kmersAndIntervals);
        int kmersPerPartition = kmersAndIntervals.size();
        int kSize = params.kSize;
        int partitionSpan = readMetadata.getMedianPartitionSpan();
        float partitionsPerLocus = (partitionSpan + readMetadata.getAvgReadLen() - params.kSize) / partitionSpan;
        int maxPartitionCount = (int)((float)params.cleanerMaxCopyNumber * partitionsPerLocus);
        logger.info("Cleanup: maxPartitions=" + maxPartitionCount);
        int maxCount = (int)((float)params.cleanerMaxCopyNumber * readMetadata.getAccurateKmerCoverage(kSize));
        List ubiquitousKmers = unfilteredReads.filter(filter::notJunk).filter(filter::isPrimaryLine).mapPartitions((FlatMapFunction & Serializable)readItr -> new KmerCounter(kSize, kmersPerPartition, (HopscotchUniqueMultiMap)broadcastKmersAndIntervals.getValue()).apply((Iterator<GATKRead>)readItr)).mapToPair((PairFunction & Serializable)kmerAndCount -> new Tuple2((Object)kmerAndCount.getKey(), (Object)new IntPair(1, kmerAndCount.getValue()))).reduceByKey(IntPair::reduce).filter((Function & Serializable)pair -> {
            IntPair intPair = (IntPair)pair._2();
            return intPair.int1() > maxPartitionCount || intPair.int2() > maxCount;
        }).map(Tuple2::_1).collect();
        for (SVKmer kmer : ubiquitousKmers) {
            Iterator entryItr = kmersAndIntervals.findEach(kmer);
            while (entryItr.hasNext()) {
                entryItr.next();
                entryItr.remove();
            }
        }
        SparkUtils.destroyBroadcast(broadcastKmersAndIntervals, "kmers and intervals");
        FindBreakpointEvidenceSpark.log("Removed " + ubiquitousKmers.size() + " ubiquitous kmers.", logger);
        return kmersAndIntervals;
    }

    @VisibleForTesting
    static List<QNameAndInterval> getAssemblyQNames(StructuralVariationDiscoveryArgumentCollection.FindBreakpointEvidenceSparkArgumentCollection params, JavaSparkContext ctx, HopscotchUniqueMultiMap<SVKmer, Integer, KmerAndInterval> kmerMultiMap, JavaRDD<GATKRead> unfilteredReads, SVReadFilter filter) {
        Broadcast broadcastKmersAndIntervals = ctx.broadcast(kmerMultiMap);
        int kSize = params.kSize;
        List qNamesAndIntervals = unfilteredReads.filter(filter::notJunk).filter(filter::isPrimaryLine).mapPartitions((FlatMapFunction & Serializable)readItr -> new FlatMapGluer<GATKRead, QNameAndInterval>(new QNameIntervalFinder(kSize, (HopscotchUniqueMultiMap)broadcastKmersAndIntervals.getValue()), (Iterator<GATKRead>)readItr)).collect();
        SparkUtils.destroyBroadcast(broadcastKmersAndIntervals, "cleaned kmers and intervals");
        return qNamesAndIntervals;
    }

    @VisibleForTesting
    static Tuple2<List<AlignedAssemblyOrExcuse>, List<KmerAndInterval>> getKmerIntervals(StructuralVariationDiscoveryArgumentCollection.FindBreakpointEvidenceSparkArgumentCollection params, ReadMetadata readMetadata, JavaSparkContext ctx, HopscotchUniqueMultiMap<String, Integer, QNameAndInterval> qNamesMultiMap, int nIntervals, Set<SVKmer> kmerKillSet, JavaRDD<GATKRead> unfilteredReads, SVReadFilter filter, Logger logger) {
        Broadcast broadcastKmerKillSet = ctx.broadcast(kmerKillSet);
        Broadcast broadcastQNameAndIntervalsMultiMap = ctx.broadcast(qNamesMultiMap);
        int kSize = params.kSize;
        int kmersPerPartition = (int)(2L * readMetadata.getNRefBases() / (long)readMetadata.getNPartitions());
        float effectiveDiploidCoverage = readMetadata.getAccurateKmerCoverage(kSize);
        float effectiveHaploidCoverage = effectiveDiploidCoverage / 2.0f;
        float effectiveHaploidCoverageSD = (float)Math.sqrt(effectiveHaploidCoverage);
        float minCoverage = effectiveHaploidCoverage - 3.0f * effectiveHaploidCoverageSD;
        int minKmers = Math.max(params.cleanerMinKmerCount, Math.round(minCoverage));
        int maxKmers = Math.round((float)params.cleanerMaxCopyNumber * effectiveDiploidCoverage);
        logger.info("Cleanup: minKmers=" + minKmers + " maxKmers=" + maxKmers);
        int maxIntervals = params.cleanerMaxIntervals;
        int maxDUSTScore = params.maxDUSTScore;
        List kmerIntervals = unfilteredReads.mapPartitionsToPair((PairFlatMapFunction & Serializable)readItr -> new FlatMapGluer<GATKRead, Tuple2<KmerAndInterval, Integer>>(new QNameKmerizer((HopscotchUniqueMultiMap)broadcastQNameAndIntervalsMultiMap.value(), (Set)broadcastKmerKillSet.value(), kSize, maxDUSTScore, filter), (Iterator<GATKRead>)readItr), false).reduceByKey(Integer::sum).mapPartitions((FlatMapFunction & Serializable)itr -> new KmerCleaner((Iterator<Tuple2<KmerAndInterval, Integer>>)itr, kmersPerPartition, minKmers, maxKmers, maxIntervals).iterator()).collect();
        SparkUtils.destroyBroadcast(broadcastQNameAndIntervalsMultiMap, "QNames and intervals");
        SparkUtils.destroyBroadcast(broadcastKmerKillSet, "kmer kill set");
        int[] intervalKmerCounts = new int[nIntervals];
        for (KmerAndInterval kmerAndInterval2 : kmerIntervals) {
            int n = kmerAndInterval2.getIntervalId();
            intervalKmerCounts[n] = intervalKmerCounts[n] + 1;
        }
        HashSet<Integer> intervalsToKill = new HashSet<Integer>();
        ArrayList<AlignedAssemblyOrExcuse> intervalDispositions = new ArrayList<AlignedAssemblyOrExcuse>();
        for (int idx = 0; idx != intervalKmerCounts.length; ++idx) {
            if (intervalKmerCounts[idx] >= params.minKmersPerInterval) continue;
            intervalsToKill.add(idx);
            intervalDispositions.add(new AlignedAssemblyOrExcuse(idx, "FASTQ not written -- too few kmers"));
        }
        qNamesMultiMap.removeIf(qNameAndInterval -> intervalsToKill.contains(qNameAndInterval.getIntervalId()));
        List filteredKmerIntervals = kmerIntervals.stream().filter(kmerAndInterval -> !intervalsToKill.contains(kmerAndInterval.getIntervalId())).collect(SVUtils.arrayListCollector(kmerIntervals.size()));
        if (params.kmerFile != null) {
            try (OutputStreamWriter writer = new OutputStreamWriter(new BufferedOutputStream(BucketUtils.createFile(params.kmerFile)));){
                for (KmerAndInterval kmerAndInterval3 : filteredKmerIntervals) {
                    writer.write(kmerAndInterval3.toString(kSize) + " " + kmerAndInterval3.getIntervalId() + "\n");
                }
            }
            catch (IOException ioe) {
                throw new GATKException("Can't write kmer intervals file " + params.kmerFile, ioe);
            }
        }
        return new Tuple2(intervalDispositions, (Object)filteredKmerIntervals);
    }

    private static List<SVInterval> removeIntervalsNearGapsAndLog(List<SVInterval> intervals, int minDistanceToGap, ReadMetadata readMetadata, String exclusionIntervalsFile, Logger logger) {
        List<SVInterval> result = FindBreakpointEvidenceSpark.removeIntervalsNearGaps(intervals, minDistanceToGap, readMetadata.getContigNameMap(), exclusionIntervalsFile);
        int nKilledIntervals = intervals.size() - result.size();
        FindBreakpointEvidenceSpark.log("Killed " + nKilledIntervals + " intervals that were near reference gaps.", logger);
        return result;
    }

    @VisibleForTesting
    static List<SVInterval> removeIntervalsNearGaps(List<SVInterval> intervals, int minDistanceToGap, Map<String, Integer> contigNameMap, String exclusionIntervalsFile) {
        if (exclusionIntervalsFile == null) {
            return intervals;
        }
        TreeSet<SVInterval> gaps = new TreeSet<SVInterval>(SVFileUtils.readIntervalsFile(exclusionIntervalsFile, contigNameMap));
        return intervals.stream().filter(interval -> {
            SVInterval gapInterval;
            SVInterval gapInterval2;
            SortedSet<SVInterval> headSet = gaps.headSet((SVInterval)interval);
            if (!headSet.isEmpty() && (gapInterval2 = headSet.last()).gapLen((SVInterval)interval) < minDistanceToGap) {
                return false;
            }
            SortedSet<SVInterval> tailSet = gaps.tailSet((SVInterval)interval);
            return tailSet.isEmpty() || interval.gapLen(gapInterval = tailSet.first()) >= minDistanceToGap;
        }).collect(Collectors.toCollection(() -> new ArrayList(intervals.size())));
    }

    private static List<SVInterval> findHighCoverageSubintervalsAndLog(StructuralVariationDiscoveryArgumentCollection.FindBreakpointEvidenceSparkArgumentCollection params, JavaSparkContext ctx, Broadcast<ReadMetadata> broadcastMetadata, List<SVInterval> intervals, JavaRDD<GATKRead> unfilteredReads, SVReadFilter filter, Logger logger) {
        int minFlankingHighCovFactor = params.highDepthCoverageFactor;
        int minPeakHighCovFactor = params.highDepthCoveragePeakFactor;
        ReadMetadata shortReadMetadata = (ReadMetadata)broadcastMetadata.getValue();
        int minFlankingHighCoverageValue = (int)((float)minFlankingHighCovFactor * shortReadMetadata.getCoverage());
        int minPeakHighCoverageValue = (int)((float)minPeakHighCovFactor * shortReadMetadata.getCoverage());
        List<SVInterval> result = FindBreakpointEvidenceSpark.findHighCoverageSubIntervals(ctx, broadcastMetadata, intervals, unfilteredReads, filter, minFlankingHighCoverageValue, minPeakHighCoverageValue);
        FindBreakpointEvidenceSpark.log("Found " + result.size() + " sub-intervals with coverage over " + minFlankingHighCoverageValue + " and a peak coverage of over " + minPeakHighCoverageValue + ".", logger);
        String intervalFile = params.highCoverageIntervalsFile;
        if (intervalFile != null) {
            try (OutputStreamWriter writer = new OutputStreamWriter(new BufferedOutputStream(BucketUtils.createFile(intervalFile)));){
                for (SVInterval svInterval : result) {
                    String bedLine = shortReadMetadata.getContigName(svInterval.getContig()) + "\t" + (svInterval.getStart() - 1) + "\t" + svInterval.getEnd() + "\n";
                    writer.write(bedLine);
                }
            }
            catch (IOException ioe) {
                throw new UserException.CouldNotCreateOutputFile("Can't write high coverage intervals file " + intervalFile, (Exception)ioe);
            }
        }
        return result;
    }

    @VisibleForTesting
    static List<SVInterval> findHighCoverageSubIntervals(JavaSparkContext ctx, Broadcast<ReadMetadata> broadcastMetadata, List<SVInterval> intervals, JavaRDD<GATKRead> unfilteredReads, SVReadFilter filter, int minFlankingHighCoverageValue, int minPeakHighCoverageValue) {
        Broadcast broadcastIntervals = ctx.broadcast(intervals);
        List highCoverageIntervalRegions = unfilteredReads.mapPartitionsToPair((PairFlatMapFunction & Serializable)readItr -> new IntervalCoverageFinder((ReadMetadata)broadcastMetadata.value(), (List)broadcastIntervals.value(), (Iterator<GATKRead>)readItr, filter).iterator()).reduceByKey((Function2 & Serializable)(a, b) -> {
            int[] result = new int[((int[])a).length];
            for (int i = 0; i < ((int[])a).length; ++i) {
                result[i] = a[i] + b[i];
            }
            return result;
        }).flatMap((FlatMapFunction & Serializable)kv -> FindBreakpointEvidenceSpark.findHighCoverageSubintervals((Broadcast<List<SVInterval>>)broadcastIntervals, (Tuple2<Integer, int[]>)kv, minFlankingHighCoverageValue, minPeakHighCoverageValue)).collect();
        ArrayList<IntervalCoverageFinder.CandidateCoverageInterval> sortedRegions = new ArrayList<IntervalCoverageFinder.CandidateCoverageInterval>(highCoverageIntervalRegions);
        sortedRegions.sort(Comparator.comparing(IntervalCoverageFinder.CandidateCoverageInterval::getInterval, SVInterval::compareTo));
        ArrayList<SVInterval> windowBoundaryMergedHighCoverageIntervalRegions = new ArrayList<SVInterval>(sortedRegions.size());
        if (sortedRegions.size() > 0) {
            IntervalCoverageFinder.CandidateCoverageInterval prev = (IntervalCoverageFinder.CandidateCoverageInterval)sortedRegions.get(0);
            for (int i = 1; i < sortedRegions.size(); ++i) {
                IntervalCoverageFinder.CandidateCoverageInterval curr = (IntervalCoverageFinder.CandidateCoverageInterval)sortedRegions.get(i);
                if (prev.getInterval().gapLen(curr.getInterval()) == 0) {
                    prev = new IntervalCoverageFinder.CandidateCoverageInterval(prev.getInterval().join(curr.getInterval()), prev.containsMaxCoveragePeak() || curr.containsMaxCoveragePeak());
                    continue;
                }
                if (prev.containsMaxCoveragePeak()) {
                    windowBoundaryMergedHighCoverageIntervalRegions.add(prev.getInterval());
                }
                prev = curr;
            }
            if (prev.containsMaxCoveragePeak()) {
                windowBoundaryMergedHighCoverageIntervalRegions.add(prev.getInterval());
            }
        }
        ArrayList<SVInterval> gapMergedHighCoverageIntervalRegions = new ArrayList<SVInterval>(windowBoundaryMergedHighCoverageIntervalRegions.size());
        if (windowBoundaryMergedHighCoverageIntervalRegions.size() > 0) {
            SVInterval prev = (SVInterval)windowBoundaryMergedHighCoverageIntervalRegions.get(0);
            for (int i = 1; i < windowBoundaryMergedHighCoverageIntervalRegions.size(); ++i) {
                SVInterval curr = (SVInterval)windowBoundaryMergedHighCoverageIntervalRegions.get(i);
                if (prev.gapLen(curr) <= ((ReadMetadata)broadcastMetadata.getValue()).getAvgReadLen()) {
                    prev = prev.join(curr);
                    continue;
                }
                gapMergedHighCoverageIntervalRegions.add(prev);
                prev = curr;
            }
            gapMergedHighCoverageIntervalRegions.add(prev);
        }
        SparkUtils.destroyBroadcast(broadcastIntervals, "intervals");
        return gapMergedHighCoverageIntervalRegions;
    }

    static Iterator<IntervalCoverageFinder.CandidateCoverageInterval> findHighCoverageSubintervals(Broadcast<List<SVInterval>> broadcastIntervals, Tuple2<Integer, int[]> intervalCoverage, int minFlankingHighCoverageValue, int minPeakHighCoverageValue) {
        SVInterval interval = (SVInterval)((List)broadcastIntervals.getValue()).get((Integer)intervalCoverage._1);
        int[] coverageArray = (int[])intervalCoverage._2;
        return IntervalCoverageFinder.getHighCoverageIntervalsInWindow(minFlankingHighCoverageValue, minPeakHighCoverageValue, interval, coverageArray);
    }

    @VisibleForTesting
    static HopscotchUniqueMultiMap<String, Integer, QNameAndInterval> getQNames(StructuralVariationDiscoveryArgumentCollection.FindBreakpointEvidenceSparkArgumentCollection params, JavaSparkContext ctx, Broadcast<ReadMetadata> broadcastMetadata, List<SVInterval> intervals, JavaRDD<GATKRead> unfilteredReads, SVReadFilter filter, Broadcast<SVIntervalTree<SVInterval>> broadcastHighCoverageSubIntervals) {
        Broadcast broadcastIntervals = ctx.broadcast(intervals);
        List qNameAndIntervalList = unfilteredReads.mapPartitions((FlatMapFunction & Serializable)readItr -> new FlatMapGluer<GATKRead, QNameAndInterval>(new QNameFinder((ReadMetadata)broadcastMetadata.value(), (List)broadcastIntervals.value(), filter, (SVIntervalTree)broadcastHighCoverageSubIntervals.value()), (Iterator<GATKRead>)readItr), false).collect();
        SparkUtils.destroyBroadcast(broadcastIntervals, "intervals");
        HopscotchUniqueMultiMap<String, Integer, QNameAndInterval> qNamesMultiMap = new HopscotchUniqueMultiMap<String, Integer, QNameAndInterval>(params.assemblyToMappedSizeRatioGuess * qNameAndIntervalList.size());
        qNamesMultiMap.addAll(qNameAndIntervalList);
        return qNamesMultiMap;
    }

    @VisibleForTesting
    static Tuple2<List<SVInterval>, List<EvidenceTargetLink>> getIntervalsAndEvidenceTargetLinks(StructuralVariationDiscoveryArgumentCollection.FindBreakpointEvidenceSparkArgumentCollection params, Broadcast<ReadMetadata> broadcastMetadata, Broadcast<List<List<BreakpointEvidence>>> broadcastExternalEvidenceByPartition, SAMFileHeader header, JavaRDD<GATKRead> unfilteredReads, SVReadFilter filter, Logger logger, Broadcast<SVIntervalTree<SVInterval>> highCoverageSubintervalTree) {
        int nContigs = header.getSequenceDictionary().getSequences().size();
        int allowedOverhang = params.allowedShortFragmentOverhang;
        int minEvidenceMapQ = params.minEvidenceMapQ;
        JavaRDD evidenceRDD = unfilteredReads.mapPartitions((FlatMapFunction & Serializable)readItr -> {
            SAMRecordToGATKReadAdapter sentinel = new SAMRecordToGATKReadAdapter(null);
            return FlatMapGluer.applyMapFunc(new ReadClassifier((ReadMetadata)broadcastMetadata.value(), sentinel, allowedOverhang, filter, (SVIntervalTree)highCoverageSubintervalTree.getValue()), readItr, sentinel);
        }, true);
        evidenceRDD.cache();
        if (params.unfilteredEvidenceDir != null) {
            evidenceRDD.map((Function & Serializable)e -> e.stringRep((ReadMetadata)broadcastMetadata.getValue(), minEvidenceMapQ)).saveAsTextFile(params.unfilteredEvidenceDir);
        }
        JavaRDD evidenceTargetLinkJavaRDD = evidenceRDD.mapPartitions((FlatMapFunction & Serializable)itr -> {
            ReadMetadata readMetadata = (ReadMetadata)broadcastMetadata.getValue();
            EvidenceTargetLinkClusterer clusterer = new EvidenceTargetLinkClusterer(readMetadata, minEvidenceMapQ);
            return clusterer.cluster((Iterator<BreakpointEvidence>)itr);
        }).filter((Function & Serializable)link -> link.readPairs >= 2 || link.splitReads >= 1);
        List evidenceTargetLinks = evidenceTargetLinkJavaRDD.collect();
        FindBreakpointEvidenceSpark.log("Collected " + evidenceTargetLinks.size() + " evidence target links", logger);
        FindBreakpointEvidenceSpark.writeTargetLinks(broadcastMetadata, evidenceTargetLinks, params.targetLinkFile);
        JavaRDD filteredEvidenceRDD = evidenceRDD.mapPartitionsWithIndex((Function2 & Serializable)(idx, evidenceItr1) -> {
            ReadMetadata readMetadata = (ReadMetadata)broadcastMetadata.value();
            PartitionCrossingChecker xChecker = new PartitionCrossingChecker((int)idx, readMetadata, readMetadata.getMaxMedianFragmentSize());
            Iterator evidenceItr2 = ((List)((List)broadcastExternalEvidenceByPartition.value()).get((int)idx)).iterator();
            ArrayList evidenceItrList = new ArrayList(2);
            evidenceItrList.add(evidenceItr1);
            evidenceItrList.add(evidenceItr2);
            Iterator<BreakpointEvidence> evidenceItr = FlatMapGluer.concatIterators(evidenceItrList.iterator());
            return FindBreakpointEvidenceSpark.getFilter(evidenceItr, readMetadata, params, xChecker);
        }, true);
        filteredEvidenceRDD.cache();
        if (params.evidenceDir != null) {
            filteredEvidenceRDD.filter(BreakpointEvidence::isValidated).saveAsTextFile(params.evidenceDir);
        }
        int maxFragmentSize = ((ReadMetadata)broadcastMetadata.value()).getMaxMedianFragmentSize();
        List collectedEvidence = filteredEvidenceRDD.mapPartitionsWithIndex((Function2 & Serializable)(idx, readEvidenceItr) -> new FlatMapGluer<BreakpointEvidence, BreakpointEvidence>(new BreakpointEvidenceClusterer(maxFragmentSize, new PartitionCrossingChecker((int)idx, (ReadMetadata)broadcastMetadata.value(), 2 * maxFragmentSize)), (Iterator<BreakpointEvidence>)readEvidenceItr, new BreakpointEvidence(new SVInterval(nContigs, 1, 1), 0, false)), true).collect();
        filteredEvidenceRDD.unpersist();
        evidenceRDD.unpersist();
        Iterator<BreakpointEvidence> evidenceIterator = FindBreakpointEvidenceSpark.getFilter(collectedEvidence.iterator(), (ReadMetadata)broadcastMetadata.value(), params, new PartitionCrossingChecker());
        ArrayList<BreakpointEvidence> allEvidence = new ArrayList<BreakpointEvidence>(collectedEvidence.size());
        while (evidenceIterator.hasNext()) {
            allEvidence.add(evidenceIterator.next());
        }
        if (params.evidenceDir != null) {
            String crossPartitionFile = params.evidenceDir + "/part-xxxxx";
            try (OutputStreamWriter writer = new OutputStreamWriter(new BufferedOutputStream(BucketUtils.createFile(crossPartitionFile)));){
                for (BreakpointEvidence ev : allEvidence) {
                    if (!(ev instanceof BreakpointEvidence.ReadEvidence)) continue;
                    writer.write(ev.toString());
                    writer.write(10);
                }
            }
            catch (IOException ioe) {
                throw new GATKException("Can't write cross-partition evidence to " + crossPartitionFile, ioe);
            }
        }
        FlatMapGluer<BreakpointEvidence, BreakpointEvidence> evidenceIterator2 = new FlatMapGluer<BreakpointEvidence, BreakpointEvidence>(new BreakpointEvidenceClusterer(maxFragmentSize, new PartitionCrossingChecker()), allEvidence.iterator(), new BreakpointEvidence(new SVInterval(nContigs, 1, 1), 0, false));
        ArrayList<SVInterval> intervals = new ArrayList<SVInterval>(allEvidence.size());
        while (evidenceIterator2.hasNext()) {
            intervals.add(((BreakpointEvidence)evidenceIterator2.next()).getLocation());
        }
        return new Tuple2(intervals, (Object)evidenceTargetLinks);
    }

    private static Iterator<BreakpointEvidence> getFilter(Iterator<BreakpointEvidence> evidenceItr, ReadMetadata readMetadata, StructuralVariationDiscoveryArgumentCollection.FindBreakpointEvidenceSparkArgumentCollection params, PartitionCrossingChecker partitionCrossingChecker) {
        switch (params.svEvidenceFilterType) {
            case DENSITY: {
                return new BreakpointDensityFilter(evidenceItr, readMetadata, params.minEvidenceWeightPerCoverage, params.minCoherentEvidenceWeightPerCoverage, partitionCrossingChecker, params.minEvidenceMapQ);
            }
            case XGBOOST: {
                return new XGBoostEvidenceFilter(evidenceItr, readMetadata, params, partitionCrossingChecker);
            }
        }
        throw new IllegalStateException("Unknown svEvidenceFilterType: " + (Object)((Object)params.svEvidenceFilterType));
    }

    private static void writeTargetLinks(Broadcast<ReadMetadata> broadcastMetadata, List<EvidenceTargetLink> targetLinks, String targetLinkFile) {
        if (targetLinkFile != null) {
            try (OutputStreamWriter writer = new OutputStreamWriter(new BufferedOutputStream(BucketUtils.createFile(targetLinkFile)));){
                targetLinks.iterator().forEachRemaining(entry -> {
                    String bedpeRecord = entry.toBedpeString((ReadMetadata)broadcastMetadata.getValue());
                    try {
                        writer.write(bedpeRecord + "\n");
                    }
                    catch (IOException ioe) {
                        throw new GATKException("Can't write target links to " + targetLinkFile, ioe);
                    }
                });
            }
            catch (IOException ioe) {
                throw new GATKException("Can't write target links to " + targetLinkFile, ioe);
            }
        }
    }

    private static void log(String message, Logger logger) {
        logger.info(message);
    }

    public static final class IntPair {
        private final int int1;
        private final int int2;

        public IntPair(int int1, int int2) {
            this.int1 = int1;
            this.int2 = int2;
        }

        public int int1() {
            return this.int1;
        }

        public int int2() {
            return this.int2;
        }

        public static IntPair reduce(IntPair pair1, IntPair pair2) {
            return new IntPair(pair1.int1 + pair2.int1, pair1.int2 + pair2.int2);
        }
    }

    @VisibleForTesting
    static interface LocalAssemblyHandler
    extends Serializable,
    java.util.function.Function<Tuple2<Integer, List<SVFastqUtils.FastqRead>>, AlignedAssemblyOrExcuse> {
    }

    static final class EvidenceScanResults {
        final ReadMetadata readMetadata;
        final List<SVInterval> intervals;
        final List<EvidenceTargetLink> evidenceTargetLinks;
        final HopscotchUniqueMultiMap<String, Integer, QNameAndInterval> qNamesForAssemblyMultiMap;

        public EvidenceScanResults(ReadMetadata readMetadata, List<SVInterval> intervals, List<EvidenceTargetLink> evidenceTargetLinks, HopscotchUniqueMultiMap<String, Integer, QNameAndInterval> qNamesForAssemblyMultiMap) {
            this.readMetadata = readMetadata;
            this.intervals = intervals;
            this.evidenceTargetLinks = evidenceTargetLinks;
            this.qNamesForAssemblyMultiMap = qNamesForAssemblyMultiMap;
        }
    }

    public static final class AssembledEvidenceResults {
        final ReadMetadata readMetadata;
        final List<SVInterval> assembledIntervals;
        final List<AlignedAssemblyOrExcuse> alignedAssemblyOrExcuseList;
        final List<EvidenceTargetLink> evidenceTargetLinks;

        public AssembledEvidenceResults(ReadMetadata readMetadata, List<SVInterval> assembledIntervals, List<AlignedAssemblyOrExcuse> alignedAssemblyOrExcuseList, List<EvidenceTargetLink> evidenceTargetLinks) {
            this.readMetadata = readMetadata;
            this.assembledIntervals = assembledIntervals;
            this.alignedAssemblyOrExcuseList = alignedAssemblyOrExcuseList;
            this.evidenceTargetLinks = evidenceTargetLinks;
        }

        public ReadMetadata getReadMetadata() {
            return this.readMetadata;
        }

        public List<SVInterval> getAssembledIntervals() {
            return this.assembledIntervals;
        }

        public List<AlignedAssemblyOrExcuse> getAlignedAssemblyOrExcuseList() {
            return this.alignedAssemblyOrExcuseList;
        }

        public List<EvidenceTargetLink> getEvidenceTargetLinks() {
            return this.evidenceTargetLinks;
        }
    }
}

