/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.spark.sv.evidence;

import com.esotericsoftware.kryo.DefaultSerializer;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.IntStream;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.tools.spark.sv.evidence.ReadMetadata;
import org.broadinstitute.hellbender.tools.spark.sv.evidence.SVReadFilter;
import org.broadinstitute.hellbender.tools.spark.sv.utils.SVInterval;
import org.broadinstitute.hellbender.utils.read.GATKRead;
import scala.Tuple2;

public final class IntervalCoverageFinder
implements Iterable<Tuple2<Integer, int[]>> {
    private final int[][] intervalCoverage;

    public IntervalCoverageFinder(ReadMetadata metadata, List<SVInterval> intervals, Iterator<GATKRead> unfilteredReadItr, SVReadFilter filter) {
        this.intervalCoverage = new int[intervals.size()][];
        int intervalsIndex = 0;
        int intervalsSize = intervals.size();
        Iterator<GATKRead> readItr = filter.applyFilter(unfilteredReadItr, (svReadFilter, read) -> svReadFilter.isMappedToPrimaryContig((GATKRead)read, metadata));
        while (readItr.hasNext()) {
            SVInterval indexedInterval;
            SVInterval interval;
            GATKRead read2 = readItr.next();
            int readContigId = metadata.getContigID(read2.getContig());
            int readStart = read2.getStart();
            while (intervalsIndex < intervalsSize && (interval = intervals.get(intervalsIndex)).getContig() <= readContigId && (interval.getContig() != readContigId || interval.getEnd() <= read2.getStart())) {
                ++intervalsIndex;
            }
            if (intervalsIndex >= intervalsSize) break;
            SVInterval readInterval = new SVInterval(readContigId, readStart, read2.getEnd() + 1);
            for (int intervalsContainingReadIndex = intervalsIndex; intervalsContainingReadIndex < intervals.size() && (indexedInterval = intervals.get(intervalsContainingReadIndex)).overlaps(readInterval); ++intervalsContainingReadIndex) {
                SVInterval overlapInterval = readInterval.intersect(indexedInterval);
                if (overlapInterval == null) {
                    throw new GATKException.ShouldNeverReachHereException("read was supposed to intersect interval but overlap is null");
                }
                if (this.intervalCoverage[intervalsContainingReadIndex] == null) {
                    this.intervalCoverage[intervalsContainingReadIndex] = new int[indexedInterval.getLength()];
                }
                int[] coverageArray = this.intervalCoverage[intervalsContainingReadIndex];
                for (int i = overlapInterval.getStart(); i < overlapInterval.getEnd(); ++i) {
                    int n = i - indexedInterval.getStart();
                    coverageArray[n] = coverageArray[n] + 1;
                }
            }
        }
    }

    static Iterator<CandidateCoverageInterval> getHighCoverageIntervalsInWindow(int minFlankingHighCoverageValue, int minPeakHighCoverageValue, SVInterval interval, int[] coverageArray) {
        boolean inRegion = false;
        int regionStart = -1;
        boolean foundHighRegion = false;
        ArrayList<CandidateCoverageInterval> highCovIntervals = new ArrayList<CandidateCoverageInterval>(2);
        for (int i = 0; i < coverageArray.length; ++i) {
            if (coverageArray[i] >= minFlankingHighCoverageValue) {
                if (!inRegion) {
                    inRegion = true;
                    foundHighRegion = false;
                    regionStart = i;
                }
                if (coverageArray[i] < minPeakHighCoverageValue) continue;
                foundHighRegion = true;
                continue;
            }
            if (inRegion && (foundHighRegion || regionStart == 0)) {
                SVInterval highCovInterval = new SVInterval(interval.getContig(), interval.getStart() + regionStart, interval.getStart() + i);
                highCovIntervals.add(new CandidateCoverageInterval(highCovInterval, foundHighRegion));
            }
            inRegion = false;
        }
        if (inRegion) {
            SVInterval highCovInterval = new SVInterval(interval.getContig(), interval.getStart() + regionStart, interval.getEnd());
            highCovIntervals.add(new CandidateCoverageInterval(highCovInterval, foundHighRegion));
        }
        return highCovIntervals.iterator();
    }

    @Override
    public Iterator<Tuple2<Integer, int[]>> iterator() {
        return IntStream.range(0, this.intervalCoverage.length).filter(idx -> this.intervalCoverage[idx] != null).mapToObj(idx -> new Tuple2((Object)idx, (Object)this.intervalCoverage[idx])).iterator();
    }

    @DefaultSerializer(value=Serializer.class)
    static class CandidateCoverageInterval {
        private static final SVInterval.Serializer intervalSerializer = new SVInterval.Serializer();
        private boolean containsMaxCoveragePeak;
        private SVInterval interval;

        public CandidateCoverageInterval(SVInterval interval, boolean containsMaxCoveragePeak) {
            this.containsMaxCoveragePeak = containsMaxCoveragePeak;
            this.interval = interval;
        }

        public CandidateCoverageInterval(Kryo kryo, Input input) {
            this.interval = intervalSerializer.read(kryo, input, (Class)SVInterval.class);
            this.containsMaxCoveragePeak = input.readBoolean();
        }

        public boolean containsMaxCoveragePeak() {
            return this.containsMaxCoveragePeak;
        }

        public SVInterval getInterval() {
            return this.interval;
        }

        protected void serialize(Kryo kryo, Output output) {
            intervalSerializer.write(kryo, output, this.interval);
            output.writeBoolean(this.containsMaxCoveragePeak);
        }

        public static final class Serializer
        extends com.esotericsoftware.kryo.Serializer<CandidateCoverageInterval> {
            public void write(Kryo kryo, Output output, CandidateCoverageInterval candidateCoverageInterval) {
                candidateCoverageInterval.serialize(kryo, output);
            }

            public CandidateCoverageInterval read(Kryo kryo, Input input, Class<CandidateCoverageInterval> klass) {
                return new CandidateCoverageInterval(kryo, input);
            }
        }
    }
}

