/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.spark.sv.evidence;

import com.google.common.annotations.VisibleForTesting;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.broadinstitute.hellbender.tools.spark.sv.evidence.BreakpointEvidence;
import org.broadinstitute.hellbender.tools.spark.sv.evidence.LibraryStatistics;
import org.broadinstitute.hellbender.tools.spark.sv.evidence.ReadMetadata;
import org.broadinstitute.hellbender.tools.spark.sv.evidence.SVReadFilter;
import org.broadinstitute.hellbender.tools.spark.sv.utils.SVInterval;
import org.broadinstitute.hellbender.tools.spark.sv.utils.SVUtils;
import org.broadinstitute.hellbender.tools.spark.utils.IntHistogram;
import org.broadinstitute.hellbender.utils.read.GATKRead;

public class KSWindowFinder {
    protected static final int BLOCK_SIZE = 250;
    protected static final float KS_SIGNIFICANCE = 3.1E-4f;
    private static final int EVIDENCE_WEIGHT = 5;
    protected static final float MAX_APPARENT_BASES_PER_WINDOW = 625.0f;
    protected final ReadMetadata readMetadata;
    private final SVReadFilter filter;
    protected final Map<String, IntHistogram[]> libraryToHistoPairMap;
    protected int fillIdx;
    protected String curContig;
    protected int curEnd;

    public KSWindowFinder(ReadMetadata readMetadata, SVReadFilter filter) {
        this.readMetadata = readMetadata;
        this.filter = filter;
        Map<String, LibraryStatistics> libraryStatisticsMap = readMetadata.getAllLibraryStatistics();
        this.libraryToHistoPairMap = new HashMap<String, IntHistogram[]>(SVUtils.hashMapCapacity(libraryStatisticsMap.size()));
        libraryStatisticsMap.forEach((libName, stats) -> {
            IntHistogram[] pair = new IntHistogram[]{stats.createEmptyHistogram(), stats.createEmptyHistogram()};
            this.libraryToHistoPairMap.put((String)libName, pair);
        });
        this.curContig = null;
        this.curEnd = 0;
        this.fillIdx = 0;
    }

    public void testReadAndGatherEvidence(GATKRead read, List<BreakpointEvidence> evidenceList) {
        if (!this.filter.isTemplateLenTestable(read)) {
            return;
        }
        if (!this.isSameBlock(read)) {
            this.checkHistograms(evidenceList);
            this.advanceBlock(read);
        }
        this.addObservation(read);
    }

    public void checkHistograms(List<BreakpointEvidence> evidenceList) {
        if (this.curContig == null) {
            return;
        }
        int oldIdx = this.fillIdx ^ 1;
        int start = Math.max(1, this.curEnd - 500);
        SVInterval curInterval = new SVInterval(this.readMetadata.getContigID(this.curContig), start, this.curEnd);
        for (Map.Entry<String, IntHistogram[]> entry : this.libraryToHistoPairMap.entrySet()) {
            IntHistogram[] histoPair = entry.getValue();
            IntHistogram oldHisto = histoPair[oldIdx];
            oldHisto.addObservations(histoPair[this.fillIdx]);
            long readCount = oldHisto.getTotalObservations();
            if (readCount > 0L && this.readMetadata.getLibraryStatistics(entry.getKey()).getCDF().isDifferentByKSStatistic(oldHisto, 3.1E-4f)) {
                evidenceList.add(new BreakpointEvidence.TemplateSizeAnomaly(curInterval, 5, (int)readCount));
            }
            oldHisto.clear();
        }
    }

    @VisibleForTesting
    Map<String, IntHistogram[]> getLibraryToHistoPairMap() {
        return this.libraryToHistoPairMap;
    }

    protected boolean isTestable(GATKRead read) {
        return this.filter.isTemplateLenTestable(read);
    }

    protected boolean isSameBlock(GATKRead read) {
        return read.getContig().equals(this.curContig) && read.getStart() < this.curEnd;
    }

    protected void addObservation(GATKRead read) {
        IntHistogram[] histoPair = this.libraryToHistoPairMap.get(this.readMetadata.getLibraryName(read.getReadGroup()));
        histoPair[this.fillIdx].addObservation(Math.abs(read.getFragmentLength()));
    }

    protected void advanceBlock(GATKRead read) {
        int oldIdx = this.fillIdx;
        this.fillIdx ^= 1;
        this.curEnd += 250;
        if (!read.getContig().equals(this.curContig) || read.getStart() >= this.curEnd) {
            this.curContig = read.getContig();
            this.curEnd = read.getStart() + 250;
            this.libraryToHistoPairMap.values().forEach(histPair -> histPair[oldIdx].clear());
        }
    }
}

