/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.spark.sv.evidence;

import com.esotericsoftware.kryo.DefaultSerializer;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.util.Map;
import org.broadinstitute.hellbender.tools.spark.sv.utils.SVKmer;
import org.broadinstitute.hellbender.tools.spark.sv.utils.SVKmerLong;

@DefaultSerializer(value=Serializer.class)
public final class KmerAndInterval
extends SVKmerLong
implements Map.Entry<SVKmer, Integer> {
    private final int intervalId;

    public KmerAndInterval(SVKmer kmer, int intervalId) {
        super(kmer);
        this.intervalId = intervalId;
    }

    private KmerAndInterval(Kryo kryo, Input input) {
        super(kryo, input);
        this.intervalId = input.readInt();
    }

    @Override
    protected void serialize(Kryo kryo, Output output) {
        super.serialize(kryo, output);
        output.writeInt(this.intervalId);
    }

    @Override
    public SVKmer getKey() {
        return new SVKmerLong(this);
    }

    @Override
    public Integer getValue() {
        return this.intervalId;
    }

    @Override
    public Integer setValue(Integer value) {
        throw new UnsupportedOperationException("Can't set KmerAndInterval.intervalId");
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof KmerAndInterval && this.equals((KmerAndInterval)obj);
    }

    public boolean equals(KmerAndInterval that) {
        return super.equals(that) && this.intervalId == that.intervalId;
    }

    public int getIntervalId() {
        return this.intervalId;
    }

    public static final class Serializer
    extends com.esotericsoftware.kryo.Serializer<KmerAndInterval> {
        public void write(Kryo kryo, Output output, KmerAndInterval kmerAndInterval) {
            kmerAndInterval.serialize(kryo, output);
        }

        public KmerAndInterval read(Kryo kryo, Input input, Class<KmerAndInterval> klass) {
            return new KmerAndInterval(kryo, input);
        }
    }
}

