/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.spark.sv.evidence;

import java.util.Iterator;
import org.broadinstitute.hellbender.tools.spark.sv.evidence.KmerAndInterval;
import org.broadinstitute.hellbender.tools.spark.sv.utils.SVKmer;
import org.broadinstitute.hellbender.tools.spark.sv.utils.SVUtils;
import org.broadinstitute.hellbender.tools.spark.utils.HopscotchSet;
import org.broadinstitute.hellbender.tools.spark.utils.HopscotchUniqueMultiMap;
import scala.Tuple2;

public final class KmerCleaner
implements Iterable<KmerAndInterval> {
    private final HopscotchUniqueMultiMap<SVKmer, Integer, KmerAndInterval> kmerMultiMap;

    public KmerCleaner(Iterator<Tuple2<KmerAndInterval, Integer>> kmerCountItr, int kmersPerPartitionGuess, int minKmerCount, int maxKmerCount, int maxIntervalsPerKmer) {
        this.kmerMultiMap = new HopscotchUniqueMultiMap(kmersPerPartitionGuess);
        while (kmerCountItr.hasNext()) {
            Tuple2<KmerAndInterval, Integer> kmerCount = kmerCountItr.next();
            int count = (Integer)kmerCount._2;
            if (count < minKmerCount || count > maxKmerCount) continue;
            this.kmerMultiMap.add((KmerAndInterval)kmerCount._1);
        }
        HopscotchSet uniqueKmers = new HopscotchSet(this.kmerMultiMap.size());
        this.kmerMultiMap.stream().map(KmerAndInterval::getKey).forEach(uniqueKmers::add);
        uniqueKmers.stream().filter(kmer -> SVUtils.iteratorSize(this.kmerMultiMap.findEach(kmer)) > maxIntervalsPerKmer).forEach(this.kmerMultiMap::removeEach);
    }

    @Override
    public Iterator<KmerAndInterval> iterator() {
        return this.kmerMultiMap.iterator();
    }
}

