/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.spark.sv.evidence;

import java.util.Iterator;
import org.broadinstitute.hellbender.tools.spark.sv.evidence.KmerAndInterval;
import org.broadinstitute.hellbender.tools.spark.sv.utils.KmerAndCount;
import org.broadinstitute.hellbender.tools.spark.sv.utils.SVKmer;
import org.broadinstitute.hellbender.tools.spark.sv.utils.SVKmerLong;
import org.broadinstitute.hellbender.tools.spark.sv.utils.SVKmerizer;
import org.broadinstitute.hellbender.tools.spark.utils.HopscotchMap;
import org.broadinstitute.hellbender.tools.spark.utils.HopscotchUniqueMultiMap;
import org.broadinstitute.hellbender.utils.read.GATKRead;

public final class KmerCounter {
    private final int kSize;
    private final int kmersPerPartitionGuess;
    private final HopscotchUniqueMultiMap<SVKmer, Integer, KmerAndInterval> kmerMap;

    public KmerCounter(int kSize, int kmersPerPartitionGuess, HopscotchUniqueMultiMap<SVKmer, Integer, KmerAndInterval> kmerMap) {
        this.kSize = kSize;
        this.kmerMap = kmerMap;
        this.kmersPerPartitionGuess = kmersPerPartitionGuess;
    }

    public Iterator<KmerAndCount> apply(Iterator<GATKRead> readItr) {
        HopscotchMap counts = new HopscotchMap(this.kmersPerPartitionGuess);
        while (readItr.hasNext()) {
            GATKRead read = readItr.next();
            SVKmerizer.canonicalStream(read.getBases(), this.kSize, new SVKmerLong()).forEach(kmer -> {
                if (this.kmerMap.contains(kmer)) {
                    KmerAndCount kmerAndCount = (KmerAndCount)counts.find(kmer);
                    if (kmerAndCount != null) {
                        kmerAndCount.bumpCount();
                    } else {
                        counts.add(new KmerAndCount((SVKmerLong)kmer));
                    }
                }
            });
        }
        return counts.iterator();
    }
}

