/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.spark.sv.evidence;

import com.esotericsoftware.kryo.DefaultSerializer;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.tools.spark.utils.IntHistogram;

@DefaultSerializer(value=Serializer.class)
public final class LibraryStatistics {
    private final IntHistogram.CDF fragmentSizeCDF;
    private final int median;
    private final float negativeMAD;
    private final float positiveMAD;
    private final float coverage;
    private final float meanBaseQuality;
    private final long nReads;
    private final float readStartFrequency;

    public LibraryStatistics(IntHistogram.CDF fragmentSizeCDF, long nBases, long nReads, long totalBaseQuality, long nRefBases) {
        this.fragmentSizeCDF = fragmentSizeCDF;
        this.median = this.fragmentSizeCDF.median();
        this.negativeMAD = this.fragmentSizeCDF.leftMedianDeviation(this.median);
        this.positiveMAD = this.fragmentSizeCDF.rightMedianDeviation(this.median);
        this.coverage = (float)nBases / (float)nRefBases;
        this.meanBaseQuality = (float)totalBaseQuality / (float)nBases;
        this.nReads = nReads;
        this.readStartFrequency = (float)nReads / (float)nRefBases;
    }

    private LibraryStatistics(Kryo kryo, Input input) {
        this.fragmentSizeCDF = new IntHistogram.CDF.Serializer().read(kryo, input, (Class)IntHistogram.CDF.class);
        this.median = this.fragmentSizeCDF.median();
        this.negativeMAD = this.fragmentSizeCDF.leftMedianDeviation(this.median);
        this.positiveMAD = this.fragmentSizeCDF.rightMedianDeviation(this.median);
        this.coverage = input.readFloat();
        this.meanBaseQuality = input.readFloat();
        this.nReads = input.readLong();
        this.readStartFrequency = input.readFloat();
    }

    private void serialize(Kryo kryo, Output output) {
        new IntHistogram.CDF.Serializer().write(kryo, output, this.fragmentSizeCDF);
        output.writeFloat(this.coverage);
        output.writeFloat(this.meanBaseQuality);
        output.writeLong(this.nReads);
        output.writeFloat(this.readStartFrequency);
    }

    public IntHistogram.CDF getCDF() {
        return this.fragmentSizeCDF;
    }

    public int getMedian() {
        return this.median;
    }

    public float getNegativeMAD() {
        return this.negativeMAD;
    }

    public float getPositiveMAD() {
        return this.positiveMAD;
    }

    public float getCoverage() {
        return this.coverage;
    }

    public float getMeanBaseQuality() {
        return this.meanBaseQuality;
    }

    public long getNReads() {
        return this.nReads;
    }

    public float getReadStartFrequency() {
        return this.readStartFrequency;
    }

    public float getZishScore(int fragmentSize) {
        if (fragmentSize < 0) {
            throw new GATKException("negative fragment size");
        }
        int diff = fragmentSize - this.median;
        if (diff == 0) {
            return 0.0f;
        }
        if (diff > 0) {
            return 1.0f * (float)diff / this.positiveMAD;
        }
        return 1.0f * (float)diff / this.negativeMAD;
    }

    public IntHistogram createEmptyHistogram() {
        return this.fragmentSizeCDF.createEmptyHistogram();
    }

    public int getMaxNonOutlierFragmentSize() {
        return this.fragmentSizeCDF.popStat(0.9f);
    }

    public static final class Serializer
    extends com.esotericsoftware.kryo.Serializer<LibraryStatistics> {
        public void write(Kryo kryo, Output output, LibraryStatistics stats) {
            stats.serialize(kryo, output);
        }

        public LibraryStatistics read(Kryo kryo, Input input, Class<LibraryStatistics> klass) {
            return new LibraryStatistics(kryo, input);
        }
    }
}

