/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.spark.sv.evidence;

import org.broadinstitute.hellbender.tools.spark.sv.evidence.ReadMetadata;
import org.broadinstitute.hellbender.tools.spark.sv.utils.SVInterval;

public class PartitionCrossingChecker {
    private final int beginningContigID;
    private final int beginningPosition;
    private final int endingContigID;
    private final int endingPosition;

    public PartitionCrossingChecker() {
        this.beginningContigID = -1;
        this.beginningPosition = 0;
        this.endingContigID = -1;
        this.endingPosition = 0;
    }

    public PartitionCrossingChecker(int partitionIdx, ReadMetadata readMetadata, int boundaryWidth) {
        ReadMetadata.PartitionBounds bounds;
        if (partitionIdx == 0) {
            this.beginningContigID = Integer.MAX_VALUE;
            this.beginningPosition = -1;
        } else {
            bounds = readMetadata.getPartitionBounds(partitionIdx - 1);
            this.beginningContigID = bounds.getLastContigID();
            this.beginningPosition = this.beginningContigID == Integer.MAX_VALUE ? -1 : bounds.getLastEnd() + boundaryWidth;
        }
        if (partitionIdx == readMetadata.getNPartitions() - 1) {
            this.endingContigID = Integer.MAX_VALUE;
            this.endingPosition = Integer.MAX_VALUE;
        } else {
            bounds = readMetadata.getPartitionBounds(partitionIdx + 1);
            this.endingContigID = bounds.getFirstContigID();
            this.endingPosition = this.endingContigID == Integer.MAX_VALUE ? Integer.MAX_VALUE : bounds.getFirstStart() - boundaryWidth;
        }
    }

    public boolean onBoundary(SVInterval interval) {
        return this.onLeadingBoundary(interval) || this.onTrailingBoundary(interval);
    }

    public boolean onLeadingBoundary(SVInterval interval) {
        return interval.getContig() == this.beginningContigID && interval.getStart() < this.beginningPosition;
    }

    public boolean onTrailingBoundary(SVInterval interval) {
        return interval.getContig() == this.endingContigID && interval.getEnd() >= this.endingPosition;
    }
}

