/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.spark.sv.evidence;

import com.esotericsoftware.kryo.DefaultSerializer;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Arrays;
import java.util.Map;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.utils.gcs.BucketUtils;

@DefaultSerializer(value=Serializer.class)
public final class QNameAndInterval
implements Map.Entry<String, Integer> {
    private final byte[] qName;
    private final int hashVal;
    private final int intervalId;

    public QNameAndInterval(String qName, int intervalId) {
        this.qName = qName.getBytes();
        this.hashVal = qName.hashCode() ^ 47 * intervalId;
        this.intervalId = intervalId;
    }

    private QNameAndInterval(Kryo kryo, Input input) {
        int nameLen = input.readInt();
        this.qName = input.readBytes(nameLen);
        this.hashVal = input.readInt();
        this.intervalId = input.readInt();
    }

    private void serialize(Kryo kryo, Output output) {
        output.writeInt(this.qName.length);
        output.writeBytes(this.qName);
        output.writeInt(this.hashVal);
        output.writeInt(this.intervalId);
    }

    @Override
    public String getKey() {
        return this.getQName();
    }

    @Override
    public Integer getValue() {
        return this.getIntervalId();
    }

    @Override
    public Integer setValue(Integer value) {
        throw new UnsupportedOperationException("Can't set QNameAndInterval.intervalId");
    }

    public String getQName() {
        return new String(this.qName);
    }

    public int getIntervalId() {
        return this.intervalId;
    }

    @Override
    public int hashCode() {
        return this.hashVal;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof QNameAndInterval && this.equals((QNameAndInterval)obj);
    }

    public boolean equals(QNameAndInterval that) {
        return this.intervalId == that.intervalId && Arrays.equals(this.qName, that.qName);
    }

    public String toString() {
        return new String(this.qName) + " " + this.intervalId;
    }

    public static void writeQNames(String qNameFile, Iterable<QNameAndInterval> qNames) {
        try (OutputStreamWriter writer = new OutputStreamWriter(new BufferedOutputStream(BucketUtils.createFile(qNameFile)));){
            for (QNameAndInterval qnameAndInterval : qNames) {
                writer.write(qnameAndInterval.toString() + "\n");
            }
        }
        catch (IOException ioe) {
            throw new GATKException("Can't write qname intervals file " + qNameFile, ioe);
        }
    }

    public static final class Serializer
    extends com.esotericsoftware.kryo.Serializer<QNameAndInterval> {
        public void write(Kryo kryo, Output output, QNameAndInterval qNameAndInterval) {
            qNameAndInterval.serialize(kryo, output);
        }

        public QNameAndInterval read(Kryo kryo, Input input, Class<QNameAndInterval> klass) {
            return new QNameAndInterval(kryo, input);
        }
    }
}

