/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.spark.sv.evidence;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.collections4.iterators.SingletonIterator;
import org.broadinstitute.hellbender.tools.spark.sv.evidence.QNameAndInterval;
import org.broadinstitute.hellbender.tools.spark.sv.evidence.ReadMetadata;
import org.broadinstitute.hellbender.tools.spark.sv.evidence.SVReadFilter;
import org.broadinstitute.hellbender.tools.spark.sv.utils.SVInterval;
import org.broadinstitute.hellbender.tools.spark.sv.utils.SVIntervalTree;
import org.broadinstitute.hellbender.utils.read.GATKRead;

public final class QNameFinder
implements Function<GATKRead, Iterator<QNameAndInterval>> {
    private final ReadMetadata metadata;
    private final List<SVInterval> intervals;
    private final SVReadFilter filter;
    private static final Iterator<QNameAndInterval> noName = Collections.emptyIterator();
    private final SVIntervalTree<SVInterval> highCoverageSubIntervals;
    private int intervalsIndex = 0;

    public QNameFinder(ReadMetadata metadata, List<SVInterval> intervals, SVReadFilter filter, SVIntervalTree<SVInterval> highCoverageSubIntervals) {
        this.metadata = metadata;
        this.intervals = intervals;
        this.filter = filter;
        this.highCoverageSubIntervals = highCoverageSubIntervals;
    }

    @Override
    public Iterator<QNameAndInterval> apply(GATKRead read) {
        SVInterval unclippedReadInterval;
        SVInterval interval;
        if (!this.filter.isMapped(read)) {
            return Collections.emptyIterator();
        }
        int readContigId = this.metadata.getContigID(read.getContig());
        int intervalsSize = this.intervals.size();
        while (this.intervalsIndex < intervalsSize && (interval = this.intervals.get(this.intervalsIndex)).getContig() <= readContigId && (interval.getContig() != readContigId || interval.getEnd() <= read.getStart())) {
            ++this.intervalsIndex;
        }
        if (this.intervalsIndex >= intervalsSize) {
            return noName;
        }
        SVInterval indexedInterval = this.intervals.get(this.intervalsIndex);
        if (indexedInterval.isDisjointFrom(unclippedReadInterval = new SVInterval(readContigId, Math.max(0, read.getUnclippedStart()), read.getUnclippedEnd()))) {
            return noName;
        }
        SVInterval clippedReadInterval = new SVInterval(readContigId, read.getStart(), read.getEnd());
        if (this.filter.containedInRegionToIgnore(clippedReadInterval, this.highCoverageSubIntervals)) {
            return noName;
        }
        return new SingletonIterator((Object)new QNameAndInterval(read.getName(), this.intervalsIndex));
    }
}

