/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.spark.sv.evidence;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.function.Function;
import org.broadinstitute.hellbender.tools.spark.sv.evidence.KmerAndInterval;
import org.broadinstitute.hellbender.tools.spark.sv.evidence.QNameAndInterval;
import org.broadinstitute.hellbender.tools.spark.sv.utils.SVKmer;
import org.broadinstitute.hellbender.tools.spark.sv.utils.SVKmerLong;
import org.broadinstitute.hellbender.tools.spark.sv.utils.SVKmerizer;
import org.broadinstitute.hellbender.tools.spark.utils.HopscotchUniqueMultiMap;
import org.broadinstitute.hellbender.utils.read.GATKRead;

public final class QNameIntervalFinder
implements Function<GATKRead, Iterator<QNameAndInterval>> {
    private final int kSize;
    private final HopscotchUniqueMultiMap<SVKmer, Integer, KmerAndInterval> kmerMap;

    public QNameIntervalFinder(int kSize, HopscotchUniqueMultiMap<SVKmer, Integer, KmerAndInterval> kmerMap) {
        this.kSize = kSize;
        this.kmerMap = kmerMap;
    }

    @Override
    public Iterator<QNameAndInterval> apply(GATKRead read) {
        ArrayList intervals = new ArrayList();
        SVKmerizer.canonicalStream(read.getBases(), this.kSize, new SVKmerLong()).forEach(kmer -> {
            Iterator kmerAndIntervalIterator = this.kmerMap.findEach(kmer);
            while (kmerAndIntervalIterator.hasNext()) {
                Integer intervalId = ((KmerAndInterval)kmerAndIntervalIterator.next()).getValue();
                if (intervals.contains(intervalId)) continue;
                intervals.add(intervalId);
            }
        });
        String qName = read.getName();
        return intervals.stream().map(intervalId -> new QNameAndInterval(qName, (int)intervalId)).iterator();
    }
}

