/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.spark.sv.evidence;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Function;
import org.broadinstitute.hellbender.tools.spark.sv.evidence.KmerAndInterval;
import org.broadinstitute.hellbender.tools.spark.sv.evidence.QNameAndInterval;
import org.broadinstitute.hellbender.tools.spark.sv.evidence.SVReadFilter;
import org.broadinstitute.hellbender.tools.spark.sv.utils.SVDUSTFilteredKmerizer;
import org.broadinstitute.hellbender.tools.spark.sv.utils.SVKmer;
import org.broadinstitute.hellbender.tools.spark.sv.utils.SVKmerLong;
import org.broadinstitute.hellbender.tools.spark.utils.HopscotchUniqueMultiMap;
import org.broadinstitute.hellbender.utils.read.GATKRead;
import scala.Tuple2;

public final class QNameKmerizer
implements Function<GATKRead, Iterator<Tuple2<KmerAndInterval, Integer>>> {
    private final HopscotchUniqueMultiMap<String, Integer, QNameAndInterval> qNameAndIntervalMultiMap;
    private final Set<SVKmer> kmersToIgnore;
    private final int kSize;
    private final int maxDUSTScore;
    private final SVReadFilter filter;
    private final ArrayList<Tuple2<KmerAndInterval, Integer>> tupleList = new ArrayList();

    public QNameKmerizer(HopscotchUniqueMultiMap<String, Integer, QNameAndInterval> qNameAndIntervalMultiMap, Set<SVKmer> kmersToIgnore, int kSize, int maxDUSTScore, SVReadFilter filter) {
        this.qNameAndIntervalMultiMap = qNameAndIntervalMultiMap;
        this.kmersToIgnore = kmersToIgnore;
        this.kSize = kSize;
        this.maxDUSTScore = maxDUSTScore;
        this.filter = filter;
    }

    @Override
    public Iterator<Tuple2<KmerAndInterval, Integer>> apply(GATKRead read) {
        if (!this.filter.notJunk(read) || !this.filter.isPrimaryLine(read)) {
            return Collections.emptyIterator();
        }
        String qName = read.getName();
        Iterator names = this.qNameAndIntervalMultiMap.findEach(qName);
        this.tupleList.clear();
        while (names.hasNext()) {
            int intervalId = ((QNameAndInterval)names.next()).getIntervalId();
            SVDUSTFilteredKmerizer.canonicalStream(read.getBases(), this.kSize, this.maxDUSTScore, (SVKmer)new SVKmerLong()).filter(kmer -> !this.kmersToIgnore.contains(kmer)).map(kmer -> new KmerAndInterval((SVKmer)kmer, intervalId)).forEach(kmerCountAndInterval -> this.tupleList.add((Tuple2<KmerAndInterval, Integer>)new Tuple2(kmerCountAndInterval, (Object)1)));
        }
        return this.tupleList.iterator();
    }
}

