/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.spark.sv.evidence;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import org.broadinstitute.hellbender.tools.spark.sv.evidence.KmerAndInterval;
import org.broadinstitute.hellbender.tools.spark.sv.evidence.SVReadFilter;
import org.broadinstitute.hellbender.tools.spark.sv.utils.SVKmer;
import org.broadinstitute.hellbender.tools.spark.sv.utils.SVKmerLong;
import org.broadinstitute.hellbender.tools.spark.sv.utils.SVKmerizer;
import org.broadinstitute.hellbender.tools.spark.utils.HopscotchUniqueMultiMap;
import org.broadinstitute.hellbender.utils.read.GATKRead;
import scala.Tuple2;

public final class QNamesForKmersFinder
implements Function<GATKRead, Iterator<Tuple2<SVKmer, String>>> {
    private final int kSize;
    private final SVReadFilter filter;
    private final HopscotchUniqueMultiMap<SVKmer, Integer, KmerAndInterval> kmerMultiMap;

    public QNamesForKmersFinder(int kSize, HopscotchUniqueMultiMap<SVKmer, Integer, KmerAndInterval> kmerMultiMap, SVReadFilter filter) {
        this.kSize = kSize;
        this.kmerMultiMap = kmerMultiMap;
        this.filter = filter;
    }

    @Override
    public Iterator<Tuple2<SVKmer, String>> apply(GATKRead read) {
        if (!this.filter.notJunk(read) || !this.filter.isPrimaryLine(read)) {
            return Collections.emptyIterator();
        }
        ArrayList results = new ArrayList();
        SVKmerizer.canonicalStream(read.getBases(), this.kSize, new SVKmerLong()).forEach(kmer -> {
            if (this.kmerMultiMap.contains(kmer)) {
                results.add(new Tuple2(kmer, (Object)read.getName()));
            }
        });
        return results.iterator();
    }
}

