/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.spark.sv.evidence;

import com.google.common.annotations.VisibleForTesting;
import htsjdk.samtools.CigarElement;
import htsjdk.samtools.CigarOperator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.function.Function;
import org.broadinstitute.hellbender.tools.spark.sv.evidence.BreakpointEvidence;
import org.broadinstitute.hellbender.tools.spark.sv.evidence.KSWindowFinder;
import org.broadinstitute.hellbender.tools.spark.sv.evidence.ReadMetadata;
import org.broadinstitute.hellbender.tools.spark.sv.evidence.SVReadFilter;
import org.broadinstitute.hellbender.tools.spark.sv.utils.SVInterval;
import org.broadinstitute.hellbender.tools.spark.sv.utils.SVIntervalTree;
import org.broadinstitute.hellbender.utils.read.GATKRead;

public class ReadClassifier
implements Function<GATKRead, Iterator<BreakpointEvidence>> {
    @VisibleForTesting
    static final int MIN_SOFT_CLIP_LEN = 30;
    @VisibleForTesting
    static final int MIN_INDEL_LEN = 40;
    private static final byte MIN_QUALITY = 15;
    private static final int MAX_LOW_QUALITY_SCORES = 3;
    private static final float MAX_NON_OUTLIER_ZISH_SCORE = 6.0f;
    private final ReadMetadata readMetadata;
    private final GATKRead sentinel;
    private final int allowedShortFragmentOverhang;
    private final SVReadFilter filter;
    private final KSWindowFinder smallIndelFinder;
    private final SVIntervalTree<SVInterval> regionsToIgnore;

    public ReadClassifier(ReadMetadata readMetadata, GATKRead sentinel, int allowedShortFragmentOverhang, SVReadFilter filter, SVIntervalTree<SVInterval> regionsToIgnore) {
        this.readMetadata = readMetadata;
        this.sentinel = sentinel;
        this.allowedShortFragmentOverhang = allowedShortFragmentOverhang;
        this.filter = filter;
        this.regionsToIgnore = regionsToIgnore;
        this.smallIndelFinder = new KSWindowFinder(readMetadata, filter);
    }

    @Override
    public Iterator<BreakpointEvidence> apply(GATKRead read) {
        int readContigId;
        SVInterval clippedReadInterval;
        if (read == this.sentinel) {
            ArrayList<BreakpointEvidence> evidenceList = new ArrayList<BreakpointEvidence>();
            this.smallIndelFinder.checkHistograms(evidenceList);
            return evidenceList.iterator();
        }
        if (!this.filter.isMappedToPrimaryContig(read, this.readMetadata)) {
            return Collections.emptyIterator();
        }
        if (!this.filter.isEvidence(read)) {
            return Collections.emptyIterator();
        }
        if (this.regionsToIgnore != null && this.filter.containedInRegionToIgnore(clippedReadInterval = new SVInterval(readContigId = this.readMetadata.getContigID(read.getContig()), read.getStart(), read.getEnd()), this.regionsToIgnore)) {
            return Collections.emptyIterator();
        }
        ArrayList<BreakpointEvidence> evidenceList = new ArrayList<BreakpointEvidence>();
        this.checkForSplitRead(read, evidenceList);
        this.checkDiscordantPair(read, evidenceList);
        this.smallIndelFinder.testReadAndGatherEvidence(read, evidenceList);
        return evidenceList.iterator();
    }

    private void checkForSplitRead(GATKRead read, List<BreakpointEvidence> evidenceList) {
        List cigarElements = read.getCigar().getCigarElements();
        if (ReadClassifier.hasInitialSoftClip(cigarElements, read)) {
            evidenceList.add(new BreakpointEvidence.SplitRead(read, this.readMetadata, true));
        }
        if (ReadClassifier.hasFinalSoftClip(cigarElements, read)) {
            evidenceList.add(new BreakpointEvidence.SplitRead(read, this.readMetadata, false));
        }
        this.checkBigIndel(cigarElements, read, evidenceList);
    }

    private static boolean hasInitialSoftClip(List<CigarElement> cigarElements, GATKRead read) {
        ListIterator<CigarElement> itr = cigarElements.listIterator();
        if (!itr.hasNext()) {
            return false;
        }
        CigarElement firstEle = itr.next();
        if (firstEle.getOperator() == CigarOperator.HARD_CLIP && itr.hasNext()) {
            firstEle = itr.next();
        }
        int clipStart = firstEle.getLength() - 30;
        return firstEle.getOperator() == CigarOperator.SOFT_CLIP && clipStart >= 0 && ReadClassifier.isHighQualityRegion(read.getBaseQualities(), clipStart);
    }

    private static boolean hasFinalSoftClip(List<CigarElement> cigarElements, GATKRead read) {
        ListIterator<CigarElement> itr = cigarElements.listIterator(cigarElements.size());
        if (!itr.hasPrevious()) {
            return false;
        }
        CigarElement lastEle = itr.previous();
        if (lastEle.getOperator() == CigarOperator.HARD_CLIP && itr.hasPrevious()) {
            lastEle = itr.previous();
        }
        return lastEle.getOperator() == CigarOperator.SOFT_CLIP && lastEle.getLength() >= 30 && ReadClassifier.isHighQualityRegion(read.getBaseQualities(), read.getLength() - lastEle.getLength());
    }

    private static boolean isHighQualityRegion(byte[] quals, int idx) {
        int lowQuals = 0;
        int end = idx + 30;
        while (idx != end) {
            if (quals[idx] < 15 && ++lowQuals > 3) {
                return false;
            }
            ++idx;
        }
        return true;
    }

    private void checkBigIndel(List<CigarElement> cigarElements, GATKRead read, List<BreakpointEvidence> evidenceList) {
        int locus = read.getStart();
        for (CigarElement ele : cigarElements) {
            CigarOperator op = ele.getOperator();
            if (ele.getLength() >= 40) {
                if (op == CigarOperator.INSERTION) {
                    evidenceList.add(new BreakpointEvidence.LargeIndel(read, this.readMetadata, locus));
                } else if (op == CigarOperator.DELETION) {
                    evidenceList.add(new BreakpointEvidence.LargeIndel(read, this.readMetadata, locus + ele.getLength() / 2));
                }
            }
            if (!op.consumesReferenceBases()) continue;
            locus += ele.getLength();
        }
    }

    private void checkDiscordantPair(GATKRead read, List<BreakpointEvidence> evidenceList) {
        if (!this.filter.isPrimaryLine(read)) {
            return;
        }
        if (read.mateIsUnmapped()) {
            evidenceList.add(new BreakpointEvidence.MateUnmapped(read, this.readMetadata));
        } else {
            int contigID2;
            int contigID1 = this.readMetadata.getContigID(read.getContig());
            if (contigID1 != (contigID2 = this.readMetadata.getContigID(read.getMateContig()))) {
                if (!this.readMetadata.ignoreCrossContigID(contigID1) && !this.readMetadata.ignoreCrossContigID(contigID2)) {
                    evidenceList.add(new BreakpointEvidence.InterContigPair(read, this.readMetadata));
                }
            } else if (read.isReverseStrand() == read.mateIsReverseStrand()) {
                evidenceList.add(new BreakpointEvidence.SameStrandPair(read, this.readMetadata));
            } else if (read.isReverseStrand() ? read.getStart() + this.allowedShortFragmentOverhang < read.getMateStart() : read.getStart() - this.allowedShortFragmentOverhang > read.getMateStart()) {
                evidenceList.add(new BreakpointEvidence.OutiesPair(read, this.readMetadata));
            } else {
                float zIshScore = this.readMetadata.getZishScore(read.getReadGroup(), Math.abs(read.getFragmentLength()));
                if (zIshScore > 6.0f) {
                    evidenceList.add(new BreakpointEvidence.WeirdTemplateSize(read, this.readMetadata));
                }
            }
        }
    }
}

