/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.spark.sv.evidence;

import com.esotericsoftware.kryo.DefaultSerializer;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.google.common.annotations.VisibleForTesting;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.util.IOUtil;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import org.apache.logging.log4j.Logger;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.tools.spark.sv.evidence.LibraryStatistics;
import org.broadinstitute.hellbender.tools.spark.sv.evidence.SVReadFilter;
import org.broadinstitute.hellbender.tools.spark.sv.utils.SVUtils;
import org.broadinstitute.hellbender.tools.spark.utils.IntHistogram;
import org.broadinstitute.hellbender.utils.gcs.BucketUtils;
import org.broadinstitute.hellbender.utils.read.CigarUtils;
import org.broadinstitute.hellbender.utils.read.GATKRead;

@DefaultSerializer(value=Serializer.class)
public class ReadMetadata {
    public static final String CDF_PREFIX = "template size cumulative counts:";
    private final Set<Integer> crossContigIgnoreSet;
    private final Map<String, Integer> contigNameToID;
    private final String[] contigIDToName;
    private final Map<String, String> readGroupToLibrary;
    private final long nReads;
    private final int avgReadLen;
    private final long nRefBases;
    private final long maxReadsInPartition;
    private final float coverage;
    private final float meanBaseQuality;
    private final PartitionBounds[] partitionBounds;
    private final Map<String, LibraryStatistics> libraryToFragmentStatistics;
    private static final String NO_GROUP = "NoGroup";
    private static final float MIN_COVERAGE = 10.0f;
    private static final float DEFAULT_MEAN_BASE_QUALITY_FOR_TESTING = 30.0f;

    public ReadMetadata(Set<Integer> crossContigIgnoreSet, SAMFileHeader header, int maxTrackedFragmentLength, JavaRDD<GATKRead> unfilteredReads, SVReadFilter filter, Logger logger) {
        this.crossContigIgnoreSet = crossContigIgnoreSet;
        this.contigNameToID = ReadMetadata.buildContigNameToIDMap(header.getSequenceDictionary());
        this.contigIDToName = ReadMetadata.buildContigIDToNameArray(this.contigNameToID);
        Map<String, String> grpToLib = this.readGroupToLibrary = ReadMetadata.buildGroupToLibMap(header);
        List perPartitionStatistics = unfilteredReads.mapPartitions((FlatMapFunction & Serializable)readItr -> SVUtils.singletonIterator(new PartitionStatistics((Iterator<GATKRead>)readItr, filter, maxTrackedFragmentLength, grpToLib))).collect();
        this.maxReadsInPartition = perPartitionStatistics.stream().mapToLong(PartitionStatistics::getNReads).max().orElse(0L);
        int nPartitions = perPartitionStatistics.size();
        this.partitionBounds = new PartitionBounds[nPartitions];
        for (int idx = 0; idx != nPartitions; ++idx) {
            PartitionStatistics stats = (PartitionStatistics)perPartitionStatistics.get(idx);
            Integer firstContigID = this.contigNameToID.get(stats.getFirstContig());
            Integer lastContigID = this.contigNameToID.get(stats.getLastContig());
            this.partitionBounds[idx] = new PartitionBounds(firstContigID == null ? Integer.MAX_VALUE : firstContigID, stats.getFirstLocation(), lastContigID == null ? Integer.MAX_VALUE : lastContigID, stats.getLastLocation(), stats.getSpan());
        }
        Map combinedMaps = perPartitionStatistics.stream().map(PartitionStatistics::getLibraryNameToStatisticsMap).reduce(new HashMap(), ReadMetadata::combineMaps);
        this.nReads = combinedMaps.values().stream().mapToLong(LibraryRawStatistics::getNReads).sum();
        long nReadBases = combinedMaps.values().stream().mapToLong(LibraryRawStatistics::getNBases).sum();
        this.avgReadLen = (int)(nReadBases / this.nReads);
        this.nRefBases = header.getSequenceDictionary().getSequences().stream().mapToLong(SAMSequenceRecord::getSequenceLength).sum();
        float cov = (float)nReadBases / (float)this.nRefBases;
        if (cov >= 10.0f) {
            this.coverage = cov;
        } else {
            logger.warn("Apparent coverage (" + cov + ") too low.  Pretending it's 10x.");
            this.coverage = 10.0f;
        }
        long totalBaseQuals = combinedMaps.values().stream().mapToLong(LibraryRawStatistics::getTotalBaseQuality).sum();
        this.meanBaseQuality = (float)totalBaseQuals / (float)nReadBases;
        this.libraryToFragmentStatistics = new HashMap<String, LibraryStatistics>(SVUtils.hashMapCapacity(combinedMaps.size()));
        combinedMaps.forEach((libName, rawStats) -> this.libraryToFragmentStatistics.put((String)libName, rawStats.createLibraryStatistics(this.nRefBases)));
    }

    @VisibleForTesting
    ReadMetadata(Set<Integer> crossContigIgnoreSet, SAMFileHeader header, LibraryStatistics stats, PartitionBounds[] partitionBounds, long nReads, long maxReadsInPartition, float coverage) {
        this.crossContigIgnoreSet = crossContigIgnoreSet;
        this.contigNameToID = ReadMetadata.buildContigNameToIDMap(header.getSequenceDictionary());
        this.contigIDToName = ReadMetadata.buildContigIDToNameArray(this.contigNameToID);
        this.readGroupToLibrary = ReadMetadata.buildGroupToLibMap(header);
        this.nReads = nReads;
        this.nRefBases = header.getSequenceDictionary().getSequences().stream().mapToLong(SAMSequenceRecord::getSequenceLength).sum();
        this.avgReadLen = (int)(coverage * (float)this.nRefBases / (float)nReads);
        this.maxReadsInPartition = maxReadsInPartition;
        this.coverage = coverage;
        this.meanBaseQuality = 30.0f;
        this.partitionBounds = partitionBounds;
        this.libraryToFragmentStatistics = new HashMap<String, LibraryStatistics>(6);
        this.libraryToFragmentStatistics.put(null, stats);
        for (SAMReadGroupRecord readGroupRecord : header.getReadGroups()) {
            this.libraryToFragmentStatistics.put(readGroupRecord.getLibrary(), stats);
        }
    }

    private ReadMetadata(Kryo kryo, Input input) {
        int crossContigIgnoreSetSize = input.readInt();
        this.crossContigIgnoreSet = new HashSet<Integer>(SVUtils.hashMapCapacity(crossContigIgnoreSetSize));
        for (int idx = 0; idx != crossContigIgnoreSetSize; ++idx) {
            this.crossContigIgnoreSet.add(input.readInt());
        }
        int groupMapSize = input.readInt();
        this.readGroupToLibrary = new HashMap<String, String>(SVUtils.hashMapCapacity(groupMapSize));
        for (int idx = 0; idx != groupMapSize; ++idx) {
            String groupName = input.readString();
            String libName = input.readString();
            this.readGroupToLibrary.put(groupName, libName);
        }
        int contigMapSize = input.readInt();
        this.contigNameToID = new HashMap<String, Integer>(SVUtils.hashMapCapacity(contigMapSize));
        for (int idx = 0; idx != contigMapSize; ++idx) {
            String contigName = input.readString();
            int contigId = input.readInt();
            this.contigNameToID.put(contigName, contigId);
        }
        this.contigIDToName = ReadMetadata.buildContigIDToNameArray(this.contigNameToID);
        this.nReads = input.readLong();
        this.avgReadLen = input.readInt();
        this.nRefBases = input.readLong();
        this.maxReadsInPartition = input.readLong();
        this.coverage = input.readFloat();
        this.meanBaseQuality = input.readFloat();
        int nPartitions = input.readInt();
        this.partitionBounds = new PartitionBounds[nPartitions];
        PartitionBounds.Serializer boundsSerializer = new PartitionBounds.Serializer();
        for (int idx = 0; idx != nPartitions; ++idx) {
            this.partitionBounds[idx] = boundsSerializer.read(kryo, input, (Class)PartitionBounds.class);
        }
        int libMapSize = input.readInt();
        LibraryStatistics.Serializer statsSerializer = new LibraryStatistics.Serializer();
        this.libraryToFragmentStatistics = new HashMap<String, LibraryStatistics>(SVUtils.hashMapCapacity(libMapSize));
        for (int idx = 0; idx != libMapSize; ++idx) {
            String libraryName = input.readString();
            Object stats = statsSerializer.read(kryo, input, (Class)LibraryStatistics.class);
            this.libraryToFragmentStatistics.put(libraryName, (LibraryStatistics)stats);
        }
    }

    private void serialize(Kryo kryo, Output output) {
        output.writeInt(this.crossContigIgnoreSet.size());
        for (Integer n : this.crossContigIgnoreSet) {
            output.writeInt(n.intValue());
        }
        output.writeInt(this.readGroupToLibrary.size());
        for (Map.Entry entry : this.readGroupToLibrary.entrySet()) {
            output.writeString((String)entry.getKey());
            output.writeString((String)entry.getValue());
        }
        output.writeInt(this.contigNameToID.size());
        for (Map.Entry entry : this.contigNameToID.entrySet()) {
            output.writeString((String)entry.getKey());
            output.writeInt(((Integer)entry.getValue()).intValue());
        }
        output.writeLong(this.nReads);
        output.writeInt(this.avgReadLen);
        output.writeLong(this.nRefBases);
        output.writeLong(this.maxReadsInPartition);
        output.writeFloat(this.coverage);
        output.writeFloat(this.meanBaseQuality);
        output.writeInt(this.partitionBounds.length);
        PartitionBounds.Serializer boundsSerializer = new PartitionBounds.Serializer();
        for (PartitionBounds bounds : this.partitionBounds) {
            boundsSerializer.write(kryo, output, bounds);
        }
        output.writeInt(this.libraryToFragmentStatistics.size());
        LibraryStatistics.Serializer serializer = new LibraryStatistics.Serializer();
        for (Map.Entry<String, LibraryStatistics> entry : this.libraryToFragmentStatistics.entrySet()) {
            output.writeString(entry.getKey());
            serializer.write(kryo, output, entry.getValue());
        }
    }

    public boolean ignoreCrossContigID(int contigID) {
        return this.crossContigIgnoreSet.contains(contigID);
    }

    @VisibleForTesting
    Set<Integer> getCrossContigIgnoreSet() {
        return this.crossContigIgnoreSet;
    }

    public Map<String, Integer> getContigNameMap() {
        return Collections.unmodifiableMap(this.contigNameToID);
    }

    public int getContigID(String contigName) {
        Integer result = this.contigNameToID.get(contigName);
        if (result == null) {
            throw new GATKException("No such contig name: " + contigName);
        }
        return result;
    }

    public String getContigName(int contigID) {
        return this.contigIDToName[contigID];
    }

    public String getLibraryName(String readGroupName) {
        if (readGroupName == null) {
            return null;
        }
        if (!this.readGroupToLibrary.containsKey(readGroupName)) {
            throw new GATKException("No such read group in header: " + readGroupName);
        }
        return this.readGroupToLibrary.get(readGroupName);
    }

    @VisibleForTesting
    Map<String, String> getReadGroupToLibraryMap() {
        return this.readGroupToLibrary;
    }

    public float getZishScore(String readGroup, int fragmentSize) {
        return this.getFragmentLengthStatistics(readGroup).getZishScore(fragmentSize);
    }

    @VisibleForTesting
    LibraryStatistics getFragmentLengthStatistics(String readGroup) {
        return this.libraryToFragmentStatistics.get(this.getLibraryName(readGroup));
    }

    public long getNReads() {
        return this.nReads;
    }

    public int getAvgReadLen() {
        return this.avgReadLen;
    }

    public long getNRefBases() {
        return this.nRefBases;
    }

    public int getNPartitions() {
        return this.partitionBounds.length;
    }

    public PartitionBounds getPartitionBounds(int partitionIdx) {
        return this.partitionBounds[partitionIdx];
    }

    @VisibleForTesting
    PartitionBounds[] getAllPartitionBounds() {
        return this.partitionBounds;
    }

    public long getMaxReadsInPartition() {
        return this.maxReadsInPartition;
    }

    public float getCoverage() {
        return this.coverage;
    }

    public float getMeanBaseQuality() {
        return this.meanBaseQuality;
    }

    public float getAccurateKmerCoverage(int kSize) {
        float probabilityOfAnAccurateKmer = (float)Math.exp((double)kSize * Math.log1p(-Math.pow(10.0, (double)this.meanBaseQuality / -10.0)));
        return this.coverage * probabilityOfAnAccurateKmer;
    }

    public int getMedianPartitionSpan() {
        int[] spans = new int[this.partitionBounds.length];
        for (int idx = 0; idx != this.partitionBounds.length; ++idx) {
            spans[idx] = this.partitionBounds[idx].getSpan();
        }
        Arrays.sort(spans);
        return spans[this.partitionBounds.length / 2];
    }

    public Map<String, LibraryStatistics> getAllLibraryStatistics() {
        return this.libraryToFragmentStatistics;
    }

    public LibraryStatistics getLibraryStatistics(String libraryName) {
        LibraryStatistics stats = this.libraryToFragmentStatistics.get(libraryName);
        if (stats == null) {
            throw new GATKException("No such library: " + libraryName);
        }
        return stats;
    }

    public int getMaxMedianFragmentSize() {
        return this.libraryToFragmentStatistics.entrySet().stream().mapToInt(entry -> ((LibraryStatistics)entry.getValue()).getMedian()).max().orElse(0);
    }

    private static Map<String, LibraryRawStatistics> combineMaps(Map<String, LibraryRawStatistics> accumulator, Map<String, LibraryRawStatistics> element) {
        for (Map.Entry<String, LibraryRawStatistics> entry : element.entrySet()) {
            String libraryName = entry.getKey();
            LibraryRawStatistics accumulatorStats = accumulator.get(libraryName);
            if (accumulatorStats == null) {
                accumulator.put(libraryName, entry.getValue());
                continue;
            }
            LibraryRawStatistics.reduce(accumulatorStats, entry.getValue());
        }
        return accumulator;
    }

    public static Map<String, Integer> buildContigNameToIDMap(SAMSequenceDictionary dictionary) {
        List contigs = dictionary.getSequences();
        HashMap<String, Integer> contigNameToID = new HashMap<String, Integer>(SVUtils.hashMapCapacity(contigs.size()));
        int nContigs = contigs.size();
        for (int contigID = 0; contigID < nContigs; ++contigID) {
            contigNameToID.put(((SAMSequenceRecord)contigs.get(contigID)).getSequenceName(), contigID);
        }
        return contigNameToID;
    }

    public static String[] buildContigIDToNameArray(Map<String, Integer> nameToIDMap) {
        String[] result = new String[nameToIDMap.size()];
        for (Map.Entry<String, Integer> entry : nameToIDMap.entrySet()) {
            result[entry.getValue().intValue()] = entry.getKey();
        }
        return result;
    }

    public static Map<String, String> buildGroupToLibMap(SAMFileHeader header) {
        List readGroups = header.getReadGroups();
        int mapCapacity = SVUtils.hashMapCapacity(header.getReadGroups().size());
        HashMap<String, String> readGroupToLibraryMap = new HashMap<String, String>(mapCapacity);
        for (SAMReadGroupRecord groupRecord : readGroups) {
            readGroupToLibraryMap.put(groupRecord.getId(), groupRecord.getLibrary());
        }
        return readGroupToLibraryMap;
    }

    public static void writeMetadata(ReadMetadata readMetadata, String filename) {
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(BucketUtils.createFile(filename)));){
            writer.write("#reads:\t" + readMetadata.getNReads() + "\n");
            writer.write("#partitions:\t" + readMetadata.getNPartitions() + "\n");
            writer.write("max reads/partition:\t" + readMetadata.getMaxReadsInPartition() + "\n");
            writer.write("coverage:\t" + readMetadata.getCoverage() + "\n");
            writer.write("meanQ:\t" + readMetadata.getMeanBaseQuality() + "\n");
            writer.write("\nLibrary Statistics\n");
            for (Map.Entry<String, LibraryStatistics> entry : readMetadata.getAllLibraryStatistics().entrySet()) {
                LibraryStatistics stats = entry.getValue();
                String name = entry.getKey();
                if (name == null) {
                    name = NO_GROUP;
                }
                int median = stats.getMedian();
                writer.write(name + ":\t" + median + "-" + stats.getNegativeMAD() + "+" + stats.getPositiveMAD() + "\t" + stats.getCoverage() + "\t" + stats.getMeanBaseQuality() + "\t" + stats.getNReads() + "\t" + stats.getReadStartFrequency() + "\n");
                IntHistogram.CDF templateSizeCDF = stats.getCDF();
                int cdfSize = templateSizeCDF.size();
                long totalObservations = templateSizeCDF.getTotalObservations();
                writer.write(CDF_PREFIX);
                for (int idx = 0; idx < cdfSize; ++idx) {
                    long cumulativeCounts = Math.round(templateSizeCDF.getFraction(idx) * (float)totalObservations);
                    writer.write("\t" + cumulativeCounts);
                }
                writer.write("\n");
            }
            PartitionBounds[] partitionBounds = readMetadata.partitionBounds;
            writer.write("\nPartition Boundaries\n");
            for (int idx = 0; idx != partitionBounds.length; ++idx) {
                PartitionBounds bounds = partitionBounds[idx];
                writer.write(idx + "\t" + bounds.firstContigID + "\t" + bounds.getFirstStart() + "\t" + bounds.getLastContigID() + "\t" + bounds.getLastEnd() + "\n");
            }
            writer.write("contigs map:\n");
            try {
                for (int i = 0; i < readMetadata.contigIDToName.length; ++i) {
                    writer.write(i + ":" + readMetadata.contigIDToName[i] + "\n");
                }
            }
            catch (IOException ex) {
                throw new GATKException("Can't write metadata contig entry", ex);
            }
        }
        catch (IOException ioe) {
            throw new GATKException("Can't write metadata file.", ioe);
        }
    }

    @DefaultSerializer(value=Serializer.class)
    public static final class PartitionBounds {
        private final int firstContigID;
        private final int firstStart;
        private final int lastContigID;
        private final int lastEnd;
        private final int span;
        public static final int UNMAPPED = Integer.MAX_VALUE;

        public PartitionBounds(int firstContigID, int firstStart, int lastContigID, int lastEnd, int span) {
            this.firstContigID = firstContigID;
            this.firstStart = firstStart;
            this.lastContigID = lastContigID;
            this.lastEnd = lastEnd;
            this.span = span;
        }

        private PartitionBounds(Kryo kryo, Input input) {
            this.firstContigID = input.readInt();
            this.firstStart = input.readInt();
            this.lastContigID = input.readInt();
            this.lastEnd = input.readInt();
            this.span = input.readInt();
        }

        private void serialize(Kryo kryo, Output output) {
            output.writeInt(this.firstContigID);
            output.writeInt(this.firstStart);
            output.writeInt(this.lastContigID);
            output.writeInt(this.lastEnd);
            output.writeInt(this.span);
        }

        public int getFirstContigID() {
            return this.firstContigID;
        }

        public int getFirstStart() {
            return this.firstStart;
        }

        public int getLastContigID() {
            return this.lastContigID;
        }

        public int getLastEnd() {
            return this.lastEnd;
        }

        public int getSpan() {
            return this.span;
        }

        public static final class Serializer
        extends com.esotericsoftware.kryo.Serializer<PartitionBounds> {
            public void write(Kryo kryo, Output output, PartitionBounds partitionBounds) {
                partitionBounds.serialize(kryo, output);
            }

            public PartitionBounds read(Kryo kryo, Input input, Class<PartitionBounds> klass) {
                return new PartitionBounds(kryo, input);
            }
        }
    }

    @DefaultSerializer(value=Serializer.class)
    public static final class PartitionStatistics {
        private final Map<String, LibraryRawStatistics> libraryNameToStatisticsMap;
        private final String firstContig;
        private final int firstLocation;
        private final String lastContig;
        private final int lastLocation;
        private final int span;

        public PartitionStatistics(Iterator<GATKRead> unfilteredReadItr, SVReadFilter filter, int maxTrackedFragmentLength, Map<String, String> readGroupToLibraryMap) {
            Iterator<GATKRead> mappedReadItr = filter.applyFilter(unfilteredReadItr, SVReadFilter::isMappedPrimary);
            this.libraryNameToStatisticsMap = new HashMap<String, LibraryRawStatistics>();
            if (!mappedReadItr.hasNext()) {
                this.lastContig = null;
                this.firstContig = null;
                this.lastLocation = -1;
                this.firstLocation = -1;
                this.span = 0;
                return;
            }
            GATKRead mappedRead = mappedReadItr.next();
            this.firstContig = mappedRead.getContig();
            this.firstLocation = mappedRead.getStart();
            String currentContig = this.firstContig;
            int currentSpan = -this.firstLocation;
            while (true) {
                String libraryName = readGroupToLibraryMap.get(mappedRead.getReadGroup());
                boolean isTestable = filter.isTemplateLenTestable(mappedRead);
                int summedQuals = 0;
                for (byte qual : mappedRead.getBaseQualities()) {
                    summedQuals += qual;
                }
                this.libraryNameToStatisticsMap.computeIfAbsent(libraryName, key -> new LibraryRawStatistics(maxTrackedFragmentLength)).addRead(CigarUtils.countAlignedBases(mappedRead.getCigar()), summedQuals, mappedRead.getFragmentLength(), isTestable);
                if (!mappedReadItr.hasNext()) break;
                int endPos = mappedRead.getEnd() + 1;
                mappedRead = mappedReadItr.next();
                if (mappedRead.getContig().equals(currentContig)) continue;
                currentSpan += endPos;
                currentContig = mappedRead.getContig();
                currentSpan -= mappedRead.getStart();
            }
            this.lastContig = mappedRead.getContig();
            this.lastLocation = mappedRead.getEnd() + 1;
            this.span = currentSpan + this.lastLocation;
        }

        private PartitionStatistics(Kryo kryo, Input input) {
            LibraryRawStatistics.Serializer rawStatsSerializer = new LibraryRawStatistics.Serializer();
            int nEntries = input.readInt();
            this.libraryNameToStatisticsMap = new HashMap<String, LibraryRawStatistics>(SVUtils.hashMapCapacity(nEntries));
            while (nEntries-- > 0) {
                String libName = input.readString();
                Object rawStats = rawStatsSerializer.read(kryo, input, (Class)LibraryRawStatistics.class);
                this.libraryNameToStatisticsMap.put(libName, (LibraryRawStatistics)rawStats);
            }
            this.firstContig = input.readString();
            this.firstLocation = input.readInt();
            this.lastContig = input.readString();
            this.lastLocation = input.readInt();
            this.span = input.readInt();
        }

        public long getNReads() {
            return this.libraryNameToStatisticsMap.values().stream().mapToLong(LibraryRawStatistics::getNReads).sum();
        }

        public Map<String, LibraryRawStatistics> getLibraryNameToStatisticsMap() {
            return this.libraryNameToStatisticsMap;
        }

        public String getFirstContig() {
            return this.firstContig;
        }

        public int getFirstLocation() {
            return this.firstLocation;
        }

        public String getLastContig() {
            return this.lastContig;
        }

        public int getLastLocation() {
            return this.lastLocation;
        }

        public int getSpan() {
            return this.span;
        }

        private void serialize(Kryo kryo, Output output) {
            LibraryRawStatistics.Serializer rawStatsSerializer = new LibraryRawStatistics.Serializer();
            output.writeInt(this.libraryNameToStatisticsMap.size());
            for (Map.Entry<String, LibraryRawStatistics> entry : this.libraryNameToStatisticsMap.entrySet()) {
                output.writeString(entry.getKey());
                rawStatsSerializer.write(kryo, output, entry.getValue());
            }
            output.writeString(this.firstContig);
            output.writeInt(this.firstLocation);
            output.writeString(this.lastContig);
            output.writeInt(this.lastLocation);
            output.writeInt(this.span);
        }

        public static final class Serializer
        extends com.esotericsoftware.kryo.Serializer<PartitionStatistics> {
            public void write(Kryo kryo, Output output, PartitionStatistics partitionStatistics) {
                partitionStatistics.serialize(kryo, output);
            }

            public PartitionStatistics read(Kryo kryo, Input input, Class<PartitionStatistics> klass) {
                return new PartitionStatistics(kryo, input);
            }
        }
    }

    @DefaultSerializer(value=Serializer.class)
    public static final class LibraryRawStatistics {
        private final IntHistogram fragmentSizes;
        private long nReads;
        private long nBases;
        private long totalBaseQuality;

        public LibraryRawStatistics(int maxTrackedValue) {
            this.fragmentSizes = new IntHistogram(maxTrackedValue);
            this.nBases = 0L;
            this.nReads = 0L;
        }

        private LibraryRawStatistics(Kryo kryo, Input input) {
            this.fragmentSizes = new IntHistogram.Serializer().read(kryo, input, (Class)IntHistogram.class);
            this.nReads = input.readLong();
            this.nBases = input.readLong();
            this.totalBaseQuality = input.readLong();
        }

        private void serialize(Kryo kryo, Output output) {
            new IntHistogram.Serializer().write(kryo, output, this.fragmentSizes);
            output.writeLong(this.nReads);
            output.writeLong(this.nBases);
            output.writeLong(this.totalBaseQuality);
        }

        public void addRead(int readLength, int summedQuals, int templateLength, boolean isTemplateLengthTestable) {
            ++this.nReads;
            this.nBases += (long)readLength;
            this.totalBaseQuality += (long)summedQuals;
            if (isTemplateLengthTestable) {
                this.fragmentSizes.addObservation(Math.abs(templateLength));
            }
        }

        public long getNReads() {
            return this.nReads;
        }

        public long getNBases() {
            return this.nBases;
        }

        public long getTotalBaseQuality() {
            return this.totalBaseQuality;
        }

        public LibraryStatistics createLibraryStatistics(long nRefBases) {
            return new LibraryStatistics(this.fragmentSizes.getCDF(), this.nBases, this.nReads, this.totalBaseQuality, nRefBases);
        }

        public static LibraryRawStatistics reduce(LibraryRawStatistics stats1, LibraryRawStatistics stats2) {
            stats1.fragmentSizes.addObservations(stats2.fragmentSizes);
            stats1.nBases += stats2.nBases;
            stats1.nReads += stats2.nReads;
            stats1.totalBaseQuality += stats2.totalBaseQuality;
            return stats1;
        }

        public static final class Serializer
        extends com.esotericsoftware.kryo.Serializer<LibraryRawStatistics> {
            public void write(Kryo kryo, Output output, LibraryRawStatistics libraryRawStatistics) {
                libraryRawStatistics.serialize(kryo, output);
            }

            public LibraryRawStatistics read(Kryo kryo, Input input, Class<LibraryRawStatistics> klass) {
                return new LibraryRawStatistics(kryo, input);
            }
        }
    }

    public static final class Serializer
    extends com.esotericsoftware.kryo.Serializer<ReadMetadata> {
        public static final String MAGIC_STRING = "9wdgy2yEbw0jg";
        public static final String VERSION_STRING = "0.1";

        public void write(Kryo kryo, Output output, ReadMetadata readMetadata) {
            readMetadata.serialize(kryo, output);
        }

        public ReadMetadata read(Kryo kryo, Input input, Class<ReadMetadata> klass) {
            return new ReadMetadata(kryo, input);
        }

        public static void writeStandalone(ReadMetadata meta, String whereTo) {
            try {
                OutputStream outputStream = BucketUtils.createFile(whereTo);
                OutputStream actualStream = IOUtil.hasBlockCompressedExtension((String)whereTo) ? new GzipCompressorOutputStream(outputStream) : outputStream;
                Output output = new Output(actualStream);
                Kryo kryo = new Kryo();
                Serializer serializer = new Serializer();
                output.writeString(MAGIC_STRING);
                output.writeString(VERSION_STRING);
                serializer.write(kryo, output, meta);
                output.close();
            }
            catch (IOException ex) {
                throw new UserException.CouldNotCreateOutputFile(whereTo, (Exception)ex);
            }
        }

        /*
         * Exception decompiling
         */
        public static ReadMetadata readStandalone(String whereFrom) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }
}

